#!/bin/sh
#
# Start or stop the CUPS server based upon the first argument to the script.
#

case $1 in
	start | restart | reload)
		if [ -n "`pidof cupsd`" ] ; then
    			killall cupsd &>/dev/null
    			killall -9 cupsd &>/dev/null
		fi	
		/usr/sbin/cupsd
		;;

	stop)
		if [ -n "`pidof cupsd`" ] ; then
    			killall cupsd &>/dev/null
    			killall -9 cupsd &>/dev/null
		fi
		;;

	status)
		if [ -n "`pidof cupsd`" ] ; then
			echo "cups: Scheduler is running."
		else
			echo "cups: Scheduler is not running."
		fi
		;;

	*)
		echo "Usage: cups {reload|restart|start|status|stop}"
		exit 1
		;;
esac
#
# End of "$Id: cups.sh.in,v 1.19 2002/06/04 20:32:03 mike Exp $".
#
