#ifndef WINDOWS

#include <sys/types.h>
#include <signal.h>

#include "btcontent.h"
#include "tracker.h"
#include "peerlist.h"
#include "btconfig.h"
#include "console.h"
#include "sigint.h"
extern int stop_process;
int raise_sig=0;
RETSIGTYPE sig_catch_hup(int sig_no);
extern char torrent_name[];

RETSIGTYPE sig_catch_pause(int sig_no)
{
  if(SIGINT == sig_no || SIGTERM == sig_no){
  	if( cfg_cache_size ) BTCONTENT.FlushCache();
    Tracker.ClearRestart();
    Tracker.SetStoped();
   // signal(sig_no,sig_catch2);
    BTCONTENT.SaveBitfield();
    WORLD.CloseAll();
    Self.StopDLTimer();
	Self.StopULTimer();
    signal(sig_no,SIG_DFL);
    if(!raise_sig)
        stop_process=1;
    exit(0);
  }
}

RETSIGTYPE sig_catch(int sig_no)
{
  if(SIGINT == sig_no || SIGTERM == sig_no){
  	if( cfg_cache_size ) BTCONTENT.FlushCache();
    Tracker.ClearRestart();
    Tracker.SetStoped();
   // signal(sig_no,sig_catch2);
    BTCONTENT.SaveBitfield();
    WORLD.CloseAll();
    Self.StopDLTimer();
     Self.StopULTimer();
    signal(sig_no,SIG_DFL);
    if(!raise_sig)
        stop_process=2;
    exit(0);
  }
}

RETSIGTYPE sig_catch2(int sig_no)
{
  if(SIGINT == sig_no || SIGTERM == sig_no){
    if( cfg_cache_size ) BTCONTENT.FlushCache();
    BTCONTENT.SaveBitfield();
    WORLD.CloseAll();
    signal(sig_no,SIG_DFL);
    raise(sig_no);
  }
}


// Handler for other signals
RETSIGTYPE signals(int sig_no)
{
  return CONSOLE.Signal(sig_no);
}

#endif


void sig_setup()
{
#ifndef WINDOWS
	struct sigaction handler;

	signal(SIGPIPE,SIG_IGN);
	signal(SIGINT,sig_catch);//Only Manager exits.
	signal(SIGTERM,sig_catch_pause);//Pause the task.
	signal(SIGHUP, sig_catch_hup);
	// Don't let printf restart a write after SIGTTOU, we will hard-loop!
    handler.sa_handler = signals;
    sigemptyset(&(handler.sa_mask));
    handler.sa_flags = 0;   // SA_RESTART is not set
	sigaction(SIGTTOU, &handler, (struct sigaction *)0);

	// Likewise with input after SIGTTIN
	sigaction(SIGTTIN, &handler, (struct sigaction *)0);

	signal(SIGCONT,signals);
	signal(SIGTSTP,signals);
#endif
}

