#include <sys/types.h>

#include <sys/time.h>
#include <time.h>

#ifdef WINDOWS
#include <Winsock2.h>
#else
#include <stdio.h>				// autoconf manual: Darwin + others prereq for stdlib.h
#include <stdlib.h>				// autoconf manual: Darwin prereq for sys/socket.h
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>

#include "peerlist.h"
#include "tracker.h"
#include "btcontent.h"
#include "ctcs.h"
#include "btconfig.h"
#include "bttime.h"
#include "console.h"

time_t now = time ((time_t *) 0);
extern int down_ok,tracker_fail,raise_sig,ip_change;
extern ANNON_LIST *pAnnonList;
extern char torrent_name[], hex_torrent[];
int run_slow=0;
void WriteDebug(const char *pFun, int nLine);

void Downloader ()
{
	int nfds = 0, maxfd, r,ret=0;
	struct timeval timeout;
	fd_set rfd, rfdnext;
	fd_set wfd, wfdnext;
	int stopped = 0, f_idleused = 0, f_poll = 0;
//	struct timespec nowspec;
	double maxsleep;
	time_t then, concheck = (time_t) 0;

	FD_ZERO (&rfdnext);
	FD_ZERO (&wfdnext);

	do {
		time(&now);
		if (!stopped) {
			if (!Tracker.IsQuitting () && BTCONTENT.SeedTimeout ())
				Tracker.SetStoped ();
			if( Tracker.IsQuitting() && !Tracker.IsRestarting() ){
				stopped = 1;
				WORLD.Pause();
			}
		}
		if(ip_change){
			res_init();
			ip_change=0;
			tracker_fail=1;
		}
try_next_tracker:		
		if (tracker_fail && pAnnonList) {
			if( cfg_cache_size ){
				WriteDebug(__FUNCTION__, __LINE__);
				BTCONTENT.FlushCache();	
				WriteDebug(__FUNCTION__, __LINE__);
			}		
			WriteDebug(__FUNCTION__, __LINE__);
			ret=Tracker.Initial();
			WriteDebug(__FUNCTION__, __LINE__);
			if(ret==-2){
				raise_sig = 1;
				raise (SIGTERM);				
			}
			else if(ret==-1){
				tracker_fail=1;
				goto try_next_tracker;
			}
			else
				tracker_fail = 0;
		}

		maxfd = -1;
		maxsleep = -1;
		rfd = rfdnext;
		wfd = wfdnext;
		if (f_poll) {
			FD_ZERO (&rfd);
			FD_ZERO (&wfd);		// remove non-peers from sets
			maxsleep = 0;		// waited for bandwidth--poll now
		}
		else {
			WORLD.DontWaitBW ();
			if (WORLD.IsIdle ()) {
				f_idleused = 0;
				if (BTCONTENT.CheckedPieces () < BTCONTENT.GetNPieces () &&
					!BTCONTENT.NeedFlush ()) {
					if (BTCONTENT.CheckNextPiece () < 0) {
						CONSOLE.Warning (1,
										 "Error while checking piece %d of %d",
										 (int) (BTCONTENT.CheckedPieces ()),
										 (int) (BTCONTENT.GetNPieces ()));
						Tracker.SetStoped ();
						maxsleep = 2;
					}
					else
						maxsleep = 0;
					f_idleused = 1;
					time(&now);
				}
				WriteDebug(__FUNCTION__, __LINE__);
				r = Tracker.IntervalCheck (&rfd, &wfd);
				WriteDebug(__FUNCTION__, __LINE__);
				if (r > maxfd)
					maxfd = r;
#if 0					
				if (arg_ctcs) {
					r = CTCS.IntervalCheck (&rfd, &wfd);
					if (r > maxfd)
						maxfd = r;
				}
#endif				
				//if (!f_idleused || concheck <= now - 8 || WORLD.IsIdle ()) {
				if (concheck <= now - 8 || concheck >= now) {
					concheck = now;
					WriteDebug(__FUNCTION__, __LINE__);
					r = CONSOLE.IntervalCheck (&rfd, &wfd);
					WriteDebug(__FUNCTION__, __LINE__);
					if (r > maxfd)
						maxfd = r;
				}
			}
		}
		WriteDebug(__FUNCTION__, __LINE__);
		r = WORLD.IntervalCheck (&rfd, &wfd);
		WriteDebug(__FUNCTION__, __LINE__);
		if (r > maxfd)
			maxfd = r;
		if( !f_poll ){
			time(&now);
			while( BTCONTENT.NeedFlush() && WORLD.IsIdle() ){
				WriteDebug(__FUNCTION__, __LINE__);
				BTCONTENT.FlushQueue();
				WriteDebug(__FUNCTION__, __LINE__);
				maxsleep = 0;
				time(&now);
			}
		}
		rfdnext = rfd;
		wfdnext = wfd;
		if (maxsleep < 0) {		//not yet set
			maxsleep = WORLD.WaitBW ();	// must do after intervalchecks!
			if (maxsleep <= -100)
				maxsleep = 0;
			else if (maxsleep <= 0 || maxsleep > MAX_SLEEP)
				maxsleep = MAX_SLEEP;
		}
		timeout.tv_sec = (long) maxsleep;
		timeout.tv_usec = (long)( (maxsleep-(long)maxsleep) * 1000000 );
		WORLD.UnLate ();
		nfds = select (maxfd + 1, &rfd, &wfd, (fd_set *) 0, &timeout);
		if( nfds < 0 ){
			FD_ZERO(&rfdnext); FD_ZERO(&wfdnext);
			nfds = 0;
		}
		if (f_poll)
			f_poll = 0;
		else if (nfds > 0){
			WORLD.DontWaitBW ();
		}
		else if (maxsleep > 0 && maxsleep < MAX_SLEEP)
			f_poll = 1;

		then = now;
		time (&now);
		if(concheck>now)
			concheck=now;
		if(now-concheck > 10*60){
			tracker_fail=1;
			concheck=now;
		}
		if (now == then - 1)
			now = then;
		if (!f_poll && nfds > 0) {
			WriteDebug(__FUNCTION__, __LINE__);
			if (T_FREE != Tracker.GetStatus ()){
				WriteDebug(__FUNCTION__, __LINE__);
				ret=Tracker.SocketReady (&rfd, &wfd, &nfds, &rfdnext, &wfdnext);
				WriteDebug(__FUNCTION__, __LINE__);
			}
			WriteDebug(__FUNCTION__, __LINE__);
		}
		if (nfds > 0){
			WriteDebug(__FUNCTION__, __LINE__);
			WORLD.AnyPeerReady (&rfd, &wfd, &nfds, &rfdnext, &wfdnext);
			WriteDebug(__FUNCTION__, __LINE__);
		}
	}
	while (Tracker.GetStatus () != T_FINISHED || Tracker.IsRestarting ());
}
