#include "./def.h"
#include <sys/types.h>

#ifdef WINDOWS
#include <windows.h>
#else
#include <unistd.h>
#include <signal.h>
#endif

#include <sys/time.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>      /** for struct ifreq **/
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>

#include <fcntl.h>
#include "btconfig.h"
#include "btcontent.h"
#include "downloader.h"
#include "peerlist.h"
#include "tracker.h"
#include "ctcs.h"
#include "console.h"
#include "constant.h"
#include "libdown.h"
#include "./config.h"

#ifndef HAVE_RANDOM
#include "compat.h"
#endif

#ifndef WINDOWS
#include "sigint.h"
#endif

void usage();
int param_check(int argc, char **argv);

#ifdef WINDOWS

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrzevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
}

#else

/*Added Functions for NAS function*/
char hex_torrent[1024] = { 0 }, torrent_path[1024] = {
0}, torrent_name[256] = {
0}, finish_size[24] = {
0}, last_speed[48] = {
0};
char *pTorrentInfo = NULL;
int language = 437;
uid_t owner_uid=501;
int down_ok=0,tracker_fail=0;
int stop_process=0;
char old_ip[16]={0};
int ip_change=0;
typedef struct sh_info{
	char	name[FSH_MaxShareLen+1];		// name of share
	char	comment[FSH_MaxCommentLen+1];	// comment of share
	unsigned char dir[FSH_MaxDirLen+1];	// folder of share
	int		hard_index;
	int 	conflict;					// 0 - no conflict, 1- conflict 
}sh_info;
sh_info info;	
#define	PID_DIR				"/var/run/down/"

#ifdef __cplusplus
extern "C" {
#endif	
int GetShareInfo(sh_info * pSh);
int GetCodePage(void);
int FirstAvaibleVolume(void);
#ifdef __cplusplus
}
#endif	
char pid_file[64]={0};
char status_file[1024]={0}, ram_status_file[670]={0};
char error_status[256]={0};
extern ANNON_LIST *pAnnonList;

int GetLocalIP(char ip_addr[16]);
void WriteDebug(const char *pFun, int nLine)
{
	FILE *fp=NULL;
	char buf[128]={0};
	struct stat f_stat;
	
	return;
	sprintf(buf, "/harddisk/volume_2/data/public/%s" , hex_torrent);
	stat(buf, &f_stat);
	if(f_stat.st_size>2*1024*1024)
		truncate(buf, 0);
	fp=fopen(buf, "at");
	if(fp){
		fprintf(fp, "%s-%d\n", pFun, nLine);
		fclose(fp);	
	}	
}

void CleanFile(void)
{
//	printf("Enter CleanFile()\n");
	if(arg_save_as)
		delete []arg_save_as;
	if(arg_bitfield_file)
		delete []arg_bitfield_file;
	if(arg_metainfo_file)
		delete []arg_metainfo_file;	
	if(cfg_user_agent)
		delete []cfg_user_agent;	
	if(arg_user_agent)
		delete []arg_user_agent;		
	if(!arg_flg_exam_only){
		if(!down_ok){
			if(!stop_process){
				BT_SetStr("task_status", "3", ram_status_file);
				BT_SetStr("result", error_status, ram_status_file);	
			#ifdef _LOG_DOWN_TASK_
				LogDownTaskActions(torrent_name, DOWN_TASK_FAILED);
			#endif
			}
			else if(stop_process==2)
				BT_SetStr("task_status", "0", ram_status_file);
			else if(stop_process==1)
				BT_SetStr("task_status", "1", ram_status_file);
		}
		else{
			BT_SetStr( "task_status", "2", ram_status_file);
		}
		BT_SetStr( "seeder_number", "0", ram_status_file);
		BT_SetStr( "peer_number", "0", ram_status_file);
	}
	
	CopyFile(ram_status_file, status_file);
#ifdef _LOG_DOWN_TASK_
	if(!arg_flg_exam_only && down_ok)
		LogDownTaskActions(torrent_name, DOWN_TASK_FIN);
#endif	

	if(!arg_flg_exam_only && down_ok){
		RecordStartFinTime(torrent_name,1);
	}
	if(pAnnonList){
		ANNON_LIST *pCurrent=NULL;
		
		pCurrent=pAnnonList;
		while(pCurrent){
			//printf("Free: [%x] %s\n", pCurrent->pURL, pCurrent->pURL);
			delete []pCurrent->pURL;
			pCurrent->pURL=NULL;
			free(pCurrent);
			pCurrent=pCurrent->next;
		}
	}
	if(cfg_listen_port > 1025){
		char cmd_str[128]={0};
		
		sprintf(cmd_str,"/usr/sbin/miniupnpc -d %d TCP >/dev/null 2>&1", cfg_listen_port);
		system(cmd_str);		
	}
	remove(pid_file);	
	if(!arg_flg_exam_only && stop_process!=2)
		NotifyManager();	
}
#ifdef __USE_UNICODE__
#include <iconv.h>				/* why here?  For osx 10.2, of course! */
char code_page[12] = "CP437";
extern "C" {
iconv_t libiconv_open (const char *tocode, const char *fromcode);
size_t libiconv (iconv_t cd, char **inbuf, size_t * inbytesleft,
						char **outbuf, size_t * outbytesleft);
int libiconv_close (iconv_t cd);
}
size_t
do_convert (const char *to_ces, const char *from_ces,
			char *inbuf, size_t inbytesleft,
			char *outbuf, size_t outbytesleft)
{
	iconv_t cd = libiconv_open (to_ces, from_ces);
	if (cd <= 0)
		return (size_t)-1;
	size_t ret = libiconv (cd, &inbuf, &inbytesleft, &outbuf, &outbytesleft);
	libiconv_close (cd);
	return ret;
}
#endif

extern int run_slow;
#define	LARGE_TORRENT_SIZE	(1*1024*1024*1024+512*1024*1024)
#define	LARGE_TORRENT_NUM	2

int IsLargeTorrent(char *pUrl)
{
	char buf[312],*p=NULL, *p0=NULL;
	FILE *fp;
	char job_name[MAX_URL_LEN*3+1]={0};
	int disk_index=0;
	unsigned long long total_size=0;

	disk_index=FirstAvaibleVolume();
	if(disk_index<0)
		return 0;	
	sprintf(job_name, TORRENT_FOLDER"/%s.info", disk_index,pUrl);
	fp=fopen(job_name,"rt");
	if(!fp){
		return 0;
	}
	while(fgets(buf,sizeof(buf),fp)){
		if(!strncmp(buf, "Total:", strlen("Total:"))){
			p=strchr(buf,':');
			if(p){
				*p=0;
				p++;
				p0=strrchr(p,'\n');
				if(p0)
					*p0=0;
				total_size=strtoull(p,NULL,10);
			}
		}	
	}
	fclose(fp);
	if(total_size>=(unsigned long long)LARGE_TORRENT_SIZE*2)
		return 2;	
	if(total_size>=(unsigned long long)LARGE_TORRENT_SIZE)
		return 1;
	return 0;
}

void NotifyOtherBTRunTasks(int my_pid)
{
	DIR *dir;
	struct dirent *dirp;
	char pid_file[64]={0}, *p=NULL, pid_name[32]={0};
	int pid=0;
	
	dir=opendir(TASK_PID_FOLDER);
	if(dir!=NULL){	
		while( (dirp=readdir(dir)) !=NULL ){
			if(!strcmp(dirp->d_name,".") || !strcmp(dirp->d_name,".."))
				continue;
			if(!(strstr(dirp->d_name, "bt.")==dirp->d_name))
				continue;
			sprintf(pid_file,"%s/%s",TASK_PID_FOLDER,dirp->d_name);
			p=strrchr(pid_file,'.');
			if(!p){
				continue;				
			}
			*p++=0;
			pid=atoi(p);
			if(pid==my_pid)
				continue;
			sprintf(pid_name, "/proc/%d", pid);
			if(access(pid_name, F_OK)){
				remove(pid_file);
			}
			if(pid>1){
				kill(pid, SIGHUP);
				sleep(2);
			}				
		}
		closedir(dir);
	}	
	return;
}

int CheckLargeTorrentNum(int my_pid)
{
	DIR *dir;
	struct dirent *dirp;
	FILE *fp=NULL;
	char url_str[257]={0},pid_file[64]={0}, *p=0, pid_name[24]={0};
	int pid=0, large_num=0;
	
	dir=opendir(TASK_PID_FOLDER);
	if(dir!=NULL){	
		while( (dirp=readdir(dir)) !=NULL ){
			if(!strcmp(dirp->d_name,".") || !strcmp(dirp->d_name,".."))
				continue;
			url_str[0]=0;
			sprintf(pid_file,"%s/%s",TASK_PID_FOLDER,dirp->d_name);
			fp=fopen(pid_file,"rt");
			if(!fp){
				continue;	
			}
			fgets(url_str, sizeof(url_str),fp);
			fclose(fp);
			p=strrchr(pid_file,'.');
			if(!p){
				continue;				
			}
			p++;
			pid=atoi(p);
			sprintf(pid_name, "/proc/%d", pid);
			if(access(pid_name, F_OK)){
				continue;
			}
			if(pid>=my_pid)
				continue;		
			large_num+=IsLargeTorrent(url_str);
		}
		closedir(dir);
	}
	
	return large_num;	
}
/*End*/
void Random_init()
{
  unsigned long seed;
#ifdef HAVE_GETTIMEOFDAY
  struct timeval tv; 
  gettimeofday(&tv,(struct timezone*) 0);
  seed = tv.tv_usec + tv.tv_sec + getpid();
#else
  seed = (unsigned long)time((time_t *)0);
#endif
  srandom(seed);
}

int main(int argc, char **argv)
{
	char *s;
	int logged=0,large_torrent=0;
	
	atexit(CleanFile);   
	Random_init();
	arg_user_agent = new char[MAX_PF_LEN+1];
	strcpy(arg_user_agent,PEER_PFX);
  
	cfg_user_agent = new char[strlen(PACKAGE_NAME)+strlen(PACKAGE_VERSION)+2];
#ifndef WINDOWS
	if( !cfg_user_agent ) return -1;
#endif
	sprintf(cfg_user_agent, "%s/%s", PACKAGE_NAME, PACKAGE_VERSION);
	while(s = strchr(cfg_user_agent, ' ')) *s = '-';

	if( argc < 2 ){
		usage();
		exit(1);
	}
	else if( param_check(argc,argv) < 0 ) exit(1);
		GetLocalIP(old_ip);

  if( arg_flg_make_torrent ){
    if( !arg_announce ){
      CONSOLE.Warning(1, "Please use -u to specify an announce URL!");
      exit(1);
    }
    if( !arg_save_as ){
      CONSOLE.Warning(1, "Please use -s to specify a metainfo file name!");
      exit(1);
    }
    if( BTCONTENT.InitialFromFS(arg_metainfo_file, arg_announce,
                                arg_piece_length) < 0 ||
        BTCONTENT.CreateMetainfoFile(arg_save_as) < 0 ){
      CONSOLE.Warning(1, "create metainfo failed.");
      exit(1);
    }
    CONSOLE.Print("Create metainfo file %s successful.", arg_save_as);
    exit(0);
  }

#if 0
	if( !arg_flg_exam_only && (!arg_flg_check_only || arg_flg_force_seed_mode) )
		if( arg_ctcs ) CTCS.Initial();
#endif 
#if 0
	large_torrent=IsLargeTorrent(torrent_name);
check_others:	
	if(CheckLargeTorrentNum(getpid())>=LARGE_TORRENT_NUM && large_torrent)					
		run_slow=1;
	else
		run_slow=0;
	if(run_slow){
		{
			FILE *ff=NULL;
			
			ff=fopen("/harddisk/volume_1/data/public/ctorrent_shearer.txt", "at");
			if(ff){			
				fprintf(ff, "%s: run_slow=%d, sleeping to wait\n",torrent_name, run_slow);
				fclose(ff);
			}
		}		
		if(!logged){
			BT_SetStr("task_status", "5", status_file);
			logged=1;
		}
		sleep(60);
		goto check_others;
	}
		{
			FILE *ff=NULL;
			
			ff=fopen("/harddisk/volume_1/data/public/ctorrent_shearer.txt", "at");
			if(ff){			
				fprintf(ff, "%s: run_slow=%d, begin to work\n",torrent_name, run_slow);
				fclose(ff);
			}
		}	
#endif
		
	if( BTCONTENT.InitialFromMI(arg_metainfo_file, arg_save_as) < 0){
		CONSOLE.Warning(1, "error, initial meta info failed.");
		stop_process=1;
		exit(1);
	}

	if( !arg_flg_exam_only && (!arg_flg_check_only || arg_flg_force_seed_mode) ){
		if(WORLD.Initial_ListenPort() < 0){
			CONSOLE.Warning(2, "warn, you can't accept connections.");
		}

		if( Tracker.Initial() < 0 ){
			CONSOLE.Warning(1, "error, tracker setup failed.");
			exit(1);
		}

		sig_setup();  // setup signal handling
		CONSOLE.Interact("Press 'h' or '?' for help (display/control client options)." );
		BT_SetStr("task_status", "5", status_file);
		Downloader ();
		if( cfg_cache_size )
			BTCONTENT.FlushCache();
	}
	if( !arg_flg_exam_only ) BTCONTENT.SaveBitfield();
	WORLD.CloseAll();

	//if(arg_verbose) CONSOLE.cpu();
	exit(0);
}

#endif


int GetLocalIP(char ip_addr[16])
{
	struct ifreq my_ifreq;
	int sock=0;
	struct sockaddr_in *mysockaddr;
	
	sock=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP);
	if ( sock<0 ){
		return -1;
	}	
	strcpy(my_ifreq.ifr_name,"eth0");  
	if(ioctl(sock, SIOCGIFADDR, &my_ifreq) < 0) {
		close(sock);
		return -1;
	}
	mysockaddr = (struct sockaddr_in *)&(my_ifreq.ifr_addr);
	strcpy(ip_addr, inet_ntoa(mysockaddr->sin_addr));
	close(sock);	
	return 0;
}

int max_down_speed=600;
int max_upload_speed=200;

int total_run_tasks=0;
extern int tracker_fail;

RETSIGTYPE sig_catch_hup(int sig_no)
{
	int ret=0, task_num=0;
	down_task TaskInfo;
	char ip[16]={0};
	
	if(SIGHUP == sig_no){
		signal(SIGHUP, SIG_IGN);

#if 0
		task_num=NumofBTRunTasks();
		switch(task_num){
			case 1:
				max_down_speed=350;
				max_upload_speed=60;
				cfg_max_peers=70;
				break;
			case 2:
				max_down_speed=250;
				max_upload_speed=50;
				cfg_max_peers=60;
				break;
			case 3:
				max_down_speed=200;
				max_upload_speed=40;
				cfg_max_peers=50;
				break;
			default:
				max_down_speed=120;
				max_upload_speed=30;
				cfg_max_peers=50;
				break;		
		}	
#endif		
		ret=GetDownTaskInfo(&TaskInfo, torrent_name);
		if(ret){
			signal(SIGHUP,sig_catch_hup);
			return;
		}
		if(TaskInfo.down_speed && TaskInfo.down_speed<max_down_speed)
			cfg_max_bandwidth_down=TaskInfo.down_speed*1024;
		else
			cfg_max_bandwidth_down=max_down_speed*1024;
			
		if(TaskInfo.upload_speed && TaskInfo.upload_speed<max_upload_speed)
			cfg_max_bandwidth_up=TaskInfo.upload_speed*1024;
		else
			cfg_max_bandwidth_up=max_upload_speed*1024;
		cfg_seed_hours=TaskInfo.seed_hour;
		if(!GetLocalIP(ip) && strcmp(ip, old_ip)){
			ip_change=1;
			strcpy(old_ip, ip);	
		}
    	signal(SIGHUP,sig_catch_hup);
	}	
}

int param_check(int argc, char **argv)
{
	const char *opts;
	int c, l;
	int ret=0,disk_index=0;
//	char *s;
	down_task TaskInfo;
 	struct passwd *u_pwd=NULL;
	FILE *fp=NULL;

	if( 0==strncmp(argv[1], "-t", 2) )
		opts = "tc:l:ps:u:";
	else
		opts = "aA:b:cC:dD:e:E:fi:I:M:m:L:n:P:p:s:S:Tu:U:vxX:z:hH";

	while( (c=getopt(argc, argv, opts)) != -1 )
    switch( c ){
    case 'a':
      arg_allocate = 1;
      break;

    case 'b':
      arg_bitfield_file = new char[strlen(optarg) + 1];
#ifndef WINDOWS
      if( !arg_bitfield_file ) return -1;
#endif
      strcpy(arg_bitfield_file, optarg);
      break;

    case 'i':			// listen on ip XXXX
      cfg_listen_ip = inet_addr(optarg);
      break;

    case 'I':			// set public ip XXXX
      cfg_public_ip = new char[strlen(optarg) + 1];
      if( !cfg_public_ip ) return -1;
      strcpy(cfg_public_ip, optarg);
      break;
		case 'L':
			language = atoi (optarg);
			break;
    case 'p':			// listen on Port XXXX
      if( arg_flg_make_torrent ) arg_flg_private = 1;
      else cfg_listen_port = atoi(optarg);
      break;

    case 's':			// Save as FILE/DIR NAME
      if( arg_save_as ) return -1;  // specified twice
      arg_save_as = new char[strlen(optarg) + 1];
#ifndef WINDOWS
      if( !arg_save_as ) return -1;
#endif
      strcpy(arg_save_as,optarg);
      break;

    case 'e':			// Exit while complete
      cfg_seed_hours = (time_t)strtoul(optarg, NULL, 10);
      break;

    case 'E':			// target seed ratio
      cfg_seed_ratio = atof(optarg);
      break;

    case 'c':			// Check exist only
      if( arg_flg_make_torrent ){
        arg_comment = new char[strlen(optarg) + 1];
        if( !arg_comment ) return -1;
        strcpy(arg_comment, optarg);
      }else arg_flg_check_only = 1;
      break;

    case 'C':			// Max cache size
      cfg_cache_size = atoi(optarg);
      break;
      
    case 'M':			// Max peers
      cfg_max_peers = atoi(optarg);
      if( cfg_max_peers > 1000 || cfg_max_peers < 20 ){
        CONSOLE.Warning(1, "-%c argument must be between 20 and 1000", c);
        return -1;
      }
      break;
      
    case 'm':			// Min peers
      cfg_min_peers = atoi(optarg);
      if( cfg_min_peers > 1000 || cfg_min_peers < 1 ){
        CONSOLE.Warning(1, "-%c argument must be between 1 and 1000", c);
        return -1;
      }
      break;

    case 'z':			// slice size
      cfg_req_slice_size = atoi(optarg) * 1024;
      if(cfg_req_slice_size < 1024 || cfg_req_slice_size > cfg_max_slice_size){
        CONSOLE.Warning(1, "-%c argument must be between 1 and %d",
          c, cfg_max_slice_size / 1024);
        return -1;
      }
      break;

    case 'n':			// Which file download
      if( arg_file_to_download ) return -1;  // specified twice
      arg_file_to_download = new char[strlen(optarg) + 1];
#ifndef WINDOWS
      if( !arg_file_to_download ) return -1;
#endif
      strcpy(arg_file_to_download,optarg);
      break;

    case 'f':			// force seed mode, skip sha1 check when startup.
      arg_flg_force_seed_mode = 1;
      break;
      
    case 'D':			// download bandwidth limit
      cfg_max_bandwidth_down = (int)(strtod(optarg, NULL) * 1024);
      break;

    case 'U':			// upload bandwidth limit
      cfg_max_bandwidth_up = (int)(strtod(optarg, NULL) * 1024);
      break;

    case 'P':			// peer ID prefix
      l = strlen(optarg);
      if (l > MAX_PF_LEN) {
        CONSOLE.Warning(1, "-P arg must be %d or less characters", MAX_PF_LEN);
        return -1;
      }
      if (l == 1 && *optarg == '-') *arg_user_agent = (char) 0;
      else strcpy(arg_user_agent,optarg);
      break;

    case 'A':			// HTTP user-agent header string
      if( cfg_user_agent ) delete []cfg_user_agent;
      cfg_user_agent = new char[strlen(optarg) + 1];
#ifndef WINDOWS
      if( !cfg_user_agent ) return -1;
#endif
      strcpy(cfg_user_agent, optarg);
      break;

    case 'T':			// convert foreign filenames to printable text
      arg_flg_convert_filenames = 1;
      break;

     // BELOW OPTIONS USED FOR CREATE TORRENT.
    case 'u':			// Announce URL
      if( arg_announce ) return -1;  // specified twice
      arg_announce = new char[strlen(optarg) + 1];
#ifndef WINDOWS
      if( !arg_announce ) return -1;
#endif
      strcpy(arg_announce, optarg);
      break;

    case 't':			// make Torrent
      arg_flg_make_torrent = 1;
      CONSOLE.ChangeChannel(O_INPUT, "off", 0);
      break;

    case 'l':			// piece Length (default 262144)
      arg_piece_length = atoi(optarg);
      if( arg_piece_length < 65536 || arg_piece_length > 4096*1024 ){
        CONSOLE.Warning(1, "-%c argument must be between 65536 and %d",
          c, 4096*1024);
        return -1;
      }
      break;
     // ABOVE OPTIONS USED FOR CREATE TORRENT.

    case 'x':			// print torrent information only
      arg_flg_exam_only = 1;
      CONSOLE.ChangeChannel(O_INPUT, "off", 0);
      break;

    case 'S':			// CTCS server
      if( arg_ctcs ) return -1;  // specified twice
      arg_ctcs = new char[strlen(optarg) + 1];
#ifndef WINDOWS
      if( !arg_ctcs ) return -1;
#endif
      if( !strchr(optarg, ':') ){
        CONSOLE.Warning(1, "-%c argument requires a port number", c);
        return -1;
      }
      strcpy(arg_ctcs, optarg);
      break;

    case 'X':			// "user exit" on download completion
      if( arg_completion_exit ) return -1;  // specified twice
      arg_completion_exit = new char[strlen(optarg) + 1];
#ifndef WINDOWS
      if( !arg_completion_exit ) return -1;
#endif
#ifndef HAVE_SYSTEM
      CONSOLE.Warning(1, "-X is not supported on your system");
      return -1;
#endif
#ifndef HAVE_WORKING_FORK
      CONSOLE.Warning(2,
        "No working fork function; be sure the -X command is brief!");
#endif
      strcpy(arg_completion_exit, optarg);
      break;

    case 'v':			// verbose output
      arg_verbose = 1;
      break;

    case 'd':			// daemon mode (fork to background)
      arg_daemon++;
      break;

    case 'h':
    case 'H':			// help
      usage();
      return -1;

    default:
      //unknown option.
      CONSOLE.Warning(1, "Use -h for help/usage.");
      return -1;
    }

  argc -= optind; argv += optind;
  if( cfg_min_peers >= cfg_max_peers ) cfg_min_peers = cfg_max_peers - 1;
  if( argc != 1 ){
    if( arg_flg_make_torrent )
      CONSOLE.Warning(1,
        "Must specify torrent contents (one file or directory)");
    else CONSOLE.Warning(1, "Must specify one torrent file");
    return -1;
  }
	strcpy (hex_torrent, *argv);
	HexStr2String (hex_torrent, torrent_name);
	if(!arg_flg_exam_only){
		sprintf(pid_file, "%s/bt.%d",PID_DIR,getpid());
		fp=fopen(pid_file,"wt");
		if(fp){
			fputs(torrent_name,fp);
			fclose(fp);	
		}	
	}		
	disk_index=FirstAvaibleVolume();
	if(disk_index<0)
		return -1;		
	sprintf (torrent_path, TORRENT_FOLDER"/%s", disk_index,torrent_name);
	if(!arg_flg_exam_only){
		char status_file_prefix[256]={0};
		int task_num=0;
		
      	if(strlen(hex_torrent)>255){
      		strncpy(status_file_prefix, hex_torrent, 254);
      		status_file_prefix[254]=0;
      		sprintf(status_file,DOWNLOAD_FOLDER"/%s/",disk_index,status_file_prefix);
      		if(access(status_file, F_OK))
      			mkdir(status_file,0775);
      		chmod(status_file, 0775);
      		
      		sprintf(status_file,TASK_STATUS_FOLDER"/%s/",status_file_prefix);
      		if(access(status_file, F_OK))
      			mkdir(status_file,0775);
      		chmod(status_file, 0775);      	
      			
			sprintf(status_file, DOWNLOAD_FOLDER"/%s/%s.status", disk_index, status_file_prefix, hex_torrent+254);
			sprintf(ram_status_file,TASK_STATUS_FOLDER"/%s/%s.status",status_file_prefix, hex_torrent+254);
      	}
      	else{		
			sprintf(status_file,DOWNLOAD_FOLDER"/%s.status",disk_index,hex_torrent);
			sprintf(ram_status_file,TASK_STATUS_FOLDER"/%s.status",hex_torrent);
		}
		ret=GetDownTaskInfo(&TaskInfo, torrent_name);
		if(ret)
			return(-1);
		memset(&info, 0, sizeof(info));
		strcpy(info.name, TaskInfo.sh_name);
		ret=GetShareInfo(&info);
		if(ret)
			return -1;
		u_pwd=getpwnam(TaskInfo.owner);
		if(u_pwd && (u_pwd->pw_uid)>=0)
			owner_uid=u_pwd->pw_uid;
#if 0			
		task_num=NumofBTRunTasks();
		switch(task_num){
			case 1:
				max_down_speed=350;
				max_upload_speed=60;
				cfg_max_peers=70;
				break;
			case 2:
				max_down_speed=250;
				max_upload_speed=50;
				cfg_max_peers=60;
				break;
			case 3:
				max_down_speed=200;
				max_upload_speed=40;
				cfg_max_peers=50;
				break;
			default:
				max_down_speed=120;
				max_upload_speed=30;
				cfg_max_peers=50;
				break;		
		}	
#endif													
		if(TaskInfo.down_speed && TaskInfo.down_speed<max_down_speed)
			cfg_max_bandwidth_down=TaskInfo.down_speed*1024;
		else
			cfg_max_bandwidth_down=max_down_speed*1024;
			
		if(TaskInfo.upload_speed && TaskInfo.upload_speed<max_upload_speed)
			cfg_max_bandwidth_up=TaskInfo.upload_speed*1024;
		else
			cfg_max_bandwidth_up=max_upload_speed*1024;;	
		cfg_seed_hours=TaskInfo.seed_hour;
		cfg_min_listen_port=TaskInfo.start_port;
		cfg_max_listen_port=TaskInfo.end_port;
	}
	arg_metainfo_file = new char[strlen (torrent_path) + 1];
#ifndef WINDOWS
  if( !arg_metainfo_file ) return -1;
#endif
	strcpy (arg_metainfo_file, torrent_path);
  if( !arg_bitfield_file ){
    arg_bitfield_file = new char[strlen(arg_metainfo_file) + 4];
#ifndef WINDOWS
    if( !arg_bitfield_file ) return -1;
#endif
    strcpy(arg_bitfield_file, arg_metainfo_file);
    strcat(arg_bitfield_file, ".bf");
  }
	pTorrentInfo = torrent_path;
	strcat (torrent_path, ".info");
	//Saved In
#if 0	
	if(!arg_flg_exam_only){
		arg_save_as=new char[1024];
		if(!arg_save_as)
			return -1;
		sprintf(arg_save_as,FSH_MNT_PREFIX"/"FSH_DATA_NAME"%s%s",info.hard_index,info.dir,TaskInfo.sub_dir);
	}
#endif	
	language=GetCodePage();
#ifdef __USE_UNICODE__	
	sprintf (code_page, "CP%d", language);
#endif	
  return 0;
}

void usage()
{
  CONSOLE.ChangeChannel(O_INPUT, "off", 0);
  fprintf(stderr,"%s   Original code Copyright: YuHong(992126018601033)\n",
    PACKAGE_STRING);
  fprintf(stderr,"WARNING: THERE IS NO WARRANTY FOR CTorrent. USE AT YOUR OWN RISK!!!\n");
  fprintf(stderr,"\nGeneral Options:\n");
  fprintf(stderr, "%-15s %s\n", "-h/-H", "Show this message");
  fprintf(stderr, "%-15s %s\n", "-x",
    "Decode metainfo (torrent) file only, don't download");
  fprintf(stderr, "%-15s %s\n", "-c", "Check pieces only, don't download");
  fprintf(stderr, "%-15s %s\n", "-v", "Verbose output (for debugging)");

  fprintf(stderr,"\nDownload Options:\n");
  fprintf(stderr, "%-15s %s\n", "-e int",
    "Exit while seed <int> hours later (default 72 hours)");
  fprintf(stderr, "%-15s %s\n", "-E num",
    "Exit after seeding to <num> ratio (UL:DL)");
  fprintf(stderr, "%-15s %s\n", "-i ip",
    "Listen for connections on specific IP address (default all/any)");
  fprintf(stderr, "%-15s %s\n", "-p port",
    "Listen port (default 2706 -> 2106)");
  fprintf(stderr, "%-15s %s\n", "-I ip",
    "Specify public/external IP address for peer connections");
  fprintf(stderr, "%-15s %s\n", "-u num or URL",
    "Use an alternate announce (tracker) URL");
  fprintf(stderr, "%-15s %s\n", "-s filename",
    "Download (\"save as\") to a different file or directory");
  fprintf(stderr, "%-15s %s\n", "-C cache_size",
    "Cache size, unit MB (default 16MB)");
  fprintf(stderr, "%-15s %s\n", "-f",
    "Force saved bitfield or seed mode (skip initial hash check)");
  fprintf(stderr, "%-15s %s\n", "-b filename",
    "Specify bitfield save file (default is torrent+\".bf\")");
  fprintf(stderr, "%-15s %s\n", "-M max_peers",
    "Max peers count (default 100)");
  fprintf(stderr, "%-15s %s\n", "-m min_peers", "Min peers count (default 1)");
  fprintf(stderr, "%-15s %s\n", "-z slice_size",
    "Download slice/block size, unit KB (default 16, max 128)");
  fprintf(stderr, "%-15s %s\n", "-n file_list",
    "Specify file number(s) to download");
  fprintf(stderr, "%-15s %s\n", "-D rate", "Max bandwidth down (unit KB/s)");
  fprintf(stderr, "%-15s %s\n", "-U rate", "Max bandwidth up (unit KB/s)");
  fprintf(stderr, "%-15s %s%s\")\n", "-P peer_id",
    "Set Peer ID prefix (default \"", PEER_PFX);
  fprintf(stderr, "%-15s %s%s\")\n", "-A user_agent",
    "Set User-Agent header (default \"", cfg_user_agent);
  fprintf(stderr, "%-15s %s\n", "-S host:port",
    "Use CTCS server at host:port");
  fprintf(stderr, "%-15s %s\n", "-a", "Preallocate files on disk");
  fprintf(stderr, "%-15s %s\n", "-T",
    "Convert foreign filenames to printable text");
  fprintf(stderr, "%-15s %s\n", "-X command",
    "Run command upon download completion (\"user exit\")");
  fprintf(stderr, "%-15s %s\n", "-d", "Daemon mode (fork to background)");
  fprintf(stderr, "%-15s %s\n", "-dd", "Daemon mode with I/O redirection");

  fprintf(stderr,"\nMake metainfo (torrent) file options:\n");
  fprintf(stderr, "%-15s %s\n", "-t", "Create a new torrent file");
  fprintf(stderr, "%-15s %s\n", "-u URL", "Tracker's URL");
  fprintf(stderr, "%-15s %s\n", "-l piece_len",
    "Piece length (default 262144)");
  fprintf(stderr, "%-15s %s\n", "-s filename", "Specify metainfo file name");
  fprintf(stderr, "%-15s %s\n", "-p", "Private (disable peer exchange)");
  fprintf(stderr, "%-15s %s\n", "-c comment", "Include a comment/description");

  fprintf(stderr,"\nExample:\n");
  fprintf(stderr,"ctorrent -s new_filename -e 12 -C 32 -p 6881 example.torrent\n");
  fprintf(stderr,"\nhome page: http://ctorrent.sourceforge.net/\n");
  fprintf(stderr,"see also: http://www.rahul.net/dholmes/ctorrent/\n");
  fprintf(stderr,"bug report: %s\n",PACKAGE_BUGREPORT);
  fprintf(stderr,"original author: bsdi@sina.com\n\n");
}

