/*
 * $Id: physmap.c,v 1.3 2008-10-23 03:13:45 shearer_lu Exp $
 *
 * Normal mappings of chips in physical memory
 *
 * Copyright (C) 2003 MontaVista Software Inc.
 * Author: Jun Sun, jsun@mvista.com or jsun@junsun.net
 *
 * 031022 - [jsun] add run-time configure and partition setup
 */

#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <asm/io.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/config.h>
#include <linux/mtd/partitions.h>

static struct mtd_info *mymtd;

#undef CONFIG_MTD_PHYSMAP_START
#undef CONFIG_MTD_PHYSMAP_LEN

#if defined(__FLASH_32M__)
	#define	CONFIG_MTD_PHYSMAP_START	0xfe000000
	#define	CONFIG_MTD_PHYSMAP_LEN		0x2000000
#elif defined(__FLASH_16M__)
	#define	CONFIG_MTD_PHYSMAP_START	0xff000000
	#define	CONFIG_MTD_PHYSMAP_LEN		0x1000000
#else
	#define	CONFIG_MTD_PHYSMAP_START	0xff800000
	#define	CONFIG_MTD_PHYSMAP_LEN		0x800000
#endif

struct map_info physmap_map = {
	.name = "phys_mapped_flash",
	.phys = CONFIG_MTD_PHYSMAP_START,
	.size = CONFIG_MTD_PHYSMAP_LEN,
	.bankwidth = CONFIG_MTD_PHYSMAP_BANKWIDTH,
};

#ifdef CONFIG_MTD_PARTITIONS
static struct mtd_partition *mtd_parts;
static int                   mtd_parts_nb;

static int num_physmap_partitions;
static struct mtd_partition physmap_partitions[] = {
	/* Put your own partition definitions here */
	{
		.name =		"Kernel",
		.size =		0x1c0000,
		.offset =	MTDPART_OFS_APPEND,
		//.mask_flags =	MTD_WRITEABLE,  /* force read-only */
	},
	{
		.name =		"User FS",
#if	defined(__FLASH_32M__)
		.size =		0x1dc0000,
#elif defined(__FLASH_16M__)
		.size =		0xde0000,
#else
		.size =		0x5F0000,
#endif
		.offset =	MTDPART_OFS_APPEND,
	},
	{
		.name =		"Config",
		
#if	defined(__FLASH_32M__)
		.size =		0x40000,
#elif defined(__FLASH_16M__)
		.size =		0x20000,
#else
		.size =		0x10000,
#endif
		.offset =	MTDPART_OFS_APPEND,
		//.mask_flags =	MTD_WRITEABLE,  /* force read-only */
	},{
		.name =		"Loader",
		.size =		0x40000,
		.offset =	MTDPART_OFS_APPEND,
	}	
};

static const char *part_probes[] __initdata = {"cmdlinepart", "RedBoot", NULL};
#if 0
void physmap_set_partitions(struct mtd_partition *parts, int num_parts)
{
	physmap_partitions=parts;
	num_physmap_partitions=num_parts;
}
#endif
#endif /* CONFIG_MTD_PARTITIONS */

static int __init init_physmap(void)
{
	static const char *rom_probe_types[] = { "cfi_probe", "jedec_probe", "map_rom", NULL };
	const char **type;

	physmap_map.size = CONFIG_MTD_PHYSMAP_LEN;
	physmap_map.phys = CONFIG_MTD_PHYSMAP_START;
	printk(KERN_NOTICE "physmap flash device: %lx at %lx\n", physmap_map.size, physmap_map.phys);
	physmap_map.virt = ioremap(physmap_map.phys, physmap_map.size);

	if (!physmap_map.virt) {
		printk("Failed to ioremap\n");
		return -EIO;
	}

	simple_map_init(&physmap_map);

	mymtd = NULL;
	type = rom_probe_types;
	for(; !mymtd && *type; type++) {
		mymtd = do_map_probe(*type, &physmap_map);
	}
	if (mymtd) {
		mymtd->owner = THIS_MODULE;

#ifdef CONFIG_MTD_PARTITIONS
		mtd_parts_nb = parse_mtd_partitions(mymtd, part_probes, 
						    &mtd_parts, 0);

		if (mtd_parts_nb > 0)
		{
			add_mtd_partitions (mymtd, mtd_parts, mtd_parts_nb);
			return 0;
		}
		num_physmap_partitions=4;
		if (num_physmap_partitions != 0) 
		{
			printk(KERN_NOTICE 
			       "Using physmap partition definition\n");
			add_mtd_partitions (mymtd, physmap_partitions, num_physmap_partitions);
			return 0;
		}

#endif
		add_mtd_device(mymtd);

		return 0;
	}

	iounmap(physmap_map.virt);
	return -ENXIO;
}

static void __exit cleanup_physmap(void)
{
#ifdef CONFIG_MTD_PARTITIONS
	if (mtd_parts_nb) {
		del_mtd_partitions(mymtd);
		kfree(mtd_parts);
	} else if (num_physmap_partitions) {
		del_mtd_partitions(mymtd);
	} else {
		del_mtd_device(mymtd);
	}
#else
	del_mtd_device(mymtd);
#endif
	map_destroy(mymtd);

	iounmap(physmap_map.virt);
	physmap_map.virt = NULL;
}

module_init(init_physmap);
module_exit(cleanup_physmap);


MODULE_LICENSE("GPL");
MODULE_AUTHOR("David Woodhouse <dwmw2@infradead.org>");
MODULE_DESCRIPTION("Generic configurable MTD map driver");
