/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

This software file (the "File") is owned and distributed by Marvell 
International Ltd. and/or its affiliates ("Marvell") under the following
alternative licensing terms.  Once you have made an election to distribute the
File under one of the following license alternatives, please (i) delete this
introductory statement regarding license alternatives, (ii) delete the two
license alternatives that you have not elected to use and (iii) preserve the
Marvell copyright notice above.


********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.
*******************************************************************************/

#ifndef __msIoctl_h
#define __msIoctl_h

#define RG_IO_FILENAME "rgcfgio"
#define RG_IO_FULLPATH "/proc/rgcfgio"

#include "mv_platform.h"
#include "mv_unimac.h"

MV_BOOL UNM_IOControl(MV_U32  hOpenContext,
			  MV_U32  Ioctl,
			  MV_U8  *pInBuf,
			  MV_U32  InBufLen, 
			  MV_U8  *pOutBuf,
			  MV_U32  OutBufLen,
			  MV_U32 *pdwRet
			  );

typedef struct _GT_IOCTL_PARAM
{
  union 
  {
    GT_LPORT	portList[8];
    GT_LPORT	port;
    GT_U8  	u8Data;
    GT_U16  	u16Data;
    GT_U32  	u32Data;
    GT_BOOL 	boolData;
    
    GT_CTR_MODE	        ctrMode;
    GT_PORT_STP_STATE	stpState;
    GT_EGRESS_MODE	egressMode;
    GT_INGRESS_MODE	ingressMode;
    GT_MC_RATE		mcRate;
    GT_PORT_STAT	portStat;
    GT_RATE_LIMIT_MODE  rateLimitMode;
    GT_EGRESS_RATE      egressRate;
    ATU_SIZE 		atuSize;
    GT_FLUSH_CMD 	flushCmd;
    GT_DOT1Q_MODE       dot1QMode;
    GT_ATU_ENTRY 	atuEntry;
    GT_ETHERADDR 	etherAddr;
    GT_SYS_CONFIG 	sysConfig;
    GT_VTU_INT_STATUS   vtuIntStatus;
    GT_VTU_ENTRY        vtuEntry;
    GT_CABLE_STATUS     cableStatus;
    GT_1000BT_EXTENDED_STATUS extStatus;
    GT_SW_MODE          swMode;
    GT_SYS_CONFIG       sysCfg;
    GT_STATS_COUNTER_SET statsCounterSet;
    GT_QD_DEV           qd_dev;    
    MV_UNM_CONFIG       netconf;
  } FirstParam;


  union 
  {
    GT_LPORT	        port;
    GT_LPORT	        portList[8];
    GT_U8	        u8Data;
    GT_U16	        u16Data;
    GT_U32		u32Data;
    GT_BOOL		boolData;
    GT_PORT_STP_STATE	stpState;
    GT_EGRESS_MODE	egressMode;
    GT_INGRESS_MODE	ingressMode;
    GT_EGRESS_RATE      egressRate;
    GT_RATE_LIMIT_MODE  rateLimitMode;
    GT_MC_RATE		mcRate;
    GT_PORT_STAT	portStat;
    GT_DOT1Q_MODE       dot1QMode;
    GT_PHY_AUTO_MODE	phyAutoMode;
    GT_STATS_COUNTERS   statsCounter;
    GT_QD_DEV           dev;
    char	        szVlanName[20];
    char       vlan_names[MV_UNM_MAX_VID][MAX_VLAN_NAME];
    
  } SecondParam;
  
  union
  {
    GT_U8	  u8Data;
    GT_U16	  u16Data;
    GT_U32	  u32Data;
    GT_BOOL       boolData;
    unsigned char macs[MV_UNM_MAX_VID][GT_ETHERNET_HEADER_SIZE];    
  } ThirdParam;

  union
  {
    GT_BOOL       boolData;
  } FourthParam;

} GT_IOCTL_PARAM, *PGT_IOCTL_PARAM;



#define FILE_DEVICE_NETWORK (0)
#define METHOD_BUFFERED     (0)
#define FILE_ANY_ACCESS     (0)

#define GET_FUNC_FROM_CTL_CODE(_ioctl) (_ioctl) /* ((_ioctl>>2) & 0xFFF) */

#define CTL_CODE(file_device_net, func_mask, method, access) (func_mask)

/*
#define CTL_CODE(file_device_net, func_mask, method, access) \
     ( (file_device_net) | (func_mask) | (method) | (access) )
*/



/*
	We are using 0x800 ~ 0xFFF
	So, our program is using 6 bits for function group,
	and 6 bits for each function.
*/
#define SUB_FUNC_MASK			(0xFC0)
#define SYS_CFG_FUNC_MASK		((1 << 6) | 0x800)
#define SYS_CTRL_FUNC_MASK		((2 << 6) | 0x800)
#define FDB_FUNC_MASK			((3 << 6) | 0x800)
#define VLAN_FUNC_MASK			((4 << 6) | 0x800)
#define STP_FUNC_MASK			((5 << 6) | 0x800)
#define PORT_CTRL_FUNC_MASK		((6 << 6) | 0x800)
#define PORT_STATUS_FUNC_MASK	        ((7 << 6) | 0x800)
#define PORT_STATS_FUNC_MASK	        ((8 << 6) | 0x800)
#define QOS_FUNC_MASK			((9 << 6) | 0x800)
#define PHY_CTRL_FUNC_MASK		((10 << 6) | 0x800)
#define SYS_EVENT_FUNC_MASK		((11 << 6) | 0x800)
#define PHY_INT_FUNC_MASK		((12 << 6) | 0x800)
#define PAV_FUNC_MASK		        ((13 << 6) | 0x800)
#define PRC_FUNC_MASK	                ((14 << 6) | 0x800)
#define VTU_FUNC_MASK	                ((15 << 6) | 0x800)
#define STATS_RMON_FUNC_MASK            ((16 << 6) | 0x800)
#define STATS_SYS_FUNC_MASK             ((17 << 6) | 0x800)
#define VCT_FUNC_MASK                   ((18 << 6) | 0x800)
#define UNM_NET_FUNC_MASK		((19 << 6) | 0x800)



/*
	Functions for SYS Configuration
*/
#define IOCTL_sysConfig    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CFG_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysReadMiiReg    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CFG_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysWriteMiiReg    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CFG_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gtVersion    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CFG_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gLoadDriver   \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CFG_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gUnloadDriver   \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CFG_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gSysEnable    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CFG_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)



/*
	Functions for ATU
*/
#define IOCTL_gfdbSetAtuSize    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbGetAgingTimeRange    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbSetAgingTimeout    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbGetAtuDynamicCount    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbGetAtuEntryFirst    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbGetAtuEntryNext    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbFindAtuMacEntry    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbFlush    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbAddMacEntry    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbDelMacEntry    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 9, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbLearnEnable    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 10, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbDelAtuEntry    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 11, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gfdbFlushInDB    \
    CTL_CODE(FILE_DEVICE_NETWORK , FDB_FUNC_MASK + 12, METHOD_BUFFERED, FILE_ANY_ACCESS)


/*
	Functions for STP
*/
#define IOCTL_gstpSetMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , STP_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gstpSetPortState    \
    CTL_CODE(FILE_DEVICE_NETWORK , STP_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gstpGetPortState    \
    CTL_CODE(FILE_DEVICE_NETWORK , STP_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)


/*
	Functions for VLAN
*/
#define IOCTL_gprtSetEgressMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetEgressMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetVlanTunnel    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetVlanTunnel    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnSetPortVlanPorts    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnGetPortVlanPorts    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnSetPortUserPriLsb    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnGetPortUserPriLsb    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnSetPortVid    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnGetPortVid    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 9, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnSetPortVlanDBNum    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 10, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnGetPortVlanDBNum    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 11, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnSetPortVlanDot1qMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 12, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnGetPortVlanDot1qMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 13, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnSetPortVlanForceDefaultVID    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 14, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvlnGetPortVlanForceDefaultVID    \
    CTL_CODE(FILE_DEVICE_NETWORK , VLAN_FUNC_MASK + 15, METHOD_BUFFERED, FILE_ANY_ACCESS)



/*
	Functions for System Event
*/
#define IOCTL_eventSetActive    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_EVENT_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_eventGetIntStatus    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_EVENT_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)


/*
	Functions for Phy Control
*/
#define IOCTL_gprtPhyReset    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetPortLoopback    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetPortSpeed    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtPortAutoNegEnable    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtPortPowerDown    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtPortRestartAutoNeg    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetPortDuplexMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetPortAutoMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetPause    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)


/* 
	Functions for Phy Interrupt
*/
#define IOCTL_gprtPhyIntEnable    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_INT_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetPhyIntStatus    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_INT_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetPhyIntPortSummary    \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_INT_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

/*
	Functions for Port Control
*/
#define IOCTL_gprtSetForceFc    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_CTRL_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetForceFc    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_CTRL_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetTrailerMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_CTRL_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetTrailerMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_CTRL_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetIngressMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_CTRL_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetIngressMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_CTRL_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetMcRateLimit    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_CTRL_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetMcRateLimit    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_CTRL_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetHeaderMode   \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetHeaderMode   \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 9, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetIGMPSnoop   \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 10, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetIGMPSnoop   \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 11, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtSetDuplex   \
    CTL_CODE(FILE_DEVICE_NETWORK , PHY_CTRL_FUNC_MASK + 12, METHOD_BUFFERED, FILE_ANY_ACCESS)



/*
	Functions for Port Statistics
*/
#define IOCTL_gprtSetCtrMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATS_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtClearAllCtr    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATS_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)



/*
	Functions for Port Status
*/
#define IOCTL_gprtGetPartnerLinkPause    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetSelfLinkPause    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetResolve    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetLinkState    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetPortMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetPhyMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetDuplex    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetSpeed    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gprtGetPortCtr    \
    CTL_CODE(FILE_DEVICE_NETWORK , PORT_STATUS_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)


/*
	Functions for QoS Mapping
*/
#define IOCTL_gcosSetPortDefaultTc    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gqosSetPrioMapRule    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gqosGetPrioMapRule    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gqosIpPrioMapEn    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gqosGetIpPrioMapEn    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gqosUserPrioMapEn    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gqosGetUserPrioMapEn    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gcosGetUserPrio2Tc    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gcosSetUserPrio2Tc    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gcosGetDscp2Tc    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 9, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gcosSetDscp2Tc    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 10, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gcosGetPortDefaultTc    \
    CTL_CODE(FILE_DEVICE_NETWORK , QOS_FUNC_MASK + 11, METHOD_BUFFERED, FILE_ANY_ACCESS)

/*
	Functions for Sys Control
*/
#define IOCTL_gsysSwReset    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysSetDiscardExcessive    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysGetDiscardExcessive    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysSetSchedulingMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysGetSchedulingMode    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysSetMaxFrameSize    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysGetMaxFrameSize    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysReLoad    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysSetWatchDog    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysGetWatchDog    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 9, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysSetDuplexPauseMac    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 10, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysGetDuplexPauseMac    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 11, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysSetPerPortDuplexPauseMac    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 12, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysGetPerPortDuplexPauseMac    \
    CTL_CODE(FILE_DEVICE_NETWORK , SYS_CTRL_FUNC_MASK + 13, METHOD_BUFFERED, FILE_ANY_ACCESS)


/*
 * Fuctions to System status
 */
#define IOCTL_gsysGetSW_Mode    \
    CTL_CODE(FILE_DEVICE_NETWORK , STATS_SYS_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gsysGetInitReady    \
    CTL_CODE(FILE_DEVICE_NETWORK , STATS_SYS_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)



/*
 *
 */
#define IOCTL_UNM_GET_VLAN_NAMES    \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_UNM_GET_VLAN_PARMS    \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_UNM_GET_PORT_VLAN	    \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_UNM_ASSOC_PORT	    \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_UNM_DISASSSOC_PORT    \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_UNM_INIT              \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_UNM_STATUS            \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_UNM_READ_REG          \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_UNM_WRITE_REG          \
    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

/*
#define IOCTL_UNM_SAVE_NETCONF    CTL_CODE(FILE_DEVICE_NETWORK , UNM_NET_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)
*/

/*  
 * Functions for Port Association Vector
 */
#define IOCTL_gpavSetPAV  \
    CTL_CODE(FILE_DEVICE_NETWORK , PAV_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gpavGetPAV  \
    CTL_CODE(FILE_DEVICE_NETWORK , PAV_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gpavSetIngressMonitor  \
    CTL_CODE(FILE_DEVICE_NETWORK , PAV_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gpavGetIngressMonitor  \
    CTL_CODE(FILE_DEVICE_NETWORK , PAV_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)


/* 
 * Functions for Port Rate Control
 */
#define IOCTL_grcSetLimitMode  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcGetLimitMode  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcSetEgressRate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcGetEgressRate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcSetPri3Rate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcGetPri3Rate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcSetPri0Rate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcGetPri0Rate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcSetPri1Rate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcGetPri1Rate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 9, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcSetPri2Rate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 10, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcGetPri2Rate  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 11, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcSetBytesCount  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 12, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_grcGetBytesCount  \
    CTL_CODE(FILE_DEVICE_NETWORK , PRC_FUNC_MASK + 13, METHOD_BUFFERED, FILE_ANY_ACCESS)


/*
 *
 */
#define IOCTL_gvtuGetIntStatus \
    CTL_CODE(FILE_DEVICE_NETWORK , VTU_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvtuGetEntryCount \
    CTL_CODE(FILE_DEVICE_NETWORK , VTU_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvtuGetEntryFirst \
    CTL_CODE(FILE_DEVICE_NETWORK , VTU_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvtuGetEntryNext \
    CTL_CODE(FILE_DEVICE_NETWORK , VTU_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvtuFindVidEntry \
    CTL_CODE(FILE_DEVICE_NETWORK , VTU_FUNC_MASK + 4, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvtuFlush \
    CTL_CODE(FILE_DEVICE_NETWORK , VTU_FUNC_MASK + 5, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvtuAddEntry \
    CTL_CODE(FILE_DEVICE_NETWORK , VTU_FUNC_MASK + 6, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvtuDelEntry \
    CTL_CODE(FILE_DEVICE_NETWORK , VTU_FUNC_MASK + 7, METHOD_BUFFERED, FILE_ANY_ACCESS)


/*
 * Functions for RMON counters
 */
#define IOCTL_gstatsFlushAll \
    CTL_CODE(FILE_DEVICE_NETWORK , STATS_RMON_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gstatsFlushPort \
    CTL_CODE(FILE_DEVICE_NETWORK , STATS_RMON_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gstatsGetPortCounter \
    CTL_CODE(FILE_DEVICE_NETWORK , STATS_RMON_FUNC_MASK + 2, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gstatsGetPortAllCounters \
    CTL_CODE(FILE_DEVICE_NETWORK , STATS_RMON_FUNC_MASK + 3, METHOD_BUFFERED, FILE_ANY_ACCESS)



/*
 * Function cable test
 */
#define IOCTL_gvctGetCableDiag \
    CTL_CODE(FILE_DEVICE_NETWORK , VCT_FUNC_MASK + 0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_gvctGet1000BTExtendedStatus \
    CTL_CODE(FILE_DEVICE_NETWORK , VCT_FUNC_MASK + 1, METHOD_BUFFERED, FILE_ANY_ACCESS)











/**/




#endif /* __msApi_h */
