/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/list.h>
#include <linux/device.h>
#include <linux/slab.h>
#include <linux/string.h>
#include <linux/sysdev.h>
#include <asm/mach/time.h>
#if defined(CONFIG_MTD_PHYSMAP) 
#include <linux/mtd/physmap.h>
#endif
#include <asm/hardware.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>

#include <asm/mach/arch.h>
#include <asm/mach/flash.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>
#include <asm/arch/system.h>
#include <asm/arch/orion_ver.h>

#include <asm/vfp.h>

#include <linux/tty.h>
#include <linux/serial_core.h>
#include <linux/serial.h>
#include <linux/serialP.h>
#include <linux/serial_reg.h>
#include <asm/serial.h>

#include <asm/arch/serial.h>

#include "mvCtrlEnvLib.h"
#include "mvCpuIf.h"
#include "mvDevice.h"
#include "mvBoardEnvLib.h"
#include "mvDebug.h"

#ifdef CONFIG_ARCH_MV88f5181
#   include "mvIdma.h"
#   include "mvUsb.h"
#endif /* CONFIG_ARCH_MV88f5181 */

#ifdef CONFIG_MV_CESA
#include "mvCesa.h"
#include "mvMD5.h"
#include "mvSHA1.h"
#endif /* CONFIG_MV_CESA */

extern void __init mv_map_io(void);
extern void __init mv_init_irq(void);
extern MV_U32 boardGetDevCSNum(MV_32 devNum, MV_BOARD_DEV_TYPE devType);

unsigned int mv_orion_ver = 0x0;
unsigned int support_wait_for_interrupt = 0x1;

#ifdef CONFIG_UBOOT_STRUCT

u32 mvTclk = 166666667;
u32 mvSysclk = 200000000;
u32 mvIsUsbHost = 1;
u32 overEthAddr = 0;
#if defined(MV_88W8660)
u8	mvMacAddr[6] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
#endif
extern MV_U32 gBoardId; 
extern unsigned int elf_hwcap;
 
static int __init parse_tag_mv_uboot(const struct tag *tag)
{
    unsigned int mvUbootVer = 0;

        mvTclk = tag->u.mv_uboot.tclk;
    mvSysclk = tag->u.mv_uboot.sysclk;
    mvUbootVer = tag->u.mv_uboot.uboot_version;
    mvIsUsbHost = tag->u.mv_uboot.isUsbHost;

    if(mvTclk == 166000000)
	    mvTclk = 166666667;
    if(mvTclk == 133000000)
	    mvTclk = 133333333;
    if(mvSysclk == 166000000)
	    mvSysclk = 166666667;

    printk("Using UBoot passing parameters structure\n");
    printk("Sys Clk = %d, Tclk = %d\n",mvSysclk ,mvTclk  );

#if 0
        /* check the u-boot version */
        if( (TEST_UBOOT_VER & 0xffffff00) != (mvUbootVer & 0xffffff00) ) {
                printk( "\n\n- Warning - This LSP release was tested only with U-Boot release %d.%d.%d \n\n", \
                TEST_UBOOT_VER >> 24, (TEST_UBOOT_VER >> 16) & 0xff,(TEST_UBOOT_VER >> 8) & 0xff );
        }
#endif
    /* If POS NAS version */
    if((mvUbootVer & 0xff) == 0xab)
    {
            gBoardId = RD_88F5181_POS_NAS;
    }
    else if ((mvUbootVer & 0xff) == 0xbc)
    {
        gBoardId = RD_88F5181_VOIP; 
    }
    else if((mvUbootVer & 0xff) == 0xcd)
    {
            gBoardId = DB_88F5X81_DDR2;
    }
    else if((mvUbootVer & 0xff) == 0xce)
    {
            gBoardId = DB_88F5X81_DDR1;
    }
#if	defined(MV_88F5182) || defined(RD_DB_88F5181L) || defined(MV_88W8660)
    else
    {
            gBoardId =  (mvUbootVer & 0xff);
    }
#endif  
        
    if( mvUbootVer > 0x01040100 )  /* releases after 1.4.2 */
    {
		overEthAddr = tag->u.mv_uboot.overEthAddr;        
#if defined (MV_88W8660)
    	/*U-boot version => 1.9.2*/			
	    if (mvUbootVer >= 0x01090200)					
	    {
		    memcpy(mvMacAddr, tag->u.mv_uboot.macAddr, 6);
	    }
#endif
    }
    return 0;
}
                                                                                                                             
__tagtable(ATAG_MV_UBOOT, parse_tag_mv_uboot);
#else
u32 mvTclk = 166666667;
u32 mvSysclk = 200000000;
#ifdef CONFIG_MV_USB_HOST
    u32 mvIsUsbHost = 1;
#else
    u32 mvIsUsbHost = 0;
#endif
#endif

#if defined(MV_88F5182) || defined(RD_DB_88F5181L)
unsigned char*  mv_sram_usage_get(int* sram_size_ptr)
{
    int used_size = 0;

#if defined(CONFIG_MV_CESA)
    used_size = sizeof(MV_CESA_SRAM_MAP);
#endif

    if(sram_size_ptr != NULL)
        *sram_size_ptr = _8K - used_size;

    return (char *)(CRYPT_ENG_BASE + used_size);
}
#endif

#ifdef CONFIG_ARCH_MV88f5181
/* Return number of free IDMA engines */
int mv_idma_usage_get(int* free_map)
{
    int idma, free;

    free = MV_IDMA_MAX_CHAN;
    for(idma=0; idma<MV_IDMA_MAX_CHAN; idma++)
    {
        free_map[idma] = 1;
    }
#if defined(CONFIG_MV_CESA)
    /* CESA uses Idma channel #0. Idma engine #1 used when CESA use two channels */
    for(idma=0; idma<MV_CESA_MAX_CHAN; idma++)
    {
        free_map[idma] = 0;
        free--;
    }
#endif /* CONFIG_MV_CESA */

#ifdef CONFIG_MV_DMA_COPYUSER
    free_map[2] = 0;
    free_map[3] = 0;
    free -= 2;
#endif /* CONFIG_MV_DMA_COPYUSER */

    return free;
}
#endif /* CONFIG_ARCH_MV88f5181 */


EXPORT_SYMBOL(mvTclk);
EXPORT_SYMBOL(mvSysclk);
EXPORT_SYMBOL(mvCtrlModelGet);
EXPORT_SYMBOL(mvOsIoUncachedMalloc);
EXPORT_SYMBOL(mvOsIoUncachedFree);
EXPORT_SYMBOL(mvOsIoCachedMalloc);
EXPORT_SYMBOL(mvOsIoCachedFree);
EXPORT_SYMBOL(mvOsCacheFlush);
EXPORT_SYMBOL(mvDebugMemDump);
EXPORT_SYMBOL(mvHexToBin);
EXPORT_SYMBOL(mvBinToHex);
EXPORT_SYMBOL(mvIsUsbHost);
EXPORT_SYMBOL(mvCtrlUsbMaxGet);
EXPORT_SYMBOL(mvCtrlModelRevGet);

#ifdef CONFIG_ARCH_MV88f5181
EXPORT_SYMBOL(mv_idma_usage_get);
EXPORT_SYMBOL(mvDmaTransfer);
EXPORT_SYMBOL(mvDmaStateGet);
EXPORT_SYMBOL(mvUsbGetCapRegAddr);
EXPORT_SYMBOL(mvUsbDevResetComplete);
#endif /* CONFIG_ARCH_MV88f5181 */

#ifdef CONFIG_MV_CESA
EXPORT_SYMBOL(mvCesaInit);
EXPORT_SYMBOL(mvCesaSessionOpen);
EXPORT_SYMBOL(mvCesaSessionClose);
EXPORT_SYMBOL(mvCesaAction);
EXPORT_SYMBOL(mvCesaReadyGet);
EXPORT_SYMBOL(mvCesaChanInProcessGet);
EXPORT_SYMBOL(mvCesaCopyFromMbuf);
EXPORT_SYMBOL(mvCesaCopyToMbuf);
EXPORT_SYMBOL(mvCesaMbufCopy);
EXPORT_SYMBOL(mvCesaCryptoIvSet);
EXPORT_SYMBOL(mvMD5);
EXPORT_SYMBOL(mvSHA1);

EXPORT_SYMBOL(mvCesaDebugCacheIdx);
EXPORT_SYMBOL(mvCesaDebugQueue);
EXPORT_SYMBOL(mvCesaDebugSram);
EXPORT_SYMBOL(mvCesaDebugSAD);
EXPORT_SYMBOL(mvCesaDebugStatus);
EXPORT_SYMBOL(mvCesaDebugMbuf);
EXPORT_SYMBOL(mvCesaDebugChan);
EXPORT_SYMBOL(mvCesaDebugSA);
#endif /* CONFIG_MV_CESA */
#if defined(MV_88F5182) || defined(RD_DB_88F5181L)
EXPORT_SYMBOL(mv_sram_usage_get);
#endif

void print_board_info(void)
{
    char name_buff[50];
#ifdef CONFIG_ARCH_MV88f1181 
    printk("\n  Marvell Development Board (LSP Version %s)\n\n",LSP_VERSION);
#else
    printk("\n  Marvell Development Board (LSP Version %s)",LSP_VERSION);

    mvBoardNameGet(name_buff);
    printk("-- %s ",name_buff);

    mvCtrlModelRevNameGet(name_buff);
    printk(" Soc: %s",  name_buff);

    printk("\n\n");
#endif
    printk(" Detected Tclk %d and SysClk %d \n",mvTclk, mvSysclk);
}

/* Add the uart to the console list (ttyS0) . */
static void serial_initialize(void)
{
    struct uart_port        serial_req;

    memset(&serial_req, 0, sizeof(serial_req));
    serial_req.line = 0;
    serial_req.uartclk = BASE_BAUD * 16;
    serial_req.irq = IRQ_UART0;
    serial_req.flags = STD_COM_FLAGS;
    serial_req.iotype = SERIAL_IO_MEM;
    serial_req.membase = (char *)PORT0_BASE;
    serial_req.regshift = 2;

    if (early_serial_setup(&serial_req) != 0) {
        printk("Early serial init of port 0 failed\n");
    }

    return;
}
#if defined(CONFIG_MTD_PHYSMAP) 
static void mv_mtd_initialize(void)
{
    u32 size = 0, boardId = 0;
    u32 base = DEVICE_CS1_BASE;
    u32 bankwidth = mvBoardGetDeviceBusWidth(1,BOARD_DEV_NOR_FLASH) / 8;
    
    boardId = mvBoardIdGet();
    switch(boardId) {
        case(RD_88F5181_VOIP):
            size = _8M;
            break;
        case(DB_88F5X81_DDR2):
        case(DB_88F5X81_DDR1):
            size = _32M;
            break;
        case(RD_88F5181_POS_NAS):
            size = 0;
            break;
        case(DB_88F5181_5281_DDR1):
        case(DB_88F5181_5281_DDR2):
            size = _16M;
            break;  
        case(DB_88F5182_DDR2):
        case(DB_88W8660_DDR2):
            size = _16M;
            break;
        case(RD_88F5182_2XSATA):
        case(RD_88F5182_2XSATA3):
            size = _256K;
            base = mvCpuIfTargetWinBaseLowGet(DEV_BOOCS);
	    bankwidth = mvBoardGetDeviceBusWidth(0,BOARD_DEV_NOR_FLASH) / 8;
            break;
	case(RD_88W8660_AP82S_DDR1):
        case(RD_88F5181L_VOIP_FE):
	case(RD_88F5181L_VOIP_GE):
	case(RD_88W8660_DDR1):
            size = mvCpuIfTargetWinSizeGet(DEV_BOOCS);
            base =  mvCpuIfTargetWinBaseLowGet(DEV_BOOCS);
            bankwidth = mvBoardGetDeviceBusWidth(0,BOARD_DEV_NOR_FLASH) / 8;
            printk("Flash bankwidth %d, base %x, size %x\n", bankwidth, base, size); 
            break;
  
        default:
            printk(" %s Error : Unknown board \n", __FUNCTION__);
            size = 0;
    }
    if(size == 0)
        return;

    physmap_configure(base, size, bankwidth, NULL);

    return;
}
#endif

static void config_device_cs(void)
{
	/* changing default CPU windows settings for a specific platform */
	MV_CPU_DEC_WIN cs_win;
	memset(&cs_win,0,sizeof(MV_CPU_DEC_WIN));

	switch(mvBoardIdGet()) {
		case(RD_88F5181_POS_NAS):
			/* CS0: N/A. CS1: 16M NOR. CS2: N/A. bootCS: 0.5M NOR */
			mvCpuIfTargetWinEnable(DEVICE_CS2, MV_FALSE);
			mvCpuIfTargetWinGet(DEVICE_CS1, &cs_win);
			cs_win.addrWin.size = _16M;
			mvCpuIfTargetWinSet(DEVICE_CS1, &cs_win);
			mvCpuIfTargetWinEnable(DEVICE_CS0, MV_FALSE);
			break;
		case(RD_88F5182_2XSATA):
		case(RD_88F5182_2XSATA3):
			/* CS0: (I) N/A, (II) CESA. CS1: 16M NOR. CS2: N/A. bootCS: 0.5M NOR. */
			mvCpuIfTargetWinEnable(DEVICE_CS2, MV_FALSE);
			mvCpuIfTargetWinGet(DEVICE_CS1, &cs_win);
			cs_win.addrWin.size = _16M;
			mvCpuIfTargetWinSet(DEVICE_CS1, &cs_win);
			mvCpuIfTargetWinEnable(DEVICE_CS0, MV_FALSE);
#if defined(CONFIG_MV_CESA) || defined (USB_UNDERRUN_WA)
			cs_win.addrWin.baseLow = CRYPT_ENG_BASE;
			cs_win.addrWin.size = CRYPT_ENG_SIZE;
			cs_win.enable = MV_TRUE;
                        cs_win.winNum = mvAhbToMbusWinAvailGet();
                        if(cs_win.winNum == 0xffffffff)
                                printk("Line %d: Error no more available windows \n",__LINE__);
			mvCpuIfTargetWinSet(CRYPT_ENG, &cs_win);
#endif
			break;
		case(RD_88F5181_VOIP):
			/* CS0: TDM FPGA. CS1: 8M NOR. CS2: N/A. bootCS: 0.5 NOR. */
			mvCpuIfTargetWinEnable(DEVICE_CS2, MV_FALSE);
			mvCpuIfTargetWinGet(DEVICE_CS1, &cs_win);
			cs_win.addrWin.size = _8M;
			mvCpuIfTargetWinSet(DEVICE_CS1, &cs_win);
			break;
		case(RD_88F5181L_VOIP_FE):
		case(RD_88F5181L_VOIP_GE):
		case(RD_88W8660_DDR1):
			/* CS0: N/A. CS1: N/A. CS2: N/A. bootCS: 16M NOR. */
			mvCpuIfTargetWinEnable(DEVICE_CS2, MV_FALSE);
			mvCpuIfTargetWinEnable(DEVICE_CS1, MV_FALSE);
			mvCpuIfTargetWinEnable(DEVICE_CS0, MV_FALSE);
			mvCpuIfTargetWinGet(DEV_BOOCS, &cs_win);
			cs_win.addrWin.baseLow = 0xf4000000;
			cs_win.addrWin.size = _16M;
			mvCpuIfTargetWinSet(DEV_BOOCS, &cs_win);
#if defined(CONFIG_MV_CESA) || defined (USB_UNDERRUN_WA)
                        cs_win.addrWin.baseLow = CRYPT_ENG_BASE;
                        cs_win.addrWin.size = CRYPT_ENG_SIZE;
                        cs_win.enable = MV_TRUE;
                        cs_win.winNum = mvAhbToMbusWinAvailGet();
                        if(cs_win.winNum == 0xffffffff)
                                printk("Line %d: Error no more available windows \n",__LINE__);
                        mvCpuIfTargetWinSet(CRYPT_ENG, &cs_win);
#endif
			break;
		case(RD_88W8660_AP82S_DDR1):
			/* CS0: N/A. CS1: N/A. CS2: N/A. bootCS: (I) 32M NAND, (II) 4M NOR. */
			mvCpuIfTargetWinEnable(DEVICE_CS2, MV_FALSE);
			mvCpuIfTargetWinEnable(DEVICE_CS1, MV_FALSE);
			mvCpuIfTargetWinEnable(DEVICE_CS0, MV_FALSE);
			mvCpuIfTargetWinGet(DEV_BOOCS, &cs_win);
			cs_win.addrWin.baseLow = 0xf4000000;
#ifdef CONFIG_MV_NAND_BOOT
			cs_win.addrWin.size = _1M;
#else
			cs_win.addrWin.size = _4M;/*_8M;*/
#endif
			mvCpuIfTargetWinSet(DEV_BOOCS, &cs_win);
			break;
		case(DB_88F5181_5281_DDR1):
		case(DB_88F5181_5281_DDR2):
			/* CS0: N/A, CS1: 16M NOR, CS2: 7seg, bootCS: 0.5M NOR */
			mvCpuIfTargetWinEnable(DEVICE_CS0, MV_FALSE);
			mvCpuIfTargetWinGet(DEVICE_CS1, &cs_win);
			cs_win.addrWin.size = _16M;
			mvCpuIfTargetWinSet(DEVICE_CS1, &cs_win);
			break;
		case(DB_88F5182_DDR2):
			/* CS0: 7seg. (I) CS1: 32M NOR, CS2: CESA, (II) CS1: CESA, CS2: 32M NAND. bootCS: 0.5 NOR */
			mvCpuIfTargetWinEnable(DEVICE_CS2, MV_FALSE);
			mvCpuIfTargetWinEnable(DEVICE_CS1, MV_FALSE);
#ifdef CONFIG_MV_NAND
			cs_win.addrWin.baseLow = 0xf4000000;
			cs_win.enable = MV_TRUE;
			cs_win.addrWin.size = _1M;
			cs_win.winNum = mvAhbToMbusWinAvailGet();
			if(cs_win.winNum == 0xffffffff)
				printk("Line %d: Error no more available windows \n",__LINE__);
			mvCpuIfTargetWinSet(DEVICE_CS2, &cs_win);
#else
			cs_win.addrWin.baseLow = 0xf4000000;
			cs_win.enable = MV_TRUE;
			cs_win.addrWin.size = _32M;
			cs_win.winNum = mvAhbToMbusWinAvailGet();
                        if(cs_win.winNum == 0xffffffff)
                                printk("Line %d: Error no more available windows \n",__LINE__);
			mvCpuIfTargetWinSet(DEVICE_CS1, &cs_win);
#endif
#if defined(CONFIG_MV_CESA) || defined (USB_UNDERRUN_WA)
			cs_win.addrWin.baseLow = CRYPT_ENG_BASE;
			cs_win.addrWin.size = CRYPT_ENG_SIZE;
			cs_win.enable = MV_TRUE;
			cs_win.winNum = mvAhbToMbusWinAvailGet();
                        if(cs_win.winNum == 0xffffffff)
                                printk("Line %d: Error no more available windows \n",__LINE__);
			mvCpuIfTargetWinSet(CRYPT_ENG, &cs_win);
#endif
			break;
		case(DB_88F5X81_DDR2):
		case(DB_88F5X81_DDR1):
		case(DB_88W8660_DDR2):
			/* defaults -  CS0: 7seg, CS1: 32M NOR flash, CS2: 32M NAND flash, bootCS: 0.5M NOR flash */
#ifdef CONFIG_MV_NAND_BOOT
			mvCpuIfTargetWinEnable(DEVICE_CS2, MV_FALSE);
			mvCpuIfTargetWinEnable(DEVICE_CS1, MV_FALSE);
			mvCpuIfTargetWinGet(DEV_BOOCS, &cs_win);
			cs_win.addrWin.baseLow = 0xf4000000;
			cs_win.addrWin.size = _1M;
			mvCpuIfTargetWinSet(DEV_BOOCS, &cs_win);
#endif
			break;
		default:
			printk(" %s Error : Unknown board \n", __FUNCTION__);
	}
}

static void __init mv_init(void)
{
        /* init the Board environment */
		
        mvBoardEnvInit();
#if 0
        /* init the controller environment */
        if( mvCtrlEnvInit() )
        {
            printk( "Controller env initialization failed.\n" );
            return;
        }
#endif
        /* Init the CPU windows setting and the access protection windows. */
        if( mvCpuIfInit() )
        {
            printk( "Cpu Interface initialization failed.\n" );
            return;
        }
    	/* adjust CPU windows for PCI IO ramap */
    	if( MV_OK != mvAhbToMbusWinTargetSwap(PEX0_IO , PEX0_MEM) )
    	{
            printk( "SWAP windows failed.\n" );
            return; 
    	}
#ifdef CONFIG_ARCH_MV88f5181
        if(mvCtrlModelGet() != MV_5082_DEV_ID)
        {
            if( MV_OK != mvAhbToMbusWinTargetSwap(PCI0_IO , PCI0_MEM) )
            {
                printk( "SWAP windows failed.\n" );
                return;
            }
        }
#else
        if( MV_OK != mvAhbToMbusWinTargetSwap(PEX1_IO , PEX1_MEM) )
        {
            printk( "SWAP windows failed.\n" );
            return;
        }
#endif

    	if(mvCtrlModelGet() == MV_5281_DEV_ID)
            mv_orion_ver = MV_ORION2; /* Orion II */    
    	else
            mv_orion_ver = MV_ORION1; /* Orion I */ 

        /* Implement workaround for FEr# CPU-C16: Wait for interrupt command */ 
        /* is not processed properly, the workaround is not to use this command */
        /* the erratum is relevant for 5281 devices with revision less than C0 */
        if((mvCtrlModelGet() == MV_5281_DEV_ID)
         && (mvCtrlRevGet() < MV_5281_C0_REV))
        {
            support_wait_for_interrupt = 0;
        }
#if defined(CONFIG_VFP) || defined(CONFIG_VFP_RUN_FAST_MODE)
         if(mvCtrlModelGet() == MV_5281_DEV_ID)
        {
            elf_hwcap |= HWCAP_VFP; 
        }
#endif
        if(mvCtrlModelGet() != MV_5281_DEV_ID)
        {   
            elf_hwcap &= ~HWCAP_EDSP;
        }
        elf_hwcap &= ~HWCAP_JAVA;

#ifdef CONFIG_VFP_RUN_FAST_MODE
#define vfpreg(_vfp_) #_vfp_

#define fmrx(_vfp_) ({			\
	u32 __v;			\
	asm("mrc%? p10, 7, %0, " vfpreg(_vfp_) ", cr0, 0 @ fmrx	%0, " #_vfp_	\
	    : "=r" (__v));		\
	__v;				\
 })

#define fmxr(_vfp_,_var_)		\
	asm("mcr%? p10, 7, %0, " vfpreg(_vfp_) ", cr0, 0 @ fmxr	" #_vfp_ ", %0"	\
	   : : "r" (_var_))

        if( mv_orion_ver == MV_ORION2)
        {
            /* init and Enable VFP to Run Fast Mode */
            printk("VFP initialized to Run Fast Mode.\n");
            /* Enable */
            fmxr(FPEXC, fmrx(FPEXC) | FPEXC_ENABLE);

            /* Run Fast Mode */
            fmxr(FPSCR, fmrx(FPSCR) | (FPSCR_DEFAULT_NAN | FPSCR_FLUSHTOZERO));

        }
#endif

#ifndef CONFIG_UBOOT_STRUCT
    	mvTclk = mvBoardTclkGet();
    	mvSysclk = mvBoardSysClkGet();
#endif
    	serial_initialize();

	/* At this point, the CPU windows are configured according to default definitions in mvSysHwConfig.h */
	/* and cpuAddrWinMap table in mvCpuIf.c. Now it's time to change defaults for each platform.         */
	config_device_cs();
	mvCpuIfAddDecShow();

#if defined(CONFIG_MTD_PHYSMAP) && !defined(CONFIG_MV_NAND_BOOT)
	/*if(0xffffffff != boardGetDevCSNum(0, BOARD_DEV_NOR_FLASH)) */
		mv_mtd_initialize();
#endif
#if defined(MV_88F5182)
        mvSataWinInit();
#endif
    	print_board_info();

#ifdef CONFIG_ARCH_MV88f5181
    mvDmaInit();
#endif

    return;
}

#include "asm/arch/time.h"

static void __init mv_init_timer(void)
{
        mv_time_init();
}

static struct sys_timer mv_timer = {
        .init           = mv_init_timer,
        .offset         = mv_gettimeoffset,
};

MACHINE_START(MV88fxx81 ,"MV-88fxx81")
    MAINTAINER("MARVELL")
    BOOT_MEM(0x00000000, 0xf1000000, 0xf1100000)
    BOOT_PARAMS(0x00000100)
    MAPIO(mv_map_io)
    INITIRQ(mv_init_irq)
    .timer          = &mv_timer,
    INIT_MACHINE(mv_init)
MACHINE_END

