#include "stralloc.h"
#include "urlparse.h"
#include "str.h"

#define STRDUP(x,p,l) do { if (!stralloc_copyb(x,p,l)) return -1; } while(0)
int urlparse(const char *url, stralloc *proto, stralloc *user, stralloc *pass,
	stralloc *hostport, stralloc *rest)
{
	const char *p;
	const char *q;
	/* proto://user:pass@host:port/SOME */
	p=url;
	q=url;
	if (proto) proto->len=0;
	if (user) user->len=0;
	if (pass) pass->len=0;
	if (hostport) hostport->len=0;
	if (rest) rest->len=0;
	while (*q && *q!=':') q++;
	if (!*q || q==p) return 0;
	if (proto) STRDUP(proto,p,q-p);
	q++;
	if (*q=='/') q++;
	if (*q=='/') q++;
	p=q;
	while (*q && *q!='@' && *q!='/') q++;
	if (!*q) return 0;
	if (*q=='@') {
		const char *r=p;
		while (r!=q && *r!=':') r++;
		if (*r==':') {
			if (user) STRDUP(user,p,r-p);
			r++;
			if (pass) STRDUP(pass,r,q-r);
		} else {
			if (user) STRDUP(user,p,q-p);
		}
		q++;
		p=q;
		while (*q && *q!='/') q++;
		if (!*q) return 0;
	}
	if (hostport) STRDUP(hostport,p,q-p);
	if (rest) STRDUP(rest,q,str_len(q));
	return 1;
}
