/* Reimplementation of Daniel J. Bernsteins timeoutconn.
 * (C) 2001 Uwe Ohse, <uwe@ohse.de>.
 *   Report any bugs to <uwe@ohse.de>.
 * Placed in the public domain.
 */
/* @(#) $Id: timeoutconn.c,v 1.1.1.1 2005/08/17 06:37:29 johnsoncheng Exp $ */
#include "error.h"
#include "iopause.h"
#include "timeoutconn.h"
#include "ndelay.h"
#include "socket.h"
#include "close.h"

int
timeoutconn (int fd, char ip[4], uint16 port, unsigned int timeout)
{
	struct taia now;
	struct taia then;
	iopause_fd iop;

	while (1) {
		if (socket_connect4 (fd, ip, port) == 0) {
			if (ndelay_off (fd) == -1) {
				close(fd);
				return -1;
			}
			return 0;
		}
		if (errno==error_intr || errno==error_again)
			continue;
		break;
	}
	/* EWOULDBLOCK isn't needed? */
	if (errno != error_wouldblock && errno != error_inprogress)
		return -1;

	iop.fd = fd;
	iop.events = IOPAUSE_WRITE;
	taia_now (&now);
	taia_uint (&then, timeout);
	taia_add (&then, &now, &then);
	while (taia_less(&now,&then)) {
		taia_now (&now);
		iopause (&iop, 1, &then, &now);
		if (iop.revents) {
			if (!socket_connected (fd)) {
				close(fd);
				return -1;
			}
			if (ndelay_off (fd) == -1) {
				close(fd);
				return -1;
			}
			return 0;
		}
	}
	close(fd); /* DJB doesn't do this. */
	errno = error_timeout;
	return -1;
}
