/* Reimplementation of Daniel J. Bernsteins taia library.
 * (C) 2001 Uwe Ohse, <uwe@ohse.de>.
 *   Report any bugs to <uwe@ohse.de>.
 * Placed in the public domain.
 */
/* @(#) $Id: taia_half.c,v 1.1.1.1 2005/08/17 06:37:29 johnsoncheng Exp $ */
#include "taia.h"

/* strange interface. i'd expected taia_half(struct taia *) */

/* XXX: breaks tai encapsulation */

#define G 1000000000UL

void
taia_half (struct taia *to, struct taia *src)
{
	/* order of operations is important of src and to point to the same
	 * object */
	to->atto = src->atto / 2;
	if (src->nano % 2) 
		to->atto += (G/2);
	to->nano = src->nano / 2;
	if (src->sec.x % 2)
		to->nano += (G/2);
	to->sec.x = src->sec.x / 2;
}
