#include <time.h>
#include "bailout.h"
#include <stdlib.h>
#include "ftpparse.h"
#include "str.h"
#include "case.h"
#include "mlsx.h"

static long
getlong (const char *buf, int len)
{
	long u = 0;
	while (len-- > 0)
		u = u * 10 + (*buf++ - '0');
	return u;
}

static time_t
getmod (const unsigned char *p, unsigned int l)
{
	unsigned int i;
	struct tm tm;
	static int init_done;
	if (!init_done) {
		init_done++;
		/* why do i have to do this? Why isn't there a "set time zone to ..."
		 * function? tzset is just plain broken, it doesn't even provide                 * a return value ...
		 */
		if (setenv ("TZ", "UTC", 1))
			oom ();
		tzset ();
	}

	tm.tm_year = tm.tm_mon = tm.tm_mday = tm.tm_hour = tm.tm_min =
		tm.tm_sec = 0;
	for (i = 0; i < l; i++) {
		unsigned int u;
		u = (p[i] - '0');
		switch (i) {
		case 0:
		case 1:
		case 2:
		case 3:
			tm.tm_year *= 10;
			tm.tm_year += u;
			break;
		case 4:
		case 5:
			tm.tm_mon *= 10;
			tm.tm_mon += u;
			break;
		case 6:
		case 7:
			tm.tm_mday *= 10;
			tm.tm_mday += u;
			break;
		case 8:
		case 9:
			tm.tm_hour *= 10;
			tm.tm_hour += u;
			break;
		case 10:
		case 11:
			tm.tm_min *= 10;
			tm.tm_min += u;
			break;
		case 12:
		case 13:
			tm.tm_sec *= 10;
			tm.tm_sec += u;
			break;
		}
	}

	tm.tm_isdst = 0;
	tm.tm_mon -= 1;
	tm.tm_year -= 1900;
	return mktime (&tm);
}

int
mlsx_parse (struct ftpparse *fp, char *x, unsigned int ll)
{
	unsigned int i;
	fp->name = 0;
	fp->namelen = 0;
	fp->flagtrycwd = 0;
	fp->flagtryretr = 0;
	fp->sizetype = FTPPARSE_SIZE_UNKNOWN;
	fp->size = 0;
	fp->mtimetype = FTPPARSE_MTIME_UNKNOWN;
	fp->mtime = 0;
	fp->idtype = FTPPARSE_ID_UNKNOWN;
	fp->id = 0;
	fp->idlen = 0;

	for (i = 0; i < ll;) {
		unsigned int sem;
		unsigned int eq;
		unsigned int spc;
		if (x[i] == ' ' || x[i] == '\t')
			break;
		sem = str_chr (x + i, ';');
		spc = str_chr (x + i, ' ');
		if (spc < sem)
			sem = spc;
		spc = str_chr (x + i, '\t');
		if (spc < sem)
			sem = spc;
		eq = str_chr (x + i, '=');
		if (eq >= sem)
			break;
#define ISFACT(name) (case_starts(x+i,name))
		if (ISFACT ("size=")) {
			fp->size = getlong (x + i + eq + 1, sem - eq - 1);
			fp->sizetype = FTPPARSE_SIZE_BINARY;
		} else if (ISFACT ("modify=")) {
			fp->mtimetype = FTPPARSE_MTIME_LOCAL;
			fp->mtime = getmod (x + i + eq + 1, sem - eq - 1);
		} else if (ISFACT ("type=")) {
			if (case_starts (x + i + eq + 1, "file"))
				fp->flagtryretr = 1;
			else if (case_starts (x + i + eq + 1, "dir")) /* "current" */
				fp->flagtrycwd = 1;
			else if (case_starts (x + i + eq + 1, "pdir")) /* "parent" */
				fp->flagtrycwd = 1;
			else if (case_starts (x + i + eq + 1, "cdir"))
				fp->flagtrycwd = 1;
			else {
				fp->flagtryretr = 1;
				fp->flagtrycwd = 1;
			}
		} else if (ISFACT ("unique=")) {
			fp->idtype = FTPPARSE_ID_FULL;
			fp->id = x + i + eq + 1;
			fp->idlen = sem - eq - 1;
		}
		i += sem;
		if (x[i++] == ';')
			continue;
		break;
	}
	if (x[i++]!=' ')
		return 0;
	fp->name = x + i;
	fp->namelen = ll - i;
	if (fp->namelen)
		return 1;
	return 0;
}
