/* Reimplementation of Daniel J. Bernsteins uint library.
 * (C) 2001 Uwe Ohse, <uwe@ohse.de>.
 *   Report any bugs to <uwe@ohse.de>.
 * Placed in the public domain.
 */
/* @(#) $Id: byte_diff.c,v 1.1.1.1 2005/08/17 06:37:29 johnsoncheng Exp $ */
#include "byte.h"

int 
byte_diff(const char *s,unsigned int n,const char *t)
{
	for (;;) {
		if (!n) return 0; 
		if (*s != *t) break; 
		++s; ++t; --n;

		if (!n) return 0; 
		if (*s != *t) break; 
		++s; ++t; --n;

		if (!n) return 0; 
		if (*s != *t) break; 
		++s; ++t; --n;

		if (!n) return 0; 
		if (*s != *t) break; 
		++s; ++t; --n;
	}
	return ((int)(unsigned int)(unsigned char) *s)
	   - ((int)(unsigned int)(unsigned char) *t);
}
