#include <stdio.h>
#include <string.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>

/* local file */
#include "server.h"
#include "server01.h"
#include "server02.h"
#include "server03.h"
#include "server04.h"

#define	QUICK_FLAG_FILE		"/tmp/server.flag"

void set_restart_flag(int bEnable)
{
	FILE	*fptr;

	fptr=fopen(QUICK_FLAG_FILE, "w");
	fwrite(&bEnable, 1, sizeof(int), fptr);
	fclose(fptr);
}

int read_restart_flag()
{
	FILE	*fptr;
	int	ret;

	if ((fptr=fopen(QUICK_FLAG_FILE, "r"))==NULL)
		return 0;
	fread(&ret, 1, sizeof(int), fptr);
	fclose(fptr);
	return ret;
}

int get_btn(INPUT *input)
{
	INPUT	*tmp;
	int	ret=SERVER_BTN_UNKNOWN;

	if ((tmp=CGI_Find_Parameter(input, "NEXTPAGE"))!=NULL)
		ret=SERVER_BTN_NEXT;
	else
	if ((tmp=CGI_Find_Parameter(input, "BACKPAGE"))!=NULL)
		ret=SERVER_BTN_BACK;
	else
	if ((tmp=CGI_Find_Parameter(input, "ADD"))!=NULL)
		ret=SERVER_BTN_ADD;
	else
	if ((tmp=CGI_Find_Parameter(input, "REMOVE"))!=NULL)
		ret=SERVER_BTN_REMOVE;
	else
	if ((tmp=CGI_Find_Parameter(input, "CONTINUE"))!=NULL)
		ret=SERVER_BTN_CONTINUE;
	else
	if ((tmp=CGI_Find_Parameter(input, "FINISH"))!=NULL)
		ret=SERVER_BTN_FINISH;
	else
	if ((tmp=CGI_Find_Parameter(input, "YES"))!=NULL)
		ret=SERVER_BTN_YES;
	else
	if ((tmp=CGI_Find_Parameter(input, "NO"))!=NULL)
		ret=SERVER_BTN_NO;
	else
	if ((tmp=CGI_Find_Parameter(input, "REFRESH"))!=NULL)
		ret=SERVER_BTN_REFRESH;
	else
	if ((tmp=CGI_Find_Parameter(input, "APPLY"))!=NULL)
		ret=SERVER_BTN_APPLY;
	else
	if ((tmp=CGI_Find_Parameter(input, "TEST_BTN1"))!=NULL)
		ret=SERVER_BTN_TEST1;
	else
	if ((tmp=CGI_Find_Parameter(input, "TEST_BTN2"))!=NULL)
		ret=SERVER_BTN_TEST2;
	else
	if ((tmp=CGI_Find_Parameter(input, "TEST_BTN3"))!=NULL)
		ret=SERVER_BTN_TEST3;
	else
	if ((tmp=CGI_Find_Parameter(input, "TEST_BTN4"))!=NULL)
		ret=SERVER_BTN_TEST4;
	 return	ret;
}

int get_server_def()
{
	int num;

	num=NIC_Count_Interface();
	if (num==2)
		return 1;
	else
	if (num==1)
		return 0;
	return 0;
}

int get_func(INPUT *input, int *server_select)
{
	INPUT	*tmp;
	int	ret=SERVER_NONE;

	tmp=CGI_Find_Parameter(input, "func");
	if (tmp==NULL)
		ret=SERVER_NONE;
	else
	{
		if (!strcmp(tmp->val, "main"))
		{
			ret=SERVER01_MAIN;
			*server_select=SELECT_SERVER01;
		}
		else
		if (!strcmp(tmp->val, "server01_main"))
		{
			ret=SERVER01_MAIN;
			*server_select=SELECT_SERVER01;
		}
		else
		if (!strcmp(tmp->val, "server01_main_submit"))
		{
			ret=SERVER01_MAIN_SUBMIT;
			*server_select=SELECT_SERVER01;
		}
		else
		if (!strcmp(tmp->val, "server01_restart_submit"))
		{
			ret=SERVER01_RESTART_SUBMIT;
			*server_select=SELECT_SERVER01_RESTART;
		}		
		else
		if (!strcmp(tmp->val, "server02_main"))
		{
			ret=SERVER02_MAIN;
			*server_select=SELECT_SERVER02;
		}
		else
		if (!strcmp(tmp->val, "server02_main_submit"))
		{
			ret=SERVER02_MAIN_SUBMIT;
			*server_select=SELECT_SERVER02;
		}
		else
		if (!strcmp(tmp->val, "server03_main"))
		{
			ret=SERVER03_MAIN;
			*server_select=SELECT_SERVER03;
		}
		else
		if (!strcmp(tmp->val, "server03_main_submit"))
		{
			ret=SERVER03_MAIN_SUBMIT;
			*server_select=SELECT_SERVER03;
		}
		else
		if (!strcmp(tmp->val, "server04_main"))
		{
			ret=SERVER04_MAIN;
			*server_select=SELECT_SERVER04;
		}
		else
		if (!strcmp(tmp->val, "server04_main_submit"))
		{
			ret=SERVER04_MAIN_SUBMIT;
			*server_select=SELECT_SERVER04;
		}
	}
	return ret;
}

int server_replace(FILE *fptr, char *name, void *arg)
{
	if (!strcmp(name, "test"))
	{
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

void do_server_error(int code, int server_select)
{
	HEADER_ITEM	header;
	//ERRMSG errormsg;    add by Tiger

	if (code==SERVER_SUCCESS)
		return;

	/* header */
	CGI_Output_Html1(SERVER_HEADER_HTML, "$", server_replace,	NULL);
	header.back[0]=0x0;
	header.home[0]=0x0;
	header.logout[0]=0x0;
	if(Is_Version_22()) 
		CGI_Get_Help(header.help, "help_warning.html");
	else
		CGI_Get_Help(header.help, "help_warning.html");
	CGI_Show_Menu_V3_1(FUNC_SYSTEM, &header);
	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$",	server_replace, NULL);
	CGI_Show_Menu_V3_2(SERVER_DEF, server_select);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$",	server_replace, NULL);

/*
	errormsg.type =	CGI_ERROR;
	sprintf (errormsg.title, "SERVER_DEF_NAME%02d", ((code*(-1)) / 10));
	sprintf (errormsg.msg, "SERVER_ERROR_MSG%d", code*(-1));
	strcpy (errormsg.note, "");

	CGI_Show_Error_V3 (&errormsg);
*/

#ifdef _DEBUG
	printf("error code = [%d]<br>\n", code);
#endif

	/* tail	*/
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", server_replace, NULL);
	CGI_Output_Html1(SERVER_TAIL_HTML, "$", server_replace, NULL);
}

int main()
{
	INPUT	*input;
	int	func, ret=0;
	int	server_select=0;

	CGI_Init();
	CGI_Check_User();
	input=CGI_Get_Input();
	//CGI_Debug_Input(input);
	func=get_func(input, &server_select);
	switch (func)
	{
		case SERVER_NONE:
			ret=do_server01_main(input, server_select);
			break;
		case SERVER01_MAIN:
			ret=do_server01_main(input, server_select);
			break;
		case SERVER01_MAIN_SUBMIT:
			ret=do_server01_main_submit(input, server_select);
			break;
		case SERVER02_MAIN:
			ret=do_server02_main(input, server_select);
			break;
		case SERVER02_MAIN_SUBMIT:
			ret=do_server02_main_submit(input, server_select);
			break;
		case SERVER03_MAIN:
			ret=do_server03_main(input, server_select);
			break;
		case SERVER03_MAIN_SUBMIT:
			ret=do_server03_main_submit(input, server_select);
			break;
		case SERVER04_MAIN:
			ret=do_server04_main(input, server_select);
			break;
		case SERVER04_MAIN_SUBMIT:
			ret=do_server04_main_submit(input, server_select);
			break;
		case SERVER01_RESTART_SUBMIT:
			ret=do_server01_restart_submit(input, server_select);
			break;
	}
	//do_server_error(ret, server_select);
	CGI_Free_Input(input);
	return SERVER_SUCCESS;
}
