#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>

/* local include */
#include "quick.h"
//#include "quick03.h"
#include "quick03_1.h"
#include "quick04.h"
#include "quick05.h"

//====================================================================
//      src = 0.1.2.3
//      pos is below
//      0 : ip1
//      1 : ip2
//      2 : ip3
//      3 : ip4
//====================================================================
char *parser_ipaddr(char *dest, const char *src, int pos)
{
        char *ptr;

        strcpy(dest, src);
        ptr=strtok(dest, ".");
        if (pos==0)
                return ptr;
        ptr=strtok(NULL, ".");
        if (pos==1)
                return ptr;
        ptr=strtok(NULL, ".");
        if (pos==2)
                return ptr;
        ptr=strtok(NULL, ".");
        if (pos==3)
                return ptr;
        return NULL;
}

int quick04_replace(FILE *fptr, char *name, void *arg)
{
	NIC_NAS_INFO	*nic_nas_info;
	char		*ptr, buf[256];

	if (!strcmp(name, "DNS_MAJOR1") || !strcmp(name, "DNS_MAJOR2") || !strcmp(name, "DNS_MAJOR3") || !strcmp(name, "DNS_MAJOR4"))
	{
		char dnsTmp[20];
		
		Get_Profile_String(NETWORK_SECTION, FIELD_DNS1,QUICK_SETUP_DEFAULT_STRING,dnsTmp,sizeof(dnsTmp));
                ptr=name+(strlen(name)-1);
		if(strcmp(dnsTmp,QUICK_SETUP_DEFAULT_STRING))
                   fprintf(fptr, "%s", parser_ipaddr(buf, dnsTmp, (int)(*ptr-'1')));
		else fprintf(fptr, "%s","0");
	}
	else
	if (!strcmp(name, "DNS_MINOR1") || !strcmp(name, "DNS_MINOR2") || !strcmp(name, "DNS_MINOR3") || !strcmp(name, "DNS_MINOR4"))
	{
		char dnsTmp[20];
		
		Get_Profile_String(NETWORK_SECTION, FIELD_DNS2,QUICK_SETUP_DEFAULT_STRING,dnsTmp,sizeof(dnsTmp));
                ptr=name+(strlen(name)-1);
		if(strcmp(dnsTmp,QUICK_SETUP_DEFAULT_STRING))
                   fprintf(fptr, "%s", parser_ipaddr(buf, dnsTmp, (int)(*ptr-'1')));
		else fprintf(fptr, "%s","0");
	}
	else
	if (!strcmp(name, "LAN_IP1") || !strcmp(name, "LAN_IP2") || !strcmp(name, "LAN_IP3") || !strcmp(name, "LAN_IP4"))
	{
                nic_nas_info=(NIC_NAS_INFO *)arg;
                ptr=name+(strlen(name)-1);
                fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.ipaddr, (int)(*ptr-'1')));
	}
        else
        if (!strcmp(name, "LAN_MASK1") || !strcmp(name, "LAN_MASK2") || !strcmp(name, "LAN_MASK3") || !strcmp(name, "LAN_MASK4"))
        {
                nic_nas_info=(NIC_NAS_INFO *)arg;
                ptr=name+(strlen(name)-1);
                fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.netmask, (int)(*ptr-'1')));
        }
	else
        if (!strcmp(name, "LAN_GW1") || !strcmp(name, "LAN_GW2") || !strcmp(name, "LAN_GW3") || !strcmp(name, "LAN_GW4"))
        {
                nic_nas_info=(NIC_NAS_INFO *)arg;
                ptr=name+(strlen(name)-1);
                fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.gateway, (int)(*ptr-'1')));
        }
        else
        if ( !strcmp(name, "quick_bonding") )
        {
        	if (NIC_Is_Bonding_Support()) {
                	printf("          <tr>\n");
                	printf("          <td colspan=\"3\">\n");
                	printf("            <table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" width=\"100%%\">\n");
                	printf("              <tr>\n");
                	//printf("                  <td width=\"5%%\">&nbsp;</td>\n");
                	printf("                  <td width=\"35%%\">\n");
                	printf("                	<script Language=\"JavaScript\">document.write ('<font class=\"st\">'+NIC_VIEW_STR47+'</font>')</script>\n");
                	printf("                  </td>\n");
                	printf("                <td width=\"20%%\">\n");
                	printf("            	<input type=\"radio\" %s name=\"Bonding\" value=\"FAILOVER\"> <script Language=\"JavaScript\">document.write ('<font class=\"st\">'+NIC_VIEW_STR50+'</font>')</script>\n", (NIC_Get_Bonding_Type()==BONDING_FAIL_OVER)?"checked":"");
                	printf("                </td>\n");
                	printf("                <td width=\"20%%\">\n");
                	printf("            	<input type=\"radio\" %s name=\"Bonding\" value=\"LOADBALANCE\"> <script Language=\"JavaScript\">document.write ('<font class=\"st\">'+NIC_VIEW_STR49+'</font>')</script>\n", (NIC_Get_Bonding_Type()==BONDING_LOAD_BALANCE)?"checked":"");
                	printf("                </td>\n");
                	printf("                <td width=\"25%%\">\n");
                	printf("                </td>\n");
                	printf("                </tr>\n");
                	printf("            </table>\n");
                	printf("          </td>\n");
                	printf("          </tr>\n");
       		}
	}
	else
	if (!strcmp(name, "radio_lan_dhcp") || !strcmp(name, "radio_lan_static"))
	{
                nic_nas_info=(NIC_NAS_INFO *)arg;
                if (nic_nas_info->usage==NIC_USE_DHCP && !strcmp(name, "radio_lan_dhcp"))
                        fprintf(fptr, "checked");
                else
                if (nic_nas_info->usage==NIC_USE_STATIC && !strcmp(name, "radio_lan_static"))
                        fprintf(fptr, "checked");
	}
  	else
		return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int show_quick04_header(int quick_select)
{
        HEADER_ITEM    	header;
	static char* 	quick_defs[]={QUICK_DEFS};

        CGI_Output_Html1(QUICK_HEADER_HTML, "$", quick04_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_quick.html#help_qconfig_step5");
	else
		CGI_Get_Help(header.help, "help_qconfig_step5.html");
        CGI_Show_Menu_V3_1(FUNC_QUICK, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", quick04_replace, NULL);
        CGI_Show_Menu_V3_2(quick_defs[get_quick_def()], quick_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", quick04_replace, NULL);
        return 1;
}

int show_quick04_tail()
{
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", quick04_replace, NULL);
        CGI_Output_Html1(QUICK_TAIL_HTML, "$", quick04_replace, NULL);
        return 1;
}

int do_quick04_main(INPUT *input, int quick_select)
{
	int		nic;
	NIC_NAS_INFO	nic_nas_info;

	show_quick04_header(quick_select);

	/* put your code here */
	nic=NIC_Count_Interface();
/*	if ((nic==2 && !NIC_Is_Bonding_Support()) || (nic==3 && !NIC_Is_Bonding_Support()))
	{
		NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
		CGI_Output_Html1(QUICK04_2_MAIN_HTML, "$", quick04_replace,& nic_nas_info);
	}
	else*/
	{
		NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
		CGI_Output_Html1(QUICK04_MAIN_HTML, "$", quick04_replace, &nic_nas_info);
	}

	show_quick04_tail();
	return QUICK_SUCCESS;
}

int do_quick04_lan_next(INPUT *input)
{
        NIC_NAS_INFO    nic_nas_info, old;
	INPUT		*p;
	char 		dns1Buf[20],dns2Buf[20],dnsold[2][20];

	NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
	memcpy(&old, &nic_nas_info, sizeof(NIC_NAS_INFO));
	if ((p=CGI_Find_Parameter(input, "LAN_USAGE"))!=NULL)
	{
		if (!strcmp(p->val, "DHCP"))
			nic_nas_info.usage=NIC_USE_DHCP;
		else
			nic_nas_info.usage=NIC_USE_STATIC;
	}
	if (nic_nas_info.usage==NIC_USE_STATIC)
	{
	        CGI_Get_Text_IP(nic_nas_info.ifconfig.ipaddr, NIC_IPADDR_LEN, input, "LAN_IP1", "LAN_IP2", "LAN_IP3", "LAN_IP4");
        	CGI_Get_Text_IP(nic_nas_info.ifconfig.netmask, NIC_IPADDR_LEN, input, "LAN_MASK1", "LAN_MASK2", "LAN_MASK3", "LAN_MASK4");
	        CGI_Get_Text_IP(nic_nas_info.ifconfig.gateway, NIC_IPADDR_LEN, input, "LAN_GW1", "LAN_GW2", "LAN_GW3", "LAN_GW4");
	}
	if ((p=CGI_Find_Parameter(input, "Bonding"))!=NULL) {
		if (!strcmp(p->val, "FAILOVER"))
			nic_nas_info.bonding_type=BONDING_FAIL_OVER;
		else
		if (!strcmp(p->val, "LOADBALANCE"))
			nic_nas_info.bonding_type=BONDING_LOAD_BALANCE;
		else
			nic_nas_info.bonding_type=BONDING_STANDALONE;
	}
	CGI_Get_Text_IP(dns1Buf, NIC_IPADDR_LEN, input, "Primary_DNS1", "Primary_DNS2", "Primary_DNS3", "Primary_DNS4");
	CGI_Get_Text_IP(dns2Buf, NIC_IPADDR_LEN, input, "Secondary_DNS1", "Secondary_DNS2", "Secondary_DNS3", "Secondary_DNS4");
	//Set_Profile_String (NETWORK_SECTION, FIELD_DNS1, dns1Buf);
	//Set_Profile_String (NETWORK_SECTION, FIELD_DNS2, dns2Buf);
	//NIC_Set_Info_To_uLinux(&nic_nas_info);
	Get_Profile_String(NETWORK_SECTION, FIELD_DNS1,QUICK_SETUP_DEFAULT_STRING,dnsold[0],sizeof(dnsold[0]));
	Get_Profile_String(NETWORK_SECTION, FIELD_DNS2,QUICK_SETUP_DEFAULT_STRING,dnsold[1],sizeof(dnsold[1]));

        if (NIC_Info_Comp(&old, &nic_nas_info)||strcmp(dnsold[0],dns1Buf)||strcmp(dnsold[1],dns2Buf))
	{
		if(NIC_Info_Comp(&old, &nic_nas_info))
		{
			if(nic_nas_info.usage==NIC_USE_DHCP)
				Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NETWORK, "DHCP", QUICK_CONF_FILE);//Shone modified 2005,09,29
			else if(nic_nas_info.usage==NIC_USE_STATIC)
				Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NETWORK, "STATIC", QUICK_CONF_FILE);
			if(nic_nas_info.usage==NIC_USE_STATIC)
			{
				Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_STATIC_IP, nic_nas_info.ifconfig.ipaddr, QUICK_CONF_FILE);
				Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NET_MASK, nic_nas_info.ifconfig.netmask, QUICK_CONF_FILE);
				Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NET_GATE, nic_nas_info.ifconfig.gateway, QUICK_CONF_FILE);
			}
		}
		if(strcmp(dnsold[0],dns1Buf)||strcmp(dnsold[1],dns2Buf))
		{
			Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NET_DNS1, dns1Buf, QUICK_CONF_FILE);
			Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_NET_DNS2, dns2Buf, QUICK_CONF_FILE);
		}
		
                set_initial_flag(1);
	}
	else
	{
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_NETWORK);	
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_STATIC_IP);	
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_NET_MASK);	
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_NET_GATE);	
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_NET_DNS1);	
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_NET_DNS2);	
	}
	return QUICK_SUCCESS;
}

int do_quick04_main_submit(INPUT *input, int quick_select)
{
	int	btn;
	int	ret=QUICK_SUCCESS;
	int	func;

	btn=get_btn(input);
	switch (btn)
	{
	case QUICK_BTN_NEXT:
		/* put your "next button" code here */
			func=do_quick04_lan_next(input);
			do_quick05_main(input, quick_select+1);
		break;
	case QUICK_BTN_BACK:
		/* put your "back button" code here */
		do_quick03_1_main(input, quick_select-1);
		break;
	}
	return ret;
}

