//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		prn_setting.c
//
//	Abstract:
//		Printer setup cgi function
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//      08/20/01	David Yang Created
//
//**************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cgi.h>
#include <cfg_nic.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_dns.h>
#include <NAS.h>

#include "prn_setting.h"

#define BUFFER_SIZE		256

// Function tag
#define PRINTER_NONE		0
#define PRINTER_MAIN		1
#define PRINTER_SAVE		2

// Default services url
#define PRN_OTHER_SERVICES_DEF		"/home/httpd/cgi-bin/network/other_services.def"
#define PRN_NETWORK_SERVICES_DEF		"/home/httpd/cgi-bin/network/network-%d.def"

// Default html
#define PRN_HEADER_HTML	"/home/httpd/cgi-bin/network/prn_setting/html/prn_header.html"
#define PRN_MAIN_HTML	"/home/httpd/cgi-bin/network/prn_setting/html/prn_main.html"
#define PRN_MAIN_USB_HTML	"/home/httpd/cgi-bin/network/prn_setting/html/prn_main_usb.html"
#define PRN_TAIL_HTML	"/home/httpd/cgi-bin/network/prn_setting/html/prn_tail.html"
//#define PRN_ERR_HTML    "/home/httpd/cgi-bin/network/prn_setting/html/prn_error.html"
#define PRN_STORAGE_DEF_URL    "/cgi-bin/storage.cgi?function=DISK"

// Error code
#define ERR_INVALID_PARAM	1
#define ERR_NOT_SUPPORT		2
#define ERR_NOT_INITIALIZED	3

// CGI Parameter keyname
const char g_keyenabled[] = "PARAM_ENABLED";
const char g_keyenabledcheck[] = "PARAM_ENABLED_CHECK";
const char g_keyname[] = "PARAM_NAME";
const char g_keycomment[] = "PARAM_COMMENT";

// global varibles
int g_enabled = 0;
int g_access = 0;
//int g_errcode = 0;
char g_name[PRINTER_MAXLEN_NAME + 1] = "";
char g_comment[PRINTER_MAXLEN_COMMENT + 1] = "";
//char g_onerror[PRINTER_MAXLEN_COMMENT + 1] = "";
//char g_errorurl[PRINTER_MAXLEN_COMMENT + 1] = "";


int get_func(INPUT *input)
{
	int	ret=PRINTER_NONE;
	INPUT	*tmp = NULL;

	if ((tmp=CGI_Find_Parameter(input, "func"))!=NULL)
	{
		if ( strcmp(tmp->val, "main") == 0 )
			ret=PRINTER_MAIN;
		else if ( strcmp(tmp->val, "save") == 0 )
			ret=PRINTER_SAVE;
	}
	return ret;
}

int my_replace(FILE *fptr, char *src)
{
	// We don't need to update this value to html...
	if (!strcmp(src, "b_parallel"))
	{
		if (Prn_Get_Type()==PRN_PARALLEL)
			fprintf(fptr, "checked");
	}
	else
	if (!strcmp(src, "b_usb"))
	{
		if (Prn_Get_Type()==PRN_USB)
			fprintf(fptr, "checked");
	}
	else
	if (!strcmp(src, "TAG_CHECK_ENABLED"))
	{
		fprintf(fptr, "%s", g_enabled?"checked":"");
	}
	else if (!strcmp(src, "TAG_NAME"))
	{
		fprintf(fptr, "%s", g_name);
	}
	else if (!strcmp(src, "TAG_COMMENT"))
	{
		fprintf(fptr, "%s", g_comment);
	}
	else
		return CGI_REPLACE_FAIL;

	return CGI_REPLACE_OK;
}

int none_replace(FILE *fptr, char *src)
{
	return CGI_REPLACE_FAIL;
//	return CGI_REPLACE_OK;
}

int none_replace1(FILE *fptr, char *src, void *arg1)
{
	return CGI_REPLACE_FAIL;
//	return CGI_REPLACE_OK;
}

int show_prn_header ()
{
    int nic_count = NIC_Count_Interface();
	HEADER_ITEM	header;

	CGI_Output_Html(PRN_HEADER_HTML, "$", none_replace);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_print_main");
	else
		CGI_Get_Help(header.help, "network_print_main.html");
        //CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
CGI_Show_Menu_V3_1(1, &header);//
        CGI_Output_Html(MENU_V3_HEADER_HTML, "$", none_replace);

	if (    (nic_count==1 && !Is_Support_DNS() && !Is_Support_DNS()) ||
		(nic_count==3 && NIC_Is_Bonding_Support() && !Is_Support_DNS() && !Is_Support_DNS()) ||
		(nic_count==2 && NIC_Is_Bonding_Support() && !Is_Support_DNS() && !Is_Support_DNS()))
	
		CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.nodns.def", 8);
	else
		CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.def", 9);
        CGI_Output_Html(MENU_V3_MIDDLE_HTML, "$", none_replace);
	return 1;
}

int show_prn_tail ()
{
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", none_replace1, NULL);
        return CGI_Output_Html(PRN_TAIL_HTML, "$", none_replace);
}

int do_main()
{
	int ret;
	show_prn_header();
	if (Is_Support_Usb_Printer() && Is_Support_Parallel_Printer())
		ret=CGI_Output_Html(PRN_MAIN_USB_HTML, "$", my_replace);
	else
		ret = CGI_Output_Html(PRN_MAIN_HTML, "$", my_replace);
	show_prn_tail();
	return ret;
}

void do_prn_error2(int code)
{
    char err_var[BUFFER_SIZE + 1] = "";
	ERRMSG	errmsg;

	switch(code)
	{
	case ERR_NOT_SUPPORT:
		strcpy(err_var, "ERR_PRINTER_NONE_SUPPORT");
		break;
	case ERR_NOT_INITIALIZED:
	    strcpy(err_var, "ERR_PRINTER_UNINITIAL");
		break;
	default:
		strcpy(err_var, "ERR_PRINTER_OTHER");
		break;
	}
	show_prn_header();
//	CGI_Show_Error_V2(err_var);
        errmsg.type=CGI_ERROR;
        strcpy(errmsg.msg, err_var);
        strcpy(errmsg.note, "IEI_NAS_NONE");
        strcpy(errmsg.title, "NIC_VIEW_STR27");
	CGI_Show_Error_V3(&errmsg);
	/* tail */
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", my_replace, NULL);
	CGI_Output_Html1("html/prn_tail.html", "$", my_replace, NULL);
}

int get_current_setting()
{
	char buf[BUFFER_SIZE]="";
	int ret_value;
	g_enabled = Is_Printer_Enabled();

	ret_value = Get_Printer_Name(buf, sizeof(buf));

	if ( strlen(buf) == 0 ) //use default
	{
	    ret_value = Get_Server_Name(buf, sizeof(buf));
	    strcat(buf, "PR");
	}
	strncpy(g_name, buf, PRINTER_MAXLEN_NAME);

	// ensure the string is end of terminator
	g_name[PRINTER_MAXLEN_NAME] = '\0';

	ret_value = Get_Printer_Comment(buf, sizeof(buf));
	strncpy(g_comment, buf, PRINTER_MAXLEN_COMMENT);
	g_comment[PRINTER_MAXLEN_COMMENT] = '\0';

	return 0;
}

int save_setting()
{
	// do not refresh samba immediately until all information is set
	Enable_Printer(g_enabled, FALSE);
	Set_Printer_Name(g_name, FALSE);
	Set_Printer_Comment(g_comment, TRUE);

	return 0;
}

/*
 * process action of submit
 * return:
 * 	0			: SUCCESS
 *	ERR_NOT_INITIALIZED	: Spool not yet initialized
 *	other			: fail
 */
int process_submit(INPUT *input)
{
	BOOL 	modified = FALSE;
	BOOL	chglpd = FALSE;
	BOOL	noparam = FALSE;
	INPUT	*tmp = NULL;
	int	val = 0;

	BOOL    chgname = FALSE;
	BOOL    ori_pr_enabled = g_enabled;
	BOOL    atalk_enabled = Is_Appletalk_Enabled();

	if ((tmp=CGI_Find_Parameter(input, "PRN_TYPE"))!=NULL)
	{
		if (!strcmp(tmp->val, "P_PARALLEL"))
		{
			if (Prn_Get_Type()==PRN_USB)
				modified=TRUE;
			Prn_Set_Type(PRN_PARALLEL);
		}
		else
		if (!strcmp(tmp->val, "P_USB"))
		{
			if (Prn_Get_Type()==PRN_PARALLEL)
				modified=TRUE;
			Prn_Set_Type(PRN_USB);
		}
		else
		{
			noparam=TRUE;
		}
	}
	if ((tmp=CGI_Find_Parameter(input, (char *)g_keyenabled))!=NULL)
	{
		val = atoi(tmp->val);
		if ( val != g_enabled )
		{
			g_enabled = atoi(tmp->val);
			modified = TRUE;
			chglpd = TRUE;
		}
	}
	else
	{
		noparam = TRUE;
	}
	if ((tmp=CGI_Find_Parameter(input, (char *)g_keyname))!=NULL)
	{
		if ( strcmp(g_name, tmp->val) != 0 )
		{
			strncpy(g_name, tmp->val, PRINTER_MAXLEN_NAME);
			g_name[PRINTER_MAXLEN_NAME] = '\0';
			modified = TRUE;
			chgname = TRUE;
		}
	}
	else
	{
		noparam = TRUE;
	}
	if ((tmp=CGI_Find_Parameter(input, (char *)g_keycomment))!=NULL)
	{
		if ( strcmp(g_comment, tmp->val) != 0 )
		{
			strcpy(g_comment, tmp->val);
			g_comment[PRINTER_MAXLEN_COMMENT] = '\0';
			modified = TRUE;
		}
	}
	else
	{
		noparam = TRUE;
	}

	if ( noparam )
	{
		return ERR_INVALID_PARAM;
	}

	val = 0;
	// if any value has been modified.
	if ( modified )
	{
		if ( chglpd )
		{
			// Test if Spool initialized
			if ( !Is_Spool_Initialized() )
			{
				return ERR_NOT_INITIALIZED;
			}
			/* install lpd must run after save setting because
			the shell script printer.sh will check config */
			//Install_Lpd(g_enabled);
		}
		val = save_setting();
		Install_Lpd(g_enabled);

		/* to implement the following logical matrix
		atalk en.   before pr en.   set pr en.   name chgd.   action
		---------------------------------------------------
		   *            *             *            *          N/A
		   T            F             T            *          InstallPAPD(T)
		   T            T             F            *          InstallPAPD(F)
		   T            T             T            F          N/A
		   T            T             T            T		  InstallPAPD(F) then InstallPAPD(T)
		---------------------------------------------------
		*/
		if ( atalk_enabled )
		{
		    if ( ori_pr_enabled != g_enabled )
		    {
		        Install_PAPD(g_enabled);
		    }
		    else
		    {
		        if ( g_enabled && chgname )
		        {
		            Install_PAPD(FALSE);
		            Install_PAPD(TRUE);
		        }
		    }
		}
	}
	return val;
}

/*
int err_replace(FILE *fptr, char *src)
{

	if (!strcmp(src, "TAG_ERRCODE"))
	{
		fprintf(fptr, "%d", g_errcode);
	}
	else if (!strcmp(src, "TAG_ONCLICK"))
	{
		fprintf(fptr, "%s", g_onerror);
	}
	else if (!strcmp(src, "TAG_ERRORURL"))
	{
	    fprintf(fptr, "%s", g_errorurl);
	}
	else
		return CGI_REPLACE_FAIL;

	return CGI_REPLACE_OK;
}

void do_prn_error(int code)
{
	g_errcode = code;
	switch(code)
	{
	case ERR_NOT_SUPPORT:
		strcpy(g_onerror, "history.go(-1)");
		break;
	case ERR_NOT_INITIALIZED:
	    strcpy(g_errorurl, PRN_STORAGE_DEF_URL);
		strcpy(g_onerror, "location.href=errorurl()");
		break;
	default:
		strcpy(g_onerror, "history.go(-1)");
		break;
	}
	show_prn_header();
	CGI_Output_Html(PRN_ERR_HTML, "$", err_replace);
	show_prn_tail();
}
*/

int main()
{
	INPUT	*input = NULL;
	int	func=PRINTER_NONE;
	HTTP_INFO http_info;
	int 	ret;

	CGI_Init();
	CGI_Check_User();
	input=(INPUT *)CGI_Get_Input();

	CGI_Get_Http_Info(&http_info);

#ifdef _DEBUG
	CGI_Debug_Input(input);
#endif
	func=get_func(input);

	get_current_setting();

	switch(func)
	{
	case PRINTER_MAIN:
		do_main();
		break;
	case PRINTER_SAVE:
		ret = process_submit(input);
		if ( ret != 0 )
		{
			do_prn_error2(ret);
		}
		else
		{
			do_main();
		}
		break;
	default:
		do_prn_error2(ERR_INVALID_PARAM);
		break;
	}

	CGI_Free_Input(input);

	return 0;
}
