#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* include NAS lib */
#include <config.h>
#include <Util.h>
#include <cgi.h>
#include <cfg_nic.h>
#include <cfg_system.h>
#include <cfg_fw.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_qphoto.h>
#include <cfg_qdownload.h>
#include <cfg_qweb.h>
#include <cfg_ftp.h>
#include <cfg_dns.h>
#include <cfg_dhcp.h>
#include <cfg_samba.h>

/* include local file */
#include "network.h"
#include "nic_view.h"
#include "nic_ms.h"

static struct dhcp_conf g_config;

int view_replace(FILE *fptr, char *name, void *arg)
{
	NIC_NAS_INFO	nic_nas_info;
	NIC_INFO	*nic_info;

        if (!strcmp(name, "ONLOAD"))
        {
        }
	else
	if (!strcmp(name, "FAIL_MESSAGE"))
	{
		if (NIC_Get_PPPOE_Status()==PPPOE_STATUS_CONNECTING)
		{
			FILE	*fp;
			char	buf[80];
			int	times;

			if ((fp=fopen("/var/pppoe.status", "r"))!=NULL)
			{
				fgets(buf, 80, fp);
				times=atoi(buf);
				fprintf(fptr, "<SCRIPT Language=\"JavaScript\">document.write(NIC_VIEW_PPPOE_FAIL01)</SCRIPT>");
				fprintf(fptr, "&nbsp;%d&nbsp;", times);
				fprintf(fptr, "<SCRIPT Language=\"JavaScript\">document.write(NIC_VIEW_PPPOE_FAIL02)</SCRIPT>");
				fclose(fp);
			}
		}
	}
	else
	if (!strcmp(name, "VIEW_WAN_STATUS"))
	{
		int status;
		status=NIC_Get_Status(NIC_WAN);
		if (status==NIC_CONNECT)
			fprintf(fptr, "NIC_VIEW_STR45");
		else
		if (status==NIC_CONNECTING)
			fprintf(fptr, "NIC_VIEW_STR44");
		else
			fprintf(fptr, "NIC_VIEW_STR46");
	}
        else
        if (!strcmp(name, "VIEW_LAN_STATUS"))
        {
		int	bonding_type=NIC_Get_Bonding_Type();
                int	status;
		
		nic_info=(NIC_INFO *)arg;
		if ( bonding_type == BONDING_STANDALONE ) {
			int idx = NIC_LAN01 + atoi(&(nic_info->dev[3]));
	                status=NIC_Get_Status(idx);
		} else
	                status=NIC_Get_Status(NIC_LAN01);
                if (status==NIC_CONNECT)
                        fprintf(fptr, "NIC_VIEW_STR45");
                else
                if (status==NIC_CONNECTING)
                        fprintf(fptr, "NIC_VIEW_STR44");
                else
                        fprintf(fptr, "NIC_VIEW_STR46");
        }
        else
        if (!strcmp(name, "VIEW_WAN_USAGE") || !strcmp(name, "VIEW_LAN_USAGE"))
        {
			
		if (!strcmp(name, "VIEW_WAN_USAGE"))
			NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
		else
		if (!strcmp(name, "VIEW_LAN_USAGE")) {
			int	bonding_type=NIC_Get_Bonding_Type();
			nic_info=(NIC_INFO *)arg;
			
			if ( bonding_type == BONDING_STANDALONE ) {
				int idx = NIC_LAN01 + atoi(&(nic_info->dev[3]));
				NIC_Get_Info_From_uLinux(&nic_nas_info, idx);
			} else
				NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
		}
		if (nic_nas_info.usage==NIC_USE_DHCP)
			fprintf(fptr, "NIC_VIEW_DHCP");
		else
		if (nic_nas_info.usage==NIC_USE_STATIC)
			fprintf(fptr, "NIC_VIEW_STATIC");
		else
		if (nic_nas_info.usage==NIC_USE_PPPOE)
			fprintf(fptr, "NIC_VIEW_PPPOE");
		else
		if (nic_nas_info.usage==NIC_USE_PPTP)
			fprintf(fptr, "NIC_VIEW_PPTP");
        }
	else
	if (!strcmp(name, "VIEW_WAN_IP") || !strcmp(name, "VIEW_LAN_IP"))
	{
		nic_info=(NIC_INFO *)arg;
		if (nic_info->ipaddr[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
			fprintf(fptr, "%s", nic_info->ipaddr);
	}
        else
        if (!strcmp(name, "VIEW_WAN_NETMASK") || !strcmp(name, "VIEW_LAN_NETMASK"))
        {
                nic_info=(NIC_INFO *)arg;
		if (nic_info->ipaddr[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
	                fprintf(fptr, "%s", nic_info->netmask);
        }
        else
        if (!strcmp(name, "VIEW_WAN_GW") || !strcmp(name, "VIEW_LAN_GW"))
        {
                nic_info=(NIC_INFO *)arg;
		if (nic_info->ipaddr[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
	                fprintf(fptr, "%s", nic_info->gateway);
        }
        else
        if (!strcmp(name, "VIEW_WAN_HWADDR") || !strcmp(name, "VIEW_LAN_HWADDR"))
        {
		char	hwaddr[128];

		if (!strcmp(name, "VIEW_WAN_HWADDR"))
		{	/* avoid device is ppp0 */
			NIC_Get_HWADDR(hwaddr, 128, NIC_WAN);
			fprintf(fptr, "%s", hwaddr);
		}
		else
		{
	                nic_info=(NIC_INFO *)arg;
		/*Shone marked 2005,05,05
			if (nic_info->ipaddr[0]==0x0)
				fprintf(fptr, "&nbsp;");
			else
			*/
		                fprintf(fptr, "%s", nic_info->hwaddr);
		}
        }
	else
	if (!strcmp(name, "VIEW_WAN_DNS"))
	{
		char dns1[256], dns2[256];

		NIC_Get_Resolv2(dns1, 256, dns2, 256);
		if (!strcmp("0.0.0.0", dns2))
		{
			if (!strcmp("0.0.0.0", dns1))
				fprintf(fptr, "&nbsp;");
			else
				fprintf(fptr, "%s", dns1);
		}
		else
			fprintf(fptr, "%s&nbsp;&nbsp;&nbsp;%s", dns1, dns2);
	}
	else
	if (!strcmp(name, "VIEW_WAN_ADSL"))
	{
		int status;

		NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_WAN);
		if (nic_nas_info.usage==NIC_USE_PPTP)
		{
                        status=NIC_Get_PPTP_Status();
                        if (status==PPTP_STATUS_CONNECT)
                                fprintf(fptr, "NIC_VIEW_PPTP_CONNECT");
                        else
                        if (status==PPTP_STATUS_CONNECTING)
                                fprintf(fptr, "NIC_VIEW_PPTP_CONNECTING");
                        else
                        if (status==PPTP_STATUS_READY)
                                fprintf(fptr, "NIC_VIEW_PPTP_READY");
                        else
                        if (status==PPTP_STATUS_DISABLE)
                                fprintf(fptr, "NIC_VIEW_PPTP_DISABLE");
			else
			if (status==PPTP_STATUS_DHCP)
				fprintf(fptr, "NIC_VIEW_PPTP_DHCP");
		}
		else
		{
			status=NIC_Get_PPPOE_Status();
			if (status==PPPOE_STATUS_CONNECT)
				fprintf(fptr, "NIC_VIEW_PPPOE_CONNECT");
			else
			if (status==PPPOE_STATUS_CONNECTING)
				fprintf(fptr, "NIC_VIEW_PPPOE_CONNECTING");
			else
			if (status==PPPOE_STATUS_READY)
				fprintf(fptr, "NIC_VIEW_PPPOE_READY");
			else
			if (status==PPPOE_STATUS_DISABLE)
				fprintf(fptr, "NIC_VIEW_PPPOE_DISABLE");
			else
			if (status==PPPOE_STATUS_DHCP)
				fprintf(fptr, "NIC_VIEW_PPPOE_DHCP");
		}
	}
        else
	if (!strcmp(name, "tabcolor1") || !strcmp(name, "tabcolor2") || !strcmp(name, "tabcolor3"))
	{
		char	*ptr;
		int	*tab;

		tab=(int *)arg;
		ptr=name+8;
		if (*tab==(int)(*ptr-'0'))
			fprintf(fptr, "#666666");
		else
			fprintf(fptr, "#EEEEEE");
	}
	else
	if (!strcmp(name, "fontcolor1") || !strcmp(name, "fontcolor2") || !strcmp(name, "fontcolor3"))
	{
		char	*ptr;
		int	*tab;

		tab=(int *)arg;
		ptr=name+9;
		if (*tab==(int)(*ptr-'0'))
			fprintf(fptr, "#FFFFFF");
	}
	else
	if (!strcmp(name, "overcolor1") || !strcmp(name, "overcolor2") || !strcmp(name, "overcolor3"))
	{
		char	*ptr;
		int	*tab;

		tab=(int *)arg;
		ptr=name+9;
		if (*tab==(int)(*ptr-'0'))
			fprintf(fptr, "#666666");
		else
			fprintf(fptr, "#CCCCCC");
	}
	else
	if (!strcmp(name, "bDHCP"))
	{
		if (Is_DHCP_Enable()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else
	if (!strcmp(name, "DHCPRANGE"))
	{
		char	range1[256], range2[256];

		Get_DHCP_Range(START_POSITION, range1, 256);
		Get_DHCP_Range(END_POSITION, range2, 256);
		fprintf(fptr, "%s - %s", range1, range2);
	}
	else
	if (!strcmp (name , "MaxLeaseTimeDay") || !strcmp (name , "MaxLeaseTimeHour"))
	{
		read_dhcp_conf (&g_config);
		if (!strcmp (name , "MaxLeaseTimeDay")) {
			if (g_config.nMax_lease_time_day == 0)
				g_config.nMax_lease_time_day = 1;
			fprintf (fptr, "%d", g_config.nMax_lease_time_day);
		} else if (!strcmp (name , "MaxLeaseTimeHour")) {
			fprintf (fptr, "%d", g_config.nMax_lease_time_hour);
		}
	}
	else
	if (!strcmp(name, "bNAT"))
	{
		if (FW_Is_NAT_Enable()==FW_SUCCESS)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else
	if (!strcmp(name, "VIEW_LAN_BONDING"))
	{
		int	type;
		type=NIC_Get_Bonding_Type();
		if (type==BONDING_STANDALONE)
			fprintf(fptr, "NIC_VIEW_STR48");
		else
		if (type==BONDING_FAIL_OVER)
			fprintf(fptr, "NIC_VIEW_STR50");
		else
		if (type==BONDING_LOAD_BALANCE)
			fprintf(fptr, "NIC_VIEW_STR49");
		else
			fprintf(fptr, "NIC_VIEW_STR50");
	}
// Catherine for switch begin ==>
	else if (!strcmp(name, "VIEW_LAN_TITLE")) {
		BOOL is_switch_support = NIC_Is_Switch_Support();
		if (is_switch_support)
			fprintf(fptr, "LAN_SETTING_STR");
		else {
			int	bonding_type=NIC_Get_Bonding_Type();
			nic_info=(NIC_INFO *)arg;
			
			if ( bonding_type == BONDING_STANDALONE ) {
				fprintf(fptr, "NIC_VIEW_LAN+'%d'", atoi(&(nic_info->dev[3]))+1);//Shone modified
			} else
				fprintf(fptr, "NIC_VIEW_STR21");
		}
	} else if (!strcmp(name, "VIEW_SWITCH_USAGE")) {
		NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN03);
		if (nic_nas_info.usage==NIC_USE_DHCP)
			fprintf(fptr, "NIC_VIEW_DHCP");
		else
		if (nic_nas_info.usage==NIC_USE_STATIC)
			fprintf(fptr, "NIC_VIEW_STATIC");

	} else if (!strcmp(name, "VIEW_SWITCH_IP")){
		nic_info=(NIC_INFO *)arg;
		if (nic_info->ipaddr[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
			fprintf(fptr, "%s", nic_info->ipaddr);
	} else if (!strcmp(name, "VIEW_SWITCH_NETMASK"))
	{
		nic_info=(NIC_INFO *)arg;
		if (nic_info->ipaddr[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
			fprintf(fptr, "%s", nic_info->netmask);
	} else if (!strcmp(name, "VIEW_SWITCH_GW"))
	{
		nic_info=(NIC_INFO *)arg;
		if (nic_info->ipaddr[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
			fprintf(fptr, "%s", nic_info->gateway);
	} else if (!strcmp(name, "VIEW_SWITCH_HWADDR"))
	{
		nic_info=(NIC_INFO *)arg;
		if (nic_info->ipaddr[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
			fprintf(fptr, "%s", nic_info->hwaddr);
	} else if (!strcmp(name, "VIEW_SWITCH_STATUS"))
	{
                int status;
                status=NIC_Get_Status(NIC_LAN03);
                if (status==NIC_CONNECT)
                        fprintf(fptr, "NIC_VIEW_STR45");
                else
                if (status==NIC_CONNECTING)
                        fprintf(fptr, "NIC_VIEW_STR44");
                else
                        fprintf(fptr, "NIC_VIEW_STR46");
	}
// <== Catherine for switch end
	else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int view2_replace(FILE *fptr, char *name, void *arg)
{
	char	buf[256];

	if (!strcmp(name, "DNSDOMAIN"))
	{
		fprintf(fptr, get_domain_name());
	}
	else
	if (!strcmp(name, "bPRN"))
	{
		if (Is_Printer_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else
	if (!strcmp(name, "PRNNAME"))
	{
		Get_Printer_Name(buf, 256);
		if (buf[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
			fprintf(fptr, "%s", buf);
	}
	else
	if (!strcmp(name, "PRNCOMMENT"))
	{
		Get_Printer_Comment(buf, 256);
		if (buf[0]==0x0)
			fprintf(fptr, "&nbsp;");
		else
			fprintf(fptr, "%s", buf);
	}
	else
	if (!strcmp(name, "bDNS"))
	{
		if (Is_DNS_Enable()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else
	if (!strcmp(name, "DNSTYPE"))
	{
		int	type;

		type=get_ns_type();
		if (type==0)
			fprintf(fptr, "NIC_VIEW_DNS_MASTER");
		else
		if (type==1)
			fprintf(fptr, "NIC_VIEW_DNS_SLAVE");
		else
			fprintf(fptr, "\"&nbsp;\"");
	}
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}

int view1_replace(FILE *fptr, char *name, void *arg)
{
	char	buf[256];
	TAG_FTP	*ftp;

	if (!strcmp(name, "bMS"))
	{
		if (Is_Samba_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "MS_Server_Type"))
	{
		MS_Net_Type	type = 	STANDALONE;
		if ( Get_MS_Server_Type(&type) >= 0 ) {
			switch(type) {
				case	STANDALONE:
					fprintf(fptr, "NIC_MS_STR08");
					break;
				case	NTDC:
					fprintf(fptr, "NIC_MS_STR09");
					break;
				case	NTDM:
					fprintf(fptr, "NIC_MS_STR10");
					break;
				case	ADDM:
					fprintf(fptr, "NIC_MS_STR11");
					break;
			}
		}
	}
	else	if (!strcmp(name, "Domain_Workgroup"))
	{
		MS_Net_Type	type = 	STANDALONE;
		if ( Get_MS_Server_Type(&type) >= 0 ) {
			switch(type) {
				case	STANDALONE:
					fprintf(fptr, "NIC_MS_STR03");
					break;
				case	NTDC:
				case	NTDM:
				case	ADDM:
					fprintf(fptr, "NIC_MS_STR12");
					break;
			}
		}
	}
	else	if (!strcmp(name, "Domain_Workgroup_Name"))
	{
		MS_Net_Type	type = 	STANDALONE;
		char		DWname[128]="";
		int		ret = 0;
		
		if ( Get_MS_Server_Type(&type) >= 0) {
			switch(type) {
				case	STANDALONE:
					ret = Get_Samba3_Workgroup_Name(DWname);
					break;
				case	NTDC:
				case	NTDM:
				case	ADDM:
					ret = Get_Samba3_Domain_Name(DWname);
					break;
			}
			fprintf(fptr, "%s", DWname);
		}
	}
	else	if (!strcmp(name, "Enabled_Wins_SRV"))
	{
		BOOL	wins_enabled = FALSE;
		Get_Samba3_WINS_Srv(&wins_enabled);
		if ( wins_enabled )
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "WINSIP"))
	{
		BOOL  checked;
		//NIC_Get_WINS(buf, 256);
		Get_Samba3_WINS(&checked,buf);//Shone modified 2005/3/22
		//if(checked)
		fprintf(fptr, "%s", buf);
	}
	else	if (!strcmp(name, "WINS_SHOW_BEGIN"))//Shone added 2005/3/22
	{
		BOOL  checked;
		Get_Samba3_WINS(&checked,buf);
		if(!checked)
		   fprintf(fptr, "<!--");
	}
	else	if (!strcmp(name, "WINS_SHOW_END"))//Shone added 2005/3/22
	{
		BOOL  checked;
		Get_Samba3_WINS(&checked,buf);
		if(!checked)
		   fprintf(fptr, "-->");
	}
	else	if (!strcmp(name, "Enabled_DM"))//Shone added 2005/3/23
	{
		//BOOL	DM_enabled = FALSE;
		//Get_Samba3_WINS_Srv(&wins_enabled);
		if ( Domain_Master_Enabled() )
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "bAPPLE"))
	{
		if (Is_Appletalk_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "APPLEZONE"))
	{
		Get_Appletalk_Default_Zone(buf, 256);
		fprintf(fptr, "%s", buf);
	}
	else	if (!strcmp(name, "bNFS"))
	{
		if (Is_NFS_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "bWEBFS"))
	{
		if (Is_Webfs_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "bFTP"))
	{
		ftp=(TAG_FTP *)arg;
		if (ftp->enable)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "bPHOTO"))
	{
		if (Is_Qphoto_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "bDOWNLOAD"))
	{
		if (Is_Qdownload_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "bWEB"))
	{
		if (Is_Qweb_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "bNETWARE"))
	{
		if (Is_Netware_Enabled()!=0)
			fprintf(fptr, "NIC_VIEW_YES");
		else
			fprintf(fptr, "NIC_VIEW_NO");
	}
	else	if (!strcmp(name, "FTPPORT"))
	{
		ftp=(TAG_FTP *)arg;
		fprintf(fptr, "%d", ftp->port);
	}
	else	if (!strcmp(name, "MAXINSTANCES"))
	{
		ftp=(TAG_FTP *)arg;
		fprintf(fptr, "%d", ftp->maxinstances);
	}
	else
		return CGI_REPLACE_FAIL;

	return CGI_REPLACE_OK;
}

int show_view_header()
{
	char	filename[256];
	int	select=9;
	HEADER_ITEM	header;
	int	nic_count;

	CGI_Output_Html1(NIC_HEADER_HTML, "$", view_replace, NULL);

	header.back[0]=0x0;
	header.home[0]=0x0;
	header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_view_main");
	else
		CGI_Get_Help(header.help, "network_view_main.html");
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);

        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", view_replace, NULL);

	nic_count=NIC_Count_Interface();
	strcpy(filename, "/home/httpd/cgi-bin/network/network.def");

	CGI_Show_Menu_V3_2(filename, select);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", view_replace, NULL);
	return NIC_SUCCESS;
}

int show_view_tail ()
{
	CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", view_replace, NULL);
	CGI_Output_Html1(NIC_TAIL_HTML, "$", view_replace, NULL);
	return NIC_SUCCESS;
}

int do_view_main()
{
	int		count_nic, tab=1, bond_cnt;
	NIC_INFO	nic_info;
	BOOL		is_switch_support, is_bonding_support;

	is_switch_support = NIC_Is_Switch_Support();
	is_bonding_support = NIC_Is_Bonding_Support();
	count_nic=NIC_Count_Interface()-is_switch_support;//Shone modified 2005,06,03
	bond_cnt = NIC_Count_Bonding_Interface();

	show_view_header();
	if (support_misc())
		CGI_Output_Html1(NIC_VIEW_HEADER_HTML, "$", view_replace, &tab);
	else
		CGI_Output_Html1(NIC_VIEW_HEADER_NO_MISC_HTML, "$", view_replace, &tab);
	if (count_nic==2 && NIC_Is_Support_NAT())
	{
		NIC_Get_Info(&nic_info, NIC_WAN);
		CGI_Output_Html1(NIC_VIEW_WAN_HTML, "$", view_replace, &nic_info);
		NIC_Get_Info(&nic_info, NIC_LAN01);
		CGI_Output_Html1(NIC_VIEW_LAN_HTML, "$", view_replace, &nic_info);
	}
	else
	if (count_nic==1 || (count_nic==2 && is_bonding_support) ||
		(count_nic==3 && is_bonding_support))
	{
		NIC_Get_Info(&nic_info, NIC_LAN01);
		if (count_nic==1)
			CGI_Output_Html1(NIC_VIEW_LAN01_HTML, "$", view_replace, &nic_info);
		else
		if ((count_nic==2 && is_bonding_support) ||
			(count_nic==3 && is_bonding_support))
		{
			int	bonding_type=NIC_Get_Bonding_Type();
			
			if ( bonding_type == BONDING_FAIL_OVER || bonding_type == BONDING_LOAD_BALANCE ) 
				CGI_Output_Html1(NIC_VIEW_LAN02_HTML, "$", view_replace, &nic_info);
			else {
				int	idx = 1;
				for ( idx = 1; idx <= count_nic; idx ++ ) {
					int	nic_lan = NIC_LAN01+idx-1;
					
					NIC_Get_Info(&nic_info, nic_lan);
					CGI_Output_Html1(NIC_VIEW_LAN02_HTML, "$", view_replace, &nic_info);
				}
			}
		}
	}
//	CGI_Output_Html1(NIC_VIEW_DHCP_HTML, "$", view_replace, &nic_info);
	if (count_nic==2 && NIC_Is_Support_NAT())
		CGI_Output_Html1(NIC_VIEW_NAT_HTML, "$", view_replace, NULL);

	// switch part begin -- Catherine
//	if (count_nic==3 && count_nic > bond_cnt && is_switch_support) {
	if (count_nic==2 && is_switch_support) {//Shone modified 2005,06,03
		NIC_Get_Info(&nic_info, NIC_LAN03);
		CGI_Output_Html1(NIC_VIEW_SWITCH_HTML, "$", view_replace, &nic_info);
	}

	// switch part end

	CGI_Output_Html1(NIC_VIEW_TAIL_HTML, "$", view_replace, NULL);

	show_view_tail();
	return NIC_SUCCESS;
}

int do_view_main1()
{
	TAG_FTP		ftp;
	int		tab=2;

	show_view_header();
	if (support_misc())
		CGI_Output_Html1(NIC_VIEW_HEADER_HTML, "$", view_replace, &tab);
	else
		CGI_Output_Html1(NIC_VIEW_HEADER_NO_MISC_HTML, "$", view_replace, &tab);

	/* body */
	CGI_Output_Html1(NIC_VIEW_MS_HTML, "$", view1_replace, NULL);
	CGI_Output_Html1(NIC_VIEW_APPLE_HTML, "$", view1_replace, NULL);
	CGI_Output_Html1(NIC_VIEW_WEBFS_HTML, "$", view1_replace, NULL);
	Ftp_Read_Tag(&ftp);
	CGI_Output_Html1(NIC_VIEW_FTP_HTML, "$", view1_replace, &ftp);
	CGI_Output_Html1(NIC_VIEW_PHOTO_HTML, "$", view1_replace, NULL);
	CGI_Output_Html1(NIC_VIEW_DOWNLOAD_HTML, "$", view1_replace, NULL);
	CGI_Output_Html1(NIC_VIEW_WEB_HTML, "$", view1_replace, NULL);

	CGI_Output_Html1(NIC_VIEW_TAIL_HTML, "$", view1_replace, NULL);
	show_view_tail();
	return NIC_SUCCESS;
}

int do_view_main2()
{
	int	tab=3;

	show_view_header();
	if (support_misc())
		CGI_Output_Html1(NIC_VIEW_HEADER_HTML, "$", view_replace, &tab);
	else
		CGI_Output_Html1(NIC_VIEW_HEADER_NO_MISC_HTML, "$", view_replace, &tab);

	/* body */
	if (Is_Support_DNS())
		CGI_Output_Html1(NIC_VIEW_DNS_HTML, "$", view2_replace, NULL);
	if (Is_Support_Printer())
		CGI_Output_Html1(NIC_VIEW_PRN_HTML, "$", view2_replace, NULL);

	CGI_Output_Html1(NIC_VIEW_TAIL_HTML, "$", view_replace, NULL);
	show_view_tail();
	return NIC_SUCCESS;
}

int do_view_main_submit(INPUT *input)
{
	do_nic_main();
	return NIC_SUCCESS;
}
