#include <stdio.h>
#include <string.h>

/* include NAS lib */
#include <cgi.h>
#include <cfg_nic.h>
#include <config.h>
#include <v2_menu.h>
#include <cfg_printer.h>
#include <cfg_dns.h>

/* include local file */
#include "network.h"
#include "nic_nfs.h"

int nfs_replace(FILE *fptr, char *name, void *arg)
{
        if (!strcmp(name, "ONLOAD"))
        {
        }
        else
        if (!strcmp(name, "bNFS"))
        {
                if (Is_NFS_Enabled()!=0)
                        fprintf(fptr, "checked");
        }
        else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

//  Add by Tiger
int show_nfs_header ()
{
        HEADER_ITEM     header;
	int	nic_count;

        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
		CGI_Get_Help(header.help, "help_network.html#network_nfs_main");
	else
		CGI_Get_Help(header.help, "network_nfs_main.html");
        CGI_Show_Menu_V3_1(FUNC_NETWORK, &header);
	CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", nfs_replace, NULL);
	nic_count=NIC_Count_Interface();
	if (	(nic_count==1 && !Is_Support_DNS() && !Is_Support_DNS()) ||
		(nic_count==3 && NIC_Is_Bonding_Support() && !Is_Support_DNS() && !Is_Support_DNS()) ||
		(nic_count==2 && NIC_Is_Bonding_Support() && !Is_Support_DNS() && !Is_Support_DNS()))
		if(!Is_Support_Printer())
			CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.noprndns.def", 4);
		else
			CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/network-1.nodns.def", 4);
	else
		CGI_Show_Menu_V3_2("/home/httpd/cgi-bin/network/nas_services.def", 3);
	CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", nfs_replace, NULL);
	return NIC_SUCCESS;
}

int show_nfs_tail ()
{
	return CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", nfs_replace, NULL);
}
//  add until here

int do_nfs_main()
{
        CGI_Output_Html1(NIC_HEADER_HTML, "$", nfs_replace, NULL);
        //  Add by Tiger
        show_nfs_header ();
        CGI_Output_Html1(NIC_NFS_MAIN_HTML, "$", nfs_replace, NULL);
        //  Add by Tiger ();
        show_nfs_tail ();
        CGI_Output_Html1(NIC_TAIL_HTML, "$", nfs_replace, NULL);
        return NIC_SUCCESS;
}

int do_nfs_main_submit(INPUT *input)
{
        INPUT   *tmp;

        if ((tmp=CGI_Find_Parameter(input, "bNFS"))!=NULL)
                Enable_NFS(1);
        else
                Enable_NFS(0);
	do_nfs_main();
        return NIC_SUCCESS;
}

