#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* include NAS lib */
#include <cgi.h>
#include <cfg_nic.h>
#include <cfg_system.h>

/* include local file */
#include "network.h"
#include "nic_lan.h"

int lan_replace(FILE *fptr, char *name, void *arg)
{
        NIC_NAS_INFO    *nic_nas_info;
        char            buf[256], *ptr;

        if (    !strcmp(name, "LAN_IP1") || !strcmp(name, "LAN_IP2") ||
                !strcmp(name, "LAN_IP3") || !strcmp(name, "LAN_IP4"))
        {
                nic_nas_info=(NIC_NAS_INFO *)arg;
                ptr=name+(strlen(name)-1);
                fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.ipaddr, (int)(*ptr-'1')));
        }
        else
        if (    !strcmp(name, "LAN_MASK1") || !strcmp(name, "LAN_MASK2") ||
                !strcmp(name, "LAN_MASK3") || !strcmp(name, "LAN_MASK4"))
        {
                nic_nas_info=(NIC_NAS_INFO *)arg;
                ptr=name+(strlen(name)-1);
                fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.netmask, (int)(*ptr-'1')));
        }
        else
        if (    !strcmp(name, "LAN_GW1") || !strcmp(name, "LAN_GW2") ||
                !strcmp(name, "LAN_GW3") || !strcmp(name, "LAN_GW4"))
        {
                nic_nas_info=(NIC_NAS_INFO *)arg;
                ptr=name+(strlen(name)-1);
                fprintf(fptr, "%s", parser_ipaddr(buf, nic_nas_info->ifconfig.gateway, (int)(*ptr-'1')));
        }
        else
        if (!strcmp(name, "radio_dhcp") || !strcmp(name, "radio_pppoe") || !strcmp(name, "radio_static"))
        {
                nic_nas_info=(NIC_NAS_INFO *)arg;
                if (nic_nas_info->usage==NIC_USE_DHCP && !strcmp(name, "radio_dhcp"))
                        fprintf(fptr, "checked");
                else
                if (nic_nas_info->usage==NIC_USE_STATIC && !strcmp(name, "radio_static"))
                        fprintf(fptr, "checked");
                else
                if (nic_nas_info->usage==NIC_USE_PPPOE && !strcmp(name, "radio_pppoe"))
                        fprintf(fptr, "checked");
        }
        else
                return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int do_lan_main()
{
        NIC_NAS_INFO    nic_nas_info;

        NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
        CGI_Output_Html1(NIC_HEADER_HTML, "$", lan_replace, &nic_nas_info);
        CGI_Output_Html1(NIC_LAN_MAIN_HTML, "$", lan_replace, &nic_nas_info);
        CGI_Output_Html1(NIC_TAIL_HTML, "$", lan_replace, &nic_nas_info);
        return NIC_SUCCESS;
}

int do_lan_main_submit(INPUT *input)
{
        INPUT           *p;
        NIC_NAS_INFO    nic_nas_info;
        int             ret=NIC_SUCCESS;

        NIC_Get_Info_From_uLinux(&nic_nas_info, NIC_LAN01);
        if ((p=CGI_Find_Parameter(input, "LAN_USAGE"))!=NULL)
        {
                if (!strcmp(p->val, "LAN_DHCP"))
                        nic_nas_info.usage=NIC_USE_DHCP;
                else
                if (!strcmp(p->val, "LAN_STATIC"))
                        nic_nas_info.usage=NIC_USE_STATIC;
                else
                        nic_nas_info.usage=NIC_USE_OTHER;
        }
        else
                goto lan_not_found;

        CGI_Get_Text_IP(nic_nas_info.ifconfig.ipaddr, NIC_IPADDR_LEN, input, "LAN_IP1", "LAN_IP2", "LAN_IP3", "LAN_IP4");
        CGI_Get_Text_IP(nic_nas_info.ifconfig.netmask, NIC_IPADDR_LEN, input, "LAN_MASK1", "LAN_MASK2", "LAN_MASK3", "LAN_MASK4");
        CGI_Get_Text_IP(nic_nas_info.ifconfig.gateway, NIC_IPADDR_LEN, input, "LAN_GW1", "LAN_GW2", "LAN_GW3", "LAN_GW4");
        ret=NIC_Set_Info_To_uLinux(&nic_nas_info);

lan_not_found:
        if (ret==NIC_RESTART)
                do_restart_main(1);
        else
                do_nic_main();
        return NIC_SUCCESS;
}

