#!/bin/sh
#
# chkconfig: - 60 60
# description: MARS is a NetWare compatible file and printer server. It \
#              lets you use a Linux machine as a file and print server for \
#              NetWare based clients using NetWare's native IPX protocol suite.
# processname: nwserv
# processname: nwbind
# processname: ncpserv
# config: /etc/nwserv.stations
# config: /etc/nwserv.conf
# pidfile: /var/run/nwserv.pid 

# Source function library.
[ -x /usr/sbin/nwserv ] || exit 0

RETVAL=0

# See how we were called.
case "$1" in
  start)
	echo -n "Starting NetWare emulator-server:"

	if [ `/sbin/getcfg Netware Enable -u -d TRUE` = FALSE ]
	then
	    echo " disabled."
	    exit 0
	fi

	echo -n " nwserv"
	/usr/sbin/nwserv
	RETVAL=$?
	[ $RETVAL -eq 0 ] && touch /var/lock/subsys/mars_nwe
	echo "."
	;;
  stop)
	echo -n "Stopping NetWare emulator-server:"
	echo -n " nwserv"
	killall -QUIT nwserv
	RETVAL=$?
	[ $RETVAL -eq 0 ] && rm -f /var/lock/subsys/mars_nwe
	echo "."
	;;
  reload)
	killall -HUP nwserv
	RETVAL=$?
	;;
  restart)
	$0 stop
	$0 start
	RETVAL=$?
	;;
  *)
	echo "Usage: $0 {start|stop|status|restart}"
	exit 1
	;;
esac

exit $RETVAL

                                                            