#ifndef		_DHCP_CONF
#define		_DHCP_CONF

#define		DNS_BUF_SIZE			1024
#define		RESOLV_CONF			"/etc/resolv.conf"

#define		DNS_OFF				0
#define		DNS_ON				1

#define		SUCCESS				0
#define		OPEN_CONFIG_FILE_ERROR		1
#define		WRITE_CONFIG_FILE_ERROR 	2

typedef struct {
	
	char zone_name[256];
	int default_TTL;
	int serial_number;
	int refresh_time;
	int retry_time;
	int expire_time;
	int mini_TTL;

}ZONE_DETAIL_INFO;

typedef struct {

	char conf_file_name[256];
	char NAS_name[32];
	char local_zone_name[256];
	int behind_firewall;
	
}CONF_FILE_INFO;

typedef struct {

	char name[128];
	char type1[8];
	char type2[16];
	char mapping[128];

}RESOURCE_RECORD;

int add_zone (FILE * fp, ZONE_INFO * zone_info);
int add_slave_zone (FILE * fp, SLAVE_ZONE_INFO * zone_info);
int add_option (char * option, char * value);
int add_record (char * zone_file, RESOURCE_RECORD * rr_info);//char * left_value, char * type1, char * type2, char * right_value);
int parser_priority (char * mapping);
char * parser_mapping (char * mapping);

int erease_option (char * option, char * value);
int remove_record (char * zone_file, char * record);

int create_zone_file (char * file_name, ZONE_DETAIL_INFO * zone_content);

int check_file_exist (char * filename);
int create_cache_only (CONF_FILE_INFO * conf_file_info);
int create_slave_ns (CONF_FILE_INFO * conf_file_info);
int create_maste_ns (CONF_FILE_INFO * conf_file_info);
int create_conf_file (CONF_FILE_INFO * conf_file_info, ZONE_DETAIL_INFO * zone, enum e_nstype type);
int paser_input (FILE * fp, char * value);
int generate_root_file (void);
void parser_resource_record (char * src, int len, RESOURCE_RECORD * rr_info, int size);
int generate_sequence_number (void);

int generate_reserve_zone (ZONE_INFO * zone_info);
int parser_ip_string (char * ip, int index);
//char * parser_reserve_zone_ip (NIC_NAS_INFO * nic_nas_info);
int conver_rr_to_reserve (RESOURCE_RECORD * rr_buf, RESOURCE_RECORD * rr_info);

#endif