#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/stat.h>
#include <sys/types.h>



#include <uLinux.h>
#include <cgi.h>
#include <config.h>
#include <v2_menu.h>
#include <Util.h>
#include <NAS.h>
#include <cfg_save_restore.h>
#include <cfg_system.h>

#include "cfg_nic.h"
#include "misc.h"
#include "save_restore.h"
#include "naslvm.h"
#include "eventlog.h"

extern int get_reset_disk_status_file(char *status);
extern int set_reset_disk_status_file(char *status);

/*#define __dbg(format, arg...)            \
	do {\
                FILE *fp; \
                fprintf(stdout,format , ## arg); \
                fp = fopen("/debug","a+"); \
                fprintf(fp, format , ## arg); \
                fclose(fp); \
        } while (0);
*/
int write_log(char *str, int type)
{
        int fd;
        char *ptr[10];

        fd = Open_Event_Log(1);
        if (fd <= 0)
        {
                return -1;
        }
        ptr[0]=str;
        Report_Event(fd, type, 1, ptr);
        Close_Event_Log(fd);
        return 0;
}

//=======================================//
// Functions of Save / Restore settings  //
//=======================================//
int upload_file_to_restore()
{
	char src[128], *work_dir = NULL;
	char backup_file_path[255];
	int ret;
	int hd_init_flag;
	
	memset(backup_file_path, '\0', sizeof(backup_file_path));
	if ((work_dir = create_update_working_directory(&hd_init_flag)) == NULL)
		return -1;
        strcpy(backup_file_path, work_dir);
	if ((ret = CGI_Upload(backup_file_path, BACKUPFILE , src)) == CGI_SUCCESS){
		strcat(backup_file_path, "/");
		strcat(backup_file_path, BACKUPFILE);
		chmod (backup_file_path, S_IRWXU | S_IRWXG | S_IRWXO);
		ret = Misc_Restore_Profile(backup_file_path);
	}
	return ret;
	 
}

int do_ask_reboot(INPUT* input, int select)
{
	show_misc_header(input, select);
	CGI_Output_Html1(SR_RESTART_HTML, "$", my_replace, NULL);
	show_misc_tail();
	return MISC_SUCCESS;
	
}
int do_sr_main(INPUT* input, int select)
{
	int num = 0;
	num = NIC_Count_Interface();

	show_misc_header(input, select);
	if((num >= 2) && !NIC_Is_Bonding_Support()) {
		CGI_Output_Html1(SR_MAIN_HTML1, "$", my_replace, (void *)input);
	}
	else {
		CGI_Output_Html1(SR_MAIN_HTML, "$", my_replace, (void *)input); // No firewall default setting to reset
	}
	show_misc_tail();
	return MISC_SUCCESS;
}
int do_sr_main_submit(INPUT* input)
{
	int btn, ret = MISC_SUCCESS;
	btn = get_btn(input);
	switch(btn){
		case MISC_BTN_RESTORE:
			ret = upload_file_to_restore();
			if(ret == -1)
				return MISC_SR_RESTORE_ERROR;
			clear_update_tmp_data();
			if (ret == SAVE_RESTORE_RESTART) {
				ret = do_ask_reboot(input, SELECT_SR);
			}
			else
				ret = MISC_SR_RESTORE_ERROR;
			break;
	}	
	return ret;
}


//==============================//
// Functions of Reset settings  //
//==============================//
int create_directory(char *full_path)
{
	int NumberOfSlash = 0, i, j, k;
	char szText[512];

	// Do we need to check path name???
	for (i = 0; i < strlen(full_path); i ++) {
		if (full_path[i] == '/')
			NumberOfSlash++;
	}
	if (full_path[strlen(full_path) - 1] == '/') {
		NumberOfSlash--;
		full_path[strlen(full_path) - 1] = 0;
	}
	for (i = 1; i <= NumberOfSlash; i ++) {
		k = 0;
		for (j = 0; j < strlen(full_path); j++) {
			szText[j] = full_path[j];
			if (full_path[j] == '/') {
				k++;
				if (k > i)
					break;
			}
		}
		szText[j] = '\0';
		if (!Is_Existing_Directory(szText)) {
			umask(0000);  // set umask
			if (mkdir(szText, S_IRWXU | S_IRWXG | S_IRWXO) != 0) {
				return ERROR_FAIL;
			}
			else if (Change_File_Attribute(szText, "admin", "everyone") != 0) {
				// return -1; // Do we need to return here???
			}
		}
	}
	return SUCCESS;
}


int get_abs_path(char *real_path, char *path, char *hd_name)
{
	LVM_VOLUME_INFO *config_vol=NULL;
	int i, cnt;

	cnt = Get_All_LVM_Configured_Vol_For_Share(&config_vol);
	if(cnt == 0)
		return ERROR_FAIL;
	i = config_vol[0].vol_data.drive_no_list[0];
	Get_MP_String(i, DATA_PART, real_path);
	if ((path != NULL) && (strlen(path) > 0)) {
		if ((real_path[strlen(real_path) - 1] != '/') && (path[0] != '/'))
			strcat(real_path, "/");
		strcat(real_path, path);
	}
	Release_LVM_Info_List(config_vol, cnt);
	return SUCCESS;
}

int get_path_for_create_share(char *sharename, char *path)
{
        int ret, i, j, k;
        char auto_path[SHARE_PATH_LENGTH];
        char c_dir[SHARE_PATH_LENGTH];   // current working pathname
        char *dir_ptr;
        int  dir_cnt, dir_len;


	strncpy(auto_path, sharename, sizeof(auto_path));
	ret = get_abs_path(c_dir, NULL, NULL);
	if(ret != SUCCESS)
		return ERROR_FAIL;
	if (Get_All_SubDIR_Cnt_Len(c_dir, c_dir, &dir_cnt, &dir_len) == 0) {
		dir_ptr = calloc(dir_cnt, dir_len);
		if (dir_ptr != NULL) {
			if (Get_All_SubDIR(c_dir, c_dir, dir_ptr, dir_cnt, dir_len) == 0) {
				for (j = -1;; j ++) {
					k = 1;
					if (j != -1)
						sprintf(auto_path, "%s%d", sharename, j);
					for (i = 0; i < dir_cnt; i++) {
						if (strcasecmp((dir_ptr + i * dir_len), auto_path) == 0) {
							k = 0;
							break;
						}
					}
					if (k == 1)
						break;
				}
			}
			free(dir_ptr);
		}
	}
	ret = get_abs_path(path, auto_path, NULL);
	if(ret != SUCCESS)
		return ERROR_FAIL;
	ret = create_directory(path);
	if(ret != SUCCESS)
		return ERROR_FAIL;
	return ret;		
}

int set_default_network_share(char *sharename, NAS_SHARE_INFO *s_info)
{
        int ret = ERROR_FAIL;
	char path[SHARE_PATH_LENGTH];
        char rw_name[USER_GROUP_NAME_LENGTH];
		        
	ret = get_path_for_create_share(sharename, path);
	if(ret != SUCCESS)
		return ERROR_FAIL;
        
        memset(s_info, 0, sizeof(NAS_SHARE_INFO));

	strcpy(s_info->share_name, sharename);

	strcpy(s_info->comment, "");

	strcpy(s_info->path, path);

	s_info->read_list_cnt = 0;

	strcpy(rw_name, "");
	s_info->read_list_ptr = &rw_name;

	s_info->write_list_cnt = 0;

	strcpy(rw_name, "@everyone");
	s_info->write_list_ptr = &rw_name;

	return SUCCESS;
}

/*-----------------------------------------------------------------------*/
/*                            Do reset single disk                             */
/*-----------------------------------------------------------------------*/
int do_reset_disk(int drive_no, int raid_level)
{
	char 	msg_log[256];
	int 	ret = 0;
	char	system_model[32];
	Get_Profile_String("System", "Internal Model", "TS-101", system_model, sizeof(system_model));
	// Jimmy 2006/03/24
	// if the internal model name is TS-101
	// then init single disk
	// if the internal model name is TS-201
	// then 
	// 1. check how many disks connect to system
	// 2. if disk number is 2, then init raid1
	//    if disk number is 1, then init single disk
	if(!strcasecmp(system_model, "TS-101"))
	{
		strcpy(msg_log,"[SATA Disk] Start formatting.");
		write_log(msg_log,EVENTLOG_INFORMATION_TYPE);

		ret = Init_NAS_Single_Disk(drive_no);

		if(ret==SUCCESS)
		{	
			strcpy(msg_log,"[SATA Disk] Formatting completed.");
			write_log(msg_log,EVENTLOG_INFORMATION_TYPE);
		}
		else if(ret==ERROR_CANT_UMOUNT)
		{
			strcpy(msg_log,"[SATA Disk] Formatting failed(Can not unmount disk).");
			write_log(msg_log,EVENTLOG_ERROR_TYPE);
		}
		else
		{
			strcpy(msg_log,"[SATA Disk] Formatting failed.");
			write_log(msg_log,EVENTLOG_ERROR_TYPE);
		}
		return ret;
	}
	//add by Jimmy for TS-201 reset disk
	else
	{
		int 	vol_no_list[4];
		int	ret, hd1=0, hd2=0;
		vol_no_list[0] = 1;
		vol_no_list[1] = 2;
		system("/bin/rm /etc/config/raidtab 2>/dev/null");
                system("/sbin/storage_boot_init 2");
		hd1=Is_Sata_HD_Exist("/dev/sda");
		hd2=Is_Sata_HD_Exist("/dev/sdb");
		if(hd1 && hd2)
		{	// found two disks
			if(raid_level != SINGLE)
                		Quick_Create_Raid_Volume(1, MIRROR);
                        else
				Create_Raid_Volume(vol_no_list,2,MIRROR);
                        return SUCCESS;
		}
		else
		{
			if (hd1)
                               	ret=Init_Single_Disk_Volume(1);
                        else
			if (hd2)
                                ret=Init_Single_Disk_Volume(2);
			else
				return FALSE;
			return SUCCESS;
		}
	}
	return FALSE;
	//add end
}

int set_reset_item(INPUT* input)
{
	INPUT 	*tmp = NULL;
	if((tmp=CGI_Find_Parameter(input, "RESET"))!=NULL) {
		if((tmp=CGI_Get_Parameter(input, "br_type"))!=NULL) {
			
			int raid_level;
			raid_level = Get_Private_Profile_Integer("VOLUME 1", "raid level", 10, "/etc/config/storage.conf");
			Stop_Services();
			System_Reset_All();

			pid_t child_pid;

			if(set_reset_disk_status_file("BUSY") != SUCCESS) {
				return ERROR_FAIL;
			}
			
			do_sr_main(input, SELECT_SR);
			child_pid = fork();
			if(child_pid == 0) {
				int status=0;
				
				close(1);
				close(2);
				//System_Reset_Disk();
				status = do_reset_disk(1, raid_level);
				Start_Services();
				if(set_reset_disk_status_file("OK") != SUCCESS || status != SUCCESS) {
					return ERROR_FAIL;
				}
				write_log(RESET_ALL_LOG, EVENTLOG_INFORMATION_TYPE);
			}
		}
		else {
			return ERROR_FAIL;
		}
	}
	else if((tmp=CGI_Find_Parameter(input, "refresh"))!=NULL) {
		char status[BUF_SIZE] = {0};

		if(SUCCESS != get_reset_disk_status_file(status)) {
			return ERROR_FAIL;
		}
		if(!strcasecmp(status, "OK")) {
			return SAVE_RESTORE_RESTART;
		}
	}

	return MISC_SUCCESS;
}	
	

int do_reset_main_submit(INPUT* input)
{	
	int ret, btn;
	
	btn = get_btn(input);
	
	switch(btn)
	{
		case MISC_BTN_RESET:
			ret = set_reset_item(input);
			if (ret == SAVE_RESTORE_RESTART) {
				ret = do_ask_reboot(input, SELECT_SR);
			}
			else {
				return ret;
			}
			break;
		case MISC_BTN_REFRESH:

			ret = set_reset_item(input);
			if (ret == SAVE_RESTORE_RESTART) {
				ret = do_ask_reboot(input, SELECT_SR);
			}
			else {
				do_sr_main(input, SELECT_SR);
			}
			break;
	}
	return MISC_SUCCESS;
}

int do_sr_restart_submit(INPUT* input)
{
	INPUT *tmp = NULL;
	int btn;
	btn = get_btn(input);
	
	switch(btn)
	{
		case MISC_BTN_YES:
			set_misc_restart(0);
			CGI_Load_Html("misc.cgi?func=sr_main_restart&restart=0");
			CGI_Free_Input(input);
			exit(0);
			break;
		case MISC_BTN_NO:
			CGI_Load_Html("misc.cgi?func=sr_main");
			CGI_Free_Input(input);
			exit(0);
			break;
		default:
			if((tmp=CGI_Find_Parameter(input, "restart")) != NULL) {
				if(!strcmp(tmp->val, "0")) {					
					do_restarting(input, SELECT_RESTART);
				}
			}
			break;	
	}
	return MISC_SUCCESS;
}
