#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <uLinux.h>
#include <cgi.h>
#include <config.h>
#include <v2_menu.h>
#include <Util.h>
#include <NAS.h>
#include <cfg_system.h>
#include "misc.h"
#include "dvd.h"
#include "restart.h"
#include "backup.h"
#include <cfg_dvd.h>

MEDIA_TYPE media;
DEVICE_TYPE dev;
int dev_ret,med_ret;
int dev_no;
//char disklabel[BUF_SIZE],dpath[BUF_SIZE];

int dvd_backup_replace(FILE* fp, char* str)
{
	SECTION_INFO *vol=NULL;
	int num,i;
	char status[BUF_SIZE], burning_process[BUF_SIZE];
	char med_ty[BUF_SIZE],disklabel[BUF_SIZE],dpath[BUF_SIZE],speed[BUF_SIZE];
	if (!strcmp(str, "VOL"))
	{	
		char vol_choose[BUF_SIZE];
		GetPrivateProfileString(DVD_SECTION,"Volume","",vol_choose,sizeof(vol_choose),DVD_CONFIG);
		num = Get_NAS_Share_List_Ex(&vol);
		for (i = 0; i<num; i++){
			char buf[1024];
			strcpy(buf,(vol+i)->section_name);
			if(!strcmp(vol_choose,buf))
				fprintf(fp,"<option value=\"%s\" selected>%s</option>", (vol+i)->section_name, (vol+i)->section_name);
			else
				fprintf(fp,"<option value=\"%s\">%s</option>", (vol+i)->section_name, (vol+i)->section_name);
		}
		if (vol != NULL)
             		Release_List(vol);
	}
	else 
	if(!strcmp(str,"dev_type"))
	{
		char devtype[BUF_SIZE];
		if(dev_ret!=E_DVD_DEVICE)
		{
			GetPrivateProfileString(DVD_SECTION,DVD_DEV_FIELD,"",devtype,sizeof(devtype),DVD_CONFIG);
			fprintf(fp,"%s",devtype);
		}
		else
			fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR33)</script>");
	}
	else 
	if(!strcmp(str,"med_type"))
	{
		DVD_Get_Status(status);
		if(strcmp(status,STATUS_EMPTY)){
			GetPrivateProfileString(DVD_SECTION,DVD_MED_FIELD,"",med_ty,sizeof(med_ty),DVD_CONFIG);
			fprintf(fp,"%s",med_ty);
		}
		else
			fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR34)</script>");
				
	}
	else
	if(!strcmp(str,"med_speed"))
	{
		DVD_Get_Status(status);
		if(dev_ret!=E_DVD_DEVICE){
			if(strcmp(status,STATUS_EMPTY)){
				GetPrivateProfileString(DVD_SECTION,DVD_SPEED_FIELD,"",speed,sizeof(speed),DVD_CONFIG);
				fprintf(fp,"%2.1fx",atof(speed));
			}
			else
				;
		}
		else
			;//fprintf(fp,"");
	}
	else if(!strcmp(str,"status"))
	{
		DVD_Get_Status(status);
		if(!strcmp(status,STATUS_EMPTY))
			fprintf(fp,"<font color=red>%s</font>","<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR29)</script>");
		else if(!strcmp(status,STATUS_BURNING))
			fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR28)</script>");
		else if(!strcmp(status,STATUS_READY))
			fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR27)</script>");
		else if(!strcmp(status,STATUS_ERASING))
			 fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR37)</script>");
		else if(!strcmp(status,STATUS_COPYING))
			fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR40)</script>");
	}
	else if(!strcmp(str,"SPEED"))
	{
		char buf[BUF_SIZE];
		GetPrivateProfileString(DVD_SECTION,DVD_SPEED_FIELD,"",buf,sizeof(buf),DVD_CONFIG);
		media.speed=atof(buf);
		if(med_ret!=E_DVD_MEDIA&&dev_ret!=E_DVD_DEVICE)
		{
			if(media.speed>3){
				for(i=(int)media.speed;i>=1;i=i/2){
					fprintf(fp,"<option value=\"%d\">%dx</option>",i,i);
				}
			}
			else
			if(media.speed>0 && media.speed<=3){
				fprintf(fp,"<option value=\"%2.1f\">%2.1fx</option>",2.4,2.4);
				fprintf(fp,"<option value=\"%d\">%dx</option>",1,1);
			}
			else
				fprintf(fp,"<option value=40>max</option");
		}
		else
			fprintf(fp,"<option value=\"%d\">%dx</option>",1,1);
	}
	else if(!strcmp(str,"disk_label"))
	{
		DVD_Get_Status(status);
		if(!strcmp(status,STATUS_BURNING)){
			GetPrivateProfileString(DVD_SECTION,DVD_LABEL_FIELD,"",disklabel,sizeof(disklabel),DVD_CONFIG);
			fprintf(fp,"<input type=\"text\" name=\"DiskLabel\" class=\"12-blueword-dbrwnline\" size=\"16\" maxlength=\"64\" value=\"%s\">",disklabel);
		}
		else
		{
			fprintf(fp,"<input type=\"text\" name=\"DiskLabel\" class=\"12-blueword-dbrwnline\" size=\"16\" maxlength=\"64\" value=\"\">");
		}
	}

	else if(!strcmp(str,"dvdpath"))
	{
		DVD_Get_Status(status);
		if(!strcmp(status,STATUS_BURNING)){
			GetPrivateProfileString(DVD_SECTION,DVD_SOURCE_PATH_FIELD,"",dpath,sizeof(dpath),DVD_CONFIG);
			fprintf(fp,dpath);
		}
	}
	else if(!strcmp(str,"btn_burn_status"))
	{
		DVD_Get_Status(status);
		if(!strcmp(status,STATUS_BURNING) || !strcmp(status,STATUS_ERASING) || !strcmp(status,STATUS_COPYING)){
			fprintf(fp,"disabled=\"true\"");
		}	
		
		else if(!strcmp(status,STATUS_READY))
			;
		else if(!strcmp(status,STATUS_EMPTY)){
			fprintf(fp,"disabled=\"true\"");
		}
	}
	else if(!strcmp(str,"btn_cancel_status")){
		DVD_Get_Status(status);
		
		if(!strcmp(status,STATUS_BURNING))
			;
		else{
			fprintf(fp,"disabled=\"true\"");
		}
	}
	else if(!strcmp(str,"btn_erase_status")){
		char medType[BUF_SIZE];
		GetPrivateProfileString(DVD_SECTION,DVD_MED_FIELD,"",medType,sizeof(medType),DVD_CONFIG);
		DVD_Get_Status(status);
		if(!strcmp(status,STATUS_BURNING) || !strcmp(status,STATUS_COPYING)){
			fprintf(fp,"disabled=\"true\"");
		}
		else
		if(!strcmp(status,STATUS_READY)&&(!strcmp(medType,"DVD+RW")||!strcmp(medType,"DVD-RW") ||!strcmp(medType,"CD-RW")))
			;
		else
		if(!strcmp(status,STATUS_EMPTY)){
			fprintf(fp,"disabled=\"true\"");
		}
		else
			fprintf(fp,"disabled=\"true\"");
	}
	else if(!strcmp(str,"burning_status")){
		DVD_Get_Status(status);
		GetPrivateProfileString(DVD_SECTION,DVD_MED_FIELD,"",med_ty,sizeof(med_ty),DVD_CONFIG);
		if(!strcmp(status,STATUS_BURNING)){
			DVD_Get_Burning_Process(OUTLOG,burning_process);
			if(strstr(burning_process,"Blanking"))
				fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR24)</script>");
			else if(strchr(burning_process,'%') || strstr(burning_process,"Writing")){
				if(strstr(burning_process,"100.00%")==NULL){
					if(strstr(med_ty,"CD-R") && !strstr(burning_process,"Writing"))
						fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR25)</script> %s",burning_process);
					else if(strstr(burning_process,"Writing"))
						fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR26)</script> %s",burning_process+23);
					
					else{
						fprintf(fp,"%s",burning_process);
					}
				}
				else{
					fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR38)</script>");
		//			DVD_Eject_Rom(dev_no);
				}
			}
			else
				fprintf(fp,"%s","<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR30)</script>");
		}
		else if(!strcmp(status,STATUS_READY)){
			FILE *fptr;
			char buf[BUF_SIZE];
			fptr=fopen(ERROR_FILE,"r");
			if(fptr==NULL)
				fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR32)</script>");
			else{
				fgets(buf,sizeof(buf),fptr);
			
				if(!strncmp(buf,"0",1)){
					fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR35)</script>");
					fclose(fptr);
					unlink(ERROR_FILE);
				}
				else{
					fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_ERROR_MSG260)</script>");
					fclose(fptr);
					unlink(ERROR_FILE);
				}
			}
		}
		else if(!strcmp(status,STATUS_EMPTY)){
			FILE *fptr;
			char buf[BUF_SIZE];
			fptr=fopen(ERROR_FILE,"r");
			if(fptr==NULL){
				GetPrivateProfileString(DVD_SECTION,"Burn Flag","0",buf,sizeof(buf),DVD_CONFIG);
				if(!strncmp(buf,"1",1)){
					fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR30)</script>");
				}
				if(!strncmp(buf,"0",1)){
					fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR32)</script>");
				}
			}
//				fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR29)</script>");
			else{
				fgets(buf,sizeof(buf),fptr);
				if(!strncmp(buf,"0",1)){
					fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR35)</script>");
					fclose(fptr);
					unlink(ERROR_FILE);
				}
				else{
					char error_ret[BUF_SIZE],check1[BUF_SIZE],check2[BUF_SIZE],check3[BUF_SIZE],check4[BUF_SIZE],check5[BUF_SIZE];
					
					fptr=fopen(ERROR_FILE,"r");
					fgets(error_ret,sizeof(error_ret),fptr);
					sprintf(check1,"%d",E_OUTSPACE);
					sprintf(check2,"%d",E_CD_CLOSED);
					sprintf(check3,"%d",E_DIR_NOT_EXIST);
					sprintf(check4,"%d",E_USER_STOP);
					sprintf(check5,"%d",E_CD_BURNING);
					if(strstr(error_ret,check1)){
						system("/sbin/write_log \"Selected data size over media size.\" 1");
						fprintf(fp,"<font color=\"red\"><script language=\"JavaScript\">document.write(MISC_DVD_ERROR_MSG251)</script></font>");
					}
				        else if(strstr(error_ret,check2)){
						system("/sbin/write_log \"Burned media has closed.\" 1");
						fprintf(fp,"<font color=\"red\"><script language=\"JavaScript\">document.write(MISC_DVD_ERROR_MSG253)</script></font>");
					}
					else if(strstr(error_ret,check3)){
						system("/sbin/write_log \"Backup directory is not exist.\" 1");
						fprintf(fp,"<font color=\"red\"><script language=\"JavaScript\">document.write(MISC_DVD_ERROR_MSG254)</script></font>");
					}
					else if(strstr(error_ret,check4)){
						fprintf(fp,"<font color=\"red\"><script language=\"JavaScript\">document.write(MISC_DVD_ERROR_MSG258)</script></font>");
					}
					else if(strstr(error_ret,check5)){
						system("/sbin/write_log \"CD Burning fail.\" 1");
						fprintf(fp,"<font color=\"red\"><script language=\"JavaScript\">document.write(MISC_DVD_ERROR_MSG259)</script></font>");
					}
					fclose(fptr);
					unlink(ERROR_FILE);
				}

				WritePrivateProfileString(DVD_SECTION,"Burn Flag","0",DVD_CONFIG);
			}
		}
		else if(!strcmp(status,STATUS_ERASING)){
			char med_type[1024];
			GetPrivateProfileString(DVD_SECTION,DVD_MED_FIELD,"",med_type,sizeof(med_type),DVD_CONFIG);
			if(!strcmp(med_type,"CD-RW")){
				DVD_Get_Burning_Process(OUTLOG,burning_process);
                        	if(strstr(burning_process,"Blanking"))
			        	fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR24)</script>");
		                else if(strchr(burning_process,'%') || strstr(burning_process,"Writing")){
					if(strstr(burning_process,"100.00%")==NULL){
						if(strstr(med_ty,"CD-R") && !strstr(burning_process,"Writing"))
						fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR25)</script> %s",burning_process);
						else if(strstr(burning_process,"Writing"))
							fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR26)</script> %s",burning_process+23);

						else{
							fprintf(fp,"%s",burning_process);
						}
					}
					else{
						fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR38)</script>");
		                        }
				}
				else
					fprintf(fp,"%s","<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR30)</script>");	
			}
			else
				fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR37)</script>");
		}
		else if(!strcmp(status,STATUS_COPYING)){
			fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR32)</script>");
		}
	}

	else if(!strcmp(str,"btn_eject")){
		DVD_Get_Status(status);
		if(!strcmp(status,STATUS_BURNING)||!strcmp(status,STATUS_COPYING)||!strcmp(status,STATUS_ERASING))
			fprintf(fp,"disabled=\"true\"");
	}
	else if(!strcmp(str,"btn_refresh")){
//		DVD_Get_Status(status);
//		if(!strcmp(status,STATUS_BURNING)||!strcmp(status,STATUS_READY))
//			;
//		else
//			fprintf(fp,"disabled=\"true\"");
	}

	else if(!strcmp(str,"label_name")){
		char label_buf[BUF_SIZE];
		int ret=0;
		DVD_Get_Status(status);
		if(!strcmp(status,STATUS_READY)){
			ret=get_media_label(label_buf, dev_no);
			
			if(ret==SUCCESS){
				WritePrivateProfileString(DVD_SECTION,"Media Label",label_buf,DVD_CONFIG);
				fprintf(fp,"%s",label_buf);
			}
			else
				WritePrivateProfileString(DVD_SECTION,"Media Label","",DVD_CONFIG);
				
		}
		else if(!strcmp(status,STATUS_COPYING)){
			GetPrivateProfileString(DVD_SECTION,"Media Label","",label_buf,sizeof(label_buf),DVD_CONFIG);
			fprintf(fp,"%s",label_buf);
		}
		else 
			;
	}

	else if(!strcmp(str,"coping_status")){
		char buf[BUF_SIZE];
		FILE *fptr;
		DVD_Get_Status(status);
		fptr=fopen(LERROR_FILE,"r");
		if(fptr==NULL){
			if(strcmp(status,STATUS_COPYING)){
				fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR32)</script>");
			}
			else{
				DVD_Get_Copy_Status(buf);
				if(!strncmp(buf,"Initialize",10))
					fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR30)</script>");
				else if(!strstr(buf,"%"))
					fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR30)</script>");
				else 
					fprintf(fp,"%s",buf);
				if(strstr(buf,"100.00%")){
					unlink("/home/httpd/cgi-bin/misc/coping");
				}
			}
		}
		else{
			 fgets(buf,sizeof(buf),fptr);
			 if(!strncmp(buf,"0",1)){
			 	fprintf(fp,"<script language=\"JavaScript\">document.write(MISC_DVD_BACKUP_STR35)</script>");
				system("/sbin/write_log \"Load data from CD/DVD media finish succesfully.\" 4");
			 }
			 else if(!strncmp(buf,"9",1)){
				 fprintf(fp,"<font color=\"red\"><script language=\"JavaScript\">document.write(MISC_DVD_ERROR_MSG258)</script></font>");
			 }
			 else
			 	fprintf(fp,"<font color=\"red\"><script language=\"JavaScript\">document.write(MISC_DVD_ERROR_MSG260)</script></font>..");
			 unlink(LERROR_FILE);
		}
		//fclose(fptr);
	}

	else if(!strcmp(str,"dest_path")){
		char path_buf[BUF_SIZE];
		DVD_Get_Status(status);
		if(!strcmp(status,STATUS_COPYING)){
			GetPrivateProfileString(DVD_SECTION,DVD_LOAD_PATH_FIELD,"",path_buf,sizeof(path_buf),DVD_CONFIG);
			fprintf(fp,"%s",path_buf);
		}
	}	

	else if(!strcmp(str,"load_able")){
		DVD_Get_Status(status);
		if(strcmp(status,STATUS_COPYING)){
			if(!strcmp(status,STATUS_EMPTY)||!strcmp(status,STATUS_BURNING)||!strcmp(status,STATUS_ERASING))
				fprintf(fp,"disabled=\"true\"");
			else
				;
		}
		else{
			fprintf(fp,"disabled=\"true\"");
		}
		
	}

	else if(!strcmp(str,"stop_load_able")){
		DVD_Get_Status(status);
                if(strcmp(status,STATUS_COPYING))
                        fprintf(fp,"disabled=\"true\"");
                else
                	;
	}
	else if(!strcmp(str,"overwrite_checked")){
		char buf[BUF_SIZE];
		GetPrivateProfileString(DVD_SECTION,"Load Type","overwrite",buf,sizeof(buf),DVD_CONFIG);
		if(!strcmp(buf,""))
			strcpy(buf,"overwrite");
		if(!strcmp(buf,"overwrite"))
			fprintf(fp,"checked");
		else
			;
	}
	else if(!strcmp(str,"skip_checked")){
		char buf[BUF_SIZE];
		GetPrivateProfileString(DVD_SECTION,"Load Type","overwrite",buf,sizeof(buf),DVD_CONFIG);
		if(!strcmp(buf,"skip"))
			fprintf(fp,"checked");
		else
			;
	}
	
	else
		return CGI_REPLACE_FAIL;
	return CGI_REPLACE_OK;
}


int do_dvd_backup_main_submit(INPUT *input, int select)
{
	int btn = MISC_BTN_UNKNOWN, ret = 0;
	switch(btn = get_btn(input)){
		case MISC_BTN_DETECT:
			ret = do_dvd_backup_detect(input,select);
			return ret;
		case MISC_BTN_EJECT:
			ret = do_dvd_backup_eject(input,select);
			return ret;
		case MISC_BTN_BURN:
			ret = do_dvd_backup_burn(input,select);
		
			return ret;
		case MISC_BTN_BN_REFRESH:
			ret = do_dvd_backup_refresh(input,select,NO_CD);
			return ret;
		case MISC_BTN_ERASE:
			ret = do_dvd_backup_erase(input,select);
			return ret;
		case MISC_BTN_BN_CANCEL:
			ret = do_dvd_backup_cancel(input,select);
			return ret;
		case MISC_BTN_LOAD:
			ret = do_dvd_backup_load(input,select);
			return ret;
		case MISC_BTN_STOP_LOAD:
			ret = do_dvd_backup_stopload(input,select);
			return ret;
	}
	return MISC_SUCCESS;
}

int do_dvd_backup_detect(INPUT *input,int select)
{
	int ret;
	char speed[BUF_SIZE],cmd[BUF_SIZE],status[BUF_SIZE];
	
	for(dev_no=0;dev_no<DEV_COUNT;dev_no++)
        {
                if(DVD_Is_Device_Exist(dev_no)==SUCCESS){
                        DVD_Get_Device_Info(&dev,dev_no);
                        dev_ret=SUCCESS;
			WritePrivateProfileString(DVD_SECTION,DVD_DEV_FIELD,dev.dev_type,DVD_CONFIG);		
                        break;
                }
                else{
                        dev_ret=E_DVD_DEVICE;
			WritePrivateProfileString(DVD_SECTION,DVD_DEV_FIELD,"",DVD_CONFIG);
		}
        }

	DVD_Get_Status(status);

	if(!strcmp(status,STATUS_BURNING))
		med_ret=DVD_Get_Media_Info(&media,dev_no,NO_CD);

	else{
		sprintf(cmd,"%s -t %s",CMD_EJECT,USB_DEV[dev_no]);
        	system(cmd);

	
	        if((med_ret=DVD_Get_Media_Info(&media,dev_no,CD))==SUCCESS)
        	        ;
	        else        
		        med_ret=E_DVD_MEDIA;
	}
	WritePrivateProfileString(DVD_SECTION,DVD_MED_FIELD,MED_TYPE[media.type],DVD_CONFIG);
	sprintf(speed,"%d",(int)media.speed);
	WritePrivateProfileString(DVD_SECTION,DVD_SPEED_FIELD,speed,DVD_CONFIG);

	show_misc_header(input, select);
        CGI_Output_Html(DVD_BACKUP_MAIN_HTML, "$",dvd_backup_replace);
        show_misc_tail();
        ret=dev_ret;


	return 0;
}

int do_dvd_backup_eject(INPUT *input,int select)
{
	int ret;
	for(dev_no=0;dev_no<DEV_COUNT;dev_no++)
        {
                if(DVD_Is_Device_Exist(dev_no)==SUCCESS){
                        DVD_Get_Device_Info(&dev,dev_no);
                        dev_ret=SUCCESS;
                        break;
                }
                else
                        dev_ret=E_DVD_DEVICE;
        }

	ret=DVD_Eject_Rom(dev_no);
	med_ret=E_DVD_MEDIA;
	show_misc_header(input, select);
        CGI_Output_Html(DVD_BACKUP_MAIN_HTML, "$",dvd_backup_replace);
        show_misc_tail();
	return ret;
}

int do_dvd_backup_burn(INPUT *input,int select)
{
	INPUT *tmp =NULL;
	pid_t	pid;
	FILE *fp;
	int ret=0;
	char label[BUF_SIZE],path[BUF_SIZE],buf[BUF_SIZE],speed[BUF_SIZE],status[BUF_SIZE],dn[BUF_SIZE];
	char med_type[BUF_SIZE];
	fp=fopen(OUTLOG,"w+");	
	fclose(fp);
	sprintf(dn,"%d",dev_no);
	WritePrivateProfileString(DVD_SECTION,DVD_DEV_NO_FIELD,dn,DVD_CONFIG);
	if((tmp = CGI_Find_Parameter(input,"DiskLabel"))){
		strcpy(label,tmp->val);
		WritePrivateProfileString(DVD_SECTION,DVD_LABEL_FIELD,label,DVD_CONFIG);
	}

	if((tmp = CGI_Find_Parameter(input,"dvd_vol"))){
		WritePrivateProfileString(DVD_SECTION,"Volume",tmp->val,DVD_CONFIG);
		GetPrivateProfileString(tmp->val,"path","",buf,sizeof(buf),SAMBA_CONF_PATH);     
	}	
	if((tmp = CGI_Find_Parameter(input,"dvd_path"))){
		sprintf(path,"/%s=%s/%s\n" ,tmp->val,buf,tmp->val);
		WritePrivateProfileString(DVD_SECTION,DVD_SOURCE_PATH_FIELD,tmp->val,DVD_CONFIG);
		WritePrivateProfileString(DVD_SECTION,DVD_BPATH,path,DVD_CONFIG);
	}
	
	if((tmp = CGI_Find_Parameter(input, "speed"))){
		strcpy(speed,tmp->val);
		WritePrivateProfileString(DVD_SECTION,DVD_SPEED_FIELD,speed,DVD_CONFIG);
		//printf("speed = %s",speed);
	}
//	if(!strcmp(label,""))
//		return MISC_DVD_LABEL_EMPTY;	
//	if(strstr(label," "))
//		return MISC_DVD_LABEL_HAS_BLANK;
	
	GetPrivateProfileString(DVD_SECTION,DVD_MED_FIELD,"",med_type,sizeof(med_type),DVD_CONFIG);
	DVD_Get_Status(status);
	if(!strcmp(status,STATUS_READY) && !strstr(med_type,"CD-R")){
		pid=fork();
		if (pid < 0){
			exit(0);
		}
		if (pid == 0) { //child
			int ret=0;
			char label[BUF_SIZE],speed[BUF_SIZE],DEV_NO[BUF_SIZE],bpath[BUF_SIZE];
			close(0);
			close(1);
			close(2);

			GetPrivateProfileString(DVD_SECTION,DVD_LABEL_FIELD,"",label,sizeof(label),DVD_CONFIG);
			GetPrivateProfileString(DVD_SECTION,DVD_SPEED_FIELD,"",speed,sizeof(speed),DVD_CONFIG);
			GetPrivateProfileString(DVD_SECTION,DVD_BPATH,"",bpath,sizeof(bpath),DVD_CONFIG);
			GetPrivateProfileString(DVD_SECTION,DVD_DEV_NO_FIELD,"0",DEV_NO,sizeof(DEV_NO),DVD_CONFIG);	
			WritePrivateProfileString("Dvd","Status","Burning","/etc/config/dvd.conf");
			WritePrivateProfileString("Dvd","Burn Flag","1","/etc/config/dvd.conf");
//			system("/bin/kill -USR2 `/sbin/pidof /home/httpd/cgi-bin/misc/burn_sig`");
			ret=DVD_Burn_DVD(label,atoi(speed),atoi(DEV_NO),bpath);
			DVD_Eject_Rom(dev_no);
			
			if(ret!=0){	// not fixed issue : don't know the return value 9
                                fp=fopen(ERROR_FILE,"w+");
                                fprintf(fp,"%d\n",ret);
				fclose(fp);
				WritePrivateProfileString("Dvd","Status","Empty","/etc/config/dvd.conf");
                        	DVD_Clear_Conf();
				exit(ret);
                        }
			else{
				fp=fopen(ERROR_FILE,"w+");
				fprintf(fp,"0\n");
				fclose(fp);
				DVD_Eject_Rom(dev_no);
				WritePrivateProfileString("Dvd","Status","Empty","/etc/config/dvd.conf");
				DVD_Clear_Conf();
				system("/bin/kill -USR2 `/sbin/pidof /sbin/burn_cd`");
				exit(ret);
			}
			DVD_Set_Status(STATUS_EMPTY);
		}
		else{
//			if(fp=fopen(ERROR_FILE,"r")==NULL)
//				system("/sbin/write_log \"Write data\" 4");
			ret = do_dvd_backup_refresh(input,select,NO_CD);
		}
	}
	else if(strstr(med_type,"CD-R")){
//		close(0);
//		close(1);
//		close(2);
//		WritePrivateProfileString("Dvd","Status","Burning","/etc/config/dvd.conf");
		WritePrivateProfileString(DVD_SECTION,DVD_STATUS_FIELD,STATUS_BURNING,DVD_CONFIG);
		WritePrivateProfileString(DVD_SECTION,"Burn Flag","1",DVD_CONFIG);
		system("/bin/kill -USR1 `/sbin/pidof /sbin/burn_cd`");
		//WritePrivateProfileString("Dvd","Status","Empty","/etc/dvd.conf");
		//DVD_Clear_Conf();
		ret=do_dvd_backup_refresh(input,select,NO_CD);
	}
	else 
		ret = MISC_DVD_NO_DISC;
	return ret;
}
int do_dvd_backup_refresh(INPUT *input, int select,int isCD)
{
	int ret;
	FILE *fptr;
	char disklabel[BUF_SIZE],dpath[BUF_SIZE],error_ret[BUF_SIZE],check1[BUF_SIZE],check2[BUF_SIZE],check3[BUF_SIZE],check4[BUF_SIZE];
	char status[BUF_SIZE],cmd[BUF_SIZE];


	DVD_Get_Status(status);
	if(!strcmp(status,STATUS_COPYING)){
		med_ret = SUCCESS;
		dev_ret = SUCCESS;
	}
	else if(!strcmp(status,STATUS_READY)){
		for(dev_no=0;dev_no<DEV_COUNT;dev_no++)
		{
			if(DVD_Is_Device_Exist(dev_no)==SUCCESS){
				DVD_Get_Device_Info(&dev,dev_no);
				dev_ret=SUCCESS;
				WritePrivateProfileString(DVD_SECTION,DVD_DEV_FIELD,dev.dev_type,DVD_CONFIG);
				break;
			}
			else{
				dev_ret=E_DVD_DEVICE;
				WritePrivateProfileString(DVD_SECTION,DVD_DEV_FIELD,"",DVD_CONFIG);
			}
		}
//		sprintf(cmd,"%s -t %s", CMD_EJECT,USB_DEV[dev_no]);
		//printf("cmd=%s",cmd);
		system(cmd);
//		if((med_ret=DVD_Get_Media_Info(&media,dev_no,CD))==SUCCESS)
//                	;
//        	else
//                	med_ret=E_DVD_MEDIA;
	}	
//	else if(!strcmp(status,STATUS_EMPTY))
//		med_ret = E_DVD_MEDIA;
//	else
//		med_ret = SUCCESS;

	
	GetPrivateProfileString(DVD_SECTION,DVD_LABEL_FIELD,"",disklabel,sizeof(disklabel),DVD_CONFIG);
	GetPrivateProfileString(DVD_SECTION,DVD_SOURCE_PATH_FIELD,"",dpath,sizeof(dpath),DVD_CONFIG);

//        show_misc_header(input, select);
//        CGI_Output_Html(DVD_BACKUP_MAIN_HTML, "$",dvd_backup_replace);
//        show_misc_tail();
	ret=dev_ret;
	fptr=fopen(ERROR_FILE,"r");
	if(fptr!=NULL){
		fgets(error_ret,sizeof(error_ret),fptr);
		sprintf(check1,"%d",E_OUTSPACE);
		sprintf(check2,"%d",E_CD_CLOSED);
		sprintf(check3,"%d",E_DIR_NOT_EXIST);
		sprintf(check4,"%d",E_OUT_DISK_SIZE);
		if(strstr(error_ret,check1)){
//			system("/sbin/write_log \"Selected data size over media size.\" 1");
		}
		else if(strstr(error_ret,check2)){
//			system("/sbin/write_log \"Burned media has closed.\" 1");
		}
		else if(strstr(error_ret,check3)){
//			system("/sbin/write_log \"Backup directory is not exist.\" 1");
		}
		else if(strstr(error_ret,check4)){
//			system("/sbin/write_log \"The destination of disk has no space.\" 1");
		}
		else
			ret=atoi(error_ret);
		fclose(fptr);
	}
	
	show_misc_header(input, select);
	CGI_Output_Html(DVD_BACKUP_MAIN_HTML, "$",dvd_backup_replace);
	show_misc_tail();
	ret=SUCCESS;
	
	return ret;
}	

int do_dvd_backup_erase(INPUT *input, int select)
{
	int ret=0;
	char med_type[1024],status[1024];
	pid_t pid;
	GetPrivateProfileString(DVD_SECTION,DVD_MED_FIELD,"",med_type,sizeof(med_type),DVD_CONFIG);
	DVD_Get_Status(status);

	if(!strcmp(status,STATUS_READY) && !strstr(med_type,"CD-R")){
		pid=fork();
		if(pid==0){
			FILE *fptr;
			ret = DVD_Erase_Rom(dev_no);
			DVD_Eject_Rom(dev_no);
			fptr=fopen(ERROR_FILE,"w+");
			fprintf(fptr,"0");
			fclose(fptr);
			exit(0);
		}
		do_dvd_backup_refresh(input,select,NO_CD);
	}
	else if(strstr(med_type,"CD-R")){
		char label[BUF_SIZE],path[BUF_SIZE],buf[BUF_SIZE],speed[BUF_SIZE],dn[BUF_SIZE];
		FILE *fp;
		INPUT *tmp =NULL;
		fp=fopen(OUTLOG,"w+");
		fclose(fp);
		sprintf(dn,"%d",dev_no);
		WritePrivateProfileString(DVD_SECTION,DVD_DEV_NO_FIELD,dn,DVD_CONFIG);
		if((tmp = CGI_Find_Parameter(input,"DiskLabel"))){
			strcpy(label,tmp->val);
			WritePrivateProfileString(DVD_SECTION,DVD_LABEL_FIELD,label,DVD_CONFIG);
		}
	        if((tmp = CGI_Find_Parameter(input,"dvd_vol"))){
		        WritePrivateProfileString(DVD_SECTION,"Volume",tmp->val,DVD_CONFIG);
		        GetPrivateProfileString(tmp->val,"path","",buf,sizeof(buf),SAMBA_CONF_PATH);
		}
		if((tmp = CGI_Find_Parameter(input,"dvd_path"))){
			sprintf(path,"/%s=%s/%s\n" ,tmp->val,buf,tmp->val);
			WritePrivateProfileString(DVD_SECTION,DVD_SOURCE_PATH_FIELD,tmp->val,DVD_CONFIG);
			WritePrivateProfileString(DVD_SECTION,DVD_BPATH,path,DVD_CONFIG);
		}
	    	if((tmp = CGI_Find_Parameter(input, "speed"))){
			strcpy(speed,tmp->val);
			WritePrivateProfileString(DVD_SECTION,DVD_SPEED_FIELD,speed,DVD_CONFIG);
			//printf("speed = %s",speed);
		}
		
		WritePrivateProfileString(DVD_SECTION,DVD_STATUS_FIELD,STATUS_ERASING,DVD_CONFIG);
                WritePrivateProfileString(DVD_SECTION,"Burn Flag","1",DVD_CONFIG);
	        system("/bin/kill -USR1 `/sbin/pidof /sbin/burn_cd`");
		ret=do_dvd_backup_refresh(input,select,NO_CD);	
	}
	return ret;
}

int do_dvd_backup_load(INPUT *input, int select)
{
	int ret;
	int codepage;
	INPUT *tmp = NULL;
	char buf[BUF_SIZE],path[1024],cmd[1024],path_tmp[1024];
	pid_t pid;
	FILE *fptr;
	DIR *dp=opendir("/mnt/cdrom");
        fptr=fopen("/home/httpd/cgi-bin/misc/load_process_log","w+");
	fclose(fptr);
	if(dp==NULL)
        {
                ret = system("mkdir /mnt/cdrom");
        }
	
	codepage = Get_System_Codepage();
	if(codepage==999)
		sprintf(cmd, "mount -t udf -o utf8 %s %s",USB_DEV[dev_no],"/mnt/cdrom");
	else
		sprintf(cmd, "mount -t udf -o iocharset=cp%d %s %s",codepage,USB_DEV[dev_no],"/mnt/cdrom");
//	sprintf(cmd, "mount -t iso9660 -o %s %s",USB_DEV[dev_no],"/mnt/cdrom");
	ret=system(cmd);
	if(ret!=0){
		if(codepage==999)
			sprintf(cmd, "mount -t iso9660 -o utf8 %s %s", USB_DEV[dev_no], "/mnt/cdrom");
		else
			sprintf(cmd, "mount -t iso9660 -o iocharset=cp%d %s %s",codepage,USB_DEV[dev_no],"/mnt/cdrom");
		ret=system(cmd);
	}
	if((tmp = CGI_Find_Parameter(input, "load_vol"))){
		WritePrivateProfileString(DVD_SECTION,DVD_VOL_FIELD,tmp->val,DVD_CONFIG);
		GetPrivateProfileString(tmp->val,"path","",buf,sizeof(buf),SAMBA_CONF_PATH);
	}
	if((tmp = CGI_Find_Parameter(input, "load_path"))){
		sprintf(path_tmp,"%s/%s/",buf,tmp->val);
		WritePrivateProfileString(DVD_SECTION,DVD_LOAD_PATH_FIELD,tmp->val,DVD_CONFIG);
	}
	translate(path_tmp,path);
	system("/sbin/write_log \"Start to load data from CD/DVD media.\" 4");
	if((tmp = CGI_Find_Parameter(input, "load_type"))){
		if(!strcmp(tmp->val, "overwrite")){
			WritePrivateProfileString(DVD_SECTION,"Load Type","overwrite",DVD_CONFIG);
			pid = fork();
			if(pid<0){
				exit(0);
			}
			if(pid==0){
				close(0);
				close(1);
				close(2);
				DVD_Set_Status(STATUS_COPYING);
				sprintf(cmd,"/sbin/load_dvd /mnt/cdrom %s %d",path,OVERWRITE_MODE);
				system(cmd);
				DVD_Set_Status(STATUS_EMPTY);
				fptr=fopen(LERROR_FILE,"w+");
				fprintf(fptr,"0");
				fclose(fptr);
				//DVD_Load_Data("/mnt/cdrom",path,OVERWRITE_MODE);
				system("umount /mnt/cdrom");
				DVD_Clear_Conf();
		//		unlink("/home/httpd/cgi-bin/misc/coping");
				exit(0);	
			}
			
			//do_dvd_backup_refresh(input,select,NO_CD);
		}
		else
		if(!strcmp(tmp->val, "skip")){
			WritePrivateProfileString(DVD_SECTION,"Load Type","skip",DVD_CONFIG);
			pid = fork();
                        if(pid<0){
				exit(0);
			}
			if(pid==0){
                                close(0);
                                close(1);
                                close(2);
				DVD_Set_Status(STATUS_COPYING);
				sprintf(cmd,"/sbin/load_dvd /mnt/cdrom %s %d",path,SKIP_MODE);
                                system(cmd);
				DVD_Set_Status(STATUS_EMPTY);
				fptr=fopen(LERROR_FILE,"w+");
				fprintf(fptr,"0");
				fclose(fptr);
                                //DVD_Load_Data("/mnt/cdrom",path,SKIP_MODE);
				system("umount /mnt/cdrom");
				DVD_Clear_Conf();
				exit(0);
                        }
			//do_dvd_backup_refresh(input,select,NO_CD);
		}
	}

	//printf("ret=%d\n",ret);
	//ret = do_dvd_backup_refresh(input,select,NO_CD);
	show_misc_header(input, select);
	CGI_Output_Html(DVD_BACKUP_MAIN_HTML, "$",dvd_backup_replace);
	show_misc_tail();
	ret=SUCCESS;
	
	return ret;
}

int do_dvd_backup_cancel(INPUT *input,int select)
{
	FILE *fptr;
	//char buf[BUF_SIZE],cmd[CMD_LENGTH];
	//int ret = system("/root/nas/lib/config/tt");
	
	int ret = system("/bin/kill -9 `/sbin/pidof /usr/bin/growisofs`");
	ret = system("/bin/kill -9 `/sbin/pidof /usr/bin/cdrecord`");
	ret = system("/bin/kill -9 `/sbin/pidof /usr/bin/mkisofs`");
	ret = system("/bin/kill -9 `/sbin/pidof /usr/bin/cdrecord`");
	ret = system("/bin/kill -9 `/sbin/pidof /sbin/burn_cd`");
	ret = system("/sbin/write_log \"User stop writing.\" 4");
	ret = system("/sbin/daemon_mgr /sbin/burn_cd");
	fptr=fopen(OUTLOG,"w+");
	fclose(fptr);
	fptr=fopen(ERROR_FILE,"w+");
	fprintf(fptr,"9");
	fclose(fptr);
	
	/*fptr = fopen("log","r");
	fgets(buf,BUF_SIZE,fptr);
	sprintf(cmd,"kill -9 %s",buf);
	ret = system(cmd);*/
	sleep(1);
	DVD_Clear_Conf();
	do_dvd_backup_eject(input,select);
	//do_dvd_backup_main(input,select);
	return 0;
}


int do_dvd_backup_stopload(INPUT *input, int select)
{
	int ret = system("/bin/kill -9 `/sbin/pidof /sbin/load_dvd`");
	FILE *fptr;
	ret = system("/sbin/write_log \"User stop loading.\" 4");
	DVD_Set_Status(STATUS_EMPTY);
	DVD_Eject_Rom(dev_no);
	DVD_Clear_Conf();
	fptr=fopen(LERROR_FILE,"w+");
	fprintf(fptr,"%d",E_USER_STOP);
	fclose(fptr);
	ret=do_dvd_backup_refresh(input,select,CD);
	return ret;
}

int do_dvd_backup_main(INPUT *input, int select)
{
//	INPUT *tmp = NULL;
//	char disklabel[BUF_SIZE],dpath[BUF_SIZE];
//	char status[BUF_SIZE];
//	DIR *dir;
	FILE *fp;
//	if((dir=opendir(DVD_CONFIG))==NULL)
//	{
	fp=fopen(DVD_CONFIG,"a+");
	fclose(fp);
//	}
	fp=fopen(PROCESS_LOG,"a+");
	fclose(fp);
	do_dvd_backup_refresh(input,select,CD);
/*	
	fp=fopen("/home/httpd/cgi-bin/misc/coping","r");
	
	for(dev_no=0;dev_no<DEV_COUNT;dev_no++)
	{
		if(DVD_Is_Device_Exist(dev_no)==SUCCESS){
			DVD_Get_Device_Info(&dev,dev_no);
			dev_ret=SUCCESS;
			WritePrivateProfileString(DVD_SECTION,DVD_DEV_FIELD,dev.dev_type,DVD_CONFIG);
			break;
		}
		else
			dev_ret=E_DVD_DEVICE;
	}
	DVD_Get_Status(status);
	if(strcmp(status,STATUS_BURNING) && fp==NULL){
		if((med_ret=DVD_Get_Media_Info(&media,dev_no,NO_CD))==SUCCESS)
			;
		else
			med_ret=E_DVD_MEDIA;
	}
	else{
		if(fp!=NULL)
			fclose(fp);
		med_ret=SUCCESS;
	}
	

	show_misc_header(input, select);
	CGI_Output_Html(DVD_BACKUP_MAIN_HTML, "$",dvd_backup_replace);
	show_misc_tail();*/
	return MISC_SUCCESS;
}
