#include <stdio.h>
#include <string.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>
#include <qnap_pic_user.h>

/* local include */
#include "hwtest.h"
#include "hwtest02.h"
#include "hwtest03.h"

int hwtest02_replace(FILE *fptr, char *name, void *arg)
{
	//char buf[64];

	if (!strcmp(name, "hwtest_usbled"))
	{
		Pic_Send_Raw_Cmd(QNAP_PIC_USB_LED_BLINK);
		fprintf(fptr,   "<form><input type=\"radio\" name=\"usb\" value=\"fail\" checked >FAIL <input type=\"radio\" name=\"usb\" value=\"ok\" checked >OK");
	}
	else
	if (!strcmp(name, "hwtest_statusled"))
	{
		Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_BOTH_BLINK);
		fprintf(fptr,   "<form><input type=\"radio\" name=\"status\" value=\"fail\" checked >FAIL <input type=\"radio\" name=\"status\" value=\"ok\" checked >OK");
	}
	else
	if (!strcmp(name, "hwtest_powerled"))
	{
		Pic_Send_Raw_Cmd(QNAP_PIC_POWER_LED_BLINK);
		fprintf(fptr,   "<form><input type=\"radio\" name=\"power\" value=\"fail\" checked >FAIL <input type=\"radio\" name=\"power\" value=\"ok\" checked >OK");
	}
	else
        	return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int do_hwtest02_main(INPUT *input)
{
	/* put your code here */
	CGI_Output_Html1(HWTEST02_MAIN_HTML, "$", hwtest02_replace, NULL);
	return HWTEST_SUCCESS;
}

int do_hwtest02_main_submit(INPUT *input)
{
	int	btn;
	int	ret=HWTEST_SUCCESS;
	INPUT   *buf = NULL;

	btn=get_btn(input);
	switch (btn)
	{
		case HWTEST_BTN_NEXT:
			/* put your "next button" code here */
			buf = CGI_Find_Parameter(input, "usb");
			if(!strcmp(buf->val, "ok"))
                        	Set_Private_Profile_String("Test Result", "USBLED", "ok", RESULT_FILE);
                        //      printf("%s",buf->val);
			else
				Set_Private_Profile_String("Test Result", "USBLED", "<font color=\"red\">fail</font>", RESULT_FILE);
                        buf = CGI_Find_Parameter(input, "status");
			if(!strcmp(buf->val, "ok"))
                        	Set_Private_Profile_String("Test Result", "StatusLED", "ok", RESULT_FILE);
			else
				Set_Private_Profile_String("Test Result", "StatusLED", "<font color=\"red\">fail</font>", RESULT_FILE);
                        //      printf("%s",buf->val);
                        buf = CGI_Find_Parameter(input, "power");
			if(!strcmp(buf->val, "ok"))
                        	Set_Private_Profile_String("Test Result", "PowerLED", "ok", RESULT_FILE);
			else
				Set_Private_Profile_String("Test Result", "PowerLED", "<font color=\"red\">fail</font>", RESULT_FILE);
			Pic_Send_Raw_Cmd(QNAP_PIC_USB_LED_OFF);
			Pic_Send_Raw_Cmd(QNAP_PIC_STATUS_GREEN_BLINK);
			Pic_Send_Raw_Cmd(QNAP_PIC_POWER_LED_ON);
			do_hwtest03_main(input);
			break;
		case HWTEST_BTN_BACK:
			printf("press exit button");
			break;
		case HWTEST_BTN_REFLASH:
			do_hwtest02_main(input);
			break;
	}
	return ret;
}

