#include <stdio.h>
#include <pthread.h>
#include <time.h>

#include "file_lock.h"
#include "Util.h"
#include "NAS.h"
int	total=0;

void test_file_lock(int *max)
{
	int	i;

	for (i=0;i<*max;i++)
	{
		if (NAS_File_Lock("/etc/config/uLinux.conf", 'w'))
		{
			NAS_File_Unlock("/etc/config/uLinux.conf");
		}
		else
			fprintf(stderr, "file lock fail...\n");
	}
	total++;
}

void test_conf_set_field(int *max)
{
	int	i;
	char	buf[64];

	for (i=0;i<*max;i++)
	{
		if (Conf_Set_Field("/etc/config/uLinux.conf", "Backup NAS", "Support", "TRUE")!=SUCCESS)
			fprintf(stderr, "Conf_Set_Field fail...\n");
		if (Conf_Get_Field("/etc/config/uLinux.conf", "Backup NAS", "Support", buf, 64)!=SUCCESS)
			fprintf(stderr, "Conf_Get_Field fail...\n");
	}
	total++;
}

void test_samba_conf(int *max)
{
	int	i;
	char	buf[64];
	SECTION_INFO *share_list = NULL;

	for (i=0;i<*max;i++)
	{
		if ((Get_NAS_Share_List_Ex(&share_list))<=0)
			fprintf(stderr, "Get_NAS_Share_List_Ex fail...\n");
		if (share_list!=NULL)
		{
			Release_List(share_list);
			share_list=NULL;
		}
	}
	total++;
}

int main()
{
	pthread_t	thread[1024];
	int		i, cnt;
	int		start, end;
	int		type, times;

	printf("input test thread(max=500) : ");
	scanf("%d", &cnt);
	printf("input test times : ");
	scanf("%d", &times);
	printf("1.File_Lock, 2.Conf_Set_Field, 3.Samba_Conf : ");
	scanf("%d", &type);

	if (cnt>500)
		return 0;
	start=time(NULL);
	if (type==1)
		for (i=0;i<cnt;i++)
			pthread_create(&thread[i], NULL, (void *)&test_file_lock, &times);
	else
	if (type==2)
		for (i=0;i<cnt;i++)
			pthread_create(&thread[i], NULL, (void *)&test_conf_set_field, &times);
	else
	if (type==3)
		for (i=0;i<cnt;i++)
			pthread_create(&thread[i], NULL, (void *)&test_samba_conf, &times);
	while (total!=cnt);
	end=time(NULL);
	printf("total time = [%d] sec\n", end-start);
	return 1;
}

