/**************************************************************************
 *      Copyright (c) 2001  QNAP Systems Inc.  All Rights Reserved.
 *
 *      FILE:
 *              sata.c
 *
 *      Abstract:
 *              provide sata hard drive operation for user.
 *             
 *      HISTORY:
 *      	2005/1/? Ricky Cheng Self-test ok.
 *      	2005/1/3 Ricky Cheng Created.
 *     
 **************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include "uLinux.h"
#include "Util.h"
#include "storage.h"
#include "sata.h"

/**************************************************************************
 *	Is_Sata_Support
 *	Description:	check the model support SATA or not.
 *	Output :	TRUE -- success / FALSE -- failure
 * 	Ricky Cheng 	Jan.	2005
 **************************************************************************/

BOOL Is_Sata_Support(){
	char support[BUFFER];	
	GetProfileString(SZ_SYSTEM_SECTION,SATA_SUPPORT_FILED,"FALSE",support,sizeof(support));
	if(!strncmp(support,"TRUE",4))
		return TRUE;
	else
		return FALSE;
}

/**************************************************************************
 *	Is_Sata_HD_Changed
 *      Description:    Check the SATA Disk's status chenged or not?
 *      Output :        TRUE -- success / FALSE -- failure
 *      Ricky Cheng     Jan.    2005
 **************************************************************************/

BOOL Is_Sata_HD_Changed(){
	int fd, size;
	char buffer[BUFFER];
	if(fd!=ERROR_OPEN){
		fd=open(SATA_PROC,O_RDONLY);
		size = read(fd, buffer, sizeof(buffer));
		close(fd);
		if(buffer[0]!='0')
			return TRUE;
		else
			return FALSE;
	}
	else 
		return FALSE;
}

/**************************************************************************
 *	Is_Sata_HD_Exist
 *	Description:	check the hard drive exist or not?
 *	Input:		dev_name -- Device name;
 *	Output:		TRUE -- success / FALSE -- failure / ERROR_DEVICE -- No such device 
 *	Ricky Cheng	Jan.    2005
 **************************************************************************/
BOOL Is_Sata_HD_Exist(char *dev_name){
	int fd, size, idx;
	char buffer[BUFFER];

	if(fd!=ERROR_OPEN){
		for(idx=0;idx<HOST_NUM;idx++){
			if(sata_dev[idx][7]==dev_name[7])
				break;
		}
		if(idx>=HOST_NUM)
			return FALSE;
		fd=open(SATA_PROC,O_RDONLY);
		if(fd < 0)
			return FALSE;
		size = read(fd, buffer, sizeof(buffer));
		close(fd);

		if(((idx+1)*2)>=size)
			return FALSE;
		// Read 2,4,6,8 bit
		if(buffer[(idx+1)*2]=='1'){
			return TRUE;
		}
		else{
			return FALSE;
		}
	}
	else {
		return FALSE;
	}
	return TRUE;
}

BOOL Is_Sata_HD_Exist_ByNo(int no){
        int fd, size;
        char buffer[BUFFER];

        if(fd!=ERROR_OPEN){
                if(no>=HOST_NUM)
                        return FALSE;
                fd=open(SATA_PROC,O_RDONLY);
                if(fd < 0)
                        return FALSE;
                size = read(fd, buffer, sizeof(buffer));
                close(fd);
                if(((no)*2)>=size)
                        return FALSE;
                // Read 2,4,6,8 bit
                if(buffer[(no)*2]=='1'){
                        return TRUE;
                }
                else{
                        return FALSE;
                }

        }
        else
                return FALSE;
        return TRUE;

}

/**************************************************************************
 *	SATA_Exe_SCSI_Cmd
 *	Description:	Execute SCSI command for "add" and "remove".
 *	Input:		driveno  -- drive number.
 *			cmd_type -- command type ("add" or "remove")
 *	Output:		SUCCESS -- success / ERROR_CMD -- No such command.
 *	Ricky Cheng     Jan.    2005
 **************************************************************************/
int SATA_Exe_SCSI_Cmd(int driveno, char *cmd_type){
	char echo_cmd[CMD_LENGTH];
	sprintf(echo_cmd,"echo \"scsi %s-single-device %d 0 0 0\" > /proc/scsi/scsi", cmd_type, driveno);
	if(!system(echo_cmd))
		return SUCCESS;
	else
		return ERROR_CMD;
}

char *SATA_Get_Model_Name(){
	char buf[64];
        GetProfileString("System","Model","",buf,sizeof(buf));
        return strdup(buf);
}	

void init_scsi_status_file(int hdno)
{
        char tmpstr[HD_DEVICE_NAME_LENGTH], tmpfile[BUF_SIZE];
        int host, ch, id, lun, err, is_pluggable = 1;
        FILE *fptr = NULL;

        sprintf(tmpfile, "/tmp/Disk%d", hdno);
        if ((fptr = fopen(tmpfile, "w+")) == NULL) {
//                printf("%s %s -- fails to create a temp file for drive %d\n",
//                        __FILE__, __FUNCTION__, hdno);
                return;
        }
        if ((err = Get_Disk_Sg_Map(hdno, tmpstr, &host, &ch, &id, &lun)) < 0) {
//                printf("%s -- something wrong with drive %d, err = %d\n",
//                        __FUNCTION__, hdno, err);
                is_pluggable = 0;
                sprintf(tmpstr, "N/A");
                host = ch = id = lun = -1;
        }
        else {
//                printf("%s -- drive %d info : %s, %d, %d, %d, %d\n",
//                        __FUNCTION__, hdno, tmpstr, host, ch, id, lun);
        }

        fprintf(fptr, "Pluggable = %d\n", is_pluggable);
        fprintf(fptr, "Sg Map = %s\n", tmpstr);
        fprintf(fptr, "Host = %d\n", host);
        fprintf(fptr, "Channel = %d\n", ch);
        fprintf(fptr, "ID = %d\n", id);
        fprintf(fptr, "Lun = %d\n", lun);
        fclose(fptr);
}

void refresh_bus(){
	system("/bin/echo \"probe\" > /proc/scsi/SiI3512");
}

void umount_all(int drive_no){
        int i=1, ret=0;
        char dev[HD_DEVICE_NAME_LENGTH], device_name[HD_DEVICE_NAME_LENGTH];
        char cmd[128];

        ret = Get_HD_DevName(drive_no,device_name);

        for(;i<5;i++){
                sprintf(dev, "%s%d", device_name, i);
                sprintf(cmd, "/bin/umount %s 2>/dev/null 1>/dev/null", dev);
                system(cmd);
        }
}

void disk_opt(int drive_no, char *cmd_type){
        if(!strcmp(cmd_type, "remove"))
                umount_all(drive_no);
        refresh_bus();
        SATA_Exe_SCSI_Cmd(drive_no-1, cmd_type);
        init_scsi_status_file(drive_no);
}
