#ifndef __MSGENG_H__
#define __MSGENG_H__

//#include <linux/fs.h>
#include <linux/types.h>

#define MSGENG_DEV	"/dev/msgeng"

// define message id
enum {
	MSG_TIMER_EVENT,
	MSG_SET_TIMER,
	MSG_KILL_TIMER,
};

#define MAX_PROGNAME_SIZE		16
#define MAX_EXTRAMSG_SIZE		257

typedef struct tagMSG_PARM {
	char	comm[16];		// task name
	int	message;
	unsigned long	parm1, parm2;
	char	extra[MAX_EXTRAMSG_SIZE];		// additional information.
} MSG_PARM;

#define IOCTL_SIZE		sizeof(MSG_PARM)
#ifndef IOCTL_MSG_MAGIC
	#define IOCTL_MSG_MAGIC	'M'
#endif
#ifndef IOCTL_MSG_GET_MESSAGE
	#define IOCTL_MSG_GET_MESSAGE	_IOR(IOCTL_MSG_MAGIC, 0, IOCTL_SIZE)
#endif
#ifndef IOCTL_MSG_SEND_MESSAGE
	#define IOCTL_MSG_SEND_MESSAGE	_IOW(IOCTL_MSG_MAGIC, 1, IOCTL_SIZE)
#endif

#ifdef __KERNEL__
#include <asm/bitops.h>

#define MAX_MSGQUEUE	60
#define MAX_TIMER	60

typedef struct tagTIMER_STATUS {
	int		id;
	void		*pmsgdesc; // PMSG_DESC type
	int		interval;
	struct timer_list timer;
} TIMER_STATUS, *PTIMER_STATUS;

typedef struct tagMSG_DESC {
	pid_t			pid;
	// wake/sleep process
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 0)
	wait_queue_head_t	msg_wait;
#else
	struct wait_queue	*msg_wait;
#endif
	// protect the message queue from the other tasks access.
	struct semaphore	msg_semaphore;
	int			msgqueue_start, msgqueue_end;
	MSG_PARM		msg_queue[MAX_MSGQUEUE];
	unsigned long		timer_enable[2];
	TIMER_STATUS		timer_status[MAX_TIMER];
	struct tagMSG_DESC	*next;
} MSG_DESC, *PMSG_DESC;

#endif

#endif	// __MSGENG_H__
