//**************************************************************************
//
//	Copyright (c) 2002  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		mail_pop3.h
//
//	Abstract: 
//		mail_pop3 header file
//
//	HISTORY:
//		06/25/02	Tiger Fu created
//
//**************************************************************************
#ifndef	__MAIL_POP3__
#define	__MAIL_POP3__

#define	MAIL_POP3_FILE_ALREADY_EXIST		-401
#define MAIL_POP3_FILE_INITIAL_ERROR		-402
#define MAIL_POP3_FAIL_TO_OPEN			-403
#define	MAIL_POP3_FAIL_TO_WRITE			-404
#define MAIL_POP3_NO_SERVER			-405
#define	MAIL_POP3_INFO_WRONG_FORMAT		-406
#define	MAIL_POP3_FAIL_TO_OPEN_RC		-407
#define	MAIL_POP3_FAIL_TO_GET_MAIL		-408

#define	MAIL_POP3_SERVER_ALREADY_EXIST		-411
#define	MAIL_POP3_SERVER_NOT_EXIST		-412
#define MAIL_POP3_MODIFIED_ALREADY_EXIST	-413

//  fetchmail full path file name
#define	FETCHMAIL_FILE_NAME			"/usr/bin/fetchmail"
#define EXIT_CODE_RECORD_FILE			"/var/log/fetchmail_exit_code"

//  fetchmail exit code
#define FETCHMAIL_SUCCESS			0
#define	FETCHMAIL_NO_AWAIT_MSG			1
#define	FETCHMAIL_UNRECOVERABLE_ERROR		2
#define	FETCHMAIL_AUTHENTICATION_FAILED		3
#define	FETCHMAIL_FATAL_PROTOCOL_ERROR		4
#define	FETCHMAIL_INVALID_PARAMETER		5
#define	FETCHMAIL_BAD_PERMISSIONS		6
#define	FETCHMAIL_SERVER_ERROR			7
#define	FETCHMAIL_OTHER_INSTANCE_EXIST		8
#define	FETCHMAIL_AUTHENTICATION_LOCK		9
#define	FETCHMAIL_SMTP_ERROR			10
#define	FETCHMAIL_DNS_ERROR			11
#define	FETCHMAIL_BSMTP_BAT_OPEN_FAILED		12
#define	FETCHMAIL_UNKNOWN_ERROR			13
#define	FETCHMAIL_SERVER_BUSY			14
#define	FETCHMAIL_INTERNAL_ERROR		23

//  config file name
#define	POP3_CONFIG				"POP3_Config"
#define	SERVER_RC				"External_Account"

typedef	struct {
	char		server[128];		// remote server name
	char		user[32];		// user name
	char		passwd[16];		// password
	int		keep_message;		// keep message in remote server
	int		use_filter;		// whether received message use filter
	int		protocol;
	int		port;			// port number of remote server, default = 110
	char		folder[256];
}POP3_INFO, *pPOP3_INFO;

enum {AUTO, POP3, IMAP};

extern int	pop3_errno;

typedef struct POP3_Info_List {
	POP3_INFO pop3_info;
	struct POP3_Info_List * next;
} POP3_INFO_LIST, * pPOP3_INFO_LIST;

int Initial_POP3_Info_File (const char * owner, int force);
int Mail_Add_POP3_Server (const POP3_INFO * pop3_info, const char * owner);
int Mail_Del_POP3_Server (const POP3_INFO * pop3_info, const char * owner);
int Mail_Check_Pop3_Info_Exist (const char * server_name, const char * owner);
int Mail_Modify_POP3_Server (const POP3_INFO * old_info, const POP3_INFO * new_info, const char * owner);
POP3_INFO_LIST *Mail_Get_POP3_Server (const char * owner);
int MAIL_Free_POP3_Info (POP3_INFO_LIST * info_list);
int Create_Server_RC (const POP3_INFO_LIST * info_list, const char * owner);
int Mail_POP3_Get_Mail (const char * owner);

#endif
