//**************************************************************************
//
//	Copyright (c) 2002  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		mail_ab.h
//
//	Abstract: 
//		address book functions header file
//
//	FUNCTIONS:	
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		05/27/02	Tiger Fu created
//
//**************************************************************************
#ifndef	__MAIL_AB__
#define	__MAIL_AB__

#define	MAIL_ADDRESS_BOOK_ALREADY_EXIST		-210
#define	MAIL_ADDRESS_BOOK_NOT_EXIST		-211
#define	MAIL_AB_RECORD_ALREADY_EXIST		-212
#define	MAIL_AB_RECORD_NOT_EXIST		-213
#define	MAIL_AB_DELETE_RECORD_NOT_EXIST		-214
#define MAIL_AB_NO_RECORD			-215
#define	MAIL_AB_HEAD_BAD_FORMAT			-216
#define	MAIL_AB_INITIAL_ERROR			-217
#define	MAIL_AB_FAIL_TO_OPEN			-218
#define	MAIL_AB_FAIL_TO_WRITE			-219
#define	MAIL_AB_FAIL_TO_READ			-220
#define	MAIL_AB_UNKNOWN_FIELD			-221
#define	MAIL_FAIL_TO_SET_AB_HEADER		-222

#define	MAIL_GROUP_FILE_ALREADY_EXIST		-230  //  the group file already exist
#define MAIL_GROUP_FILE_NOT_EXIST		-231  //  the group file do not exist
#define	MAIL_GROUP_FILE_INITIAL_ERROR		-232
#define	MAIL_GROUP_FILE_FAIL_TO_OPEN		-233
#define	MAIL_GROUP_FILE_FAIL_TO_WRITE		-234
#define	MAIL_GROUP_FILE_FAIL_TO_READ		-235
#define	MAIL_GROUP_MODIFIED_ALREADY_EXIST	-236
#define	MAIL_GROUP_ALREADY_EXIST		-237  //  the group be created already exist
#define	MAIL_GROUP_NOT_EXIST			-238  //  the specify group do not exist
#define	MAIL_NO_GROUP				-239  //  no group in the group file
#define	MAIL_GROUP_NO_MEMBER			-240
#define	MAIL_GROUP_MEMBER_ALREADY_EXIST		-241
#define	MAIL_GROUP_MEMBER_NOT_EXIST		-242
#define MAIL_GROUP_HEAD_BAD_FORMAT		-243
#define MAIL_FAIL_TO_SET_GROUP_HEADER		-244

#define	MAIL_FAIL_TO_OPEN_EXPORT_FILE		-250
#define	MAIL_FAIL_TO_OPEN_IMPORT_FILE		MAIL_FAIL_TO_OPEN_EXPORT_FILE
#define	MAIL_SELECTED_COUNTRY_NOT_SUPPORT	-251
#define	MAIL_FAIL_TO_GET_IMPORT_FILE_HEAD	-252
#define	MAIL_IMPORT_AB_HEAD_FORMAT_INCORRECT	-253
#define	MAIL_FAIL_TO_OPEN_IMPORT_EXPORT_FILE	-254
#define	MAIL_FAILT_TO_FIND_SPECIFIC_FIELD	-255

//  export/inport field
#define	IMPORT_EXPORT_FIRST_NAME		0x0001
#define	IMPORT_EXPORT_SECOND_NAME		0x0002
#define	IMPORT_EXPORT_MIDDLE_NAME		0x0004
#define	IMPORT_EXPORT_REALNAME  		0x0008
#define	IMPORT_EXPORT_NICKNAME  		0x0010
#define	IMPORT_EXPORT_EMAIL  			0x0020
#define	IMPORT_EXPORT_HOME_ADDRESS		0x0040
#define	IMPORT_EXPORT_HOME_TEL			0x0080
#define	IMPORT_EXPORT_HOME_FAX			0x0100
#define	IMPORT_EXPORT_MOBIL			0x0200
#define	IMPORT_EXPORT_COMPANY_ADDRESS		0X0400
#define	IMPORT_EXPORT_COMPANY			0x0800
#define	IMPORT_EXPORT_COMPANY_TEL		0x1000
#define	IMPORT_EXPORT_COMPANY_FAX		0x2000
#define	IMPORT_EXPORT_MOMO			0x4000

#define	MAX_SUPPORTED_COUNTRY			1
#define	MAX_IMPORT_EXPORT_NUMBER_OF_FIELD	15

typedef enum {POSITIVE,   	// a ~ z
	      REVERSE}ORDER;	// z ~ a
	      
enum {NOT_EXIST_MEMBER, EXIST_MEMBER};

typedef enum {FIRST_NAME = 1, SECOND_NAME, MIDDLE_NAME, REALNAME, NICKNAME, 
	EMAIL, HOME_ADDRESS, HOME_TEL, HOME_FAX, MOBIL, COMPANY_ADDRESS, 
	COMPANY, COMPANY_TEL, COMPANY_FAX, NOTES}INFO_FILED;

typedef enum {ENG_HEADER}IMPORT_EXPORT_FIELD;

extern int	ab_errno;

//  group structure
typedef struct {
	int	ver;
	char	owner[32];
	long	size;
	int	number_of_groups;
	long	reserved;
}MAIL_GROUP_HEADER, *PMAIL_GROUP_HEADER;

typedef struct {
	char	group_name[32];
	int	member_list_length;
	int	number_of_members;
} MAIL_AB_GROUP_INFO, * PMAIL_AB_GROUP_INFO;

typedef struct AB_Group_List {
	MAIL_AB_GROUP_INFO group_info;
	struct AB_Group_List * next;
} AB_GROUP_LIST, * PAB_GROUP_LIST;

//  address book structure
typedef struct {
	int	ver;
	char	owner[32];
	long	size;
	int	number_of_records;
	long	reserved;
}MAIL_AB_HEADER, *PMAIL_AB_HEADER;

typedef struct {
	int	ver;
	int	unique_id;
	char	first_name[32];
	char	second_name[32];
	char	middle_name[32];
	char	realname[128];
	char	nickname[32];
	char	email[128];
	char	home_address[256];
	char	home_tel[32];
	char	home_fax[32];
	char	mobil[32];
	char	company_address[256];
	char	company[256];
	char	company_tel[32];
	char	company_fax[32];
	char	notes[128];
} MAIL_AB_RECORD_INFO, * PMAIL_AB_RECORD_INFO;

typedef struct AB_Record_List{
	MAIL_AB_RECORD_INFO record_info;
	struct AB_Record_List * next;
} AB_RECORD_LIST, * PAB_RECORD_LIST;

typedef struct Address_Book_Field_List {
	char field_name[32];
	INFO_FILED which_field;
	struct Address_Book_Field_List * next;
}ADDRESS_BOOK_FIELD_LIST, * PADDRESS_BOOK_FIELD_LIST;

//  address book opration for group functions
int Mail_Initial_AB_Group_File (const char * owner, int force);
int Mail_AB_Get_Group_Header (MAIL_GROUP_HEADER * group_header, const char * owner);
int Mail_AB_Create_Group (const char * group, const char * owner);
int Mail_AB_Delete_Group (const char * group, const char * owner);
int Mail_Check_Group_Exist (const char * group, const char * owner);
int Mail_Check_Group_Member_Exist (int unique_id, const char * group, const char * owner);
int Mail_AB_Modify_Group (const char * old_group_name, const char * new_group_name, const char * owner);
int Mail_AB_Add_Group_Member (int unique_id, const char * group, const char * owner);
int Mail_AB_Del_Group_Member (int unique_id, const char * group, const char * owner);
AB_GROUP_LIST * Mail_Get_Group (const char * owner);
AB_RECORD_LIST * Mail_Get_Group_Member (const char * group, const char * owner, int exist);
AB_GROUP_LIST * Mail_AB_Sort_Group (AB_GROUP_LIST * group_list, ORDER order);
int Mail_Ab_Free_Group (AB_GROUP_LIST * group_list);

//  address book opration for record functions
int Mail_Initial_AB_File (const char * owner, int force);
int Mail_AB_Get_Header (MAIL_AB_HEADER * ab_header, const char * owner);
int Mail_AB_Create_Record (MAIL_AB_RECORD_INFO * record_info, const char * owner);
int Mail_AB_Delete_Record (int unique_id, const char * owner);
int Mail_Check_AB_Record_Exist (int unique_id, const char * owner);
int Mail_AB_Modify_Record (int unique_id, MAIL_AB_RECORD_INFO * new_record_info, const char * owner);
AB_RECORD_LIST * Mail_Get_Record (const char * owner);
AB_RECORD_LIST * Mail_Find_Record (AB_RECORD_LIST * record_list, int unique_id);
AB_RECORD_LIST * Mail_AB_Sort_Record (AB_RECORD_LIST * record_list, INFO_FILED field, ORDER order);
int Mail_AB_Free_Record (AB_RECORD_LIST * record_list);

//  Import/export function
int Export_Address_Book (const char * export_file_name, int export_field, char * buffer, int size_of_buffer, const char * owner);
int Import_Address_Book (const char * import_file_name, int import_field, ADDRESS_BOOK_FIELD_LIST * ab_field_list, const char * owner);
ADDRESS_BOOK_FIELD_LIST * Get_Address_Book_Field (const char * import_address_file_name);
int Mail_AB_Free_Field_List (ADDRESS_BOOK_FIELD_LIST * field_list);
AB_RECORD_LIST * Mail_Get_Records_From_File (const char * file_name, ADDRESS_BOOK_FIELD_LIST * field_list);

#endif
