//**************************************************************************
//
//	Copyright (c) 2000-2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		eventlog.h
//
//	Abstract: 
//		Win NT/2K like event log functions declaration
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		01/02/01	kw lee created
//
//**************************************************************************
#ifndef EVENTLOG_H
#define EVENTLOG_H 1

#include "../uLinux/uLinux.h"

//
// Defines for the READ flags for Eventlogging
//
#define EVENTLOG_SEQUENTIAL_READ        0X0001
#define EVENTLOG_SEEK_READ              0X0002
#define EVENTLOG_FORWARDS_READ          0X0004
#define EVENTLOG_BACKWARDS_READ         0X0008
//
// The types of events that can be logged.
//
#define EVENTLOG_SUCCESS                0X0000
#define EVENTLOG_ERROR_TYPE             0x0001
#define EVENTLOG_WARNING_TYPE           0x0002
#define EVENTLOG_INFORMATION_TYPE       0x0004

// at least 8 bytes alignment
typedef struct _EVENTLOGRECORD { 
  unsigned long  Length; 
  unsigned long  RecordNumber; 
  unsigned long  TimeGenerated; 
  unsigned long   EventType; 
  unsigned long   NumStrings; 
  unsigned long  StringOffset; 
  // 
  // Then follow: 
  // 
  // TCHAR SourceName[] 
  // TCHAR Computername[] 
  // SID   UserSid 
  // TCHAR Strings[] 
  // BYTE  Data[] 
  // CHAR  Pad[] 
  // DWORD Length; 
  // 
} EVENTLOGRECORD, *PEVENTLOGRECORD; 

// exported function prototype
BOOL Get_Number_Of_Event_Log_Records(int fd, int *num);
BOOL Open_Event_Log(int flag);
BOOL Close_Event_Log(int fd);
BOOL Read_Event_Log(int fd, int ReadFlags, int RecordOffset, char *buffer, int nNumberOfBytesToRead, int *pnBytesRead);
BOOL Report_Event(int fd, int LogType, int NumStrings, char *Strings[]);
BOOL Clear_Event_Log(int fd);
int Write_Log(char *str, int type);
#endif
