#ifndef __CFG_VSCAN_H__
#define __CFG_VSCAN_H__

// system header files
#include <string.h>
#include <stdio.h>		// sprintf
#include <stdlib.h>		// system

// IEI header files
#include <eventlog.h>
#include <Util.h>
#include <config.h>

#define SZ_VSCAN_INFORM_ACTION "inform"
#define SZ_VSCAN_DO_NOTHING_ACTION "nothing"

#define VSCAN_INFORM_ACTION             0
#define VSCAN_DO_NOTHING_ACTION         2

#define SZ_NETWORK_VSCAN	"NT vscan"
#define SZ_LOCAL_VSCAN      "Local vscan"

#define SZ_VSCAN_SECTION    "VSCAN"
#define SZ_SERVER_FIELD     "Server"
#define SZ_STATUS_FIELD     "Status"
#define SZ_SUPPORTED_FIELD  "Supported"
#define SZ_TYPE_FIELD       "Type"
#define SZ_INFECTED_RESPONSE_FIELD "Infected Response"
#define SZ_INFECTED_RESPONSE_DEFAULT SZ_VSCAN_INFORM_ACTION

#define SZ_REMOTE_SCANNING "remote scanning"

#define START_SCRIPT "/etc/init.d/vscan.sh"

int Get_VSCAN_Supported(char* supported, int buf_size);
int Get_VSCAN_Server_Address(char* address, int buf_size);
int Get_VSCAN_Status(char* status, int buf_size);
int Get_VSCAN_Infected_Action(char* action, int buf_size);
int Set_VSCAN_Supported(int supported);
int Set_VSCAN_Status(char* status);
int Set_VSCAN_Server_Address(char* address);
int Set_VSCAN_Infected_Action(char* action);
int Set_VSCAN_Supported(int supported);

int Get_VSCAN_Type(char* type, int buf_size);
int Set_VSCAN_Type(char* type);

int Is_VSCAN_Supported();


void send_virus_alert_mail(char* subject, char* message);

// return 0 on succes
int Start_VSCAN();
void Stop_VSCAN();

#endif
