#ifndef		_SAVE_RESTORE_SETTING
#define		_SAVE_RESTORE_SETTING

#include        "NAS.h"

#define		SAVE_RESTORE_RESTART		100

#define 	ENCRYPT_PROG			"/sbin/PC1"

#define 	BACKUPDATA			"backupdata.bin"
#define		SR_WORKING_DIR			"/mnt/update"
#define 	HTTP_HEAD_STATUS		"Status: 302\r\n"

#define		PC1_ALL_CODE			"ICPIPALL"
#define		PC1_DISK_CODE			"ICPIPDISK"
#define		PC1_NETWORK_CODE		"ICPIPNETWORK"
#define		PC1_SHARE_CODE			"ICPIPSHARE"
#define		PC1_HARDWARE_CODE		"ICPIPHARDWARE"
#define		PC1_SYSTEM_CODE			"ICPIPSYSTEM"
#define 	PC1_USR_GRP_CODE		"ICPIPNAS4000"
#define		PC1_NASWARE_V301		"ICPIPNASWAREV301"

#define  	RESTORE_HW_SECTION	        "Misc"
#define		RESTORE_HW_SYS_START            "System Started"
#define		RESTORE_HW_CONFIG		"Configured"
#define		RESTORE_HW_LCD_SETTING		"LCD Panel Setting Control"
#define		RESTORE_HW_RESET_PASSWD         "Reset Password Switch"
#define         RESTORE_HW_TIMEOUT		"Disk StandBy Timeout"
#define		RESTORE_HW_BUZZER		"Buzzer"	

#define		RESTORE_NIC_SECTION		"Network"
#define		RESTORE_NIC_INTERFACE_NUM	"Interface Number"
#define		RESTORE_NIC_DNS			"DNS"
#define		RESTORE_NIC_WAN			"Wan"
#define		RESTORE_NIC_INTERFACE1		"Interface1"
#define		RESTORE_NIC_INTERFACE2		"Interface2"
#define		RESTORE_NIC_WINS_IP		"WINS IP"
#define		RESTORE_NIC_WINS_ENABLED	"WINS Enable"
#define		RESTORE_NIC_WAN_DHCP		"Wan DHCP"
#define		RESTORE_NIC_SLEEP		"SLEEP"
#define		RESTORE_NIC_BONDING_SUPPORT	"BONDING Support"
#define		RESTORE_NIC_BONDING01		"BONDING01"
#define 	RESTORE_NIC_BONDING02		"BONDING02"

#define		RESTORE_NAT_SECTION		"NAT"
#define		RESTORE_NAT_SUPPORT		"Support"
#define		RESTORE_NAT_ENABLED		"Enable"
#define		RESTORE_NAT_VDMZ		"Virtual DMZ"
#define		RESTORE_NAT_ICMP_REQUEST	"ICMP Request"

#define		RESTORE_NIC_DEV01		"eth0"
#define		RESTORE_NIC_DEV02		"eth1"
#define		RESTORE_NIC_DEV03		"eth2"
#define		RESTORE_DEV_CONFIGURE		"Configure"
#define		RESTORE_DEV_USE_DHCP		"Use DHCP"
#define		RESTORE_DEV_USAGE		"Usage"
#define		RESTORE_DEV_IP			"IP Address"
#define		RESTORE_DEV_NETMASK		"Subnet Mask"
#define		RESTORE_DEV_BROADCAST		"Broadcast"
#define		RESTORE_DEV_GATEWAY		"Gateway"
#define		RESTORE_DEV_BONDING		"Bonding"


#define  	RESTORE_SYS_SECTION	        "System"
#define  	RESTORE_SYS_MODEL	        "Model"
#define		RESTORE_SYS_SER_COMMENT         "Server Comment"
#define		RESTORE_SYS_TIMEZONE		"Time Zone"
#define		RESTORE_SYS_DAYLIGHT		"Enable Daylight Saving Time"
#define		RESTORE_SYS_WORKGROUP           "Workgroup"
#define         RESTORE_SYS_CODEPAGE		"Code Page"
#define		RESTORE_SYS_SYS_DEV		"System Device"
#define		RESTORE_SYS_TEST                "Test Mode"
#define		RESTORE_SYS_AUTO_CRT_RAID	"Auto Create Raid"
#define		RESTORE_SYS_WAN_ACCESS		"Wan Access"
#define		RESTORE_SYS_LAN_ACCESS          "Lan Access"
#define         RESTORE_SYS_WEB_PORT            "Web Access Port"
#define		RESTORE_SYS_SER_NAME		"Server Name"	
#define         RESTORE_SYS_NETWARE_SER_NAME	"Netware Server Name"

#define  	RESTORE_STOR_SECTION	        "Storage"
#define  	RESTORE_DISK_SECTION	        "Disk"
#define		RESTORE_STOR_AUTO_INIT		"Auto Init"
#define		RESTORE_STOR_DISK_NO		"Disk Drive Number"
#define		RESTORE_STOR_DISK_DRIVE		"Drive "
#define		RESTORE_STOR_DISK_CHK_ON_BOOT	"Disk Check On Boot"
#define		RESTORE_STOR_AUTO_FIX_ERROR	"Auto Fix Disk Check Errors"
#define		RESTORE_STOR_SUPPORT_R5		"Support RAID 5"
#define		RESTORE_STOR_SUPPORT_LVM	"Support LVM"
#define		RESTORE_STOR_DISK_EXIST		"Drive "
#define		RESTORE_STOR_DISK_EXIST2	" EXIST"

#define 	SR_CP_PROG			"/bin/cp"
#define 	SR_SMB_PRPG_CMD			"/etc/init.d/smb restart 2> /dev/null 1> /dev/null"

#define   	TMP_CONFIG_PATH           	"/tmp/etc/config/uLinux.conf"
#define	   	TMP_CONFIG_DIR      		"/tmp/etc/config"	
#define	  	DEFAULT_CONFIG_DIR      	"/etc/config"
#define	  	SR_SMB_CONFIG_FILE		"smb.conf"
#define	 	BACKUP_UPLOAD_WORKING_DIR	"/mnt/update"

typedef enum{
	SR_NONE_CONFIG=1000,
	SR_USR_GRP_CONFIG,
	SR_DISK_CONFIG,
	SR_NETWORK_CONFIG,
	SR_SHARE_CONFIG,
	SR_HARDWARE_CONFIG,
	SR_SYSTEM_CONFIG,
	SR_ALL_CONFIG
}SR_TYPE;

typedef enum{
	SR_USR_GRP_CFG =  1,
	SR_DISK_CFG = 	  2,
	SR_SHARE_CFG = 	  4,
	SR_HARDWARE_CFG = 8,
	SR_SYSTEM_CFG =   16,
	SR_NETWORK_CFG =  32,
	SR_FIREWALL_CFG = 64,
	SR_ALL_CFG = 	  127
}SR_NEW_TYPE;

typedef struct tagSR_SYSTEM {
	char  zSerstr[BUF_SIZE];
	char  zTimezone[BUF_SIZE];
	int  bDayligth;
	char  zWorkgrp[BUF_SIZE];
	int   nCodepage;
	char  zSysdev[BUF_SIZE];
	int  bTestmode;
	char  zAutoraid[BUF_SIZE];
	int  bWanAccess;
	int  bLanAccess;
	int   nWebport;
	char  zServer[SERVER_NAME_LENGTH];
	char  zNetwareServer[BUF_SIZE];
	
}SR_SYSTEM;

typedef struct tagSR_HARDWARE{
	int bSys;
	int bConfig;
	int bLcdsetting;
	int bRestPasswd;
	int nTimeout;
	int bBuzzer; 
}SR_HARDWARE;

#define DISK_NAME_LENGTH	4
#define MAX_DISK_NUMBER		32
typedef struct tagSR_STORAGE{
	int bAutoInit;
	int nDiskNo;
	char zDriveN[MAX_DISK_NUMBER][DISK_NAME_LENGTH];
	char zDiskChkOnBoot[10];
	int bAutoFixError;
	int bSupportR5;
	int bSupportLVM;
	int nDriveExist[MAX_DISK_NUMBER]; // In [Disk] secction
}SR_STORAGE;	
	

//export function.....
int Misc_Save_Profile(int nSave_type);
int Misc_Restore_Profile(char* filename);
int Restore_HW_Setting();
int Restore_SYS_Setting();
int Restore_Network_Setting();
int Restore_Storage_Stting();
int Restore_Usr_Grp_Setting();
//char *create_sr_working_directory();
//void clear_update_tmp_data();

#endif
