#include	<NAS.h>
#include	<Util.h>


#define	MAX_JOB_NAME_LEN	32

#define	RTRR_CONFFILE		"/etc/config/rtrr.conf"
#define	RSYNCD_CONFFILE		"/etc/rsyncd.conf"
#define	PATH_FIELD		"path"
#define	COMMENT_FIELD		"comment"
#define	HOSTS_ALLOW_FIELD	"hosts allow"
#define	HOSTS_DENY_FIELD	"hosts deny"


typedef	struct {
	int			job_id;
	BOOL			job_enable;
	char			job_name[MAX_JOB_NAME_LEN];
	char			local_share_name[SHARE_NAME_LENGTH];
	char			local_dir_name[FILE_NAME_MAX_LENGTH];
	char			local_path[FILE_NAME_MAX_LENGTH];
	char			remote_server_ip[16];
	int			remote_server_port;
	char			remote_share_name[SHARE_NAME_LENGTH];
	char			remote_dir_name[FILE_NAME_MAX_LENGTH];
	struct RTRR_CLIENT *	next;
} RTRR_CLIENT;


#define	RTRR_SUCCESS	0
#define	ERR_FATAL	-1


#define ERROR_RTRRC_ADD_EXIST	-1010
#define ERROR_RTRRC_EDIT_EXIST	-1011

#define ERROR_RTRRS_ADD_EXIST	-1021


typedef struct
{
	char	path[FILE_NAME_MAX_LENGTH];
	char	share[SHARE_NAME_LENGTH];
} RTRR_FOLDER;

typedef struct
{
	char	name[32];
	char	passwd[16];
} RTRR_USER;

typedef struct
{
	char			share_name[SHARE_NAME_LENGTH];
	char			share_comment[SHARE_COMMENT_LENGTH];
	char			share_path[FILE_NAME_MAX_LENGTH];
	char			hosts_allow[32];
	char			hosts_deny[32];
	struct RTRR_SERVER *	next;
} RTRR_SERVER;


/* export functions	*/
int add_rtrrc_job(RTRR_CLIENT *new);
int rtrr_get_remote_server_share_list(char *server_ip, int port, char ***share_list);
int get_rtrr_jobs(RTRR_CLIENT **all_jobs);
int del_rtrrc_job(char *job_name);
void DEBUG_rtrr(RTRR_CLIENT *job);
int ren_rtrrc_job(RTRR_CLIENT *new, RTRR_CLIENT *old);
int add_rtrrs_job(RTRR_SERVER *new);
int get_rtrr_server_shares(RTRR_SERVER **all_jobs);
int del_rtrrs_job(char * share_name);
int ren_rtrrs_job(RTRR_SERVER *new, RTRR_SERVER *old);
int start_rsyncd();
int stop_rsyncd();
int init_rtrr_system();
int chk_rtrrc_conf_exist(char *conffile);
int is_rtrr_support();
int is_rtrr_enabled();


