#define FW_VSERVER_CONF		"/etc/config/fw_vserver.conf"
#define FW_RULE_CONF		"/etc/config/fw_rule.conf"
#define FW_VDMZ_CONF		"/etc/config/fw_vdmz.conf"
#define FW_FILTER_CONF		"/etc/config/fw_filter.conf"
#define FW_STRING_FILTER_CONF	"/etc/config/fw_string_filter.conf"
#define FW_ROUTING_TABLE_CONF	"/etc/config/fw_routing_table.conf"
#define FW_SA_CONF		"/etc/config/fw_special_application.conf"
#define FW_SA_DEFAULT_CONF	"/etc/fw_special_application.conf.default"
#define FW_MAPPING_CONF		"/etc/config/fw_mapping.conf"
#define FW_LINE			1024

#define SZ_DMZ_FIELD		"Virtual DMZ"
#define SZ_ENABLE_FIELD		"Enable"
#define SZ_NAT_SECTION		"NAT"
#define SZ_ICMP_REQUEST_FIELD	"ICMP Request"

#define icmp_chain		"icmp_pkts"

#define FW_SUCCESS		0
#define FW_FAIL			-1

#define FW_TEST_NUM		-1

#define FW_PROTOCOL_UNKNOWN	0
#define FW_PROTOCOL_TCP		1
#define FW_PROTOCOL_UDP		2
#define FW_PROTOCOL_ALL		100

#define FW_ACCEPT		1
#define FW_DROP			2

#define FW_HAVE_LOG		1
#define FW_NO_LOG		0

#define FW_ADDR_IP		1
#define FW_ADDR_DOMAIN_NAME	2
#define FW_ADDR_ERROR		3

#define FW_VALID		1
#define FW_INVALID		0

#define ADD_ROUTING_TABLE	1
#define DEL_ROUTING_TABLE	0

#define FW_VSERVER_DUPLICATE	-1
#define FW_VSERVER_NOT_FOUND	-2
#define FW_RULE_DUPLICATE	-3
#define FW_RULE_NOT_FOUND	-4
#define FW_RULE_ADD_FAIL	-5
#define FW_VSERVER_ADD_FAIL	-6

#define FW_NO_MEMORY		-7
#define FW_RESOLVE_FAIL		-8

#define FW_FILTER_DUPLICATE	-9
#define FW_FILTER_ADD_FAIL	-10
#define FW_FILTER_NOT_FOUND	-11
#define FW_VSERVER_REN_FAIL	-12
#define FW_RULE_REN_FAIL	-13
#define FW_FILTER_REN_FAIL	-14

#define FW_TABLE_NOT_FOUND	-20
#define FW_TABLE_DUPLICATE	-21
#define FW_TABLE_ADD_FAIL	-22
#define FW_TABLE_REN_FAIL	-23

#define FW_SA_DUPLICATE		-30
#define FW_SA_NOT_FOUND		-31
#define FW_SA_ADD_FAIL		-32
#define FW_SA_REN_FAIL		-33
#define FW_SA_NAME_SAME		-34
#define FW_SA_PORT_SAME		-35

#define FW_MAPPING_DUPLICATE	-40
#define FW_MAPPING_NOT_FOUND	-41
#define FW_MAPPING_SRC_DUPLICATE -42
#define FW_MAPPING_DST_DUPLICATE -43
#define FW_MAPPING_ADD_FAIL	-44
#define FW_MAPPING_REN_FAIL	-45

#define FW_STRING_FILTER_DUPLICATE	-80
#define FW_STRING_FILTER_ADD_FAIL	-81
#define FW_STRING_FILTER_NOT_FOUND	-82
#define FW_STRING_FILTER_REN_FAIL	-83

#define FW_IPTABLES_APPEND	1
#define FW_IPTABLES_REPLACE	2
#define FW_IPTABLES_INSERT	3

#define FW_FLAG_NORMAL		1
#define FW_FLAG_NOT		2
#define FW_FLAG_ANY		3

#define FW_RULE_MOVE_UP		1
#define FW_RULE_MOVE_DOWN	2

#define ADDR_LEN		256

/* routing table data struct */
typedef struct
{
	char				dest_addr[30];
	char				netmask[30];
	char				gw[30];
	char				interface[10];
	int				metric;
	int				user_define;
	struct FW_ROUTING_TABLE		*next;
} FW_ROUTING_TABLE;

/* virtual server data struct */
typedef struct
{
	char				addr[ADDR_LEN];
	int				protocol;
	int				src_port;
	int				dest_port;
	int				nat_access;
	int				ulog;
	int				klog;
	struct FW_VIRTUAL_SERVER	*next;
} FW_VIRTUAL_SERVER;

/* firewall rule data struct */
typedef struct
{
	char				src_addr[ADDR_LEN];
	char				dest_addr[ADDR_LEN];
	int				src_flag;
	int				dest_flag;
	int				protocol;
	int				src_port;
	int				dest_port;
	int				valid;
	int				action;
	int				ulog;
	int				klog;
	int				src_type;
	int				dst_type;
	struct FW_RULE			*next;
} FW_RULE;

/* virtual dmz data struct */
typedef struct
{
	char				addr[ADDR_LEN];
	int				ulog;
	int				klog;
	struct FW_DMZ			*next;
} FW_VIRTUAL_DMZ;

/* filter data struct */
typedef struct
{
	char				url[ADDR_LEN];
	int				valid;
	int				ulog;
	int				klog;
	struct FW_FILTER		*next;
} FW_FILTER;

/* string filter data struct */
#define MAX_STRING_FILTER_LENGTH	256
typedef struct
{
	char				string[MAX_STRING_FILTER_LENGTH+1];
	int				ulog;
	int				klog;
	struct FW_STRING_FILTER		*next;
} FW_STRING_FILTER;

/* port style */
typedef struct
{
	int	protocol;
	int	start;
	int	end;
} FW_PORT;

/* special application data struct */
typedef struct
{
	char				name[28];
	char				ipaddr[ADDR_LEN];
	FW_PORT				range[3];
	int				enable;
	int				ulog;
	int				klog;
	struct FW_SA			*next;
} FW_SA;

/* one-to-one mapping data struct */
typedef struct
{
	char				srcaddr[ADDR_LEN];
	char				dstaddr[ADDR_LEN];
	int				ulog;
	int				klog;
	struct FW_MAPPING		*next;
} FW_MAPPING;

/* header of all fw conf files */
#define FW_VERSION		2

typedef struct
{
	int				version;
	int				bodysize;
	int				total;
	int				reserved;
} FW_HEADER;

typedef struct
{
	int	enable;
	char	ipaddr[ADDR_LEN];
} FW_TRIGGER;

/*	export function		*/
//======================================
//	about ip address functions
//======================================
int 	FW_Resolve_Addr(char *ipaddr, char *name, int len);
int	FW_Check_Addr(const char *addr);

int	FW_Add_Web_Access_Rule(int type);

//==================================
//	reset function
//==================================
void	FW_Reset();
void	FW_Reset_Router(int restart);
void	FW_Reset_Vserver(int restart);
void	FW_Reset_Mapping(int restart);
void	FW_Reset_Special_Application(int restart);
void	FW_Reset_Filter(int restart);
void	FW_Reset_Rule(int restart);
void	FW_Reset_Vdmz(int restart);

//============================
//	NAT function
//============================
int 	FW_Start_NAT(FW_TRIGGER *trigger);
int 	FW_Enable_NAT(int bEnable);
int 	FW_Stop_NAT();
int 	FW_Restart_NAT();
int	FW_Refresh_NAT(FW_TRIGGER *trigger);
int	FW_Begin_NAT(FW_TRIGGER *trigger);
int	FW_Is_NAT_Enable();
int	FW_Set_NAT(int bEnable);


//======================================
//	Virtual DMZ function
//======================================
FW_VIRTUAL_DMZ		*FW_Get_Vdmz();
void			FW_Free_Vdmz(FW_VIRTUAL_DMZ *vdmz);
int			FW_Modify_Vdmz(FW_VIRTUAL_DMZ *new);
int			FW_Start_Vdmz();
int			FW_Set_DMZ(int bEnable);
int			FW_Is_DMZ_Enable();

//======================================
//	Virtual Server function
//======================================
FW_VIRTUAL_SERVER       *FW_Get_Vserver();
void                    FW_Free_Vserver(FW_VIRTUAL_SERVER *vserver);
int 			FW_Add_Vserver(FW_VIRTUAL_SERVER *new);
int 			FW_Del_Vserver(FW_VIRTUAL_SERVER *del);
int			FW_Ren_Vserver(FW_VIRTUAL_SERVER *new, FW_VIRTUAL_SERVER *old);
int			FW_Start_Vserver();

//=======================================
//	Firewall Rule function
//=======================================
FW_RULE			*FW_Get_Rule();
void			FW_Free_Rule(FW_RULE *rule);
int 			FW_Add_Rule(FW_RULE *new);
int			FW_Del_Rule(FW_RULE *del);
int			FW_Ren_Rule(FW_RULE *new, FW_RULE *old);
int			FW_Move_Rule(FW_RULE *select, int action);
int			FW_Start_Rule(int bnat);

//========================================
//	Filter function
//========================================
FW_FILTER		*FW_Get_Filter();
void			FW_Free_Filter(FW_FILTER *filter);
int			FW_Add_Filter(FW_FILTER *new);
int			FW_Del_Filter(FW_FILTER *del);
int			FW_Ren_Filter(FW_FILTER *new, FW_FILTER *old);
int			FW_Start_Filter(int bnat);

//==========================================
//	string filter function
//==========================================
FW_STRING_FILTER	*FW_Get_String_Filter();
void			FW_Free_String_Filter(FW_STRING_FILTER *string);
int			FW_Add_String_Filter(FW_STRING_FILTER *new);
int			FW_Del_String_Filter(FW_STRING_FILTER *del);
int			FW_Ren_String_Filter(FW_STRING_FILTER *new, FW_STRING_FILTER *old);
int			FW_Start_String_Filter(int bnat);

//==============================================
//	routing table function
//==============================================
FW_ROUTING_TABLE	*FW_Get_Routing_Table();
void 			FW_Free_Routing_Table(FW_ROUTING_TABLE *table);
int			FW_Del_Routing_Table(FW_ROUTING_TABLE *del);
int			FW_Add_Routing_Table(FW_ROUTING_TABLE *new);
FW_ROUTING_TABLE	*FW_Get_Default_Routing_Table();
int			FW_Ren_Routing_Table(FW_ROUTING_TABLE *new, FW_ROUTING_TABLE *old);
int			FW_Start_Routing_Table();

//==============================================
//	special application function
//==============================================
FW_SA			*FW_Get_Special_Application(int type);
void			FW_Free_Special_Application(FW_SA *sa);
int			FW_Add_Special_Application(FW_SA *new);
int			FW_Del_Special_Application(FW_SA *del);
int			FW_Ren_Special_Application(FW_SA *new, FW_SA *old);
int			FW_Start_Special_Application(FW_TRIGGER *trigger);
int			FW_Check_Special_Application(int protocol, int port, char *dst_ipaddr);

//===============================================
//	icmp function
//===============================================
int			FW_Is_ICMP_Request();
int			FW_Set_ICMP_Request(int bEnable);
int			FW_Add_ICMP_Rule();

//=================================================
//	one-to-one address mapping
//=================================================
FW_MAPPING		*FW_Get_Mapping();
void			FW_Free_Mapping(FW_MAPPING *mapping);
int			FW_Add_Mapping(FW_MAPPING *new);
int			FW_Del_Mapping(FW_MAPPING *del);
int			FW_Ren_Mapping(FW_MAPPING *new, FW_MAPPING *old);
int			FW_Start_Mapping();

