//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		ifcfg.c
//
//	Abstract: 
//		Get active network interface information
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		05/02/01	Louis Tsai - let printf_if can judge eth? interface is up or down
//		12/22/00	kw lee created
//
//**************************************************************************
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>




#include <netdb.h>

#define EON

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "config.h"

struct	sockaddr_in	netmask;
struct	sockaddr_in	broadcast;
struct	sockaddr_in	gw;

struct	ifreq		ifr, ridreq;
char	name[30];
int	flags, metric, mtu, setaddr, setipdst, doalias;
int	clearaddr, s;
int	newaddr = 0;
int	nsellength = 1;
int	af = AF_INET;
int     dflag, mflag, lflag, uflag;
int     reset_if_flags;
int	explicit_prefix = 0;
#ifdef INET6
int	Lflag = 1;
#endif

int print_if(IFInfo *pif);
void getsock(int naf);
extern int Get_Gateway_Addr(char *ifname, struct sockaddr_in *gwin);

void
err1(int num, char *str)
{
//  Tiger Fu 2001/07/24 avoid printing error message for CGI
//	printf("%s\n", str);
	fprintf(stderr, "%s\n", str);
}


int
print_if(IFInfo *pif)
{
	char *inbuf = NULL;
	struct ifconf ifc;
	struct ifreq ifreq, *ifrp;
	struct ifreq ifrm;
	int i, siz, len = 8192;
	char ifrbuf[8192];
	unsigned char *ptr;
	struct sockaddr_in *sin;
	int count = 0;

	memset(&ifrm, 0, sizeof(struct ifreq));
	strcpy(ifrm.ifr_name, pif->device_name);

	getsock(af);
	if (s < 0)
		err1(1, "socket");
	while (1) {
		ifc.ifc_len = len;
		ifc.ifc_buf = inbuf = realloc(inbuf, len);
		if (inbuf == NULL) {
			err1(1, "malloc");
			free(inbuf);
			return -1;	
		}
		if (ioctl(s, SIOCGIFCONF, &ifc) < 0) {
			err1(1, "SIOCGIFCONF");
			free(inbuf);
			return -1;
		}
		
		if (ifc.ifc_len + sizeof(ifreq) < len)
			break;
		len *= 2;
	}
	
	ifrp = ifc.ifc_req;
	ifreq.ifr_name[0] = '\0';
	for (i = 0; i < ifc.ifc_len; ) {
		ifrp = (struct ifreq *)((caddr_t)ifc.ifc_req + i);
		memcpy(ifrbuf, ifrp, sizeof(*ifrp));

		/* glibc>2.2.3 not support */
//		siz = SA_LEN(&(((struct ifreq *)ifrbuf)->ifr_addr));
//		if (siz < sizeof(ifrp->ifr_addr))
			siz = sizeof(ifrp->ifr_addr);
		siz += sizeof(ifrp->ifr_name);
		i += siz;
		/* avoid alignment issue */
		if (sizeof(ifrbuf) < siz) {
			err1(1, "err all");
			free(inbuf);
			return -1;
		}
		memcpy(ifrbuf, ifrp, siz);
		ifrp = (struct ifreq *)ifrbuf;

		if (strncmp(ifrm.ifr_name, ifrp->ifr_name,
		    sizeof(ifrp->ifr_name)))
			continue;
		strncpy(name, ifrp->ifr_name, sizeof(ifrp->ifr_name));
		sin = (struct sockaddr_in *)&ifrp->ifr_addr;
		//----------------------------------------------------
		// IP Address
		//----------------------------------------------------
		sprintf(pif->ip_addr, "%s", inet_ntoa(sin->sin_addr));
		if (ioctl(s, SIOCGIFBRDADDR, (caddr_t)ifrp) < 0) {
			err1(1, "err broadcast");
			free(inbuf);
			return -1;
		} 
		broadcast.sin_addr =
		    ((struct sockaddr_in *)&(ifrp->ifr_addr))->sin_addr;
		
		//----------------------------------------------------
		// Broadcast Address
		//----------------------------------------------------
		sprintf(pif->broadcast, "%s", inet_ntoa(broadcast.sin_addr));
		//
		if (ioctl(s, SIOCGIFNETMASK, (caddr_t)ifrp) < 0) {
			err1(1, "err netmask");
			free(inbuf);
			return -1;
		} 
		netmask.sin_addr =
		    ((struct sockaddr_in *)&(ifrp->ifr_addr))->sin_addr;
		
		//----------------------------------------------------
		// Netmask Address
		//----------------------------------------------------
		sprintf(pif->net_mask, "%s", inet_ntoa(netmask.sin_addr));
		//----------------------------------------------------
		// Gateway Address
		//----------------------------------------------------
		if(Get_Gateway_Addr(ifrp->ifr_name, &gw))
			sprintf(pif->gateway, "%s", inet_ntoa(gw.sin_addr));
		
		count++;
	}
	// there is no need to enumerate if in order to find MAC address
	// 	because sometimes cable is not connected...
	// you can force to call ioctl iff device driver is up
	strcpy(ifrp->ifr_name, "eth0");
	if (ioctl(s, SIOCGIFHWADDR, (caddr_t)ifrp) < 0) {
		err1(1, "err mac");
		free(inbuf);
		return -1;
	} 
	//----------------------------------------------------
	// MAC Address
	//----------------------------------------------------
	ptr = &(ifrp->ifr_hwaddr.sa_data[0]);
	sprintf(pif->hw_addr, "%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
			ptr[0], ptr[1], ptr[2], ptr[3], ptr[4], ptr[5]);
	free(inbuf);
	if (ioctl(s, SIOCGIFFLAGS, &ifrm) < 0) {
		err1(1, "SIOCGIFFLAGS");
		return -1;
	}
	
	if (!( ifrm.ifr_flags & 1)) {
	//	err1(1, "network interface is disable");
		return -1;
	}	 
	return count;
}


void
getsock(int naf)
{
	static int oaf = -1;

	if (oaf == naf)
		return;
	if (oaf != -1)
		close(s);
	s = socket(naf, SOCK_DGRAM, 0);
	if (s < 0)
		oaf = -1;
	else
		oaf = naf;
}
