//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_webfs.c
//
//	Abstract: 
//		System configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/06/00	kw lee created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "Util.h"


/* ------------------------------------------------------------------------- **
 * Build options...
 */

//#define CFG_SYSTEM_TEST		// Build as a standalone program (with main), for testing only...



/* ------------------------------------------------------------------------- **
 * Constants...
 */



/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */



#define	SZ_WEBFS_SECTION		"WebFS"
#define	SZ_ENABLE_FIELD			"Enable"
#define	SZ_ROOT_PATH_FIELD		"Web Root Path"

/*
 * Check web filesystem enabled
 * Return:
 *	true	Enabled			
 *	false	Disabled
 */
BOOL Is_Webfs_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_WEBFS_SECTION, SZ_ENABLE_FIELD, "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

/*
 * Enable web file system
 * Return:
 *	0		pass			
 *  ERROR_WRITE_FILE	can not write to config file
 *	others	fail, according to webfs's report
 */
int Enable_Webfs(int bEnable)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_WEBFS_SECTION, SZ_ENABLE_FIELD, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;
	if (bEnable) {		// *** TBD ****
//		if (!is_webfs_started()) ret = restart_webfs();	 
	}
	else {
//		ret = stop_webfs();
	}
	return ret;
}


/*
int GetWebRootPath(char *root_path, int buf_size)
{
	return GetProfileString(SZ_WEBFS_SECTION, SZ_ROOT_PATH_FIELD, "", root_path, buf_size);
}

int SetWebRootPath(char *root_path)
{
	return WriteProfileString(SZ_WEBFS_SECTION, SZ_ROOT_PATH_FIELD, root_path);
}
*/
