//**************************************************************************
//
//      Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//      FILE:
//              cfg_tape.c
//
//      Abstract:
//              Tape Function Library.
//
//      FUNCTIONS:      TBD.
//
//      COMMENTS:       N/A
//
//      HISTORY:
//      03/01/2002      Johnson Hsu created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <dirent.h>
#include <time.h>
#include <sys/wait.h>
#include "cfg_tape.h"
#include "config.h"
#include "NAS.h"
#include "nas_lib_common.h"

//#define _DEBUG

void Tape_Clear_Status_Info()
{
	Set_Private_Profile_String( TAPE_SESSION, TAPE_STATUS_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);
	Set_Private_Profile_String( TAPE_SESSION, TAPE_MSG_TIME_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);	
	Set_Private_Profile_String( TAPE_SESSION, TAPE_TAPE_NUM_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);	
	Set_Private_Profile_String( TAPE_SESSION, TAPE_SOURCE_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);	
	Set_Private_Profile_String( TAPE_SESSION, TAPE_DESTINATION_FIELD, TAPE_DEFAULT_STR, TAPE_FILE);		
	Set_Private_Profile_String( TAPE_SESSION, TAPE_LABEL_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);	
	Set_Private_Profile_String( TAPE_SESSION, TAPE_TYPE_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);	
	Set_Private_Profile_String( TAPE_SESSION, TAPE_COMPRESSION_FIELD, TAPE_DEFAULT_STR, TAPE_FILE);	
	Set_Private_Profile_String( TAPE_SESSION, TAPE_VERIFY_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);	
	Set_Private_Profile_String( TAPE_SESSION, TAPE_FILES_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);	
	Set_Private_Profile_String( TAPE_SESSION, TAPE_MEGABYTES_FIELD	, TAPE_DEFAULT_STR, TAPE_FILE);			
}

TAPE_INFO *Tape_Get_Tape_Info()
{
	FILE 		*fptrn;
	TAPE_INFO	*current=NULL;
	char		value[SSTR_LENGTH];
	char		tag[SSTR_LENGTH];
	char		*timestamp_ptr;						

	if ((fptrn=fopen(TAPE_TAR_n_FILE, "r+"))==NULL)
		return NULL;
		
	if ((current = calloc(1, sizeof(TAPE_INFO)))==NULL) {
		fclose(fptrn);
		return NULL;
	}
			
	while (!feof(fptrn)) {	
			
		fscanf(fptrn, "%s %s", tag, value);
					
		if (strcasecmp(tag, "TAPE_timestamp") == 0) {
			timestamp_ptr = strchr(value, '_');
			*timestamp_ptr = ' ';
			strcpy(current->timestamp, value);
		}	
		else if (strcasecmp(tag, "TAPE_label") == 0)
			strcpy(current->label, value);
		else if (strcasecmp(tag, "TAPE_volume") == 0)
			strcpy(current->volume, value);		
		else if (strcasecmp(tag, "TAPE_compress") == 0)
			strcpy(current->compress, value);
		else if (strcasecmp(tag, "TAPE_source") == 0)
			strcpy(current->source, value);	
		else if (strcasecmp(tag, "TAPE_servername") == 0)
			strcpy(current->servername, value);						
	}
	fclose(fptrn);	
	return current;
}

void Tape_Clear_Tape_Info()
{
	unlink(TAPE_TAR_n_FILE);
}

BOOL Tape_Info_Test(TAPE_INFO *tape_info)
{
	if (strcasecmp(tape_info->compress,"") == 0)
		return FALSE;
	else	return TRUE;	
}	
		
TAPE_INFO *Tape_Get_All_Tape_Info()
{
	int i=1, count=0;
	TAPE_INFO	*tape_info=NULL, *start=NULL, *prev=NULL ,*current=NULL;
		
	do {
		Tar_Cmd_Tvf(TAPE_NON_REWIND_DEV);
		Tape_Forward_Count_Tape(i++);	

		if ((current = Tape_Get_Tape_Info())==NULL)
			return NULL;				
		else {
			if (++count == 1)
				start = current;
			else
				prev->next = current;

			strcpy(current->timestamp, tape_info->timestamp);
			strcpy(current->label, tape_info->label);
			strcpy(current->volume, tape_info->volume);
			strcpy(current->compress, tape_info->compress);
			strcpy(current->source, tape_info->source);
			prev = current;
		}						

	} while (strcasecmp(tape_info->compress,"") != 0);
	
	Tape_Rewind_Tape();
	return start;
}

void Tape_Free_Info(TAPE_INFO *tape_info)
{
	TAPE_INFO *current;
	
	current = tape_info;
	while (tape_info != NULL)
	{
		tape_info = tape_info->next;
		free(current);
		current = tape_info;
	}
}

TAPE_INFO *Tape_Get_Assign_Tape_Info(int count)
{
	TAPE_INFO	*current=NULL;
	
	Tape_Forward_Count_Tape(count);	

	Tar_Cmd_Tvf(TAPE_NON_REWIND_DEV);
					
	if ((current = Tape_Get_Tape_Info())==NULL)
		return NULL;
			
	Tape_Rewind_Tape();
				
	return current;
}
		
void Tape_Free_Tape_Info(TAPE_INFO *tape_info)
{
	free(tape_info);
}

TAPE_BACKUP_SHARE_DIR_REVERSE_INFO *Tape_Get_Backup_Share_Dir_Reverse_Info(char *compare)
{
	int flag=0;

	TAPE_BACKUP_SHARE_DIR_REVERSE_INFO	*current=NULL;					

	TAPE_BACKUP_SHARE_DIR_INFO *tape_backup_share_dir_info, *tape_backup_share_dir_start;

	tape_backup_share_dir_info = Tape_Backup_Share_Dir_Info(); 
	tape_backup_share_dir_start = tape_backup_share_dir_info;

	while(tape_backup_share_dir_info != NULL) {
		if (strcasecmp(compare, tape_backup_share_dir_info->share_path) == 0) {
			if ((current = calloc(1, sizeof(TAPE_BACKUP_SHARE_DIR_REVERSE_INFO)))==NULL)
				return NULL;

			strcpy(current->share_type, tape_backup_share_dir_info->share_type);
			strcpy(current->share_name, tape_backup_share_dir_info->share_name);
			flag=1;
			break;
		}			

		tape_backup_share_dir_info = tape_backup_share_dir_info->next;
	}
			
	Tape_Free_Backup_Share_Dir_Info(tape_backup_share_dir_start);// erase memory

	if (flag==1)
		return current;
	else
		return NULL;
}	
		
void Tape_Free_Backup_Share_Dir_Reverse_Info(TAPE_BACKUP_SHARE_DIR_REVERSE_INFO *tape_info)
{
	free(tape_info);
}

TAPE_LOG_INFO *Tape_Get_Log_Last_Line()
{
	FILE 		*fptrq;
	TAPE_LOG_INFO	*last=NULL, *current=NULL;
	char		line[TAPE_LINE], *ptrf, *ptrl, tmp[TAPE_LINE]="";

	if ((fptrq=fopen(TAPE_TAR_q_FILE, "r+"))==NULL)
		return NULL;

	if (fgets(line, TAPE_LINE, fptrq)== NULL) {
		fclose(fptrq);
		return NULL;
	}
	
	while (!feof(fptrq))
		fgets(line, TAPE_LINE, fptrq);
	
	erase_char(line);
	
	if ((current = calloc(1, sizeof(TAPE_LOG_INFO)))==NULL) {
		fclose(fptrq);
		return NULL;
	}
	else {
                ptrf = strstr(line, "[");		//id
                ptrl = strstr(line, "]");
                strncpy(tmp, ptrf+1, ptrl-ptrf-1);			
		current->id=atoi(tmp);
			
                ptrf = strstr(ptrf+1, "[");		//time_stamp
                ptrl = strstr(ptrf, "]");               			    			                	
                strncpy(tmp, ptrf+1, ptrl-ptrf-1);
		strcpy(current->time_stamp,tmp);

		ptrf = strstr(ptrl+1, "[");		//type
                ptrl = strstr(ptrf, "]");  	
                *ptrl = 0x0;                	            	                         		             			    			                              	       	
		strcpy(current->type,ptrf+1);
				
		strcpy(current->msg,ptrl+2);		//msg			

		last = current;
	}	
	fclose(fptrq);	
	return last;
}	

void Tape_Set_Status_Info_Time_Field()
{
	char time_buf[SSTR_LENGTH]="";	
	FILE 	*fptrt;

	if ((fptrt=fopen(TAPE_TIME_FILE, "r+"))==NULL)
		return;

	fgets(time_buf, SSTR_LENGTH, fptrt);

	fclose(fptrt);	

	erase_char(time_buf);		
	Set_Private_Profile_String( TAPE_SESSION, TAPE_MSG_TIME_FIELD, time_buf, TAPE_FILE);
}   

void Tape_Set_Status_Info_Time_File()
{
	time_t timep;
	char time_buf[SSTR_LENGTH]="";	
	FILE 	*fptrt;
	time(&timep);
	strcpy(time_buf, ctime(&timep));
	erase_char(time_buf);

	if ((fptrt=fopen(TAPE_TIME_FILE, "w+"))==NULL)
		return;

	fprintf(fptrt, "%s", time_buf);

	fclose(fptrt);
}   

void Tape_Set_Status_Info_Status_Field()
{
	char tape_status[MSTR_LENGTH]="";
	TAPE_LOG_INFO *tape_log_last; 
	tape_log_last = Tape_Get_Log_Last_Line();
	
	if  (tape_log_last == NULL)
		return;
	
	sprintf(tape_status, "%s (%s)", tape_log_last->msg, tape_log_last->time_stamp);
		
	Set_Private_Profile_String( TAPE_SESSION, TAPE_STATUS_FIELD, tape_status, TAPE_FILE);							
	Tape_Free_Log_Info(tape_log_last);// erase memory
}   

void Tape_Set_Status_Info_Status_Time_Field()
{
	time_t timep;
	char time_buf[SSTR_LENGTH]="";
	TAPE_LOG_INFO *tape_log_last; 
	
	time(&timep);
	tape_log_last = Tape_Get_Log_Last_Line();
	
	if  (tape_log_last == NULL)
		return;
		
	strcpy(time_buf, ctime(&timep));
	erase_char(time_buf);
		
	Set_Private_Profile_String( TAPE_SESSION, TAPE_STATUS_FIELD	, tape_log_last->msg, TAPE_FILE);
	Set_Private_Profile_String( TAPE_SESSION, TAPE_MSG_TIME_FIELD	, time_buf, TAPE_FILE);
									
	Tape_Free_Log_Info(tape_log_last);// erase memory
}

void Tape_Set_Status_Info_Count_Size_Field()
{
	FILE 	*fptra;
	char 	tag[SSTR_LENGTH];
	char	value[SSTR_LENGTH];

	if ((fptra=fopen(TAPE_TAR_a_FILE, "r"))==NULL)
		return;

	if (fscanf(fptra, "%s %s", tag, value) != -1) {	
		if (strcasecmp(tag, "TAPE_files_total_count")==0)		
			Set_Private_Profile_String( TAPE_SESSION, TAPE_FILES_FIELD, value, TAPE_FILE);
	}			
	if (fscanf(fptra, "%s %s", tag, value) != -1) {
		if (strcasecmp(tag, "TAPE_files_total_size")==0)	
			Set_Private_Profile_String( TAPE_SESSION, TAPE_MEGABYTES_FIELD, value, TAPE_FILE);
	}					
	fclose(fptra);	
}  

void Tape_Set_Status_Info_Source_Label_Field()
{
	FILE 	*fptre;
	char 	tag[SSTR_LENGTH];
	char	value[SSTR_LENGTH];

	if ((fptre=fopen(TAPE_TAR_e_FILE, "r"))==NULL)
		return;

	if (fscanf(fptre, "%s %s", tag, value) != -1) {	
		if (strcasecmp(tag, "TAPE_current_label")==0)		
			Set_Private_Profile_String( TAPE_SESSION, TAPE_LABEL_FIELD, value, TAPE_FILE);
		else if (strcasecmp(tag, "TAPE_source")==0) {
			Set_Private_Profile_String( TAPE_SESSION, TAPE_SOURCE_FIELD, value, TAPE_FILE);
			fclose(fptre);				
			return;
		}	
	}
		
	if (fscanf(fptre, "%s %s", tag, value) != -1) {
		if (strcasecmp(tag, "TAPE_source")==0)	
			Set_Private_Profile_String( TAPE_SESSION, TAPE_SOURCE_FIELD, value, TAPE_FILE);
	}					
	fclose(fptre);	
}

void Tape_Set_Restore_Status_Info_Source_Label_Field()
{
	FILE 	*fptrn;
	char 	tag[SSTR_LENGTH];
	char	value[SSTR_LENGTH];

	if ((fptrn=fopen(TAPE_TAR_n_FILE, "r"))==NULL)
		return;
	
	while(!feof(fptrn)) {	
		if (fscanf(fptrn, "%s %s", tag, value) != -1) {	
			if (strcasecmp(tag, "TAPE_label")==0)		
				Set_Private_Profile_String( TAPE_SESSION, TAPE_LABEL_FIELD, value, TAPE_FILE);
			else if (strcasecmp(tag, "TAPE_source")==0)
				Set_Private_Profile_String( TAPE_SESSION, TAPE_SOURCE_FIELD, value, TAPE_FILE);
			else continue;
		}
	}			
	fclose(fptrn);	
}   

void Tape_Set_Status_Info_Num_Field()
{
	FILE 	*fptrj;
	char 	tag[SSTR_LENGTH];
	char	value[SSTR_LENGTH];

	if ((fptrj=fopen(TAPE_TAR_j_FILE, "r"))==NULL)
		return;

	if (fscanf(fptrj, "%s %s", tag, value) != -1) {	
		if (strcasecmp(tag, "TAPE_current_volume")==0)		
			Set_Private_Profile_String( TAPE_SESSION, TAPE_TAPE_NUM_FIELD, value, TAPE_FILE);
	}			
	fclose(fptrj);	
}  

void Tape_Set_Status_Info_Compress_Verify_Type_Field( char *type, char *compress, char *verify)
{
	if (strcasecmp(type, "1")==0)		
		Set_Private_Profile_String( TAPE_SESSION, TAPE_TYPE_FIELD, TAPE_INCREMENTAL_TAG, TAPE_FILE);
	else if (strcasecmp(type, "0")==0)
		Set_Private_Profile_String( TAPE_SESSION, TAPE_TYPE_FIELD, TAPE_FULL_TAG, TAPE_FILE);
	else
		Set_Private_Profile_String( TAPE_SESSION, TAPE_TYPE_FIELD, TAPE_DEFAULT_STR, TAPE_FILE);				
	
	if (strcasecmp(compress, "1")==0)		
		Set_Private_Profile_String( TAPE_SESSION, TAPE_COMPRESSION_FIELD, TAPE_COMPRESS_TAG, TAPE_FILE);
	else if (strcasecmp(compress, "0")==0)
		Set_Private_Profile_String( TAPE_SESSION, TAPE_COMPRESSION_FIELD, TAPE_NON_COMPRESS_TAG, TAPE_FILE);
	else
		Set_Private_Profile_String( TAPE_SESSION, TAPE_COMPRESSION_FIELD, TAPE_DEFAULT_STR, TAPE_FILE);				
	
	if (strcasecmp(verify, "1")==0)	
		Set_Private_Profile_String( TAPE_SESSION, TAPE_VERIFY_FIELD, TAPE_VERIFY_TAG, TAPE_FILE);
	else if (strcasecmp(verify, "0")==0)
		Set_Private_Profile_String( TAPE_SESSION, TAPE_VERIFY_FIELD, TAPE_NON_VERIFY_TAG, TAPE_FILE);
	else
		Set_Private_Profile_String( TAPE_SESSION, TAPE_VERIFY_FIELD, TAPE_DEFAULT_STR, TAPE_FILE);					
}  

void Tape_Set_All_Status_Info(char *type, char *compress, char *verify)
{
	Tape_Set_Status_Info_Status_Field();
	Tape_Set_Status_Info_Count_Size_Field();
	Tape_Set_Status_Info_Source_Label_Field();
	Tape_Set_Status_Info_Compress_Verify_Type_Field(type, compress, verify);
	Tape_Set_Status_Info_Num_Field();	
}

void Tape_Set_All_Restore_Status_Info()
{
	Tape_Set_Status_Info_Status_Field();
	Tape_Set_Status_Info_Count_Size_Field();
	Tape_Set_Restore_Status_Info_Source_Label_Field();
	Tape_Set_Status_Info_Num_Field();	
}

void Tape_Set_All_Status_Info_Except_Compress_Verify_Type_Field()
{
	Tape_Set_Status_Info_Status_Field();
	Tape_Set_Status_Info_Count_Size_Field();
	Tape_Set_Status_Info_Source_Label_Field();
	Tape_Set_Status_Info_Num_Field();
	Tape_Set_Status_Info_Time_Field();	
}

TAPE_STATUS_INFO *Tape_Get_Status_Info()
{
	TAPE_STATUS_INFO *tape_status;
	char str_buf[MSTR_LENGTH];
	char sstr_buf[SSTR_LENGTH];	
	
	if ((tape_status = calloc(1, sizeof(TAPE_STATUS_INFO)))==NULL)
			return NULL;
			
	Get_Private_Profile_String( TAPE_SESSION,TAPE_STATUS_FIELD, TAPE_DEFAULT_STR, tape_status->status, MSTR_LENGTH, TAPE_FILE);
	Get_Private_Profile_String( TAPE_SESSION,TAPE_MSG_TIME_FIELD, TAPE_DEFAULT_STR, tape_status->msg_time, MSTR_LENGTH, TAPE_FILE);	
	Get_Private_Profile_String( TAPE_SESSION,TAPE_TAPE_NUM_FIELD, TAPE_DEFAULT_STR, sstr_buf, SSTR_LENGTH, TAPE_FILE);
	tape_status->tape_num = atoi(sstr_buf);
	Get_Private_Profile_String( TAPE_SESSION,TAPE_SOURCE_FIELD, TAPE_DEFAULT_STR, tape_status->source, SSTR_LENGTH, TAPE_FILE);
	Get_Private_Profile_String( TAPE_SESSION,TAPE_DESTINATION_FIELD, TAPE_DEFAULT_STR, tape_status->destination, SSTR_LENGTH, TAPE_FILE);	
	Get_Private_Profile_String( TAPE_SESSION,TAPE_LABEL_FIELD, TAPE_DEFAULT_STR, tape_status->label, SSTR_LENGTH, TAPE_FILE);
	Get_Private_Profile_String( TAPE_SESSION,TAPE_TYPE_FIELD, TAPE_DEFAULT_STR, tape_status->type, SSTR_LENGTH, TAPE_FILE);
	Get_Private_Profile_String( TAPE_SESSION,TAPE_COMPRESSION_FIELD, TAPE_DEFAULT_STR, sstr_buf, SSTR_LENGTH, TAPE_FILE);
	if (!strcasecmp(sstr_buf, TAPE_COMPRESS_TAG))
		tape_status->compression=1;
	else if (!strcasecmp(sstr_buf, TAPE_NON_COMPRESS_TAG))
		tape_status->compression=0;
	else	tape_status->compression=-1;		
	Get_Private_Profile_String( TAPE_SESSION,TAPE_VERIFY_FIELD, TAPE_DEFAULT_STR, sstr_buf, SSTR_LENGTH, TAPE_FILE);
	if (!strcasecmp(sstr_buf, TAPE_VERIFY_TAG))
		tape_status->verify=1;
	else if (!strcasecmp(sstr_buf, TAPE_NON_VERIFY_TAG))
		tape_status->verify=0;
	else	tape_status->verify=-1;		
	Get_Private_Profile_String( TAPE_SESSION,TAPE_FILES_FIELD, TAPE_DEFAULT_STR, str_buf, MSTR_LENGTH, TAPE_FILE);
	tape_status->files_processed = atof(str_buf);	
	Get_Private_Profile_String( TAPE_SESSION,TAPE_MEGABYTES_FIELD, TAPE_DEFAULT_STR, str_buf, MSTR_LENGTH, TAPE_FILE);	
	tape_status->megabytes_processed = atof(str_buf);						
	
	return 	tape_status;
}

void Tape_Free_Status_Info(TAPE_STATUS_INFO *tape_status)
{
	if (tape_status != NULL)
		free(tape_status);
}

char *find_incremented_file(char *src, char *incremented_file)
{
	TAPE_MOUNTS_INFO *tape_mounts_root_info, *tape_mounts_root_start;
	char first_root_dir[MSTR_LENGTH] = "";
	char dir_buf[MSTR_LENGTH]="";
	struct stat stat_buf;
	char create_cmd[MSTR_LENGTH]="";
	
	tape_mounts_root_info = Tape_Get_Mounts_Root_Info(); 
	tape_mounts_root_start = tape_mounts_root_info;
		
	while(tape_mounts_root_info != NULL) {
		strcpy(first_root_dir, tape_mounts_root_info->mount_path);
		sprintf(incremented_file, "%s/%s/%s", first_root_dir, TAPE_INCREMENTAL_DIR, src);	
		break;
	}	
//for debug	printf("incremented_file %s\n", incremented_file);

	Tape_Free_Mounts_Info(tape_mounts_root_start);// erase memory	
	
	if (strcasecmp(first_root_dir, "") != 0) {	
		sprintf(dir_buf, "%s/%s", first_root_dir, TAPE_INCREMENTAL_DIR);	

		if (!(stat(dir_buf, &stat_buf)==0)) {
			sprintf(create_cmd, "mkdir %s", dir_buf);
			system(create_cmd);
		}
	}
	return incremented_file;
}

char *find_incremented_file_ex_1(char *src, char *incremented_file)
{
	char 	dir_buf[MSTR_LENGTH]="";
	struct 	stat stat_buf;
	char 	create_cmd[MSTR_LENGTH]="";
	char 	compare_buf[SSTR_LENGTH]="";
	char 	*disk_num_ptr;
	int	disk_num = 0;
	char 	*no[] = {"A", "B", "C", "D", "E", "F", "G", "H"};
	char 	*incremented_src_ptr;
	char 	incremented_src[MSTR_LENGTH];
	char 	first_root_dir[MSTR_LENGTH] = "";
	TAPE_BACKUP_SHARE_DIR_REVERSE_INFO *tape_backup_share_dir_reverse_info;	
	TAPE_MOUNTS_INFO *tape_mounts_root_info, *tape_mounts_root_start;
	
	strcpy(incremented_file,"");
	strncpy(compare_buf, src, 15);
		
   	strcpy(incremented_src, (src + 1));
   	incremented_src_ptr = incremented_src;	

  	do					//incremented_src
   	{
   		incremented_src_ptr = strchr(incremented_src_ptr, '/');
   		if (incremented_src_ptr != 0)
   			*incremented_src_ptr = '_';
//   	printf("incremented_src %s\n", incremented_src);	//debug
   	} while (incremented_src_ptr != 0);


	if (	(strcasecmp(compare_buf, "/share/HDA_DATA")== 0) || 
		(strcasecmp(compare_buf, "/share/HDB_DATA")== 0) ||
		(strcasecmp(compare_buf, "/share/HDC_DATA")== 0) ||		
		(strcasecmp(compare_buf, "/share/HDD_DATA")== 0) ||
		(strcasecmp(compare_buf, "/share/HDE_DATA")== 0) ||	
		(strcasecmp(compare_buf, "/share/HDF_DATA")== 0) ||	
		(strcasecmp(compare_buf, "/share/HDG_DATA")== 0) ||	
		(strcasecmp(compare_buf, "/share/HDH_DATA")== 0) ||						
		(strcasecmp(compare_buf, "/share/MD0_DATA")== 0) ||
		(strcasecmp(compare_buf, "/share/MD1_DATA")== 0) ||		
		(strcasecmp(compare_buf, "/share/MD2_DATA")== 0) ||		
		(strcasecmp(compare_buf, "/share/MD3_DATA")== 0) ||		
		(strcasecmp(compare_buf, "/share/MD4_DATA")== 0) ||
		(strcasecmp(compare_buf, "/share/MD5_DATA")== 0) ||		
		(strcasecmp(compare_buf, "/share/MD6_DATA")== 0) ||		
		(strcasecmp(compare_buf, "/share/MD7_DATA")== 0) )		
	{					
			
	tape_backup_share_dir_reverse_info = Tape_Get_Backup_Share_Dir_Reverse_Info(compare_buf);
	
//	printf("incremented_file%s\n",incremented_file);
	
	if (tape_backup_share_dir_reverse_info == NULL)
		return incremented_file;		
		
	strcpy(compare_buf, tape_backup_share_dir_reverse_info->share_name);
	disk_num_ptr = strchr(compare_buf, ' ');	

	if (disk_num_ptr == NULL)
		return incremented_file;
	
	if (strchr(disk_num_ptr, '1')!= 0)
		disk_num = 1;
	else if (strchr(disk_num_ptr, '2')!= 0)	
		disk_num = 2;
	else if (strchr(disk_num_ptr, '3')!= 0)	
		disk_num = 3;		
	else if (strchr(disk_num_ptr, '4')!= 0)	
		disk_num = 4;	
	else if (strchr(disk_num_ptr, '5')!= 0)	
		disk_num = 5;
	else if (strchr(disk_num_ptr, '6')!= 0)	
		disk_num = 6;
	else if (strchr(disk_num_ptr, '7')!= 0)	
		disk_num = 7;		
	else if (strchr(disk_num_ptr, '8')!= 0)	
		disk_num = 8;			

	Tape_Free_Backup_Share_Dir_Reverse_Info(tape_backup_share_dir_reverse_info);

	snprintf(compare_buf, sizeof(compare_buf), TAPE_ROOT_DISK_PATH, no[disk_num-1]);

	if (stat(compare_buf, &stat_buf) == -1)
		return incremented_file;
	
	sprintf(incremented_file, "%s/%s/%s", compare_buf, TAPE_INCREMENTAL_DIR, incremented_src);	
	
	sprintf(dir_buf, "%s/%s", compare_buf, TAPE_INCREMENTAL_DIR);	

	if (!(stat(dir_buf, &stat_buf)==0)) {
		sprintf(create_cmd, "mkdir %s", dir_buf);
		system(create_cmd);
	}

	return incremented_file;
	
	} //if
	else {
		
	tape_mounts_root_info = Tape_Get_Mounts_Root_Info(); 
	tape_mounts_root_start = tape_mounts_root_info;
	
	while(tape_mounts_root_info != NULL) {
		strcpy(first_root_dir, tape_mounts_root_info->mount_path);
		sprintf(incremented_file, "%s/%s/%s", first_root_dir, TAPE_INCREMENTAL_DIR, incremented_src);	
		break;
	}
	
//for debug	printf("incremented_file %s\n", incremented_file);			//	
	Tape_Free_Mounts_Info(tape_mounts_root_start);// erase memory	
	
	if (strcasecmp(first_root_dir, "") != 0) {	
		sprintf(dir_buf, "%s/%s", first_root_dir, TAPE_INCREMENTAL_DIR);	

		if (!(stat(dir_buf, &stat_buf)==0)) {
			sprintf(create_cmd, "mkdir %s", dir_buf);
			system(create_cmd);
		}
	}
	return incremented_file;		
	}
}

void Tar_Cmd_Cvf(char *dest, char *src, char *label, char *compress, char *verify, char *incremented, char *tape_length)
{
   char tar_cmd[LSTR_LENGTH];
   char sys_cmd[MSTR_LENGTH];
   char label_cmd[SSTR_LENGTH]; 
   char compress_cmd[4]="";
   char verify_cmd[16]="";
   char multi_volume_cmd[8]=" -M";
   char incremented_cmd[4]="";      
   char incremented_file[MSTR_LENGTH]="";
   char tape_length_buf[SSTR_LENGTH]=" -L";
   char isrc[MSTR_LENGTH]="";

   if (strstr(label, " ") != NULL) { 					//label
  		printf("Label can't include ' ' character !\n");
   		return;
   	}	
   else if (strcasecmp(label, "") == 0)
   		strcpy(label_cmd,"NO_NAME");
   else strcpy(label_cmd,label);

   if (!strcasecmp(tape_length,TAPE_NULL_STR))
   	strcpy(tape_length_buf, TAPE_NULL_STR);
   else
	strcat(tape_length_buf, tape_length);

	   if (strcasecmp(compress, "1") == 0)				//compress
	   	strcpy(compress_cmd, " -z");
	   else if (strcasecmp(compress, "0") == 0)
	   	strcpy(compress_cmd, "");
	   else {
	   	printf("Don't define compress option!\n");
	   	return;
	   }
   
	   if (strcasecmp(verify, "1") == 0)				//verify
	   	strcpy(verify_cmd, " -W -C/");
	   else if (strcasecmp(verify, "0") == 0)
	   	strcpy(verify_cmd, "");
	   else {
	   	printf("Don't define verify option!\n");
	   	return;
	   } 	
  
	   if (strcasecmp(incremented, "1") == 0) {			//incremented
	   	strcpy(incremented_cmd, " -g");
	   	Tape_Transfer_Sp_Char(src, isrc);			// 09-16-2002, Johnson modify
	   	find_incremented_file_ex_1(isrc, incremented_file);	// 09-16-2002, Johnson modify
	   }	
	   else if (strcasecmp(incremented, "0") == 0) {
	   	strcpy(incremented_cmd, " -g");
	   	Tape_Transfer_Sp_Char(src, isrc);			// 09-16-2002, Johnson modify
	   	find_incremented_file_ex_1(isrc, incremented_file);	// 09-16-2002, Johnson modify
	   	
	   	if (strcasecmp(incremented_file,"") != 0) {
	   		sprintf(sys_cmd, "rm -f %s", incremented_file);
	   		system(sys_cmd);
	   	}
	   }	   	
	   else {
	   	printf("Don't define incremented option!\n");
	   	return;
	   }
  
	   if (strcasecmp(incremented_file, "") == 0)
	      strcpy(incremented_cmd, "");

	   sprintf(tar_cmd, "%s cvf %s %s -V%s%s%s%s%s%s%s %s %s %s %s %s %s %s > /dev/null 2>&1", TAPE_TAR_PATH, dest, src, label_cmd, compress_cmd, verify_cmd, multi_volume_cmd, incremented_cmd, incremented_file, tape_length_buf, TAPE_TAR_FLAG_a_FILE, TAPE_TAR_FLAG_e_FILE, TAPE_TAR_FLAG_j_FILE, TAPE_TAR_FLAG_q_FILE, TAPE_TAR_FLAG_H_FILE, TAPE_TAR_FLAG_Q_FILE, TAPE_TAR_FLAG_D_FILE);
//    	                             d  s    l c v m i f L  a  e  j  q  H  Q  D  
	   system(tar_cmd);
}

BOOL Make_Sh_Tar_Cmd_Cvf(int id, char *dest, char *src_tmp, char *label, char *compress, char *verify, char *incremented)		// 09-17-2002, Johnson Modify
{ 					
   FILE *fptr;
   char file_name[MSTR_LENGTH];
   char chmod_cmd[MSTR_LENGTH];
   char src_buf[MSTR_LENGTH];
   
   char tar_cmd[LSTR_LENGTH];
   char sys_cmd[MSTR_LENGTH];
   char label_cmd[SSTR_LENGTH]; 
   char compress_cmd[4]="";
   char verify_cmd[16]="";
   char multi_volume_cmd[8]=" -M";
   char incremented_cmd[4]="";      
   char incremented_file[MSTR_LENGTH]=""; 
   struct stat buf;  
   char isrc[MSTR_LENGTH]=""; 		// 09-16-2002, Johnson add
   char src[MSTR_LENGTH]="";    	// 09-17-2002, Johnson add
   
   sprintf(src, "\"%s\"", src_tmp);	// 09-17-2002, Johnson add
   
   strcpy(src_buf, src); //keep src path
       
   if (stat(TAPE_CRON_CMD_DIR, &buf)==-1) {
  	sprintf(sys_cmd,"/bin/mkdir %s", TAPE_CRON_CMD_DIR);  
   	system(sys_cmd);
   }	
   	
   sprintf(file_name, "%s/%d.sh", TAPE_CRON_CMD_DIR, id);
   
   if ((fptr=fopen(file_name, "w+"))==NULL)
		return FALSE;   
   
   if (strstr(label, " ") != NULL) { 				//label
  	printf("Label can't include ' ' character !\n");
   	fclose(fptr);  	
   	return FALSE;
   }	
   else if (strcasecmp(label, "") == 0)
   		strcpy(label_cmd,"NO_NAME");
   else strcpy(label_cmd,label);
 
   if (strcasecmp(compress, "1") == 0)				//compress
   	strcpy(compress_cmd, " -z");
   else if (strcasecmp(compress, "0") == 0)
   	strcpy(compress_cmd, "");
   else {
   	printf("Don't define compress option!\n");
   	fclose(fptr);
   	return FALSE;
   }
   
   if (strcasecmp(verify, "1") == 0)				//verify
   	strcpy(verify_cmd, " -W -C /");
   else if (strcasecmp(verify, "0") == 0)
   	strcpy(verify_cmd, "");
   else {
   	printf("Don't define verify option!\n");
   	fclose(fptr);
   	return FALSE;
   } 	
  
   if (strcasecmp(incremented, "1") == 0) {			//incremented
   	strcpy(incremented_cmd, " -g");
   	Tape_Transfer_Sp_Char(src, isrc);			// 09-16-2002, Johnson modify
   	find_incremented_file_ex_1(isrc, incremented_file);	// 09-16-2002, Johnson modify
   }	
   else if (strcasecmp(incremented, "0") == 0) {
   	strcpy(incremented_cmd, " -g");
   	Tape_Transfer_Sp_Char(src, isrc);			// 09-16-2002, Johnson modify
   	find_incremented_file_ex_1(isrc, incremented_file);	// 09-16-2002, Johnson modify
   	if (strcasecmp(incremented_file,"") != 0) {
   		sprintf(sys_cmd, "rm -f %s", incremented_file);
   		system(sys_cmd);
   	}
   }	   	
   else {
   	printf("Don't define incremented option!\n");
   	fclose(fptr);
   	return FALSE;
   }

   if (strcasecmp(incremented_file, "") == 0)
      strcpy(incremented_cmd, "");

#if	BACKUP_FROM_SNAPSHOT
   sprintf(tar_cmd, "%s cvf %s %s -V%s%s%s%s%s%s %s %s %s %s %s %s %s > /dev/null 2>&1",
   	TAPE_TAR_PATH, dest, Tape_Transfer_Instead_Sp_Char(src_buf), label_cmd, compress_cmd,
   	verify_cmd, multi_volume_cmd, incremented_cmd, incremented_file, TAPE_TAR_FLAG_a_FILE,
   	TAPE_TAR_FLAG_j_FILE, TAPE_TAR_FLAG_q_FILE, TAPE_TAR_FLAG_H_FILE,
   	TAPE_TAR_FLAG_Q_FILE, TAPE_TAR_FLAG_D_FILE, TAPE_TAR_FLAG_L_CMD);
#else
   sprintf(tar_cmd, "%s cvf %s %s -V%s%s%s%s%s%s %s %s %s %s %s %s %s %s > /dev/null 2>&1",
   	TAPE_TAR_PATH, dest, Tape_Transfer_Instead_Sp_Char(src_buf), label_cmd, compress_cmd,
   	verify_cmd, multi_volume_cmd, incremented_cmd, incremented_file, TAPE_TAR_FLAG_a_FILE,
   	TAPE_TAR_FLAG_e_FILE, TAPE_TAR_FLAG_j_FILE, TAPE_TAR_FLAG_q_FILE, TAPE_TAR_FLAG_H_FILE,
   	TAPE_TAR_FLAG_Q_FILE, TAPE_TAR_FLAG_D_FILE, TAPE_TAR_FLAG_L_CMD);	// 09-17-2002, Johnson Modify
#endif
//                           d  s    l c v m i f  a  e  j  q  H  Q  D  L 
   fprintf(fptr, "%s\n", tar_cmd);
   sprintf(chmod_cmd, "/bin/chmod 755 %s", file_name);
   system(chmod_cmd);
   fclose(fptr);
   return TRUE;   
}

void Tar_Cmd_Xvf(char *src, char *dest, char *keep_old_files)
{
   	char tar_cmd[LSTR_LENGTH];
   	char dest_cmd[MSTR_LENGTH];
   	char multi_volume_cmd[8]=" -M";
   	char relative_path_cmd[8]=" -y";    
   	char keep_old_files_cmd[8]=""; 
   	char compress_cmd[8]="";  
 
        if (strcasecmp(keep_old_files, "1") == 0)		//keep_old_files
	   	strcpy(keep_old_files_cmd, " -k");
	else if (strcasecmp(keep_old_files, "0") == 0)
	   	strcpy(keep_old_files_cmd, "");
	else {
	   	printf("Don't define keep-old-files option!\n");
	   	return;
	}
   
	if (strcasecmp(dest, "") == 0)			//dest
	   	strcpy(dest_cmd, "");
	else 
	   	sprintf(dest_cmd, " -C%s", dest);

	sprintf(tar_cmd, "%s xvf %s%s%s%s%s%s %s %s %s %s %s %s %s %s > /dev/null 2>&1", TAPE_TAR_PATH, src, multi_volume_cmd, keep_old_files_cmd, compress_cmd, dest_cmd, relative_path_cmd, TAPE_TAR_FLAG_a_FILE, TAPE_TAR_FLAG_e_FILE, TAPE_TAR_FLAG_j_FILE, TAPE_TAR_FLAG_q_FILE, TAPE_TAR_FLAG_H_FILE, TAPE_TAR_FLAG_Q_FILE, TAPE_TAR_FLAG_D_FILE, TAPE_TAR_FLAG_L_CMD);
//		                     s m k c d r  a  e  j  q  H  Q  D  L
	system(tar_cmd);
}

int Tape_Get_Default_Restore_Dir(char *src, char *retdir, int length)
{
	TAPE_INFO *tape_info=NULL;

	Tar_Cmd_Tvf(src);
	tape_info = Tape_Get_Tape_Info();
	if ((strlen(tape_info->source)) > length)
		return -1;
	else
		strcpy(retdir, tape_info->source);
			
	Tape_Free_Tape_Info(tape_info);
	
	return 0;
}

BOOL Tape_Exist_Default_Restore_Dir(char *source)
{
	TAPE_BACKUP_SHARE_DIR_INFO *tape_backup_share_dir_info, *tape_backup_share_dir_start;
	tape_backup_share_dir_info = Tape_Backup_Share_Dir_Info(); 
	tape_backup_share_dir_start = tape_backup_share_dir_info;
		
	while(tape_backup_share_dir_info != NULL) {
		if (!strcasecmp(tape_backup_share_dir_info->share_path, source))
			return TRUE;

		tape_backup_share_dir_info = tape_backup_share_dir_info->next;
	}
				
	Tape_Free_Backup_Share_Dir_Info(tape_backup_share_dir_start);// erase memory
	
	return FALSE;	
}

void Tar_Cmd_Tvf(char *src)
{	
   char tar_cmd[LSTR_LENGTH]; 

   sprintf(tar_cmd, "%s tvf %s %s %s %s %s> /dev/null 2>&1", TAPE_TAR_PATH, src, TAPE_TAR_FLAG_n_FILE, TAPE_TAR_FLAG_t_FILE, TAPE_TAR_FLAG_D_FILE, TAPE_TAR_FLAG_H_FILE);
//                           s  n  t  D  H
   system(tar_cmd);
}

void Tar_Cmd_Tvf_For_Compress(char *src)
{	
   char tar_cmd[LSTR_LENGTH]; 
   char compress_cmd[4]="-z"; 

   sprintf(tar_cmd, "%s tvf %s %s %s %s %s %s> /dev/null 2>&1", TAPE_TAR_PATH, src, compress_cmd, TAPE_TAR_FLAG_n_FILE, TAPE_TAR_FLAG_t_FILE, TAPE_TAR_FLAG_D_FILE, TAPE_TAR_FLAG_H_FILE);
//                           s  c  n  t  D  H
   	system(tar_cmd);	
}

void Tar_Cmd_Tvf_Test(char *src)
{
	
   char tar_cmd[LSTR_LENGTH]; 
   char compress_cmd[4]="-z"; 
  
   sprintf(tar_cmd, "%s tvf %s %s %s %s %s> /dev/null 2>&1", TAPE_TAR_PATH, src, TAPE_TAR_FLAG_n_FILE, TAPE_TAR_FLAG_t_FILE, TAPE_TAR_FLAG_D_FILE, TAPE_TAR_FLAG_H_FILE);
//                           s  n  t  D  H
   system(tar_cmd);

   if (Tape_Test_Log_Occur_Error(TAPE_TAR_t_FILE)) {
  		sprintf(tar_cmd, "%s tvf %s %s %s %s %s %s> /dev/null 2>&1", TAPE_TAR_PATH, src, compress_cmd, TAPE_TAR_FLAG_n_FILE, TAPE_TAR_FLAG_t_FILE, TAPE_TAR_FLAG_D_FILE, TAPE_TAR_FLAG_H_FILE);
//     	                                  s  c  n  t  D	 H
                system(tar_cmd);
   }

}

BOOL Tape_Test_Log_Occur_Error(char *log_src)
{	
	TAPE_LOG_INFO *tape_log_info, *tape_log_start;
	
	tape_log_info = Tape_Get_Test_Log_Info(); 
	tape_log_start = tape_log_info;
		
	while(tape_log_info != NULL) {
		if ( strcasecmp(tape_log_info->type, "ERROR") == 0 ) {
			return TRUE;
		}	
		tape_log_info = tape_log_info->next;
	}
				
	Tape_Free_Log_Info(tape_log_start);// erase memory
		
	return FALSE;
}

BOOL Tape_Test_Source_Compress(char *src)
{
	int result=1;
	TAPE_INFO *tape_info=NULL;
	
	Tar_Cmd_Tvf_Test(src);
	tape_info = Tape_Get_Tape_Info();
	
	if (strcasecmp(tape_info->compress, "Non-Compress")==0)
		result = 0;
	else if (strcasecmp(tape_info->compress, "Compress")==0)
		result = 1;

	Tape_Free_Tape_Info(tape_info);
	
	if (result == 1)
		return TRUE;
	else
		return FALSE;
}
#if 0
void erase_char(char *origin)
{
        char *start, *ptr;

        if (strlen(origin)==0)
                return;
        start=ptr=origin;
        ptr=origin+strlen(origin);
        while (*start==' ' || *start=='	' || *start==0x0d || *start==0x0a)
                start++;
        ptr--;
        while (*ptr==' ' || *ptr=='	' || *ptr==0x0d || *ptr==0x0a)
                ptr--;
        *(ptr+1)=0x0;
        ptr=origin;
        while (*start)
                *ptr++=*start++;
        *ptr=0x0;
}
#endif

TAPE_LOG_INFO *Tape_Get_Log_Info()
{
	FILE 		*fptrq;
	TAPE_LOG_INFO	*start=NULL, *prev=NULL ,*current=NULL;
	char		line[TAPE_LINE], *ptrf, *ptrl, tmp[TAPE_LINE]="";
	int count=0;		

	if ((fptrq=fopen(TAPE_TAR_q_FILE, "r"))==NULL)
		return NULL;

	if (fgets(line, TAPE_LINE, fptrq)== NULL) {
		fclose(fptrq);
		return NULL;
	}
		
	while (!feof(fptrq))
	{
		erase_char(line);
		
		if ((current = calloc(1, sizeof(TAPE_LOG_INFO)))==NULL) {
			fclose(fptrq);
			return NULL;
		}			
		else {
                	ptrf = strstr(line, "[");		//id
                	ptrl = strstr(line, "]");
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);			
			current->id=atoi(tmp);
			
                	ptrf = strstr(ptrf+1, "[");		//time_stamp
                	ptrl = strstr(ptrf, "]");               			    			                	
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);
			strcpy(current->time_stamp,tmp);
			
			ptrf = strstr(ptrl+1, "[");		//type
                	ptrl = strstr(ptrf, "]"); 
//for debug			printf("ptrf+1 %x, *ptrf+1 %s\n", ptrf+1, (ptrf+1));
//for debug			printf("ptrl+1 %x, *ptrl %s\n", ptrl, ptrl);          	
                	*ptrl = 0x0;                	            	                         		             			    			                              	       	
			strcpy(current->type,ptrf+1);

			strcpy(current->msg,ptrl+2);		//msg			

			if (++count == 1)			//linking list header
				start = current;		
			else
				prev->next = current;		//linking list body

			prev = current;				//linking list prev ptr
		}
		fgets(line, TAPE_LINE, fptrq);
	}	
	fclose(fptrq);	
	return start;
}

TAPE_LOG_INFO *Tape_Get_Test_Log_Info()
{
	FILE 		*fptrq;
	TAPE_LOG_INFO	*start=NULL, *prev=NULL ,*current=NULL;
	char		line[TAPE_LINE], *ptrf, *ptrl, tmp[TAPE_LINE]="";
	int count=0;		

	if ((fptrq=fopen(TAPE_TAR_t_FILE, "r"))==NULL)
		return NULL;

	if (fgets(line, TAPE_LINE, fptrq)== NULL)
		return NULL;
		
	while (!feof(fptrq))
	{
		erase_char(line);
		
		if ((current = calloc(1, sizeof(TAPE_LOG_INFO)))==NULL) {
			fclose(fptrq);				
			return NULL;				
		}
		else {
                	ptrf = strstr(line, "[");		//id
                	ptrl = strstr(line, "]");
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);			
			current->id=atoi(tmp);
			
                	ptrf = strstr(ptrf+1, "[");		//time_stamp
                	ptrl = strstr(ptrf, "]");               			    			                	
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);
			strcpy(current->time_stamp,tmp);
			
			ptrf = strstr(ptrl+1, "[");		//type
                	ptrl = strstr(ptrf, "]"); 
//for debug			printf("ptrf+1 %x, *ptrf+1 %s\n", ptrf+1, (ptrf+1));
//for debug			printf("ptrl+1 %x, *ptrl %s\n", ptrl, ptrl);          	
                	*ptrl = 0x0;                	            	                         		             			    			                              	       	
			strcpy(current->type,ptrf+1);

			strcpy(current->msg,ptrl+2);		//msg			

			if (++count == 1)			//linking list header
				start = current;		
			else
				prev->next = current;		//linking list body

			prev = current;				//linking list prev ptr
		}
		fgets(line, TAPE_LINE, fptrq);
	}	
	fclose(fptrq);	
	return start;
}	

void Tape_Free_Log_Info(TAPE_LOG_INFO *tape_log_info)
{
	TAPE_LOG_INFO *current;
	
	current = tape_log_info;
	while (tape_log_info != NULL)
	{
		tape_log_info = tape_log_info->next;
		free(current);
		current = tape_log_info;
	}
}

int Tape_Get_History_Log_Info_Total()
{
	FILE 		*fptrD;
	int 		count=0;	
	char		line[TAPE_LINE];	

	if ((fptrD=fopen(TAPE_TAR_D_FILE, "r+"))==NULL)
		return -1;

	while (fgets(line, TAPE_LINE, fptrD)!= NULL) {
		
		count++;		
	}
	
	fclose(fptrD);	
	return count;
}

int Tape_Get_History_Log_Info_Total_By_Case(char *condition)
{
	TAPE_LOG_INFO *tape_log_info, *tape_log_start;
	int count = 0;
		
	tape_log_info = Tape_Get_History_Log_Info();
	tape_log_start = tape_log_info;
		
	while(tape_log_info != NULL) {
		if (!strcasecmp(condition, "ALL"))
			count++;
		else if (!strcasecmp(tape_log_info->type, condition))
				count++;		
		tape_log_info = tape_log_info->next;					
	}
				
	Tape_Free_History_Log_Info(tape_log_start);// erase memory
	return count;
}

int Tape_Get_History_Log_Info_Total_Page_By_Case(char *condition)
{
	div_t result;
	
	result = div(Tape_Get_History_Log_Info_Total_By_Case(condition), TAPE_HISTORY_LOG_PER_PAGE_NUM);
	
	if (result.rem != 0)
		result.quot++;
		
	return result.quot;
}

TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Case_and_Page(char *condition, int page)
{
	FILE 		*fptrD;
	TAPE_LOG_INFO	*start=NULL, *prev=NULL ,*current=NULL;
	char		line[TAPE_LINE], *ptrf, *ptrl, tmp[TAPE_LINE]="", cond_buf[SSTR_LENGTH];
	int count=0, start_ret_count, end_ret_count;		

	start_ret_count = (page-1)*TAPE_HISTORY_LOG_PER_PAGE_NUM+1;
	end_ret_count = page*TAPE_HISTORY_LOG_PER_PAGE_NUM;
	sprintf(cond_buf, "[%s]", condition);

	if ((fptrD=fopen(TAPE_TAR_D_FILE, "r+"))==NULL)
		return NULL;

	if (fgets(line, TAPE_LINE, fptrD)== NULL)
		return NULL;

	while (!feof(fptrD))
	{
		erase_char(line);
		
		if (strcasecmp(condition, "ALL")) {                        	// compare get all log: A. get special log, B. get all log
			if (!strstr(line, cond_buf)) {				// get special log
				if (fgets(line, TAPE_LINE, fptrD)== NULL)  
					break;				
				continue;	
			}	
			else if (++count < start_ret_count) {
				if (fgets(line, TAPE_LINE, fptrD)== NULL)
					break;			
				continue;
			}			
			else if (count > end_ret_count)
				return start;
		}
		else {								// get all log
			if (++count < start_ret_count) {
				if (fgets(line, TAPE_LINE, fptrD)== NULL)
					break;			
				continue;
			}			
			else if (count > end_ret_count) {
				fclose(fptrD);	
				return start;	
			}		
		}	

		if ((current = calloc(1, sizeof(TAPE_LOG_INFO)))==NULL) {
			fclose(fptrD);	
			return NULL;
		}				
		else {
                	ptrf = strstr(line, "[");		//id
                	ptrl = strstr(line, "]");
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);			
			current->id=atoi(tmp);
			
                	ptrf = strstr(ptrf+1, "[");		//time_stamp
                	ptrl = strstr(ptrf, "]");               			    			                	
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);
			strcpy(current->time_stamp,tmp);
			
			ptrf = strstr(ptrl+1, "[");		//type
                	ptrl = strstr(ptrf, "]");     	
                	*ptrl = 0x0;                	            	                         		             			    			                              	       	
			strcpy(current->type,ptrf+1);

			strcpy(current->msg,ptrl+2);		//msg			

			if (count == start_ret_count)		//linking list header
				start = current;		
			else
				prev->next = current;		//linking list body

			prev = current;				//linking list prev ptr
		}
		fgets(line, TAPE_LINE, fptrD);
		
	}	
	fclose(fptrD);	
	return start;
}

TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Page(int page)
{
	FILE 		*fptrD;
	TAPE_LOG_INFO	*start=NULL, *prev=NULL ,*current=NULL;
	char		line[TAPE_LINE], *ptrf, *ptrl, tmp[TAPE_LINE]="";
	int count=0, start_ret_count, end_ret_count;		

	start_ret_count = (page-1)*TAPE_HISTORY_LOG_PER_PAGE_NUM+1;
	end_ret_count = page*TAPE_HISTORY_LOG_PER_PAGE_NUM;

	if ((fptrD=fopen(TAPE_TAR_D_FILE, "r+"))==NULL)
		return NULL;

	if (fgets(line, TAPE_LINE, fptrD)== NULL) {
		fclose(fptrD);			
		return NULL;
	}

	while (!feof(fptrD))
	{
		erase_char(line);
				
		if (++count < start_ret_count) {
			if (fgets(line, TAPE_LINE, fptrD)== NULL)
				break;			
			continue;
		}			
		else if (count > end_ret_count)
			return start;	

		if ((current = calloc(1, sizeof(TAPE_LOG_INFO)))==NULL) {
			fclose(fptrD);	
			return NULL;				
		}	
		else {
                	ptrf = strstr(line, "[");		//id
                	ptrl = strstr(line, "]");
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);			
			current->id=atoi(tmp);
			
                	ptrf = strstr(ptrf+1, "[");		//time_stamp
                	ptrl = strstr(ptrf, "]");               			    			                	
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);
			strcpy(current->time_stamp,tmp);
			
			ptrf = strstr(ptrl+1, "[");		//type
                	ptrl = strstr(ptrf, "]");     	
                	*ptrl = 0x0;                	            	                         		             			    			                              	       	
			strcpy(current->type,ptrf+1);

			strcpy(current->msg,ptrl+2);		//msg			

			if (count == start_ret_count)		//linking list header
				start = current;		
			else
				prev->next = current;		//linking list body

			prev = current;				//linking list prev ptr
		}
		fgets(line, TAPE_LINE, fptrD);
	}	
	fclose(fptrD);	
	return start;
}

TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Case(char *condition)
{
	FILE 		*fptrD;
	TAPE_LOG_INFO	*start=NULL, *prev=NULL ,*current=NULL;
	char		line[TAPE_LINE], *ptrf, *ptrl, tmp[TAPE_LINE]="", cond_buf[SSTR_LENGTH]="";
	int count=0;		

	sprintf(cond_buf, "[%s]", condition);

	if ((fptrD=fopen(TAPE_TAR_D_FILE, "r+"))==NULL)
		return NULL;

	if (fgets(line, TAPE_LINE, fptrD)== NULL) {
		fclose(fptrD);	
		return NULL;
	}
		
	while (!feof(fptrD))
	{
		erase_char(line);
		
		if (strcasecmp(cond_buf, "[ALL]")) {
			if (strstr(line, cond_buf) == 0) {
				fgets(line, TAPE_LINE, fptrD);
				continue;
			}
		}	
		
		if ((current = calloc(1, sizeof(TAPE_LOG_INFO)))==NULL) {
			fclose(fptrD);	
			return NULL;				
		}
		else {
                	ptrf = strstr(line, "[");		//id
                	ptrl = strstr(line, "]");
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);			
			current->id=atoi(tmp);
			
                	ptrf = strstr(ptrf+1, "[");		//time_stamp
                	ptrl = strstr(ptrf, "]");               			    			                	
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);
			strcpy(current->time_stamp,tmp);
			
			ptrf = strstr(ptrl+1, "[");		//type
                	ptrl = strstr(ptrf, "]");   	
                	*ptrl = 0x0;                	            	                         		             			    			                              	       	
			strcpy(current->type,ptrf+1);

			strcpy(current->msg,ptrl+2);		//msg			

			if (++count == 1)			//linking list header
				start = current;		
			else
				prev->next = current;		//linking list body

			prev = current;				//linking list prev ptr
		}
		fgets(line, TAPE_LINE, fptrD);
	}	
	fclose(fptrD);	
	return start;
}

TAPE_LOG_INFO *Tape_Get_History_Log_Info()
{
	FILE 		*fptrD;
	TAPE_LOG_INFO	*start=NULL, *prev=NULL ,*current=NULL;
	char		line[TAPE_LINE], *ptrf, *ptrl, tmp[TAPE_LINE]="";
	int count=0;		

	if ((fptrD=fopen(TAPE_TAR_D_FILE, "r+"))==NULL)
		return NULL;

	if (fgets(line, TAPE_LINE, fptrD)== NULL) {
		fclose(fptrD);	
		return NULL;
	}
		
	while (!feof(fptrD))
	{
		erase_char(line);
		
		if ((current = calloc(1, sizeof(TAPE_LOG_INFO)))==NULL) {
			fclose(fptrD);	
			return NULL;
		}				
		else {
                	ptrf = strstr(line, "[");		//id
                	ptrl = strstr(line, "]");
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);			
			current->id=atoi(tmp);
			
                	ptrf = strstr(ptrf+1, "[");		//time_stamp
                	ptrl = strstr(ptrf, "]");               			    			                	
                	strncpy(tmp, ptrf+1, ptrl-ptrf-1);
			strcpy(current->time_stamp,tmp);
			
			ptrf = strstr(ptrl+1, "[");		//type
                	ptrl = strstr(ptrf, "]"); 
//for debug		printf("ptrf+1 %x, *ptrf+1 %s\n", ptrf+1, (ptrf+1));
//for debug		printf("ptrl+1 %x, *ptrl %s\n", ptrl, ptrl);          	
                	*ptrl = 0x0;                	            	                         		             			    			                              	       	
			strcpy(current->type,ptrf+1);

			strcpy(current->msg,ptrl+2);		//msg			

			if (++count == 1)			//linking list header
				start = current;		
			else
				prev->next = current;		//linking list body

			prev = current;				//linking list prev ptr
		}
		fgets(line, TAPE_LINE, fptrD);
	}	
	fclose(fptrD);	
	return start;
}	

BOOL Tape_Clear_History_Log()
{
	FILE 		*fptrD;

	if ((fptrD=fopen(TAPE_TAR_D_FILE, "w+"))==NULL)
		return FALSE;

	fclose(fptrD);
	return TRUE;
}

BOOL Tape_Clear_Cron_Job_List()
{
	FILE 		*fptrc;

	if ((fptrc=fopen(TAPE_CRONTAB_FILE, "w+"))==NULL)
		return FALSE;

	fclose(fptrc);
	return TRUE;
}	

void Tape_Free_History_Log_Info(TAPE_LOG_INFO *tape_log_info)
{
	TAPE_LOG_INFO *current;
	
	current = tape_log_info;
	while (tape_log_info != NULL)
	{
		tape_log_info = tape_log_info->next;
		free(current);
		current = tape_log_info;
	}
}

TAPE_MOUNTS_INFO *Tape_Get_Mounts_Info()
{
	FILE 			*fptr;
	TAPE_MOUNTS_INFO	*start=NULL, *prev=NULL ,*current=NULL;

	int  count=0;
	char dev_path[SSTR_LENGTH];	
	char mount_path[SSTR_LENGTH];	
	char tmp1_path[SSTR_LENGTH];
	char tmp2_path[SSTR_LENGTH];
	char tmp3_path[SSTR_LENGTH];
	char tmp4_path[SSTR_LENGTH];						

	if ((fptr=fopen(TAPE_MOUNTS_FILE, "r"))==NULL)
		return NULL;

	while (!feof(fptr))
	{
		fscanf(fptr, "%s %s %s %s %s %s", dev_path, mount_path, tmp1_path, tmp2_path, tmp3_path, tmp4_path);	
		
		if ((current = calloc(1, sizeof(TAPE_MOUNTS_INFO)))==NULL) {
			fclose(fptr);	
			return NULL;	
		}			
		else {
			if (++count == 1)
				start = current;
			else
				prev->next = current;

			strcpy(current->dev_path, dev_path);
			strcpy(current->mount_path, mount_path);
			prev = current;
		}
		
	}
	
	fclose(fptr);	
	return start;
}																				

TAPE_MOUNTS_SHARE_VOLUME_INFO *Tape_Get_Mounts_Share_Volume_Info()
{
// Catherine 2003/03/19
//	TAPE_MOUNTS_INFO *tape_mounts_share_info, *tape_mounts_share_start;
	TAPE_MOUNTS_SHARE_VOLUME_INFO	*start=NULL, *prev=NULL ,*current=NULL;	
// Catherine 2003/03/19
//	VOLUME_INFO_EX *vol_info_list;
	LVM_VOLUME_INFO *vol_info_list = NULL;
	
	int ret, i, j;
	int count = 0;

#ifdef DEBUG_TAPE
	printf("Start Debug Tape\n");
#endif

// Catherine 2003/03/19
//	tape_mounts_share_info = Tape_Get_Mounts_Share_Info(); 
//	tape_mounts_share_start = tape_mounts_share_info;
		
// Catherine 2003/03/19
//		while(tape_mounts_share_info != NULL) {
//			ret = Get_All_Configured_Vol_For_Share_Ex_2(&vol_info_list);
			ret = Get_All_LVM_Configured_Vol_For_Share(&vol_info_list);

			for (i=0; i<ret; i++) {
// Catherine 2003/03/19
//				if (strcasecmp(vol_info_list[i].vol_data.device_name, tape_mounts_share_info->dev_path)==0)
//				{
					if ((current = calloc(1, sizeof(TAPE_MOUNTS_SHARE_VOLUME_INFO)))== NULL)
						return NULL;				
					else {
						if (++count == 1)
							start = current;
						else 
							prev->next = current;

						current->vol_no = vol_info_list[i].vol_data.vol_no;
						current->raid_level = vol_info_list[i].vol_data.raid_level;
							
						for (j=0; j< vol_info_list[i].vol_data.list_cnt;j++)
							current->drive_no_list[j] = vol_info_list[i].vol_data.drive_no_list[j];
														
						current->list_cnt = vol_info_list[i].vol_data.list_cnt;
// Catherine 2003/03/19 ==>
						for (j=0; j< vol_info_list[i].vol_data.spare_list_cnt;j++)
							current->spare_drive_list[j] = vol_info_list[i].vol_data.spare_drive_list[j];
														
						current->spare_list_cnt = vol_info_list[i].vol_data.spare_list_cnt;
// <== Catherine 2003/03/19
						current->status = vol_info_list[i].vol_data.status;							
// Catherine 2003/03/19 ==>
//						strcpy(current->dev_path, tape_mounts_share_info->dev_path);
//						strcpy(current->mount_path, tape_mounts_share_info->mount_path);
						if (Is_LV_Exist(vol_info_list[i].vol_data.lv_name))
							strcpy(current->dev_path, vol_info_list[i].vol_data.lv_name);
						else
							strcpy(current->dev_path, vol_info_list[i].vol_data.device_name);
						Get_Mount_Point(current->dev_path, current->mount_path);
// <== Catherine 2003/03/19
						current->total_size = vol_info_list[i].total_size;
						current->free_size = vol_info_list[i].free_size;
//for debug					
					/*		
					printf("Volume %d =======\n", i);
					printf("vol_no=%d, %d\n",
						vol_info_list[i].vol_data.vol_no, current->vol_no);
					printf("device_name=%s %s\n",
						vol_info_list[i].vol_data.device_name, current->dev_path);
					printf("raid_level=%d, %d\n",
						vol_info_list[i].vol_data.raid_level, current->raid_level);
					printf("drive list count=%d, %d\n",
						vol_info_list[i].vol_data.list_cnt, current->list_cnt);
					printf("drive no list = ");
					for (j=0; j< vol_info_list[i].vol_data.list_cnt;j++)
						printf("(%d , %d) ",vol_info_list[i].vol_data.drive_no_list[j], current->drive_no_list[j]);
					printf("\n");
					printf("spare list count=%d\n",
						vol_info_list[i].vol_data.spare_list_cnt);
					printf("spare drive no list = ");
					for (j=0; j< vol_info_list[i].vol_data.spare_list_cnt;j++)
						printf("%d ",vol_info_list[i].vol_data.spare_drive_list[j]);
					printf("\n");
					printf("status=%d\n",
						vol_info_list[i].vol_data.status);
					printf("total_size=%f, %f\n",
						vol_info_list[i].total_size, current->total_size);
					printf("free_size=%f, %f\n",
						vol_info_list[i].free_size, current->free_size);
					printf("resync_per=%d\n",
						vol_info_list[i].resync_per);	
					printf("tape_mounts_share_info->dev_path: 			%s\n", tape_mounts_share_info->dev_path);
					printf("tape_mounts_share_info->mount_path: 			%s\n", tape_mounts_share_info->mount_path);	
					*/													
						prev = current;
					} //else
// Catherine 2003/03/19
//				} //if
			} //for	
/* Catherine 2003/03/19
			if (ret>0) Release_List(vol_info_list);
			if (ret>0) Release_LVM_Info_List(vol_info_list, ret);
		
			tape_mounts_share_info = tape_mounts_share_info->next;
		}

	Tape_Free_Mounts_Info(tape_mounts_share_start);// erase memory	
*/	
	return start;	
}

void Tape_Free_Mounts_Share_Volume_Info(TAPE_MOUNTS_SHARE_VOLUME_INFO *tape_mounts_share_volume_info)
{
	TAPE_MOUNTS_SHARE_VOLUME_INFO *current;
	
	current = tape_mounts_share_volume_info;
	while (tape_mounts_share_volume_info != NULL)
	{
		tape_mounts_share_volume_info = tape_mounts_share_volume_info->next;
		free(current);
		current = tape_mounts_share_volume_info;
	}
}						

TAPE_MOUNTS_INFO *Tape_Get_Mounts_Root_Info()
{
	FILE 			*fptr;
	TAPE_MOUNTS_INFO	*start=NULL, *prev=NULL ,*current=NULL;

	int  count=0;
	char dev_path[SSTR_LENGTH];	
	char mount_path[SSTR_LENGTH];	
	char tmp1_path[SSTR_LENGTH];
	char tmp2_path[SSTR_LENGTH];
	char tmp3_path[SSTR_LENGTH];
	char tmp4_path[SSTR_LENGTH];						

	if ((fptr=fopen(TAPE_MOUNTS_FILE, "r"))==NULL)
		return NULL;

	while (!feof(fptr))
	{
		fscanf(fptr, "%s %s %s %s %s %s", dev_path, mount_path, tmp1_path, tmp2_path, tmp3_path, tmp4_path);	
		
		if (strstr(mount_path, "ROOT") == NULL)
		   continue;
		
		if ((current = calloc(1, sizeof(TAPE_MOUNTS_INFO)))==NULL) {
			fclose(fptr);				
			return NULL;	
		}			
		else {
			if (++count == 1)
				start = current;
			else
				prev->next = current;

			strcpy(current->dev_path, dev_path);
			strcpy(current->mount_path, mount_path);
			prev = current;
		}
		
	}
	
	fclose(fptr);	
	return start;
}	
	
TAPE_MOUNTS_INFO *Tape_Get_Mounts_Share_Info()
{
	FILE 			*fptr;
	TAPE_MOUNTS_INFO	*start=NULL, *prev=NULL ,*current=NULL;

	int  count=0;
	char dev_path[SSTR_LENGTH];	
	char mount_path[SSTR_LENGTH];	
	char tmp1_path[SSTR_LENGTH];
	char tmp2_path[SSTR_LENGTH];
	char tmp3_path[SSTR_LENGTH];
	char tmp4_path[SSTR_LENGTH];						

	if ((fptr=fopen(TAPE_MOUNTS_FILE, "r"))==NULL)
		return NULL;

	while (!feof(fptr))
	{
		strcpy(mount_path,"");   //prevent to read the null line
		fscanf(fptr, "%s %s %s %s %s %s", dev_path, mount_path, tmp1_path, tmp2_path, tmp3_path, tmp4_path);	
		
		if (strstr(mount_path, "share") == NULL)
		   continue;
		
		if ((current = calloc(1, sizeof(TAPE_MOUNTS_INFO))) == NULL) {
			fclose(fptr);			
			return NULL;				
		}
		else {
			if (++count == 1)
				start = current;
			else
				prev->next = current;

			strcpy(current->dev_path, dev_path);
			strcpy(current->mount_path, mount_path);
			prev = current;
		}
		
	}
	
	fclose(fptr);	
	return start;
}	
		
void Tape_Free_Mounts_Info(TAPE_MOUNTS_INFO *tape_mounts_info)
{
	TAPE_MOUNTS_INFO *current;
	
	current = tape_mounts_info;
	while (tape_mounts_info != NULL)
	{
		tape_mounts_info = tape_mounts_info->next;
		free(current);
		current = tape_mounts_info;
	}
}

TAPE_BACKUP_SHARE_DIR_INFO *Tape_Backup_Share_Dir_Info()
{
	TAPE_BACKUP_SHARE_DIR_INFO	*start=NULL, *prev=NULL ,*current=NULL;
	TAPE_MOUNTS_SHARE_VOLUME_INFO 	*tape_mounts_share_volume_info, *tape_mounts_share_volume_start;		
	SMB_SHARE_INFO 			*smb_info,*smb_start;
	char tmp[MSTR_LENGTH]="";
	int  count=0, j;
	
//part A: find share volume (begin)	
	tape_mounts_share_volume_info = Tape_Get_Mounts_Share_Volume_Info(); 
	tape_mounts_share_volume_start = tape_mounts_share_volume_info;					

	while(tape_mounts_share_volume_info != NULL) {		

		if ((current = calloc(1, sizeof(TAPE_BACKUP_SHARE_DIR_INFO)))==NULL)
			return NULL;				
		else {
			if (++count == 1)
				start = current;
			else
				prev->next = current;
//copy work (begin)
			switch(tape_mounts_share_volume_info->raid_level) {

			case 0	: //strip
				strcpy(tmp, "strip "); 
				break;
			case 1	: //mirror
				strcpy(tmp, "mirror "); 
				break;
			case 4	: //raid 5
			case 5	: //raid 5
				strcpy(tmp, "raid5 "); 
				break;
			case -1	: //linear
				strcpy(tmp, "linear "); 
          			break;
  			case -2 : // single
       				strcpy(tmp, "single ");
				break;		
			default : //unknow type
				strcpy(tmp, "unknow-type ");
				break;
			} //switch
		
			for (j=0; j< tape_mounts_share_volume_info->list_cnt;j++)
				sprintf(tmp,"%s%d",tmp, tape_mounts_share_volume_info->drive_no_list[j]);

// Catherine 2003/03/19 ==>
			if (tape_mounts_share_volume_info->spare_list_cnt>0)
				strcat(tmp, " ");

			for (j=0; j< tape_mounts_share_volume_info->spare_list_cnt;j++)
				sprintf(tmp,"%s%d",tmp, tape_mounts_share_volume_info->spare_drive_list[j]);
// <== Catherine 2003/03/19
			strcpy(current->share_type, "disk");
			strcpy(current->share_name, tmp);
			strcpy(current->share_path, tape_mounts_share_volume_info->mount_path);			
//copy work (end)	
			prev = current;
		} //else
		tape_mounts_share_volume_info = tape_mounts_share_volume_info->next;	
	} //while
	Tape_Free_Mounts_Share_Volume_Info(tape_mounts_share_volume_start);// erase memory
//part A: find share volume (end)
	
//part B: find share SMB (begin)	
	smb_info = SMB_Get_Share_Info();
	smb_start = smb_info;

	while(smb_info != NULL) {		

		if ((current = calloc(1, sizeof(TAPE_BACKUP_SHARE_DIR_INFO)))==NULL)
			return NULL;				
		else {
			if (++count == 1)
				start = current;
			else
				prev->next = current;
//copy work (begin)
			strcpy(current->share_type, "share");
			strcpy(current->share_name, smb_info->sharename);
			strcpy(current->share_path, smb_info->path);			
//copy work (end)	
			prev = current;
		} //else
		smb_info = smb_info->next;	
	} //while
	SMB_Free_Share_Info(smb_start); // erase memory
//part B: find share SMB (end)		
	return start;
}	

		
void Tape_Free_Backup_Share_Dir_Info(TAPE_BACKUP_SHARE_DIR_INFO *tape_backup_share_dir_info)
{
	TAPE_BACKUP_SHARE_DIR_INFO *current;
	
	current = tape_backup_share_dir_info;
	while (tape_backup_share_dir_info != NULL)
	{
		tape_backup_share_dir_info = tape_backup_share_dir_info->next;
		free(current);
		current = tape_backup_share_dir_info;
	}
}

void Tape_Set_New_Cron_Job(char *task_name, char *source, char *type,
	 int compress, int verify, int day, char *weekly, int monthly, int hh, int mm)
{
	FILE 	*fptr;
	char	type_buf[SSTR_LENGTH];
	int 	id;
	char    tape_cmd[SSTR_LENGTH];
	
	if (strcasecmp(type, "1") == 0)			//1:Full
		strcpy(type_buf, "Full");
	else if (strcasecmp(type, "0") == 0)		//0:Incremental
		strcpy(type_buf, "Incremental");
	else	strcpy(type_buf, "Unknow");
	
	if ((fptr=fopen(TAPE_CRONTAB_FILE, "a+"))==NULL)
		return;

	id = Tape_Find_Unoccupied_Id();
	
	sprintf(tape_cmd, "%d.sh", id);

	fprintf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d\n", 
		id, task_name, Tape_Invert_Sp_Char(source), type_buf, compress, verify, day, weekly, monthly, hh, mm, tape_cmd, TAPE_JOB_READY_STATUS, TAPE_JOB_DEFAULT_PID);		// 08-17-2002, Johnson Modify

	fclose(fptr);
	
	Tape_Set_Cron_Job_Srcipt(task_name); //new_add	
}

BOOL Tape_Test_Included_Sp (char *str)
{
	BOOL result = TRUE;
	
	if (strstr(str, " ")==0)
		result = FALSE;

	return result;
}

BOOL Tape_Delete_Cron_Job(int cid, char *ctask_name)
{
	BOOL	result = FALSE;
	FILE 	*fptr, *fptrm;	
	char sys_cmd[MSTR_LENGTH];
	int  id;
	char task_name[SSTR_LENGTH];	
	char source[SSTR_LENGTH];
	char type[SSTR_LENGTH];
	int  compress;
	int  verify;	
	int  day;
	char weekly[SSTR_LENGTH];
	int  monthly;
	int  hh; //time:hh
	int  mm; //time:mm
	char tape_cmd[MSTR_LENGTH];
	char status[SSTR_LENGTH];
	int  pid;		

#if	BACKUP_FROM_SNAPSHOT	// Catherine 2003/04/17
	int is_from_snap;
	char snapname[LV_PATH_MAX_LEN];
	char line[LSTR_LENGTH];
#endif
	
	sprintf(sys_cmd, "/bin/mv -f %s %s", TAPE_CRONTAB_FILE, TAPE_CRONTAB_TMP_FILE);	
	system(sys_cmd);
	
	if ((fptrm=fopen(TAPE_CRONTAB_TMP_FILE, "r+"))==NULL)
		return FALSE;

	if ((fptr=fopen(TAPE_CRONTAB_FILE, "w+"))==NULL) {
		fclose(fptrm);		
		return FALSE;
	}
		
	while (!feof(fptrm))
	{		
#if	BACKUP_FROM_SNAPSHOT	// Catherine 2003/04/17
		is_from_snap = 0;
		strcpy(snapname, "");

		if (!fgets(line, sizeof(line), fptrm)) continue;
		sscanf(line, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d %d %s",
			&id, task_name, source, type, &compress, &verify,
			&day, weekly, &monthly, &hh, &mm, tape_cmd, status,
			&pid, &is_from_snap, snapname);
#else
		fscanf(fptrm, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d",
			&id, task_name, source, type, &compress, &verify, &day, weekly, &monthly, &hh, &mm, tape_cmd, status, &pid);	
#endif
			
		if (strcasecmp(task_name,"")==0) //prevent read null line
			continue;
			
		if ((cid == id) || (strcasecmp(ctask_name, task_name) == 0)) {
			result = TRUE;
			sprintf(sys_cmd, "/bin/rm -f %s/%d.sh", TAPE_CRON_CMD_DIR, id);
			system(sys_cmd);			
		}	
		else
#if	BACKUP_FROM_SNAPSHOT	// Catherine 2003/04/17
			fprintf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d %d %s\n", 
				id, task_name, source, type, compress, verify,
				day, weekly, monthly, hh, mm, tape_cmd, status, pid,
				is_from_snap, snapname);
#else
			fprintf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d\n",
				id, task_name, source, type, compress, verify, day, weekly, monthly, hh, mm, tape_cmd, status, pid);
#endif
				
		strcpy(task_name,""); //prevent read null line
	}
		
	fclose(fptrm);				
	fclose(fptr);
	
	sprintf(sys_cmd, "/bin/rm -f %s", TAPE_CRONTAB_TMP_FILE);	
	system(sys_cmd);
		
	return result;				
}

BOOL Tape_Test_Duplicate_Name(char *ctask_name)
{
	FILE 	*fptr;	
	int  id;
	char task_name[SSTR_LENGTH];	
	char source[SSTR_LENGTH];
	char type[SSTR_LENGTH];
	int  compress;
	int  verify;	
	int  day;
	char weekly[SSTR_LENGTH];
	int  monthly;
	int  hh; //time:hh
	int  mm; //time:mm
	char tape_cmd[MSTR_LENGTH];
	char status[SSTR_LENGTH];
	int  pid;			
#if	BACKUP_FROM_SNAPSHOT
	int fromsnap;
	char snapname[LV_PATH_MAX_LEN];
	char line[LSTR_LENGTH];
#endif
	
	if ((fptr=fopen(TAPE_CRONTAB_FILE, "r+"))==NULL)
		return FALSE;
		
	while (!feof(fptr))
	{		
#if	BACKUP_FROM_SNAPSHOT
		fromsnap = 0;
		strcpy(snapname, "");

		if (!fgets(line, sizeof(line), fptr)) continue;
		sscanf(line, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d %d %s",
			&id, task_name, source, type, &compress, &verify,
			&day, weekly, &monthly, &hh, &mm, tape_cmd, status, &pid,
			&fromsnap, snapname);
#else
		fscanf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d",
			&id, task_name, source, type, &compress, &verify, &day, weekly, &monthly, &hh, &mm, tape_cmd, status, &pid);	
#endif
		if (strcasecmp(ctask_name, task_name) == 0) {
			fclose(fptr);			
			return TRUE;
		}
	}
		
	fclose(fptr);
	return FALSE;	
}

TAPE_SCHEDULE_TASK_NAME_INFO *Tape_Set_Schedule_Task_Name_Info(TAPE_SCHEDULE_TASK_NAME_INFO *p, char *task_name)
{
	TAPE_SCHEDULE_TASK_NAME_INFO	*start = NULL, *current = NULL;

	if (p == NULL) {
		if ((current = calloc(1, sizeof(TAPE_SCHEDULE_TASK_NAME_INFO))) == NULL)
			return NULL;
			
		else {
			strcpy(current->task_name, task_name);
			return current;
		}		
	}
	else {
		if (p != NULL)
			start = p;
	
		while (p->next != NULL)
			p=p->next;
					
		if ((current = calloc(1, sizeof(TAPE_SCHEDULE_TASK_NAME_INFO))) == NULL)
			return NULL;
				
		else {
			strcpy(current->task_name, task_name);
			p->next=current;
		}
	
		return start;
	}
}																			
			
void Tape_Free_Schedule_Task_Name_Info(TAPE_SCHEDULE_TASK_NAME_INFO *tape_schedule_task_name_info)
{
	TAPE_SCHEDULE_TASK_NAME_INFO *current;
	
	current = tape_schedule_task_name_info;
	while (tape_schedule_task_name_info != NULL)
	{
		tape_schedule_task_name_info = tape_schedule_task_name_info->next;
		free(current);
		current = tape_schedule_task_name_info;
	}
}

TAPE_SCHEDULE_INFO *Tape_Get_Schedule_Info()
{
	FILE 			*fptr;
	TAPE_SCHEDULE_INFO	*start = NULL, *prev = NULL,*current = NULL;

	int  id, count = 0;
	char task_name[SSTR_LENGTH];	
	char source[SSTR_LENGTH];
	char type[SSTR_LENGTH];
	int  compress;
	int  verify;	
	int  day;
	char weekly[SSTR_LENGTH];
	int  monthly;
	int  hh; //time:hh
	int  mm; //time:mm
	char tape_cmd[MSTR_LENGTH];
	char status[SSTR_LENGTH];				
	int  pid;

#if	BACKUP_FROM_SNAPSHOT	// Catherine 2003/04/17
	int backup_from_snap;
	char snapname[LV_PATH_MAX_LEN];
	char line[LSTR_LENGTH];
#endif

	if ((fptr=fopen(TAPE_CRONTAB_FILE, "r+"))==NULL)
		return NULL;

	while (!feof(fptr))
	{	
		strcpy(task_name,"");  //prevent to read the null line
		
#if	BACKUP_FROM_SNAPSHOT	// Catherine 2003/04/17
		backup_from_snap = 0;
		strcpy(snapname, "");

		if (!fgets(line, sizeof(line), fptr)) continue;
		sscanf(line, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d %d %s", 
			&id, task_name, source, type, &compress, &verify,
			&day, weekly, &monthly, &hh, &mm, tape_cmd, status, &pid,
			&backup_from_snap, snapname);
#else
		fscanf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d", 
			&id, task_name, source, type, &compress, &verify, &day, weekly, &monthly, &hh, &mm, tape_cmd, status, &pid);
#endif

		if (strcasecmp(task_name,"") == 0) //prevent to read the null line
			continue;
				
		if ((current = calloc(1, sizeof(TAPE_SCHEDULE_INFO))) == NULL)
			return NULL;
			
		else {
			if (++count == 1)
				start = current;
			else
				prev->next = current;
				
			current->id = id;
			strcpy(current->task_name, task_name);
			strcpy(current->source, source);
			strcpy(current->type, type);
			current->compress = compress;
			current->verify = verify;
			current->day = day;
			strcpy(current->weekly, weekly);
			current->monthly = monthly;
			current->hh = hh;
			current->mm = mm;
			strcpy(current->tape_cmd, tape_cmd);
			strcpy(current->status, status);
			current->pid = pid;	

/* another link list method					
			current->next = start;
			start = current;
*/
#if	BACKUP_FROM_SNAPSHOT	// Catherine 2003/04/17
			current->backup_from_snap = backup_from_snap;
			strcpy(current->snapname, snapname);
#endif

			prev = current;
		}

	}
	
	fclose(fptr);	
	return start;
}																				
			
void Tape_Free_Schedule_Info(TAPE_SCHEDULE_INFO *tape_schedule_info)
{
	TAPE_SCHEDULE_INFO *current;
	
	current = tape_schedule_info;
	while (tape_schedule_info != NULL)
	{
		tape_schedule_info = tape_schedule_info->next;
		free(current);
		current = tape_schedule_info;
	}
}

int Tape_Find_Unoccupied_Id()
{
	int	ans=0, i=1, flag=0;
	TAPE_SCHEDULE_INFO *tape_info,*tape_start;
	
	while(1)
	{
		tape_info = Tape_Get_Schedule_Info(); // get data structure
		tape_start = tape_info;
				
		while(tape_info != NULL) { // read data
			
			if (tape_info->id == i)	{
				flag = 1;
				break;	
			}	
			tape_info = tape_info->next;
		}
		Tape_Free_Schedule_Info(tape_start);// erase memory
		
		if (flag) {
			i++;
			flag = 0;
		}
		else {
			ans=i;
			return ans;
		}
		
		if (i > 2000000000) break; //just for safe
	};
	return -1; //not find			
}

BOOL Tape_Set_Confirm_Next_Volume_Yes()
{
	FILE 	*fptrH;
	char	tag[SSTR_LENGTH];
	int 	pid;

	if ((fptrH=fopen(TAPE_TAR_H_FILE, "r+"))==NULL)
		return FALSE;

	if (fscanf(fptrH, "%s %d\n", tag, &pid) == -1) {
		fclose(fptrH);
		return FALSE;
	}
	fclose(fptrH);
	kill(pid, SIGUSR1);
	
	return TRUE;			
}

BOOL Tape_Set_Confirm_Next_Volume_No()
{
	FILE 	*fptrH;
	char	tag[SSTR_LENGTH];
	int 	pid;

	if ((fptrH=fopen(TAPE_TAR_H_FILE, "r+"))==NULL)
		return FALSE;

	if (fscanf(fptrH, "%s %d\n", tag, &pid) == -1) {
		fclose(fptrH);
		return FALSE;
	}
	fclose(fptrH);
	kill(pid, SIGUSR2);

	return TRUE;		
}

BOOL Tape_Do_Next_Volume_Job()
{
	FILE 	*fptrH;
	char	tag[SSTR_LENGTH];
	int 	pid;

	if ((fptrH=fopen(TAPE_TAR_H_FILE, "r+"))==NULL)
		return FALSE;

	if (fscanf(fptrH, "%s %d\n", tag, &pid) == -1) {
		fclose(fptrH);
		return FALSE;
	}

	fclose(fptrH);
	kill(pid, SIGCONT);
	
	return TRUE;	
}

BOOL Tape_Check_Need_Next_Volume()
{
	struct  stat buf;
	int	ret;
	
	ret = stat(TAPE_TAR_Q_FILE, &buf);

	if (ret == 0)	return TRUE;
	else 		return FALSE;	
}

int Tape_Get_Next_Volume_No()
{
	FILE 	*fptrj;
	char 	tag[SSTR_LENGTH];
	int	value;

	if ((fptrj=fopen(TAPE_TAR_j_FILE, "r+"))==NULL)
		return -2; //can't open

	if (fscanf(fptrj, "%s %d", tag, &value) != -1) {	
		if (strcasecmp(tag, "TAPE_next_volume")==0) {
			fclose(fptrj);						
			return value;
		}	
	}			
	if (fscanf(fptrj, "%s %d", tag, &value) != -1) {
		if (strcasecmp(tag, "TAPE_next_volume")==0) {
			fclose(fptrj);					
			return value;
		}
	}					
	fclose(fptrj);
	return -1; //not find	
}

void Tape_Delete_History_Log()
{
	char sys_cmd[MSTR_LENGTH];

	sprintf(sys_cmd, "/bin/rm -f %s", TAPE_TAR_D_FILE);
	system(sys_cmd); 
}

BOOL Tape_Check_Job_Finish()
{


	FILE 	*fptrH;
	char	test_dir[SSTR_LENGTH];
	char	tag[SSTR_LENGTH];		
	int 	pid, ret=-1;
	struct  stat buf;

	if ((fptrH=fopen(TAPE_TAR_H_FILE, "r+"))==NULL)
		return TRUE;

	if (fscanf(fptrH, "%s %d\n", tag, &pid) == -1) {
		fclose(fptrH);
		return TRUE;	
	}
	
	fclose(fptrH);
	
	sprintf(test_dir, "%s/%d", TAPE_PROC_DIR, pid); 
	
	ret = stat(test_dir, &buf);
	
	if (ret!=0)
		unlink(TAPE_TAR_Q_FILE);
	
	if (ret==0)	return FALSE; 
	else		return TRUE;
}

BOOL Tape_User_Abort_Job()
{
	FILE 	*fptrH;
	char	sys_cmd[MSTR_LENGTH];
	char	tag[SSTR_LENGTH];
	int 	pid;

	if ((fptrH=fopen(TAPE_TAR_H_FILE, "r+"))==NULL)
		return FALSE;

	if (fscanf(fptrH, "%s %d\n", tag, &pid) == -1) {
		fclose(fptrH);
		return FALSE;
	}

	if (kill(pid, SIGABRT)== -1) { //send signal to kill process
		fclose(fptrH);
		return FALSE;
	}
	fclose(fptrH);
	sprintf(sys_cmd, "/bin/rm -f %s", TAPE_TAR_Q_FILE);
	system(sys_cmd);
	
	return TRUE;	
}

void Tape_Eject_Tape()
{
	char sys_cmd[SSTR_LENGTH];
	sprintf(sys_cmd, "/bin/mt -f %s offline", TAPE_REWIND_DEV);
	system(sys_cmd);	
}

void Tape_Rewind_Tape()
{
	char sys_cmd[SSTR_LENGTH];
	sprintf(sys_cmd, "/bin/mt -f %s rewind", TAPE_REWIND_DEV);
	system(sys_cmd);	
}

void Tape_Erase_Tape()
{
	char sys_cmd[SSTR_LENGTH];
	Tape_Rewind_Tape();
	sprintf(sys_cmd, "/bin/mt -f %s weof 2", TAPE_REWIND_DEV);
	system(sys_cmd);	
}

void Tape_Forward_Count_Tape(int count)
{
	char sys_cmd[SSTR_LENGTH];
	sprintf(sys_cmd, "/bin/mt -f %s asf %d", TAPE_NON_REWIND_DEV, count);
	system(sys_cmd);	
}

BOOL Tape_Set_Cron_Job_Srcipt(char *ctask_name)
{
	TAPE_SCHEDULE_INFO *tape_schedule_info, *tape_schedule_start; //case 40		
	int flag = 0;
	char compress_buf[4]="";
	char verify_buf[4]="";
	char type_buf[4]="";	
	
	tape_schedule_info = Tape_Get_Schedule_Info(); // get data structure
	tape_schedule_start = tape_schedule_info;

	while(tape_schedule_info != NULL) { // read data

		if (strcasecmp(tape_schedule_info->task_name, ctask_name) == 0) {
			flag = 1;
			break;
		}
// for debug	
/*
		printf("tape_schedule_info->id			%d\n", tape_schedule_info->id);
		printf("tape_schedule_info->task_name		%s\n", tape_schedule_info->task_name);
		printf("tape_schedule_info->source		%s\n", tape_schedule_info->source);						
		printf("tape_schedule_info->type		%s\n", tape_schedule_info->type);
		printf("tape_schedule_info->compress		%d\n", tape_schedule_info->compress);			
		printf("tape_schedule_info->verify		%d\n", tape_schedule_info->verify);			
		printf("tape_schedule_info->day			%d\n", tape_schedule_info->day	);			
		printf("tape_schedule_info->weekly		%s\n", tape_schedule_info->weekly);			
		printf("tape_schedule_info->monthly		%d\n", tape_schedule_info->monthly);			
		printf("tape_schedule_info->hh			%d\n", tape_schedule_info->hh);
		printf("tape_schedule_info->mm			%d\n", tape_schedule_info->mm);			
		printf("tape_schedule_info->tape_cmd		%s\n", tape_schedule_info->tape_cmd);
		printf("tape_schedule_info->status		%s\n", tape_schedule_info->status);		
*/
							
		tape_schedule_info = tape_schedule_info->next;
				
		getchar();
	}
	Tape_Free_Schedule_Info(tape_schedule_start);// erase memory		
	
	if (flag == 1) {
		
		if (strcasecmp(tape_schedule_info->type, "Full")==0)
			strcpy(type_buf, "0");
		else if (strcasecmp(tape_schedule_info->type, "Incremental")==0)
			strcpy(type_buf, "1");
		else return FALSE;
		
		sprintf(compress_buf, "%d", tape_schedule_info->compress);
		sprintf(verify_buf, "%d", tape_schedule_info->verify);

		if (!(Make_Sh_Tar_Cmd_Cvf(tape_schedule_info->id, TAPE_DEFAULT_DEV, tape_schedule_info->source,
			 tape_schedule_info->task_name, compress_buf, verify_buf, type_buf)))
			return FALSE;
		return TRUE;	
	}  
	else	return FALSE;	
}

BOOL Tape_Weekly_Num_To_Weekly_Alp(char *num_str, char *alp_str, int length)
{
	char s1[7]={'S', 'M', 'T', 'W', 'T', 'F', 'S'};
	char s2[7]={'-', '-', '-', '-', '-', '-', '-'}; 
	char compare[4]="";
	int i;

	memset(alp_str, '\0', sizeof(alp_str));	
	
	for (i=0; i<7; i++) {
		sprintf(compare, "%d", i);
		
 		if (strstr(num_str, compare) != 0) 
	 	     sprintf(alp_str, "%s %c",alp_str, s1[i]);
	 	else sprintf(alp_str, "%s %c ",alp_str, s2[i]);	
 	}
 	
 	if (length > strlen(alp_str))
 		return TRUE;
 	else
 		return FALSE;
}

BOOL Tape_Restore_Switch(int cmd)
{
	char sys_cmd[SSTR_LENGTH]="";
	if (cmd==1) {
		sprintf(sys_cmd, "/bin/touch %s", TAPE_RESTORE_SWITCH_FILE);
		system(sys_cmd);
		return TRUE;
	}
	else if (cmd==0) {
		unlink(TAPE_RESTORE_SWITCH_FILE);
		return TRUE;
	}
	else return FALSE;
}

BOOL Tape_Test_Restore_Switch()
{
	struct stat test_buf;

	if (stat(TAPE_RESTORE_SWITCH_FILE, &test_buf)==0)
		return TRUE;
	else
		return FALSE;
}

BOOL Tape_Backup_Switch(int cmd)
{
	char sys_cmd[SSTR_LENGTH]="";
	if (cmd==1) {
		sprintf(sys_cmd, "/bin/touch %s", TAPE_BACKUP_SWITCH_FILE);
		system(sys_cmd);
		return TRUE;
	}
	else if (cmd==0) {
		unlink(TAPE_BACKUP_SWITCH_FILE);
		return TRUE;
	}
	else return FALSE;
}

BOOL Tape_Test_Backup_Switch()
{
	struct stat test_buf;

	if (stat(TAPE_BACKUP_SWITCH_FILE, &test_buf)==0)
		return TRUE;
	else
		return FALSE;
}

BOOL Tape_Next_Volume_Switch(int cmd)
{
	char sys_cmd[SSTR_LENGTH]="";
	if (cmd==1) {
		sprintf(sys_cmd, "/bin/touch %s", TAPE_NEXT_VOLUME_SWITCH_FILE);
		system(sys_cmd);
		return TRUE;
	}
	else if (cmd==0) {
		unlink(TAPE_NEXT_VOLUME_SWITCH_FILE);
		return TRUE;
	}
	else return FALSE;
}

BOOL Tape_Test_Next_Volume_Switch()
{
	struct stat test_buf;

	if (stat(TAPE_NEXT_VOLUME_SWITCH_FILE, &test_buf)==0)
		return TRUE;
	else
		return FALSE;
}

BOOL Tape_Compare_Status_Info_Status_Field()
{
	char status[MSTR_LENGTH]="";
	TAPE_LOG_INFO *tape_log_last; 
	
	tape_log_last = Tape_Get_Log_Last_Line(); 
	
	Get_Private_Profile_String( TAPE_SESSION,TAPE_STATUS_FIELD, TAPE_DEFAULT_STR, status, MSTR_LENGTH, TAPE_FILE);		

	if (tape_log_last == NULL) //if no the message file, it does not need to update the status 
		return TRUE;

	if (!strcasecmp(status, tape_log_last->msg)) {
		Tape_Free_Log_Info(tape_log_last);// erase memory		
		return TRUE;
	}	
	else {
		Tape_Free_Log_Info(tape_log_last);// erase memory
		return FALSE;
	}						
}

BOOL Tape_Test_Is_Sp_For_Status_Info_Status_Field()
{
	char status[MSTR_LENGTH]="";
	char type[MSTR_LENGTH]="";
	char compress[MSTR_LENGTH]="";
	
	Get_Private_Profile_String( TAPE_SESSION,TAPE_STATUS_FIELD, TAPE_DEFAULT_STR, status, MSTR_LENGTH, TAPE_FILE);		
	Get_Private_Profile_String( TAPE_SESSION,TAPE_TYPE_FIELD, TAPE_DEFAULT_STR, type, SSTR_LENGTH, TAPE_FILE);
	Get_Private_Profile_String( TAPE_SESSION,TAPE_COMPRESSION_FIELD, TAPE_DEFAULT_STR, compress, SSTR_LENGTH, TAPE_FILE);
	
	if (!strcasecmp(status, "--") && !strcasecmp(type, "--") && !strcasecmp(compress, "--"))	
		return TRUE;

	else 
		return FALSE;
						
}

BOOL Tape_Tvf_Switch(int cmd)
{
	char sys_cmd[SSTR_LENGTH]="";
	if (cmd==1) {
		sprintf(sys_cmd, "/bin/touch %s", TAPE_TVF_SWITCH_FILE);
		system(sys_cmd);
		return TRUE;
	}
	else if (cmd==0) {
		unlink(TAPE_TVF_SWITCH_FILE);
		return TRUE;
	}
	else return FALSE;
}

BOOL Tape_Tvf_Test_Switch()
{
	struct stat test_buf;

	if (stat(TAPE_TVF_SWITCH_FILE, &test_buf)==0)
		return TRUE;
	else
		return FALSE;
}

BOOL Tape_Status_Switch(int cmd)
{
	char sys_cmd[SSTR_LENGTH]="";
	if (cmd==1) {
		sprintf(sys_cmd, "/bin/touch %s", TAPE_STATUS_SWITCH_FILE);
		system(sys_cmd);
		return TRUE;
	}
	else if (cmd==0) {
		unlink(TAPE_STATUS_SWITCH_FILE);
		return TRUE;
	}
	else return FALSE;
}

BOOL Tape_Status_Test_Switch()
{
	struct stat test_buf;

	if (stat(TAPE_STATUS_SWITCH_FILE, &test_buf)==0)
		return TRUE;
	else
		return FALSE;
}

BOOL Tape_Check_Mt_Finish()
{
	char sys_cmd[MSTR_LENGTH];
	char test_dir[MSTR_LENGTH];
	
	FILE 	*fptrm;	
	int 	pid =-1, ret=-1;
	struct  stat buf;	

	sprintf(sys_cmd, "/bin/rm -f %s", TAPE_MT_PROG_TEST_FILE);
	system(sys_cmd);
	sprintf(sys_cmd, "%s -s mt > %s", TAPE_PIDOF_PROG_PATH, TAPE_MT_PROG_TEST_FILE);
	system(sys_cmd);

	if ((fptrm=fopen(TAPE_MT_PROG_TEST_FILE, "r+"))==NULL)
		return TRUE;

	if (fscanf(fptrm, "%d\n", &pid) == -1) {
		fclose(fptrm);
		return TRUE;	
	}
	
	fclose(fptrm);
	
	sprintf(test_dir, "%s/%d", TAPE_PROC_DIR, pid); 
	
	ret = stat(test_dir, &buf);
	
	if (ret==0)	return FALSE; 
	else		return TRUE;
}

BOOL Tape_User_Abort_Mt()
{
	FILE 	*fptrm;
	int 	pid;

	if ((fptrm=fopen(TAPE_MT_PROG_TEST_FILE, "r+"))==NULL)
		return FALSE;

	if (fscanf(fptrm, "%d\n", &pid) == -1) {
		fclose(fptrm);
		return FALSE;
	}

	if (kill(pid, SIGABRT)== -1) { //send signal to kill process
		fclose(fptrm);
		return FALSE;
	}
	fclose(fptrm);
	return TRUE;	
}

BOOL Tape_Check_Gzip_Finish()
{
	char sys_cmd[MSTR_LENGTH];
	char test_dir[MSTR_LENGTH];
	
	FILE 	*fptrm;	
	int 	pid =-1, ret=-1;
	struct  stat buf;	

	sprintf(sys_cmd, "/bin/rm -f %s", TAPE_GZIP_PROG_TEST_FILE);
	system(sys_cmd);
	sprintf(sys_cmd, "%s -s mt > %s", TAPE_PIDOF_PROG_PATH, TAPE_GZIP_PROG_TEST_FILE);
	system(sys_cmd);

	if ((fptrm=fopen(TAPE_GZIP_PROG_TEST_FILE, "r+"))==NULL)
		return TRUE;

	if (fscanf(fptrm, "%d\n", &pid) == -1) {
		fclose(fptrm);
		return TRUE;	
	}
	
	fclose(fptrm);
	
	sprintf(test_dir, "%s/%d", TAPE_PROC_DIR, pid); 
	
	ret = stat(test_dir, &buf);
	
	if (ret==0)	return FALSE; 
	else		return TRUE;
}

int Tape_Get_Schedule_Count()
{
	int count=0;
	TAPE_SCHEDULE_INFO *tape_schedule_info, *tape_schedule_start;
	tape_schedule_info = Tape_Get_Schedule_Info(); // get data structure
	tape_schedule_start = tape_schedule_info;

	while(tape_schedule_info != NULL) { // read data			
		count++;			
		tape_schedule_info = tape_schedule_info->next;

	}
	Tape_Free_Schedule_Info(tape_schedule_start);// erase memory	
	
	return count;
}

BOOL Is_Tape_Support()
{
	return	(Get_Private_Profile_Boolean( TAPE_APP_ULINUX, TAPE_KEY_ULINUX, FALSE, TAPE_FILEPATH_ULINUX));
}
	
BOOL Tape_Conf_File_Is_Null()
{		
	char test_str[SSTR_LENGTH];

	Get_Private_Profile_String( TAPE_SESSION, TAPE_STATUS_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;

	Get_Private_Profile_String( TAPE_SESSION, TAPE_MSG_TIME_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;
		
	Get_Private_Profile_String( TAPE_SESSION, TAPE_TAPE_NUM_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;

	Get_Private_Profile_String( TAPE_SESSION, TAPE_SOURCE_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;

	Get_Private_Profile_String( TAPE_SESSION, TAPE_DESTINATION_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;
	
	Get_Private_Profile_String( TAPE_SESSION, TAPE_LABEL_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;	
	
	Get_Private_Profile_String( TAPE_SESSION, TAPE_TYPE_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;		
	
	Get_Private_Profile_String( TAPE_SESSION, TAPE_COMPRESSION_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;		
		
	Get_Private_Profile_String( TAPE_SESSION, TAPE_VERIFY_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;	
	
	Get_Private_Profile_String( TAPE_SESSION, TAPE_FILES_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;	
	
	Get_Private_Profile_String( TAPE_SESSION, TAPE_MEGABYTES_FIELD, TAPE_NULL_STR, test_str, SSTR_LENGTH, TAPE_FILE);	
	if (strcasecmp(test_str, "")!=0) return FALSE;							

	return 	TRUE;
}

int Tape_In_Drive()//Shone added for testing tape existency
{
	FILE *tapetest; 
	char buf[80],syscmd[65],*str_ptr;
	int    ret=1,count=5;
					
	sprintf(syscmd,"mt -f %s status 1>%s 2>>%s", TAPE_DEFAULT_DEV , TAPE_EXIST_FILE , TAPE_EXIST_FILE);
	system(syscmd);
					
	if((tapetest=fopen(TAPE_EXIST_FILE,"r"))!=NULL)
	   {   
	        while(count--)
	              {       fgets(buf,80,tapetest);
		        str_ptr= strstr(buf,"Device or resource busy");
		        if (str_ptr != NULL) 
		           {
		            	    ret=-1;
		           	    break;
		           }
		          
		        str_ptr= strstr(buf,"No such device");
		        if (str_ptr != NULL) 
		           {
		            	    ret=-2;
		           	    break;
		           } 
		    
		         str_ptr = strstr(buf,"File number=");
		         if (str_ptr != NULL) 	
		            {
		           	      if( *(str_ptr+12)=='-'&&*(str_ptr+13)=='1')
		           	        {
		           	              ret=0;
		           	              break;
		           	        }
		           	      else break;
		            }  	
	                }
	  }             
	fclose(tapetest);
	
      return ret;
}

BOOL Tape_Device_Ready()
{		
	char test_str[SSTR_LENGTH]="";
	char sys_cmd[MSTR_LENGTH];
	FILE 	*fptr;	
		
	sprintf(sys_cmd, "/bin/mt -f %s status 2> %s 1> %s", TAPE_DEFAULT_DEV, TAPE_DEVICE_READY_TEST_FILE, TAPE_NULL_DEVICE);
	system(sys_cmd);

	if ((fptr=fopen(TAPE_DEVICE_READY_TEST_FILE, "r+"))==NULL)
		return TRUE;

	if (fgets(test_str, SSTR_LENGTH, fptr)==NULL) {	
		fclose(fptr);	
		unlink(TAPE_DEVICE_READY_TEST_FILE);			
		return TRUE;		
	}
	
	fclose(fptr);
	unlink(TAPE_DEVICE_READY_TEST_FILE);
	erase_char(test_str);

	if (strlen(test_str) > 0)
		return FALSE;				// the string included error message
	else
		return TRUE;
/*	
	if ( strstr(test_str, TAPE_DEVICE_NOT_READY_MSG)!= 0 )
		return FALSE;
	else
		return TRUE;
*/
}	
	
BOOL Tape_Set_Destination_Label_Field()
{	
	
	FILE 	*fptr;
	char read_line[TAPE_LINE];

	if ((fptr=fopen(TAPE_STATUS_DESTINATION_FILE, "r+"))==NULL)
		return FALSE;

	if (fgets(read_line, TAPE_LINE, fptr)==NULL) {
		fclose(fptr);
		return FALSE;
	}

	fclose(fptr);

	erase_char(read_line);

	if (Set_Private_Profile_String( TAPE_SESSION, TAPE_DESTINATION_FIELD, read_line, TAPE_FILE)<0)
		return FALSE;
	else
		return TRUE;	
}

BOOL Tape_Set_Destination_Temp_File(char *dest)
{	
	FILE 	*fptr;

	unlink(TAPE_STATUS_DESTINATION_FILE);

	if ((fptr=fopen(TAPE_STATUS_DESTINATION_FILE, "w"))==NULL)
		return FALSE;

	if (fprintf(fptr, "%s", dest)<0) {
		fclose(fptr);	
		return FALSE;
	}
			
	fclose(fptr);
	
	return TRUE;
}	

void Tape_Transfer_Sp_Char(char *src, char *dest)
{
	char *p;
	int i;
	
	p=src;
	
	for (i=1; i<strlen(src); i++) {
		if (*(p+i) == TAPE_SP_CHARACTER)
			*(dest+i-1)=TAPE_INSTEAD_SP_CHARACTER;
		else
			*(dest+i-1)=*(src+i);
		
	}
	
	*(dest+strlen(src)-2)='\0';
}

char *Tape_Transfer_Instead_Sp_Char(char *src)
{
	int i;
	
	for (i=0; i<strlen(src); i++)
  		if (*(src+i) == TAPE_INSTEAD_SP_CHARACTER)
  			*(src+i) = TAPE_SP_CHARACTER;
  			
	return src;
}

char *Tape_Invert_Sp_Char(char *src)
{
	int i;

	for (i=0; i<strlen(src); i++)
  		if (*(src+i) == TAPE_SP_CHARACTER)
  			*(src+i) = TAPE_INSTEAD_SP_CHARACTER;
	
	return src;
}

int Reset_Tape()
{
	char sys_cmd[MSTR_LENGTH];
	
	
	if (Is_Tape_Support()) {
		
		sprintf(sys_cmd, "%s -rf %s/*", TAPE_RM_PATH, TAPE_CONFIG_PATH);
	
		if (system(sys_cmd)!=SUCCESS)
			return ERROR_EXEC_FAIL;
			
		sprintf(sys_cmd, "%s -p %s", TAPE_MKDIR_PATH, TAPE_CRON_CMD_DIR);
	
		if (system(sys_cmd)!=SUCCESS)
			return ERROR_EXEC_FAIL;
	
		sprintf(sys_cmd, "%s %s %s", TAPE_CHMOD_PATH, TAPE_DIR_PREMISSIONS, TAPE_CRON_CMD_DIR);
	
		if (system(sys_cmd)!=SUCCESS)
			return ERROR_EXEC_FAIL;
			
		sprintf(sys_cmd, "%s -f %s %s", TAPE_CP_PATH, TAPE_CONFIG_DEFAULT_FILE, TAPE_CONFIG_PATH);
	
		if (system(sys_cmd)!=SUCCESS)
			return ERROR_EXEC_FAIL;
			
	}			
		
	return SUCCESS;			
}	
	
	
void print_menu()
{
/* for test library used*/
	printf("\n===============================================================\n");
	printf("0. Quit\n");
	printf("1. TAPE_STATUS_INFO *Tape_Get_Status_Info()\n");
	printf("2. TAPE_MOUNTS_INFO *Tape_Get_Mounts_Info()\n");
	printf("3. TAPE_MOUNTS_INFO *Tape_Get_Mounts_Share_Info()\n");
	printf("4. TAPE_MOUNTS_INFO *Tape_Get_Mounts_Root_Info()\n");
	printf("5. TAPE_LOG_INFO *Tape_Get_Log_Info()\n");
	printf("6. char *find_incremented_file(char *src, char *incremented_file)\n");
	printf("7. void Tar_Cmd_Cvf(char *dest, char *src, char *label, char *compress, char *verify, char *incremented, char *tape_length)\n");
	printf("8. void Tar_Cmd_Xvf(char *src, char *dest, char *keep_old_files)\n");
	printf("9. void Tar_Cmd_Tvf(char *src)\n");	
	printf("10. TAPE_MOUNTS_SHARE_VOLUME_INFO *Tape_Get_Mounts_Share_Volume_Info()\n");
	printf("11. void Tape_Clear_Status_Info()\n");	
	printf("12. TAPE_LOG_INFO *Tape_Get_Log_Last_Line()\n");
	printf("13. void Tape_Set_Status_Info_Status_Field()\n");
	printf("14. void Tape_Set_Status_Info_Count_Size_Field()\n");
	printf("15. void Tape_Set_Status_Info_Source_Label_Field()\n");				
	printf("16. Void Tape_Set_Status_Info_Compress_Verify_Type_Field( char *type, char *compress, char * verify)\n");
	printf("17. void Tape_Set_Status_Info_Num_Field()\n");
	printf("18. void Tape_Set_All_Status_Info(char *type, char *compress, char *verify)\n");
	printf("19. Test SMB_Get_Share_Info()\n");
	printf("20. TAPE_BACKUP_SHARE_DIR_INFO *Tape_Backup_Share_Dir_Info()\n");
	printf("21. void Tape_Set_New_Cron_Job(...)\n");
	printf("22. BOOL Tape_Test_Included_Sp (char *str)\n");	
	printf("23. BOOL Tape_Delete_Cron_Job(int cid, char *ctask_name)\n");
	printf("24. BOOL Tape_Test_Duplicate_Name(char *ctask_name)\n");
	printf("25. int Tape_Find_Unoccupied_Id()\n");
	printf("26. BOOL Tape_Set_Confirm_Next_Volume_Yes()\n");
	printf("27. BOOL Tape_Set_Confirm_Next_Volume_No()\n");
	printf("28. BOOL Tape_Do_Next_Volume_Job()\n");
	printf("29. BOOL Tape_Check_Need_Next_Volume()\n");
	printf("30. int Tape_Get_Next_Volume_No()\n");	
	printf("31. Tape_Check_Job_Finish\n");	
	printf("32. BOOL Tape_User_Abort_Job()\n");	
	printf("33. void Tape_Eject_Tape()\n");
	printf("34. Tape_Rewind_Tape()\n");
	printf("35. Tape_Erase_Tape()\n");
	printf("36. void Tape_Forward_Count_Tape(int count)\n");
	printf("37. TAPE_INFO *Tape_Get_Tape_Info()\n");
	printf("38. TAPE_SCHEDULE_INFO *Tape_Get_Schedule_Info()\n");
	printf("39. BOOL Tape_Set_Cron_Job_Srcipt(char *ctask_name)\n");
	printf("40. TAPE_BACKUP_SHARE_DIR_REVERSE_INFO *Tape_Get_Backup_Share_Dir_Reverse_Info(char *compare)\n");
	printf("41. find_incremented_file_ex_1(char *src, char *incremented_file)\n");
	printf("42. void Tape_Delete_History_Log()\n");	
	printf("43. TAPE_LOG_INFO *Tape_Get_History_Log_Info()\n");
	printf("44. BOOL Tape_Clear_History_Log()\n");	
	printf("45. void Tape_Set_All_Status_Info_Except_Compress_Verify_Type_Field()\n");
	printf("46. TAPE_INFO *Tape_Get_All_Tape_Info()\n");	
	printf("47. TAPE_INFO *Tape_Get_Assign_Tape_Info(int count)\n");
	printf("48. BOOL Tape_Info_Test(TAPE_INFO *tape_info)\n");	
	printf("49. BOOL Tape_Test_Source_Compress(char *src)\n");
	printf("50. BOOL Tape_Test_Log_Occur_Error(char *log_src)\n");	
	printf("51. char *Tape_Weekly_Num_To_Weekly_Alp(char *numstr)\n");
	printf("52. TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Case(char *condition)\n");
	printf("53. int Tape_Get_History_Log_Info_Total_By_Case(char *condition)\n");	
	printf("54. TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Case_and_Page(char *condition, int page)\n");	
	printf("55. TAPE_LOG_INFO *Tape_Get_History_Log_Info_By_Page(int page)\n");
	printf("56. int Tape_Get_History_Log_Info_Total_Page_By_Case(char *condition)\n");
	printf("57. TAPE_SCHEDULE_TASK_NAME_INFO *Tape_Set_Schedule_Task_Name_Info(TAPE_SCHEDULE_TASK_NAME_INFO *p, char *task_name)\n");
	printf("58. BOOL Tape_Restore_Switch(int cmd)\n");
	printf("59. void Tape_Set_All_Restore_Status_Info()\n");
	printf("60. BOOL Tape_Test_Restore_Switch()\n");
	printf("61. BOOL Tape_Next_Volume_Switch(int cmd)\n");	
	printf("62. BOOL Tape_Test_Next_Volume_Switch()\n");
	printf("63. BOOL Tape_Compare_Status_Info_Status_Field()\n");
	printf("64. BOOL Tape_Test_Is_Sp_For_Status_Info_Status_Field()\n");
	printf("65. BOOL Tape_Check_Mt_Finish()\n");
	printf("66. BOOL Tape_User_Abort_Mt()\n");
	printf("67, int Get_Server_Name(char *svr_name, int buf_size);\n");
	printf("68, void Tape_Set_Status_Info_Status_Time_Field();\n");	
	printf("69, int Tape_Get_Default_Restore_Dir(char *src, char *retdir, int length);\n");	
	printf("70, BOOL Tape_Exist_Default_Restore_Dir(char *source);\n");
	printf("71, void Tape_Clear_Tape_Info();\n");		
	printf("72, int Tape_Get_Schedule_Count();\n");	
	printf("73, BOOL Is_Tape_Support();\n");
	printf("74, BOOL Tape_Conf_File_Is_Null();\n");
	printf("75, BOOL Tape_Device_Ready();\n");
	printf("76, BOOL Tape_Set_Destination_Label_Field();\n");
	printf("77, BOOL Tape_Set_Destination_Temp_File(char *dest);\n");	
	printf("78, int Reset_Tape();\n");
	printf("===============================================================\n");				
	printf("\n");
}

void exec_and_show_result(int function_no)
{
/* for test library used*/
		TAPE_STATUS_INFO *tape_status_info;
		TAPE_MOUNTS_INFO *tape_mounts_info, *tape_mounts_start;
		TAPE_MOUNTS_INFO *tape_mounts_root_info, *tape_mounts_root_start;
		TAPE_MOUNTS_INFO *tape_mounts_share_info, *tape_mounts_share_start;
		TAPE_MOUNTS_SHARE_VOLUME_INFO *tape_mounts_share_volume_info, *tape_mounts_share_volume_start;		
		TAPE_LOG_INFO *tape_log_info, *tape_log_start;
		char incremented_file[MSTR_LENGTH]="";
		int j;
		TAPE_LOG_INFO *tape_log_last; 				//case 12
		SMB_SHARE_INFO *smb_info,*smb_start;			//case 19
		TAPE_INFO *tape_info, *tape_start, *tape_current=NULL;	//case 39, case 46, case 48		
		TAPE_BACKUP_SHARE_DIR_INFO *tape_backup_share_dir_info, *tape_backup_share_dir_start;
		TAPE_SCHEDULE_INFO *tape_schedule_info, *tape_schedule_start; //case 40	
		TAPE_BACKUP_SHARE_DIR_REVERSE_INFO *tape_backup_share_dir_reverse_info; //case 42
		char incremented_test_file[MSTR_LENGTH]; //case 43
		char alp_str[SSTR_LENGTH];	
		TAPE_SCHEDULE_TASK_NAME_INFO *tape_schedule_task_name_info, *tape_schedule_task_name_start; //case 40
		char servername[MSTR_LENGTH]=""; //case 67
		char restore_path[MSTR_LENGTH]=""; //case 69	
		int ret; // case 78
			
	switch (function_no) {
		case 0:
			exit(0);
		case 1:
/* read status info */		
		tape_status_info = Tape_Get_Status_Info(); 
		
		printf("tape_status_info->status: 			%s\n", tape_status_info->status);
		printf("tape_status_info->msg_time: 			%s\n", tape_status_info->msg_time);		
		printf("tape_status_info->tape_num: 			%d\n", tape_status_info->tape_num);		
		printf("tape_status_info->source: 			%s\n", tape_status_info->source);
		printf("tape_status_info->destination: 			%s\n", tape_status_info->destination);				
		printf("tape_status_info->label: 			%s\n", tape_status_info->label);
		printf("tape_status_info->type: 			%s\n", tape_status_info->type);
		printf("tape_status_info->compression: 			%d\n", tape_status_info->compression);						
		printf("tape_status_info->verify: 			%d\n", tape_status_info->verify);
		printf("tape_status_info->files_processed: 		%20.0f\n", tape_status_info->files_processed);
		printf("tape_status_info->megabytes_processed: 		%20.0f\n\n", tape_status_info->megabytes_processed);
				
		Tape_Free_Status_Info(tape_status_info);// erase memory
		getchar();
/* read status info */	
			break;
		case 2: 
/* read mounts info */		
		tape_mounts_info = Tape_Get_Mounts_Info(); 
		tape_mounts_start = tape_mounts_info;
		
		while(tape_mounts_info != NULL) {
			printf("tape_mounts_info->dev_path: 			%s\n", tape_mounts_info->dev_path);
			printf("tape_mounts_info->mount_path: 			%s\n", tape_mounts_info->mount_path);		
			tape_mounts_info = tape_mounts_info->next;
		}
				
		Tape_Free_Mounts_Info(tape_mounts_start);// erase memory
/* read mounts info */
			break;
		case 3:
/* read mounts share info */	
	
		tape_mounts_share_info = Tape_Get_Mounts_Share_Info(); 
		tape_mounts_share_start = tape_mounts_share_info;
		
		while(tape_mounts_share_info != NULL) {
			printf("tape_mounts_share_info->dev_path: 			%s\n", tape_mounts_share_info->dev_path);
			printf("tape_mounts_share_info->mount_path: 			%s\n", tape_mounts_share_info->mount_path);		
			tape_mounts_share_info = tape_mounts_share_info->next;
		}
				
		Tape_Free_Mounts_Info(tape_mounts_share_start);// erase memory
		getchar();
/* read mounts share info */
			break;
		case 4:
/* read mounts root info */		
		tape_mounts_root_info = Tape_Get_Mounts_Root_Info(); 
		tape_mounts_root_start = tape_mounts_root_info;
		
		while(tape_mounts_root_info != NULL) {
			printf("tape_mounts_root_info->dev_path: 			%s\n", tape_mounts_root_info->dev_path);
			printf("tape_mounts_root_info->mount_path: 			%s\n", tape_mounts_root_info->mount_path);		
			tape_mounts_root_info = tape_mounts_root_info->next;
		}
				
		Tape_Free_Mounts_Info(tape_mounts_root_start);// erase memory
		getchar();
/* read mounts root info */
			break;
		case 5:
/* read log info */	
	
		tape_log_info = Tape_Get_Log_Info(); 
		tape_log_start = tape_log_info;
		
		while(tape_log_info != NULL) {
			printf("tape_log_info->id: 			%d\n", tape_log_info->id);
			printf("tape_log_info->type: 			%s\n", tape_log_info->type);						
			printf("tape_log_info->time_stamp: 		%s\n", tape_log_info->time_stamp);
			printf("tape_log_info->msg: 			%s\n", tape_log_info->msg);		
			tape_log_info = tape_log_info->next;
		}
				
		Tape_Free_Log_Info(tape_log_start);// erase memory
		
/* read log info */
			break;
		case 6: 
/* find_incremented_file */	
// src = "sec.txt"
		find_incremented_file("sec.txt", incremented_file);	
		printf("incremented_file %s\n", incremented_file);
		getchar();			
/* find_incremented_file */	
			break;
		case 7:
/* tar cvf */	
		Tar_Cmd_Cvf(TAPE_DEFAULT_DEV, "/tmp/tmp3", "cool", "0", "0", "0", "");
//void Tar_Cmd_Cvf(char *dest, char *src, char *label, char *compress, char *verify, char *incremented, char *tape_length);		
/* tar cvf */	getchar();
			break;
		case 8:
/* tar xvf */	
		Tar_Cmd_Xvf(TAPE_DEFAULT_DEV, "", "0");
//void Tar_Cmd_Xvf(char *src, char *dest, char *keep_old_files);	
/* tar xvf */	getchar();
		break;
		case 9:
/* tar tvf */	
		Tar_Cmd_Tvf(TAPE_DEFAULT_DEV);		
//void Tar_Cmd_Tvf(char *src);		
/* tar tvf */	getchar();
		break;
		case 10:
/* read mounts share volume info */		
		tape_mounts_share_volume_info = Tape_Get_Mounts_Share_Volume_Info(); 
		tape_mounts_share_volume_start = tape_mounts_share_volume_info;
		
		while(tape_mounts_share_volume_info != NULL) {			
			
			printf("\ntape_mounts_share_volume_info->vol_no: 		%d\n", tape_mounts_share_volume_info->vol_no);
			printf("tape_mounts_share_volume_info->raid_level: 		%d\n", tape_mounts_share_volume_info->raid_level);
			
			for (j=0; j< tape_mounts_share_volume_info->list_cnt;j++) {
				printf("tape_mounts_share_volume_info->drive_no_list:");
				printf(" %d ", tape_mounts_share_volume_info->drive_no_list[j]);
				printf("\n");
			}								
			printf("tape_mounts_share_volume_info->list_cnt: 		%d\n", tape_mounts_share_volume_info->list_cnt);					
			printf("tape_mounts_share_volume_info->status: 			%d\n", tape_mounts_share_volume_info->status);								
			printf("tape_mounts_share_volume_info->total_size: 		%f\n", tape_mounts_share_volume_info->total_size);
			printf("tape_mounts_share_volume_info->free_size: 		%f\n", tape_mounts_share_volume_info->free_size);											
			printf("tape_mounts_share_volume_info->dev_path: 		%s\n", tape_mounts_share_volume_info->dev_path);
			printf("tape_mounts_share_volume_info->mount_path: 		%s\n", tape_mounts_share_volume_info->mount_path);
			
			getchar();
			printf("\nplease press any key!\n\n");
					
			tape_mounts_share_volume_info = tape_mounts_share_volume_info->next;
		}
				
		Tape_Free_Mounts_Share_Volume_Info(tape_mounts_share_volume_start);// erase memory
/* read mounts share volume info */
			break;
		case 11:
			Tape_Clear_Status_Info();
			break;
		case 12:
/* read last log info */		
			tape_log_last = Tape_Get_Log_Last_Line(); 
		
			printf("tape_log_info->id: 			%d\n", tape_log_last->id);
			printf("tape_log_info->type: 			%s\n", tape_log_last->type);					
			printf("tape_log_info->time_stamp: 		%s\n", tape_log_last->time_stamp);
			printf("tape_log_info->msg: 			%s\n", tape_log_last->msg);		
				
			Tape_Free_Log_Info(tape_log_last);// erase memory
			getchar();
/* read last log info */
			break;
		case 13:
		 	Tape_Set_Status_Info_Status_Field();
			break;
		case 14:
			Tape_Set_Status_Info_Count_Size_Field();
			break;
		case 15:
			Tape_Set_Status_Info_Source_Label_Field();
			break;
		case 16:
			Tape_Set_Status_Info_Compress_Verify_Type_Field("1", "1", "1");
			// type:1->i, 0->f | compress:1->c, 0->u | verify:1->v, 0->u
			break;
		case 17:
			Tape_Set_Status_Info_Num_Field();
			break;
		case 18:
			Tape_Set_All_Status_Info("0", "0", "0");
			break;
		case 19:
			smb_info = SMB_Get_Share_Info();
			smb_start = smb_info;
			
			while(smb_info != NULL) {
				printf("smb_info->sharename %s\n", smb_info->sharename);
				printf("smb_info->path %s\n", smb_info->path);
				smb_info = smb_info->next;
			}
		
			SMB_Free_Share_Info(smb_start);
			break;
		case 20:
/* read tape backup share dir info */	
			tape_backup_share_dir_info = Tape_Backup_Share_Dir_Info(); 
			tape_backup_share_dir_start = tape_backup_share_dir_info;
		
			while(tape_backup_share_dir_info != NULL) {
				printf("tape_backup_share_dir_info->share_type: 			%s\n", tape_backup_share_dir_info->share_type);				
				printf("tape_backup_share_dir_info->share_name: 			%s\n", tape_backup_share_dir_info->share_name);
				printf("tape_backup_share_dir_info->share_path: 			%s\n", tape_backup_share_dir_info->share_path);
				tape_backup_share_dir_info = tape_backup_share_dir_info->next;
			}
				
			Tape_Free_Backup_Share_Dir_Info(tape_backup_share_dir_start);// erase memory
/* read tape backup share dir info */
			getchar();
			break;
		case 21:
			Tape_Set_New_Cron_Job("test_task", "/tmp", "0",
	 			1, 1, 0, "345", 0, 12, 24);
			break;
		case 22:
			if (Tape_Test_Included_Sp("test_ok"))
				printf("included space\n");
			else
				printf("is not included space\n");			
			getchar();
			
			break;
		case 23:
			if (Tape_Delete_Cron_Job(0, "WwT_task"))
				printf("find it\n");
			else
				printf("doesn't find\n");
				
			getchar();
			break;
		case 24:
			if (Tape_Test_Duplicate_Name("CCC"))
				printf("duplicate\n");
			else
				printf("doesn't duplicate\n");
			getchar();
			break;
		case 25:
			printf("find a unoccupied id = %d\n", Tape_Find_Unoccupied_Id());
			getchar();
			break;
		case 26:
			Tape_Set_Confirm_Next_Volume_Yes();
			break;
		case 27:
			Tape_Set_Confirm_Next_Volume_No();
			break;
		case 28:
			if(Tape_Do_Next_Volume_Job())
				printf("run next volume success\n");
			else
				printf("run nex volume fail\n");
			break;
		case 29:
			if(Tape_Check_Need_Next_Volume())
				printf("need next volume\n");
			else
				printf("doesn't need next volume\n");
			getchar();			
			break;
		case 30:
			switch (Tape_Get_Next_Volume_No()) {
			case 0  : printf ("one volume enough, doesn't need next volume\n");
					break;
			case -1	: printf ("not find\n");
					break;		
			case -2	: printf ("can't open file\n");
					break;
			default : printf ("next volume number %d\n", Tape_Get_Next_Volume_No());
					break;		
			}
			getchar();
			break;
		case 31:
			if(Tape_Check_Job_Finish())
				printf("tape job finish\n");
			else
				printf("doesn't finish tape job\n");
			getchar();			
			break;	
		case 32:
			if(Tape_User_Abort_Job())
				printf("user abort job successfully\n");
			else
				printf("user abort job failure\n");
			getchar();			
			break;	
		case 33:
			Tape_Eject_Tape();
			break;				
		case 34:
			Tape_Rewind_Tape();
			break;			
		case 35:
			Tape_Erase_Tape();
			break;
		case 36:
			Tape_Forward_Count_Tape(2);
			break;
		case 37:
			tape_info = Tape_Get_Tape_Info();
			
			printf("tape_info->timestamp %s\n", tape_info->timestamp);
			printf("tape_info->label %s\n", tape_info->label);
			printf("tape_info->volume %s\n", tape_info->volume);
			printf("tape_info->compress %s\n", tape_info->compress);			
			printf("tape_info->source %s\n", tape_info->source);
			printf("tape_info->servername %s\n", tape_info->servername);
						
			Tape_Free_Tape_Info(tape_info);
			getchar();
			break;						
		case 38:
			tape_schedule_info = Tape_Get_Schedule_Info(); // get data structure
			tape_schedule_start = tape_schedule_info;

			while(tape_schedule_info != NULL) { // read data

				printf("tape_schedule_info->id			%d\n", tape_schedule_info->id);	
				printf("tape_schedule_info->task_name		%s\n", tape_schedule_info->task_name);
				printf("tape_schedule_info->source		%s\n", tape_schedule_info->source);						
				printf("tape_schedule_info->type		%s\n", tape_schedule_info->type);
				printf("tape_schedule_info->compress		%d\n", tape_schedule_info->compress);			
				printf("tape_schedule_info->verify		%d\n", tape_schedule_info->verify);			
				printf("tape_schedule_info->day			%d\n", tape_schedule_info->day	);			
				printf("tape_schedule_info->weekly		%s\n", tape_schedule_info->weekly);			
				printf("tape_schedule_info->monthly		%d\n", tape_schedule_info->monthly);			
				printf("tape_schedule_info->hh			%d\n", tape_schedule_info->hh);
				printf("tape_schedule_info->mm			%d\n", tape_schedule_info->mm);			
				printf("tape_schedule_info->tape_cmd		%s\n", tape_schedule_info->tape_cmd);
				printf("tape_schedule_info->status		%s\n", tape_schedule_info->status);
				printf("tape_schedule_info->pid			%d\n", tape_schedule_info->pid);				
								
				tape_schedule_info = tape_schedule_info->next;

				getchar();
			}
			Tape_Free_Schedule_Info(tape_schedule_start);// erase memory	
			break;
		case 39:
			if (Tape_Set_Cron_Job_Srcipt("BBB"))
				printf("make script successfully");
			else
				printf("make script failure");
			getchar();
			break;
		case 40:
			tape_backup_share_dir_reverse_info = Tape_Get_Backup_Share_Dir_Reverse_Info("/share/MD0_DATA"); // get data structure
			
			if ( tape_backup_share_dir_reverse_info != NULL ) {
				printf("tape_backup_share_dir_reverse_info->share_type	%s\n", tape_backup_share_dir_reverse_info->share_type);
				printf("tape_backup_share_dir_reverse_info->share_name	%s\n", tape_backup_share_dir_reverse_info->share_name);
			}
			Tape_Free_Backup_Share_Dir_Reverse_Info(tape_backup_share_dir_reverse_info);// erase memory	
			getchar();		
			break;	
		case 41:
//			printf("find_incremented_file_ex_1        %s\n", find_incremented_file_ex_1("/share/MD0_DATA/q1", incremented_test_file));
			printf("find_incremented_file_ex_1        %s\n", find_incremented_file_ex_1("/share/MD0_DATA/xyz", incremented_test_file));			
			getchar();
			break;	
		case 42:
			Tape_Delete_History_Log();
			break;
		case 43:
/* read history log info */	
	
			tape_log_info = Tape_Get_History_Log_Info(); 
			tape_log_start = tape_log_info;
		
			while(tape_log_info != NULL) {
				printf("tape_log_info->id: 			%d\n", tape_log_info->id);
				printf("tape_log_info->type: 			%s\n", tape_log_info->type);						
				printf("tape_log_info->time_stamp: 		%s\n", tape_log_info->time_stamp);
				printf("tape_log_info->msg: 			%s\n", tape_log_info->msg);		
				tape_log_info = tape_log_info->next;			
				getchar();			
			}
				
			Tape_Free_History_Log_Info(tape_log_start);// erase memory
		
/* read history log info */
			break;
		case 44:
			if (Tape_Clear_History_Log())
				printf("clear history log successfully\n");
			else
				printf("clear history log failure\n");
			break;
		case 45:
			Tape_Set_All_Status_Info_Except_Compress_Verify_Type_Field();
			break;			
		case 46:
			tape_info = Tape_Get_All_Tape_Info();
			tape_start = tape_info;
		
			while(tape_info != NULL) {
				printf("tape_info->timestamp %s\n", tape_info->timestamp);
				printf("tape_info->label %s\n", tape_info->label);
				printf("tape_info->volume %s\n", tape_info->volume);
				printf("tape_info->compress %s\n", tape_info->compress);			
				printf("tape_info->source %s\n", tape_info->source);					
				tape_info = tape_info->next;
				getchar();
			}				
			Tape_Free_Info(tape_start);// erase memory			
			
			break;			
		case 47:
			tape_info = Tape_Get_Assign_Tape_Info(3);
			
			printf("tape_info->timestamp %s\n", tape_info->timestamp);
			printf("tape_info->label %s\n", tape_info->label);
			printf("tape_info->volume %s\n", tape_info->volume);
			printf("tape_info->compress %s\n", tape_info->compress);			
			printf("tape_info->source %s\n", tape_info->source);
			
			Tape_Free_Tape_Info(tape_info);
			getchar();
			break;	
		case 48:
			if (Tape_Info_Test(tape_current))  
				printf("The content is ok in the tape.\n");
			else 	printf("There are no any content in the tape.\n");
			break;	
		case 49:
			if (Tape_Test_Source_Compress(TAPE_DEFAULT_DEV))  
				printf("The source is compress file.\n");
			else 	printf("The source is non-compress file.\n");
			getchar();
			break;	
		case 50:
			if (Tape_Test_Log_Occur_Error(TAPE_TAR_t_FILE))  
				printf("There is a error message in the log file at least.\n");
			else 	printf("There is no any error message in the log file.\n");
			getchar();
			break;	
		case 51:
			if (Tape_Weekly_Num_To_Weekly_Alp("0123456", alp_str, sizeof(alp_str)))
				printf("The result %s\n", alp_str);
			else
				printf("The pass parameter buffer is too small\n");
			getchar();
			break;	
		case 52:
/* read history log info by case*/		
			tape_log_info = Tape_Get_History_Log_Info_By_Case("ALL"); 
			tape_log_start = tape_log_info;
		
			while(tape_log_info != NULL) {
				printf("tape_log_info->id: 			%d\n", tape_log_info->id);
				printf("tape_log_info->type: 			%s\n", tape_log_info->type);						
				printf("tape_log_info->time_stamp: 		%s\n", tape_log_info->time_stamp);
				printf("tape_log_info->msg: 			%s\n", tape_log_info->msg);		
				tape_log_info = tape_log_info->next;			
				getchar();			
			}
				
			Tape_Free_History_Log_Info(tape_log_start);// erase memory
		
/* read history log info*/
			break;
		case 53:
			printf("The total history %d\n", Tape_Get_History_Log_Info_Total_By_Case("NORMAL"));
			getchar();
			break;	
		case 54:
/* read history log info by case*/		
			tape_log_info = Tape_Get_History_Log_Info_By_Case_and_Page("NORMAL", 3); 
			tape_log_start = tape_log_info;
		
			while(tape_log_info != NULL) {
				printf("tape_log_info->id: 			%d\n", tape_log_info->id);
				printf("tape_log_info->type: 			%s\n", tape_log_info->type);						
				printf("tape_log_info->time_stamp: 		%s\n", tape_log_info->time_stamp);
				printf("tape_log_info->msg: 			%s\n", tape_log_info->msg);		
				tape_log_info = tape_log_info->next;			
				getchar();			
			}
				
			Tape_Free_History_Log_Info(tape_log_start);// erase memory
		
/* read history log info*/
			break;	
		case 55:
/* read history log info by case*/		
			tape_log_info = Tape_Get_History_Log_Info_By_Page(5); 
			tape_log_start = tape_log_info;
		
			while(tape_log_info != NULL) {
				printf("tape_log_info->id: 			%d\n", tape_log_info->id);
				printf("tape_log_info->type: 			%s\n", tape_log_info->type);						
				printf("tape_log_info->time_stamp: 		%s\n", tape_log_info->time_stamp);
				printf("tape_log_info->msg: 			%s\n", tape_log_info->msg);		
				tape_log_info = tape_log_info->next;			
				getchar();			
			}
				
			Tape_Free_History_Log_Info(tape_log_start);// erase memory
		
/* read history log info*/
			break;	
		case 56:
			printf("The total page %d\n", Tape_Get_History_Log_Info_Total_Page_By_Case("ERROR"));
			getchar();
			break;	
		case 57:			
			tape_schedule_task_name_info = Tape_Set_Schedule_Task_Name_Info(NULL, "AAA"); //set first data		
			tape_schedule_task_name_info = Tape_Set_Schedule_Task_Name_Info(tape_schedule_task_name_info, "BBB"); //set more data	
			tape_schedule_task_name_info = Tape_Set_Schedule_Task_Name_Info(tape_schedule_task_name_info, "CCC"); //set more data		
			tape_schedule_task_name_info = Tape_Set_Schedule_Task_Name_Info(tape_schedule_task_name_info, "DDD"); //set more data		
			tape_schedule_task_name_start = tape_schedule_task_name_info;

			while(tape_schedule_task_name_info != NULL) { // read data
				printf("tape_schedule_task_name_info->name			%s\n", tape_schedule_task_name_info->task_name);	
				tape_schedule_task_name_info = tape_schedule_task_name_info->next;
			}
			Tape_Free_Schedule_Task_Name_Info(tape_schedule_task_name_start);// erase memory	
			getchar();
			break;	
		case 58:
			if (Tape_Restore_Switch(0))
				printf("Do the restore switch successfully\n");
			else
				printf("Do the restore swtich failure\n");
			getchar();
			break;	
		case 59:
			Tape_Set_All_Restore_Status_Info();
			printf("Set the restore status\n");
			getchar();
			break;	
		case 60:
			if (Tape_Test_Restore_Switch())
				printf("Execute restore job for the current time\n");
			else
				printf("Don't execute restroe job now\n");
			getchar();
			break;	
		case 61:
			if (Tape_Next_Volume_Switch(0))
				printf("Do the next volume switch successfully\n");
			else
				printf("Do the next volume swtich failure\n");
			getchar();
			break;
		case 62:
			if (Tape_Test_Next_Volume_Switch())
				printf("Execute next volume job for the current time\n");
			else
				printf("Don't execute next volume job now\n");
			getchar();
			break;
		case 63:
			if (Tape_Compare_Status_Info_Status_Field())
				printf("The config file status is as same as last line message.\n");
			else
				printf("The config file status is not as same as last line message.\n");
			getchar();
			break;	
		case 64:
			if (Tape_Test_Is_Sp_For_Status_Info_Status_Field())
				printf("The config file status is included \"--\" string.\n");
			else
				printf("The config file status is not included \"--\" string.\n");
			getchar();
			break;	
		case 65:
			if (Tape_Check_Mt_Finish())
				printf("No mt job running.\n");
			else
				printf("Mt job running.\n");
			getchar();
			break;			
		case 66:
			if (Tape_User_Abort_Mt())
				printf("Kill mt job successfully.\n");
			else
				printf("Kill mt job failure.\n");
			getchar();
			break;	
		case 67:
			Get_Server_Name(servername, sizeof(servername));
			printf("The server name is %s.\n", servername);
			getchar();
			break;	
		case 68:
		 	Tape_Set_Status_Info_Status_Time_Field();
			break;	
		case 69:
			Tape_Get_Default_Restore_Dir("/mnt/config/tape/new", restore_path, sizeof(restore_path));
		 	printf("The default restore path is %s\n", restore_path);
		 	getchar();
			break;
		case 70:
		 	if (Tape_Exist_Default_Restore_Dir("/share/MD0_DATA"))
		 		printf("exist the default path\n");
		 	else
		 		printf("non-exist the default path\n");
		 	getchar();
			break;	
		case 71:
		 	Tape_Clear_Tape_Info();
			break;				
		case 72:
		 	printf("There are %d data in the schedule list\n", Tape_Get_Schedule_Count());
			getchar();
			break;	
		case 73:
			if (Is_Tape_Support())
		 		printf("The tape function is enable\n");
		 	else
		 		printf("Disabled tape function\n");
		 	getchar();			
			break;	
		case 74:
			if (Tape_Conf_File_Is_Null())
		 		printf("The tape config file is null\n");
		 	else
		 		printf("The tape config file isn't null\n");
		 	getchar();			
			break;
		case 75:
			if (Tape_Device_Ready())
		 		printf("The tape device is ready\n");
		 	else
		 		printf("The tape device isn't ready\n");
		 	getchar();			
			break;	
		case 76:
			if (Tape_Set_Destination_Label_Field())
				printf("set uLinux.conf file successfully\n");
			else
				printf("set uLinux.conf file failure\n");
			getchar();
			break;			
		case 77:
			if (Tape_Set_Destination_Temp_File("ABC"))
				printf("set temp file successfully\n");
			else
				printf("set temp file failure\n");
			getchar();
			break;		
		case 78:
			ret = Reset_Tape();
			printf("ret = %d\n", ret);
			break;																																																																																		
		default:
			printf("Unknown function number!\n");
			getchar();
			break;
	} 
}

int main()
{
	int f;
	while(1) {
		print_menu();
		printf("\n");
		scanf("%d", &f);
		printf("\n\n");
		exec_and_show_result(f);
		getchar();
		printf("\nplease press any key\n\n");
	}
}

// Catherine 2003/04/17 for "backup-from_snapshot"
#if	BACKUP_FROM_SNAPSHOT
void Tape_Set_New_Cron_Job_Ex(char *task_name, char *source, char *type,
	 int compress, int verify, int day, char *weekly, int monthly, int hh, int mm,
	 int from_snapshot)
{
	FILE 	*fptr;
	char	type_buf[SSTR_LENGTH];
	int 	id;
	char    tape_cmd[SSTR_LENGTH];
	
	if (strcasecmp(type, "1") == 0)			//1:Full
		strcpy(type_buf, "Full");
	else if (strcasecmp(type, "0") == 0)		//0:Incremental
		strcpy(type_buf, "Incremental");
	else	strcpy(type_buf, "Unknow");
	
	if ((fptr=fopen(TAPE_CRONTAB_FILE, "a+"))==NULL)
		return;

	id = Tape_Find_Unoccupied_Id();
	
	sprintf(tape_cmd, "%d.sh", id);
		
	fprintf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d %d \n",
		id, task_name, Tape_Invert_Sp_Char(source), type_buf, compress,
		verify, day, weekly, monthly, hh, mm, tape_cmd,
		TAPE_JOB_READY_STATUS, TAPE_JOB_DEFAULT_PID,
		from_snapshot);
	
	fclose(fptr);
	
	Tape_Set_Cron_Job_Srcipt(task_name); //new_add	
}

int Tape_Edit_Cron_Job_Fields(TAPE_SCHEDULE_INFO* jobinfo)
{
	FILE 	*fptr, *fptrm;
	int	result = ERROR_NOT_FOUND, id;
	char	task_name[SSTR_LENGTH];
	char	source[MSTR_LENGTH];
	char	type[SSTR_LENGTH];
	int	compress, verify, day;
	char	weekly[SSTR_LENGTH];
	int	monthly, hh, mm;
	char	tape_cmd[SSTR_LENGTH];
	char	status[SSTR_LENGTH];
	int	pid, is_from_snap;
	char	snapname[LV_PATH_MAX_LEN];
	char	sys_cmd[BUF_SIZE];
	char	line[LSTR_LENGTH];
	
	// backup the original crontab.tape
	sprintf(sys_cmd, "/bin/cp -f %s %s", TAPE_CRONTAB_FILE, TAPE_CRONTAB_TMP_FILE);	
	system(sys_cmd);

	// crontab file OK?
	if ((fptrm=fopen(TAPE_CRONTAB_FILE, "r+"))==NULL)
		return ERROR_OPEN_FILE;

	// backup crontab file OK?
	if ((fptr=fopen(TAPE_CRONTAB_TMP_FILE, "w+"))==NULL) {
		fclose(fptrm);		
		return ERROR_OPEN_FILE;
	}

	while (fgets(line, sizeof(line), fptrm))
	{	
		is_from_snap = 0;
		id = 0;
		strcpy(snapname, "");
		strcpy(task_name, ""); //prevent read null line

		sscanf(line, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d %d %s",
			&id, task_name, source, type, &compress, &verify,
			&day, weekly, &monthly, &hh, &mm, tape_cmd, status,
			&pid, &is_from_snap, snapname);

		if (strcasecmp(task_name,"")==0) //prevent read null line
			continue;

		if ((jobinfo->id == id) || (strcasecmp(jobinfo->task_name, task_name) == 0)) {
			result = SUCCESS;
			fprintf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d %d %s\n", 
				jobinfo->id, jobinfo->task_name, jobinfo->source, jobinfo->type,
				jobinfo->compress, jobinfo->verify, jobinfo->day, 
				jobinfo->weekly, jobinfo->monthly, jobinfo->hh, jobinfo->mm,
				jobinfo->tape_cmd, jobinfo->status, jobinfo->pid,
				jobinfo->backup_from_snap, jobinfo->snapname);
		}	
		else
			fprintf(fptr, "%d %s %s %s %d %d %d %s %d %d %d %s %s %d %d %s\n", 
				id, task_name, source, type, compress, verify,
				day, weekly, monthly, hh, mm, tape_cmd, status, pid,
				is_from_snap, snapname);
	}

	fclose(fptrm);				
	fclose(fptr);
	if (result == SUCCESS) {
		sprintf(sys_cmd, "/bin/mv -f %s %s", TAPE_CRONTAB_TMP_FILE, TAPE_CRONTAB_FILE);	
		system(sys_cmd);
	}

	return result;
}

int get_new_snapshot_info_from_source(char* tape_src, SNAPSHOT_VOLUME_CONF *sconf)
{
	char tmpname[SHARE_NAME_LENGTH];
	char vgname[LV_PATH_MAX_LEN], srclvname[LV_PATH_MAX_LEN];
	int ret;

	if (tape_src == NULL || sconf == NULL)
		return ERROR_INVALID_PARAM;

	if (!Is_Existing_Directory(tape_src))
		return ERROR_NOT_EXISTED;

	if ((ret = Get_LVM_Volume_LV_From_Path(tape_src, srclvname)) < 0)
		return ret;

	if (!Is_Allocatable_Snapshot_Volume(srclvname, 1))
		return ERROR_INVALID_PARAM;

	if ((ret = Get_VG_Name_By_LV(srclvname, vgname, sizeof(vgname))) < 0)
		return ret;

	sprintf(tmpname, "%sXXXXXX", BACKUP_SNAPSHOT_PREFIX);
	mktemp(tmpname);
	sprintf(sconf->c_Snapshot_Path, "%s/%s", vgname, tmpname);
	strcpy(sconf->c_Src_LV, srclvname);
	sconf->Priority = PRIORITY_HIGH;
	sconf->b_Is_Scheduled_Snap = FALSE;
	return SUCCESS;
}

void print_sys_log(char *str, int flag)
{
	char sys_buf[255];
	sprintf(sys_buf, "%s \"%s\" %d", TAPE_write_log_prog, str, flag);
       	system(sys_buf);	
}

void Tar_Cmd_Cvf_Ex(char *dest, char *src, char *label, char *compress,
	char *verify, char *incremented, char *tape_length, int is_from_snap)
{
   char tar_cmd[LSTR_LENGTH];
   char sys_cmd[MSTR_LENGTH];
   char label_cmd[SSTR_LENGTH]; 
   char compress_cmd[4]="";
   char verify_cmd[16]="";
   char multi_volume_cmd[8]=" -M";
   char incremented_cmd[4]="";      
   char incremented_file[MSTR_LENGTH]="";
   char tape_length_buf[SSTR_LENGTH]=" -L";
   char isrc[MSTR_LENGTH]="";
   char err[BUF_SIZE];
   FILE *fp = NULL;
   char orgsrc[LSTR_LENGTH];
   char *pp;

   if ((pp = strchr(src, '\"')) != NULL) {
	strcpy(orgsrc, pp+1);
	if ((pp = strrchr(orgsrc, '\"')) != NULL)
		*pp = 0x0;			
   }
   else
	strcpy(orgsrc, src);

   if (strstr(label, " ") != NULL) { 					//label
  		printf("Label can't include ' ' character !\n");
  		print_sys_log("Label can't include ' ' character !", TAPE_write_log_error);
   		return;
   	}	
   else if (strcasecmp(label, "") == 0)
   		strcpy(label_cmd,"NO_NAME");
   else strcpy(label_cmd,label);

   if (!strcasecmp(tape_length,TAPE_NULL_STR))
   	strcpy(tape_length_buf, TAPE_NULL_STR);
   else
	strcat(tape_length_buf, tape_length);

	   if (strcasecmp(compress, "1") == 0)				//compress
	   	strcpy(compress_cmd, " -z");
	   else if (strcasecmp(compress, "0") == 0)
	   	strcpy(compress_cmd, "");
	   else {
	   	printf("Don't define compress option!\n");
	   	print_sys_log("Don't define compress option!", TAPE_write_log_error);
	   	return;
	   }
   
	   if (strcasecmp(verify, "1") == 0)				//verify
	   	strcpy(verify_cmd, " -W -C/");
	   else if (strcasecmp(verify, "0") == 0)
	   	strcpy(verify_cmd, "");
	   else {
	   	printf("Don't define verify option!\n");
	   	print_sys_log("Don't define verify option!", TAPE_write_log_error);
	   	return;
	   } 	
  
	   if (strcasecmp(incremented, "1") == 0) {			//incremented
	   	strcpy(incremented_cmd, " -g");
	   	Tape_Transfer_Sp_Char(src, isrc);			// 09-16-2002, Johnson modify
	   	find_incremented_file_ex_1(isrc, incremented_file);	// 09-16-2002, Johnson modify
	   }	
	   else if (strcasecmp(incremented, "0") == 0) {
	   	strcpy(incremented_cmd, " -g");
	   	Tape_Transfer_Sp_Char(src, isrc);			// 09-16-2002, Johnson modify
	   	find_incremented_file_ex_1(isrc, incremented_file);	// 09-16-2002, Johnson modify
	   	
	   	if (strcasecmp(incremented_file,"") != 0) {
	   		sprintf(sys_cmd, "rm -f %s", incremented_file);
	   		system(sys_cmd);
	   	}
	   }	   	
	   else {
	   	printf("Don't define incremented option!\n");
	   	print_sys_log("Don't define incremented option!", TAPE_write_log_error);
	   	return;
	   }
  
	   if (strcasecmp(incremented_file, "") == 0)
	      strcpy(incremented_cmd, "");

	   // create a temp snapshot to do rr and the source is not a snapshot itself
	   if (is_from_snap && strncmp(src, "/share/SNAPSHOTS/", 17)!= 0) {
		int ret, i;
		char newsrc[LSTR_LENGTH];
		char snapmp[MSTR_LENGTH], sharedir[MSTR_LENGTH];
		SNAPSHOT_VOLUME_CONF sn_vol_conf;
		char TAPE_timep_buf[BUF_SIZE] = {""};
		time_t TAPE_timep;

		// handle the backup source info
		if ((fp = fopen(TAPE_TAR_e_FILE, "w+")) == NULL) {
			print_sys_log("Backup job cannot open a status file ("
				TAPE_TAR_e_FILE
				") to write.",
				TAPE_write_log_error);
			return;
		}
		fprintf(fp, "TAPE_current_label %s\n", label_cmd);
		fprintf(fp, "TAPE_source %s\n", orgsrc);
		fclose(fp);

		// handle the backup status info
		time(&TAPE_timep);

		if ((fp = fopen(TAPE_TAR_q_FILE, "w+")) == NULL) {
			print_sys_log("Backup job cannot open a status file ("
			TAPE_TAR_q_FILE
			") to write.",
			TAPE_write_log_error);
			return;
		}
		fprintf(fp, "TAPE MSG [0]: [%s] [NORMAL] "
			"Create a temporary snapshot for the backup job.\n",
			strncpy(TAPE_timep_buf, (char *)ctime(&TAPE_timep), 24));
		fclose(fp);

		ret = get_new_snapshot_info_from_source(orgsrc, &sn_vol_conf);
		if (ret<0) {
#ifdef	_DEBUG
			printf("get_new_snapshot_info_from_source fails, "
				"err=%d\n", ret);
#endif
			sprintf(err, "Cannot create snapshot for backup source \"%s\", "
				"err=%d\n", orgsrc, ret);
			print_sys_log(err, TAPE_write_log_error);
			return;
		}

		ret = Add_Snapshot_Volume_Record(&sn_vol_conf);
		if (ret<=0) {
#ifdef	_DEBUG
			printf("fails to add a new snapshot record, "
				"err=%d\n", ret);
#endif
			sprintf(err, "Fails to add a new snapshot record, "
				"err=%d\n", ret);
			print_sys_log(err, TAPE_write_log_error);
			return;
		}

		ret = Create_Snapshot_Volume(&sn_vol_conf);
		if (ret<0) {
#ifdef	_DEBUG
			printf("fails to add a new snapshot volume,"
				"err=%d\n", ret);
#endif
			sprintf(err, "Fails to add a new snapshot volume,"
				"err=%d\n", ret);
			print_sys_log(err, TAPE_write_log_error);
			return;
		}
		Set_Snapshot_Status(sn_vol_conf.i_Snapshot_No, S_VOLUME_BUSY);

		Get_Mount_Point(sn_vol_conf.c_Snapshot_Path, snapmp);
		pp = orgsrc;
		for (i=0; i<2 && pp && *pp; i++) pp = strchr(pp+1, '/');

 		if (pp && *(pp+1)) {
 			strcpy(sharedir, (char*)(pp+1));
 			sprintf(newsrc, "\"%s/%s\"", snapmp, sharedir);
 		}
 		else
			sprintf(newsrc, "\"%s\"", snapmp);

	   	sprintf(tar_cmd, "%s cvf %s %s -V%s%s%s%s%s%s%s %s %s %s %s %s %s "
	   		"> /dev/null 2>&1",
	   		TAPE_TAR_PATH, dest, newsrc, label_cmd, compress_cmd, verify_cmd,
	   		multi_volume_cmd, incremented_cmd, incremented_file,
	   		tape_length_buf, TAPE_TAR_FLAG_a_FILE,
	   		TAPE_TAR_FLAG_j_FILE, TAPE_TAR_FLAG_q_FILE, TAPE_TAR_FLAG_H_FILE,
	   		TAPE_TAR_FLAG_Q_FILE, TAPE_TAR_FLAG_D_FILE);

		system(tar_cmd);

#ifdef	_DEBUG
		printf("command = [%s]<br>\n", tar_cmd);
#endif

	   	Set_Snapshot_Status(sn_vol_conf.i_Snapshot_No, S_READY);

	   	if (Get_Snapshot_Volume_Use_Rate(sn_vol_conf.c_Snapshot_Path) >= 100) {
			print_sys_log("Backup job might have failed due to snapshot overflow.",
				TAPE_write_log_error);
		}
		Delete_Snapshot_Volume(sn_vol_conf.i_Snapshot_No);
	   }
	   else {
	   	sprintf(tar_cmd, "%s cvf %s %s -V%s%s%s%s%s%s%s %s %s %s %s %s %s %s "
	   		"> /dev/null 2>&1",
	   		TAPE_TAR_PATH, dest, src, label_cmd, compress_cmd, verify_cmd,
	   		multi_volume_cmd, incremented_cmd, incremented_file,
	   		tape_length_buf, TAPE_TAR_FLAG_a_FILE, TAPE_TAR_FLAG_e_FILE,
	   		TAPE_TAR_FLAG_j_FILE, TAPE_TAR_FLAG_q_FILE, TAPE_TAR_FLAG_H_FILE,
	   		TAPE_TAR_FLAG_Q_FILE, TAPE_TAR_FLAG_D_FILE);
	   	system(tar_cmd);
	   }
}

#endif
