//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_system.c
//
//	Abstract: 
//		System configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		12/06/00	Meiji Chang created
//		10/08/01	Add Set_Web_Access(int type, int bEnable) function
//				    Get_Web_Access(int type) function
//				    Set_Web_Access_Port(int port) function
//				    Get_Web_Access_Port() function
//
//**************************************************************************
#define __TIME_ZONE__
#define __CODE_PAGE__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

/* NAS include file */
#include <config.h>
#include <timezone.h>
#include <codepage.h>
#include <Util.h>
#include <shm_conf.h> // Catherine
#include <NAS.h>
#include <cfg_fw.h>
#include <cfg_nic.h>
#include <cfg_dhcp.h>
#include <cfg_ftp.h>
#include <cfg_printer.h>

/* NAS include file by Kent */
#include <cfg_system.h>
#include <file_lock.h>
#include <naslvm.h>

#include <cfg_rtrr.h>
#include "eventlog.h"

#define USR_PASSWD_PATH			"/etc/passwd"
#define DEFAULT_USR_PASSWD_PATH		"/etc/default_config/passwd"
#define USR_SHADOW_PATH			"/etc/shadow"
#define DEFAULT_USR_SHADOW_PATH		"/etc/default_config/shadow"
#define USR_GROUP_PATH			"/etc/group"
#define DEFAULT_USR_GROUP_PATH		"/etc/default_config/group"
#define SMBPASSWD_PATH			"/etc/config/smbpasswd"
#define DEFAULT_SMBPASSWD_PATH		"/etc/default_config/smbpasswd"
#define NW_PASSWD_PATH			"/etc/config/nwpwd"
#define DEFAULT_NW_PASSWD_PATH		"/etc/config/nwpwd.bak"



extern int set_samba_netbios_name(char *name);
extern int set_samba_codepage(char *cp_str);
extern int set_samba_wrokgroup_name(char *workgroup);
extern int set_samba_server_string(char *svr_str);
int Reset_Disk();	// source code under storage/lvm.c

//                  0    1    2    3    4    5    6    7    8     9
int ZoneDiff[] = {-720,-660,-600,-540,-480,-420,-420,-360,-360,-360,
				  -300,-300,-300,-240,-240,-240,-210,-180,-180,-120,
				   -60,   0,   0,  60,  60,  60,  60, 120, 120, 120,
				   120, 120, 120, 180, 180, 180, 210, 240, 240, 270,
 				   300, 300, 330, 360, 360, 420, 480, 480, 480, 480,
				   540, 540, 540, 570, 570, 600, 600, 600, 600, 600,
				   660, 720, 720
};

/* ------------------------------------------------------------------------- **
 * Build options...
 */




/* ------------------------------------------------------------------------- **
 * Constants...
 */



/* ------------------------------------------------------------------------- **
 * Variables...
 *
 *  bufr        - pointer to a global buffer.  This is probably a kludge,
 *                but it was the nicest kludge I could think of (for now).
 *  bSize       - The size of the global buffer <bufr>.
 */






/* ------------------------------------------------------------------------- */
/*         		Function Implementation                              */
/* ------------------------------------------------------------------------- */



#define	SZ_SYSTEM_SECTION		"System"
#define	SZ_SERVER_NAME_FIELD		"Server Name"
#define	SZ_NW_SERVER_NAME_FIELD		"Netware Server Name"
#define	SZ_SERVER_NAME_DEFAULT		"uLinux"
#define	SZ_SERVER_COMMENT_FIELD		"Server Comment"
#define	SZ_SERVER_COMMENT_DEFAULT	"uLinux Server"
#define	SZ_VERSION_FIELD		"Version"
#define	SZ_VERSION_DEFAULT		"1.0"
#define	SZ_TIMEZONE_FIELD		"Time Zone"
#define	SZ_TIMEZONE_DEFAULT		"US/Eastern"
#define	SZ_DAYLIGHT_SAVING_FIELD	"Enable Daylight Saving Time"
#define	SZ_CODEPAGE_FIELD		"Code Page"
#define	SZ_CODEPAGE_DEFAULT		"850"
#define	SZ_WORKGROUP_FIELD		"Workgroup"
#define	SZ_WORKGROUP_DEFAULT		"WORKGROUP"
#define SZ_BUILDNO_FIELD		"Build Number"
#define SZ_BUILDNO_DEFAULT		"0000"
#define SZ_MODELNAME_FIELD		"Model"
#define SZ_INTMODELNAME_FIELD		"Internal Model"
#define SZ_SUBMODELNAME_FIELD		"SubModel"
#define SZ_FAN_SUPPORT_FIELD            "FAN Support"
#define SZ_MODELNAME_DEFAULT		"NAS-4000"
//#define CODEPAGE_FILE			"/etc/config/codepage"

int Stop_Services()
{
	system("/etc/init.d/smb.sh stop 2>/dev/null 1>/dev/null");
	system("/etc/init.d/atalk.sh stop 2>/dev/null 1>/dev/null");
	system("/etc/init.d/ftp.sh stop 2>/dev/null 1>/dev/null");
	stop_rsyncd();
	return SUCCESS;	
}
	
int Start_Services()
{
	start_rsyncd();
	system("/etc/init.d/smb.sh start 2>/dev/null 1>/dev/null");
	system("/etc/init.d/atalk.sh start 2>/dev/null 1>/dev/null");
	system("/etc/init.d/ftp.sh start 2>/dev/null 1>/dev/null");
	return SUCCESS;	
}	

void Restart_System()
{
	system("/sbin/reboot");
}

void Shutdown_System()
{
	system("/sbin/halt");
}

//Shone added for Server name modification use 2005,12,19
void Modify_Hosts(char *Server_Name)
{
	NIC_INFO        nic_info;
	FILE *fp,*fp2;
	char buf[BUF_SIZE];
	if((fp=fopen("/etc/hosts","r"))==NULL)
		return;
	if((fp2=fopen("/tmp/hosts.tmp","w"))==NULL)
	{
		fclose(fp);
		return;
	}
	NIC_Get_Info(&nic_info, NIC_LAN01);

	while(!feof(fp))
	{
		if(fgets(buf,sizeof(buf),fp)!=NULL)
		{
			if(strstr(buf,nic_info.ipaddr)!=NULL)
			{
				sprintf(buf, "%s\t\t%s\t\t%s", nic_info.ipaddr, Server_Name, Server_Name);
				fputs(buf, fp2);
			}
			else
				fputs(buf,fp2);
		}
	}

	fclose(fp);
	fclose(fp2);
	system("cp /tmp/hosts.tmp /etc/hosts 1>/dev/null 2>&1");//Using mv may change the attribute of the origin file
	system("rm -f /tmp/hosts.tmp 1>/dev/null 2>&1");
}

/*
 * Read Server Name from config file
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_Server_Name(char *svr_name, int buf_size)
{
	int val, ret = SUCCESS; 

	val = GetProfileString(SZ_SYSTEM_SECTION, SZ_SERVER_NAME_FIELD, SZ_SERVER_NAME_DEFAULT, svr_name, buf_size);
	if(!val)
		ret = ERROR_READ_FILE;
	return ret;
}

/*
 * Write Server Name to config file
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not write config file
 */
int Set_Server_Name(char *svr_name, int restart_now)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_SYSTEM_SECTION, SZ_SERVER_NAME_FIELD, svr_name);
	if(!val)
		return ERROR_WRITE_FILE;

	// activate server name settings...	
	set_samba_netbios_name(svr_name);
	// *** TBD ***	? for Appletalk ?

	Modify_Hosts(svr_name);	
	Update_System_Display();

	// If restart_now is FALSE, then it's the caller's responsibility to reboot 
	// the machine to make changes take effects... 
	if (restart_now) Restart_System();
	
	return ret;
}

/*
 * Read Server Comment from config file
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_Server_Comment(char *svr_comment, int buf_size)
{
	int val, ret = SUCCESS; 

	val = GetProfileString(SZ_SYSTEM_SECTION, SZ_SERVER_COMMENT_FIELD, SZ_SERVER_COMMENT_DEFAULT, svr_comment, buf_size);
	if(!val)
		ret = ERROR_READ_FILE;
	return ret;
}

/*
 * Write Server Comment to config file
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not write config file
 */
int Set_Server_Comment(char *svr_comment)
{
	int val, ret = SUCCESS; 

	val = WriteProfileString(SZ_SYSTEM_SECTION, SZ_SERVER_COMMENT_FIELD, svr_comment);
	if(!val)
		return ERROR_WRITE_FILE;

	// activate server comment settings...	
	set_samba_server_string(svr_comment);
	// *** TBD ***	? for Appletalk ?
	
	return ret;
}


/*
 * Read Netware Server Name from config file
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_Netware_Server_Name(char *svr_name, int buf_size)
{
	int len, ret = SUCCESS; 
	char	nw_svr_name[256];

	memset(nw_svr_name, 0, sizeof(nw_svr_name));
	len = GetProfileString(SZ_SYSTEM_SECTION, SZ_NW_SERVER_NAME_FIELD, "", nw_svr_name, 256);
	if(len != 0) {
		strcpy(svr_name, nw_svr_name);
		return ret;
	}
	// No string defined in netware server name field, read from Server Name field
	len = GetProfileString(SZ_SYSTEM_SECTION, SZ_SERVER_NAME_FIELD, SZ_SERVER_NAME_DEFAULT, nw_svr_name, 256);
	if(len == 0)
		ret = ERROR_READ_FILE;
	// append "NW" after server name, max Server name length is 15
	memset(svr_name, 0, buf_size);
	len = strlen(nw_svr_name);
	if(len < 14) {
		strcpy(svr_name, nw_svr_name);
		strcat(svr_name, "NW");
	}
	else {
		strncpy(svr_name, nw_svr_name, 13);
		strncpy(&(svr_name[13]), "NW", 2);
	}

	return ret;
}

/*
 * Write Netware Server Name to config file
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not write config file
 */
int Set_Netware_Server_Name(char *svr_name, int restart_now)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(SZ_SYSTEM_SECTION, SZ_NW_SERVER_NAME_FIELD, svr_name);
	if(!val)
		return ERROR_WRITE_FILE;

	// the machine to make changes take effects... 
	if (restart_now) Restart_System();
	
	return ret;
}


/*
 * Read System TimeZone from config file
 * Return:
 *	0			pass
 *	ERROR_NOT_FOUND	can not find a matched timezone
 */
int Get_System_Time_Zone(char *win_timezone, int buf_size) 
{
	char buf[BUF_SIZE];
	int i, bFind = 0, ret = SUCCESS;

	// store Linux style timezone
	GetProfileString(SZ_SYSTEM_SECTION, SZ_TIMEZONE_FIELD, SZ_TIMEZONE_DEFAULT, buf, sizeof(buf));
	for (i = 0; i < LINUX_TIMEZONE_MAX; i++) {
       		if (strcmp(timezone_Linux[i], buf) == 0 ) { 	/*- find it -*/
//       		strncpy(win_timezone, timezone_Windows[i], buf_size);
          		strcpy(win_timezone, timezone_Windows[i]);
          		bFind = 1;
          		break;
		}
	}

	if (!bFind) {  /* This could be the first time system init, give it Greenwich Mean Time */
		strcpy(win_timezone, timezone_Windows[22]);
		ret = ERROR_NOT_FOUND;	
	}
	return ret;
}

/*
 * Update config file
 * In the same way as timeconfig command, modify /etc/localtime to
 * corresponding time-zone, where should be /usr/share/zoneinfo.
 * also re-write /etc/sysconfig/clock to modify ZONE info
 * Return:
 *	0			pass
 *	ERROR_FAIL	fail to set timezone
 */
int Set_System_Time_Zone(char *win_timezone) 
{
	char *zonefile = NULL;
	char CurrZone_Windows[BUF_SIZE];
	char buf[BUF_SIZE];
//	struct timeval tv;
//	struct timezone tz;
//	FILE *f;
	int i, j, ret = SUCCESS;

	// Find current zone & its index
	Get_System_Time_Zone(CurrZone_Windows, BUF_SIZE);
    	for (j = 0; j < WINDOWS_TIMEZONE_MAX; j++) {
     		if (strcmp(timezone_Windows[j], CurrZone_Windows) == 0) {
			break;
       		}
    	}
	// Find index of new zone name 
    	for (i = 0; i < WINDOWS_TIMEZONE_MAX; i++) {
     		if (strcmp(timezone_Windows[i], win_timezone) == 0) {
       			zonefile = timezone_Linux[i];
			break;
       		}
    	}

    	if (NULL != zonefile) {
		WriteProfileString(SZ_SYSTEM_SECTION, SZ_TIMEZONE_FIELD, zonefile);
		/* 2005.11.29, Johnson Cheng, Don't need in TS-101
//    		unlink("/etc/localtime");
    		snprintf(buf,sizeof(buf),"/bin/cp /usr/share/zoneinfo/%s /etc/localtime",zonefile);
		if (system(buf)) {
			ret = ERROR_FAIL;
			goto end_timezone;
		}
		f = fopen("/etc/sysconfig/clock", "w");
		if(f <= 0)
			goto end_timezone;
		buf[0] = 0;	
	    	strcat(buf, "UTC=false\n");
	    	strcat(buf, "ARC=false\n");
		snprintf(buf,sizeof(buf),"ZONE=\"%s\"\n",zonefile);
		if (fputs(buf, f) < 0) {
	    		unlink("/etc/sysconfig/clock");
			ret = ERROR_FAIL;
		}
		fclose(f);
		//Update_Flash_Data("/etc/localtime");
		//Update_Flash_Data("/etc/sysconfig/clock");
         	*/	
	}
//end_timezone:
	/* 2005.11.29, Johnson Cheng fixed timezone bug
	tzset();
	gettimeofday(&tv, &tz);
	tv.tv_sec -= 60 * (ZoneDiff[i] - ZoneDiff[j]);
	ret = settimeofday(&tv, &tz);*/
	// For suspend issue, we have to sync /etc/config/TZ file in HD.
	sprintf(buf, "echo \"%s\" > /etc/TZ", timezone_mapping[i]);
	system(buf);
	sprintf(buf, "echo \"%s\" > /etc/config/TZ", timezone_mapping[i]);
	system(buf);
	snprintf(buf,sizeof(buf),"/sbin/hwclock --systohc");
	//if (!ret && system(buf)) {
	if (system(buf)) {
		ret = ERROR_FAIL;
	}

	// add by Kent 2003/03/24
	// call snapshot API to modify the configuration of snapshot start_time, TBD.
	// the original timezone is timezone_Position[j], and the current timezone is timezone_Position[i]
	//Modify_Snap_Conf_Time_Zone(timezone_Position[j], timezone_Position[i]);
	
	return ret;
}

/*
 * Get current date & time
 * Return:
 *	0			pass
 */
int Get_Current_Date_Time(char *date_time)
{
	int result = 0;
	char buf[BUF_SIZE];

/*
	system("/sbin/nastime");
	fp = fopen("/root/nastime", "r");
	if(fp >= 0) {
		fgets(str, 128, fp);
		fclose(fp);
		strncpy(date_time, str, len);
		date_time[len] = 0;
	}
*/
#define	TEMP_TIME_DATA_DILE	"/tmp/nastime"

	sprintf(buf, "/sbin/get_time > %s", TEMP_TIME_DATA_DILE);
	result = system(buf);
	if ( 0 == result ) {
		FILE *fp = fopen(TEMP_TIME_DATA_DILE, "r");
		if(fp != NULL) {
			int len = 14;
			fgets(buf, sizeof(buf), fp);
			fclose(fp);
			strncpy(date_time, buf, len);
			date_time[len] = 0;
			return SUCCESS;
		}
	}


	{
		time_t t;
	  	struct tm *ptm;
		char str[128];
	
		memset(date_time, ' ', sizeof(date_time));
		time(&t);
		ptm = localtime(&t);	
		// month
		sprintf(str, "%.2d", ptm->tm_mon + 1);
		strncpy(date_time, str, 2);
		date_time += 2;
		// day
		sprintf(str, "%.2d", ptm->tm_mday);
		strncpy(date_time, str, 2);
		date_time += 2;
		// year
		sprintf(str, "%.4d", ptm->tm_year + 1900);
		strncpy(date_time, str, 4);
		date_time += 4;
		// hour
		sprintf(str, "%.2d", ptm->tm_hour);
		strncpy(date_time, str, 2);
		date_time += 2;
		// minute
		sprintf(str, "%.2d", ptm->tm_min);
		strncpy(date_time, str, 2);
		date_time += 2;
		// sec
		sprintf(str, "%.2d", ptm->tm_sec);
		strncpy(date_time, str, 2);
		date_time += 2;
	}

	return SUCCESS;
}

/*
 * Set current date & time
 * Return:
 *	0			pass
 *	others		fail, according to system report
 */
int Set_Current_Date_Time(char *date_time)
{
	int ret = SUCCESS;
  	struct tm tm, *tm_ptr;
	char str[128];
	struct timeval tv;
	//struct timezone tz;

	memset(&tm, 0, sizeof(tm));
	memset(&tv, 0, sizeof(tv));
	//memset(&tz, 0, sizeof(tz));
	// Kevin: 2001-04-23 Initialize the tm data structure using the local time first...
	time((time_t *) &tm.tm_sec);
	tm_ptr = localtime((time_t *) &tm.tm_sec);
	memcpy(&tm, tm_ptr, sizeof(struct tm));
	// month
	strncpy(str, date_time, 2);
	str[2] = 0;
	tm.tm_mon = atoi(str) - 1;
	date_time += 2;
	// day
	strncpy(str, date_time, 2);
	str[2] = 0;
	tm.tm_mday = atoi(str);
	date_time += 2;
	// year
	strncpy(str, date_time, 4);
	str[4] = 0;
	tm.tm_year = atoi(str) - 1900;
	date_time += 4;
	// hour
	strncpy(str, date_time, 2);
	str[2] = 0;
	tm.tm_hour = atoi(str);
	date_time += 2;
	// minute
	strncpy(str, date_time, 2);
	str[2] = 0;
	tm.tm_min = atoi(str);
	date_time += 2;
	// hour
	strncpy(str, date_time, 2);
	str[2] = 0;
	tm.tm_sec = atoi(str);
	date_time += 2;
	tv.tv_sec = mktime(&tm);
	if(tv.tv_sec == (time_t)-1)
		return ERROR_FAIL;

	//ret = settimeofday(&tv, &tz);
	ret = settimeofday(&tv, NULL);
	if(ret == -1)
		return ERROR_FAIL;
	snprintf(str,sizeof(str),"/sbin/hwclock --systohc");
	if (system(str)) {
		return ERROR_FAIL;
	}
	// for LCD display
	Update_System_Display();
	
	return SUCCESS;
}

BOOL Is_Day_Light_Saving_Time_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(SZ_SYSTEM_SECTION, SZ_DAYLIGHT_SAVING_FIELD, "TRUE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

BOOL Is_Fan_Support()
{
        char    buf[BUF_SIZE];

        GetProfileString(SZ_SYSTEM_SECTION, SZ_FAN_SUPPORT_FIELD, "TRUE", buf, sizeof(buf));
        return NOT_FALSE(buf);
}

int Enable_Day_Light_Saving_Time(int bEnable)
{
	int ret = WriteProfileString(SZ_SYSTEM_SECTION, SZ_DAYLIGHT_SAVING_FIELD, BOOL2STR(bEnable));
    extern int daylight;
    extern long timezone;

//    printf("--- day ligh = %d , timezone= %d, %s, %s\n", daylight, timezone, tzname[0], tzname[1]);
	// **** TBD **** 	What should we do for this?
	
	return ret;
}

/*
 * Get system codepage    
 * Return: codepage number
 *	
 */
int Get_System_Codepage()
{
// Catherine 2001/12/20
	char buf[BUF_SIZE];
	int  val = 0;

	val = GetProfileString(SZ_SYSTEM_SECTION, SZ_CODEPAGE_FIELD, SZ_CODEPAGE_DEFAULT, buf, sizeof(buf));
	if(!val)
		return 0;
	val = atoi(buf);
	return val;

/*	char buf[64];
	int  val = 0;

	if (SHM_Get_Config((int)SHM_KEY_CODEPAGE, (int)SHM_CODEPAGE_SIZE,
		DEFAULT_CFG_FILE, SZ_SYSTEM_SECTION, SZ_CODEPAGE_FIELD, &buf)==SUCCESS) {
		val = atoi(buf);
		free(buf);
	}
	Conf_Get_Field(DEFAULT_CFG_FILE, "System", "Code Page", buf, 64);
	val=atoi(buf);
	return val;*/

/*	int	fd, ret;
	char	buf[64];

	if (NAS_File_Lock(CODEPAGE_FILE, 'r')==0)
		return -1;
	if ((fd=open(CODEPAGE_FILE, O_RDONLY))==-1)
	{
		NAS_File_Unlock(CODEPAGE_FILE);
		return 437;
	}
	read(fd, buf, 64);
	close(fd);
	NAS_File_Unlock(CODEPAGE_FILE);
	ret=atoi(buf);
	return ret;*/
}

/*
 * Set system codepage    
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not write config file
 */
int Set_System_Codepage(int cp)
{
// Catherine 2001/12/20	
	char str[BUF_SIZE];
	int val;

	sprintf(str, "%d", cp);

	val = WriteProfileString(SZ_SYSTEM_SECTION, SZ_CODEPAGE_FIELD, str);
	if(!val)
		return ERROR_WRITE_FILE;
	set_samba_codepage(str);
	set_appletalk_codepage(str);
// Paul 2005/08/15
	FTP_Create_Conf();
// Paul

	return SUCCESS;

/*	char str[BUF_SIZE];
	int ret = SUCCESS;

	sprintf(str, "%d", cp);
	if ((ret = SHM_Set_Config((int)SHM_KEY_CODEPAGE, (int)SHM_CODEPAGE_SIZE,
		DEFAULT_CFG_FILE, SZ_SYSTEM_SECTION, SZ_CODEPAGE_FIELD, str))!=SUCCESS)
		return (ret);	
	
	// activate code page settings...
	set_samba_codepage(str);
	set_appletalk_codepage(str);
	
	return ret;
*/
/*	int	fd;
	char	buf[64];

        if (NAS_File_Lock(CODEPAGE_FILE, 'w')==0)
		return ERROR_WRITE_FILE;
        if ((fd=open(CODEPAGE_FILE, O_WRONLY))==-1)
        {
                NAS_File_Unlock(CODEPAGE_FILE);
                return ERROR_WRITE_FILE;
        }
	sprintf(buf, "%d", cp);
        write(fd, buf, strlen(buf));
        close(fd);
        NAS_File_Unlock(CODEPAGE_FILE);
	set_samba_codepage(buf);
	set_appletalk_codepage(buf);
        return SUCCESS;;*/
}

/*
 * Get system version    
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_System_Version(char *version, int buf_size)
{
	int val, ret = SUCCESS;
	val = GetProfileString(SZ_SYSTEM_SECTION, SZ_VERSION_FIELD, SZ_VERSION_DEFAULT, version, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

/* Meiji: system version should not be set from function */
/* bird: Could be useful for system version upload... */
/*
 * Set system version    
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not read config file
 */
int Set_System_Version(char* version)
{
	int val, ret = SUCCESS;
	
	val = WriteProfileString(SZ_SYSTEM_SECTION, SZ_VERSION_FIELD, version);
	if(!val)
		return ERROR_WRITE_FILE;
	return ret;
}


/*
 * Get workgroup name    
 * Return:
 *	0			pass
 *	ERROR_READ_FILE	can not read config file
 */
int Get_Workgroup_Name(char *workgroup, int buf_size)
{
	int val, ret = SUCCESS;
	
	val = GetProfileString(SZ_SYSTEM_SECTION, SZ_WORKGROUP_FIELD, SZ_WORKGROUP_DEFAULT, workgroup, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

/*
 * Set workgroup name    
 * Return:
 *	0			pass
 *	ERROR_WRITE_FILE	can not write config file
 */
int Set_Workgroup_Name(char *workgroup)
{
	int val,ret = SUCCESS;
	
	val = WriteProfileString(SZ_SYSTEM_SECTION, SZ_WORKGROUP_FIELD, workgroup);
	if(!val)
		return ERROR_WRITE_FILE;
	
	// Sync Workgroup name to Smaba...
	set_samba_wrokgroup_name(workgroup);
	
	return ret;
}

int Get_Build_Number(char *build_no,int buf_size) 
{
	int val, ret = SUCCESS;
	
	val = GetProfileString(SZ_SYSTEM_SECTION, SZ_BUILDNO_FIELD, SZ_BUILDNO_DEFAULT, build_no, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;	
}

int Get_Model_Name(char *model_name,int buf_size) 
{
	int val, ret = SUCCESS;
	
	val = GetProfileString(SZ_SYSTEM_SECTION, SZ_MODELNAME_FIELD, SZ_MODELNAME_DEFAULT,model_name, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;	
}

int Get_Internal_Model_Name(char *model_name,int buf_size)
{
	int val, ret = SUCCESS;

	val = GetProfileString(SZ_SYSTEM_SECTION, SZ_INTMODELNAME_FIELD, SZ_MODELNAME_DEFAULT,model_name, buf_size);
	if(!val)
		return ERROR_READ_FILE;
	return ret;
}

int Get_SubModel_Name(char *model_name, int buf_size)
{
	int val, ret = SUCCESS;

	 val = GetProfileString(SZ_SYSTEM_SECTION, SZ_SUBMODELNAME_FIELD, SZ_MODELNAME_DEFAULT,model_name, buf_size);
	if (!val)
		return ERROR_READ_FILE;
	return ret;
}

//================================================
//	set enable/disable from WAN/LAN access 
//================================================
int Set_Web_Access(int type, int bEnable)
{
	int	ret=SYSTEM_ERROR_TYPE;

	if (type==SYSTEM_WAN_ACCESS)
		ret=WriteProfileString(SZ_SYSTEM_SECTION, SZ_WAN_ACCESS_FIELD, BOOL2STR(bEnable));
	else
	if (type==SYSTEM_LAN_ACCESS)
		ret=WriteProfileString(SZ_SYSTEM_SECTION, SZ_LAN_ACCESS_FIELD, BOOL2STR(bEnable));
	return ret;
}

//================================================
//	get Web access 
//================================================
int Get_Web_Access(int type)
{
	int	ret;
	char	buf[80]={""};

	if (type==SYSTEM_WAN_ACCESS)
		ret=GetProfileString(SZ_SYSTEM_SECTION, SZ_WAN_ACCESS_FIELD, "FALSE", buf, 80);
	else
	if (type==SYSTEM_LAN_ACCESS)
		ret=GetProfileString(SZ_SYSTEM_SECTION, SZ_LAN_ACCESS_FIELD, "FALSE", buf, 80);
	else
		return SYSTEM_ERROR_TYPE;
	if (!strcasecmp(buf, "TRUE"))
		return 1;
	else
		return 0;
}

//=========================
//	restart thttpd
//=============================
int Web_Server_Restart()
{
	int	ret;
	ret=system("/etc/init.d/thttpd restart 2>/dev/null 1>/dev/null");
	return ret;
}

//=========================================
//	set web access port
//===========================================
int Set_Web_Access_Port(int port)
{
	int	ret;
	char	buf[80];

	sprintf(buf, "%d", port);
	ret=WriteProfileString(SZ_SYSTEM_SECTION, SZ_WEB_ACCESS_PORT_FIELD, buf);
	return ret;
}

//==================================================
//	get web access port
//==================================================
int Get_Web_Access_Port()
{
	int	port;
	char	buf[80];

	GetProfileString(SZ_SYSTEM_SECTION, SZ_WEB_ACCESS_PORT_FIELD, "80", buf, 80);
	port=atoi(buf);
	return port;
}

//====================================================
//	set routing table type
//====================================================
int Set_Routing_Table_Type(int type)
{
	int	ret=0;

	if (type==ROUTER_USE_DEFAULT)
		ret=WriteProfileString(SZ_ROUTER_SECTION, SZ_ROUTER_USAGE_FIELD, "Default");
	else
	if (type==ROUTER_USE_STATIC)
		ret=WriteProfileString(SZ_ROUTER_SECTION, SZ_ROUTER_USAGE_FIELD, "Static");
	else
	if (type==ROUTER_USE_DYNAMIC)
		ret=WriteProfileString(SZ_ROUTER_SECTION, SZ_ROUTER_USAGE_FIELD, "Dynamic");
	return ret;
}

int Get_Routing_Table_Type()
{
        char    buf[80];

        GetProfileString(SZ_ROUTER_SECTION, SZ_ROUTER_USAGE_FIELD, "80", buf, 80);
	if (!strcasecmp(buf, "Default"))
		return ROUTER_USE_DEFAULT;
	else
	if (!strcasecmp(buf, "Static"))
		return ROUTER_USE_STATIC;
	else
	if (!strcasecmp(buf, "Dynamic"))
		return ROUTER_USE_DYNAMIC;
	else
		return 0;
}

//-----------------------------------------------------------------------------
// System_Reset_Admin()
// description : reset password of administrator
// input : none
// output :
//	0: success
//-----------------------------------------------------------------------------
int System_Reset_Admin()
{
	int ret;
	ret = Change_System_User_Password(USER_ADMINISTRATOR, "admin");
	if (ret == SUCCESS) {
		ret = Change_Samba_User_Passwd(USER_ADMINISTRATOR, "admin");
		//if (ret == SUCCESS)
		//	ret = change_netware_user_password(USER_ADMINISTRATOR, "admin");
	}

	//Update_Flash_Data(PASS_CONF_FILE);
	//Update_Flash_Data(GROUP_CONF_PATH);
	//Update_Flash_Data(SAMBA_PASS_PATH);

	return ret;
	
}

//-----------------------------------------------------------------------------
// System_Reset_Network_Share()
// description :
//	reset network share settings
//	
// input : none
// output :
//      0: success
//-----------------------------------------------------------------------------
int System_Reset_Network_Share(NAS_SHARE_INFO *s_info)
{
	SECTION_INFO *list = NULL;
	int i, ret = SUCCESS, share_num = 0;
	
	share_num = Get_NAS_Share_List_Ex(&list);

	for(i=0; i<share_num; i++) {
		ret = Remove_NAS_Share(list[i].section_name);
		if(ret != SUCCESS)
			return ret;
	}
	
	if(list != NULL)
		Release_List(list);
		
	ret = Create_NAS_Share(s_info);
	if(ret == SUCCESS) {
		ret = Add_NAS_User_For_Share(s_info->share_name, 'W', "@everyone");
		if(ret == SUCCESS) {
			ret = Add_NAS_User_For_Share(s_info->share_name, 'I', "guest");
		}
	}	
	return ret;
}

//-----------------------------------------------------------------------------
// System_Reset_Network()
// description :
//	reset network settings
//	NIC_Reset will automatically detect one or two nic device
// input : none
// output :
//      0: success
//-----------------------------------------------------------------------------
int System_Reset_Network(int restart)
{
	// 2005.11.26, Johnson Cheng
	// Never need dhcpd.sh in TS-101 because it can't be a dhcp server.
	//Enable_DHCP(0); // disable dhcpd
	NIC_Reset(restart);	// 0: don't restart web & network services after reset
	return 0;
}

//-----------------------------------------------------------------------------
// System_Reset_Firewall()
// description :
//	reset firewall settings
//	FW_Reset will automatically detect if support router?
// input : none
// output :
//      0: success
//-----------------------------------------------------------------------------
int System_Reset_Firewall()
{
	FW_Reset();
	return 0;
}

//-----------------------------------------------------------------------------
// System_Reset_Disk()
// description : reset disk configurations
// input : none
// output :
//      0: success
//-----------------------------------------------------------------------------
int System_Reset_Disk()
{
	Reset_Disk();
	return 0;
}

//-----------------------------------------------------------------------------
// System_Reset_Hardware()
// description :
//	reset hardware settings
//	include NAS hardware settings
// input : none
// output :
//      0: success
// changes:
// Add "Stop Network Services" & "Power Supply"	
//-----------------------------------------------------------------------------
int System_Reset_Hardware()
{
	WriteProfileString("Misc", "LCD Panel Setting Control", "TRUE");
	WriteProfileString("Misc", "Reset Password Switch", "TRUE");
	WriteProfileString("Misc", "Disk StandBy Timeout", "30");
	WriteProfileString("Misc", "Buzzer", "TRUE");
	WriteProfileString("Misc", "Stop Network Services", "TRUE");
	WriteProfileString("Misc", "Power Supply", "1");
	return 0;
}

//-----------------------------------------------------------------------------
// System_Reset_System()
// description :
//	reset system settings
//	include NAS system settings and all NAS services settings
// input : none
// output :
//      0: success
// Changes:
// Change default language to unicode
//-----------------------------------------------------------------------------
int System_Reset_System()
{
	Set_System_Time_Zone("(GMT) Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London");
	Enable_Day_Light_Saving_Time(1);
	Set_System_Codepage(437);
	Set_Workgroup_Name("NAS");
	Set_Server_Comment("NAS Server");
	Enable_Samba(1);
	set_samba_WINS_support(0);
	set_samba_WINS_server("");
	system("/sbin/gen_hostname");

	FTP_Reset();
	Enable_Webfs(1);
	Set_Appletalk_Default_Zone("*");
	Enable_Appletalk(1);
	Reset_Printer();
	return 0;
}

int System_Reset_User_Group()
{
	int ret=0;
	char cmd[128]={0};
	sprintf(cmd, "/bin/cp -f %s %s", DEFAULT_USR_PASSWD_PATH, USR_PASSWD_PATH);
	system(cmd);
	sprintf(cmd, "/bin/cp -f %s %s", DEFAULT_USR_SHADOW_PATH, USR_SHADOW_PATH);
	system(cmd);
	sprintf(cmd, "/bin/cp -f %s %s", DEFAULT_USR_GROUP_PATH, USR_GROUP_PATH);
	system(cmd);
	sprintf(cmd, "/bin/cp -f %s %s", DEFAULT_SMBPASSWD_PATH, SMBPASSWD_PATH);
	system(cmd);
	//sprintf(cmd, "/bin/cp -f %s %s", DEFAULT_NW_PASSWD_PATH, NW_PASSWD_PATH);
	//system(cmd);
	SMB_Reset_User_Group();
	//ret = change_netware_user_password(USER_ADMINISTRATOR, "admin");
	return ret;
}

//-----------------------------------------------------------------------------
// System_Reset_All()
// description : reset all settings
// input : none
// output :
//      0: success
//-----------------------------------------------------------------------------
/*int System_Reset_All()
{
	Write_Log("System was reset to default setting.", EVENTLOG_INFORMATION_TYPE);

	System_Reset_Admin();
	System_Reset_Network(0);
	System_Reset_Firewall();
	System_Reset_Hardware();
	System_Reset_System();
	System_Reset_User_Group();
//	System_Reset_Disk();	// it will be called by CGI because it takes too long time
	return 0;
}*/

int System_Reset_All()
{
	Write_Log("System was reset to default setting.", EVENTLOG_INFORMATION_TYPE);

	system("/bin/rm -fr /etc/config/* 2> /dev/null");
	system("/bin/cp -a /etc/default_config/* /etc/config/ 2> /dev/null");
	system("/etc/init.d/hostname.sh 2> /dev/null");

	return 0;
}

/*
 * Set Disk Free Size Alert to config file
 */
int Set_Disk_Free_Size_Alert(int value)
{
	return Set_Profile_Integer(MISC_SECTION, MISC_FREE_SIZE_ALERT_FIELD, value);
}

int Get_Disk_Free_Size_Alert()
{
	return Get_Profile_Integer(MISC_SECTION, MISC_FREE_SIZE_ALERT_FIELD, 3072);
}

BOOL Is_Disk_Free_Size_Alert_Enabled()
{
	char buf[BUF_SIZE];
	GetProfileString(MISC_SECTION, MISC_FREE_SIZE_ALERT_ENABLE_FIELD, "FALSE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}

int Enable_Disk_Free_Size_Alert(int bEnable)
{
	int val, ret = SUCCESS;

	val = WriteProfileString(MISC_SECTION, MISC_FREE_SIZE_ALERT_ENABLE_FIELD, BOOL2STR(bEnable));
	if(!val)
		return ERROR_WRITE_FILE;
	if (bEnable)
		Enable_Check_HD_Size(3600, Get_Disk_Free_Size_Alert() );
	else
		Disable_Check_HD_Size();
	return ret;
}

