//**************************************************************************
//
//	Copyright (c) 2000  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_snmp.c
//
//	Abstract: 
//		System configuration Access Functions.
//
//	FUNCTIONS:	TBD.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		07/20	LouisTsai created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "Util.h"



#define CMD_SNMPD	"/etc/init.d/snmp"
#define CMD_SNMPTRAP	"/usr/sbin/snmptrap"
#define CONF_SNMP	"/etc/snmp/snmpd.conf"
/* ------------------------------------------------------------------------- */
/*         		Local Function Implementation                              */
/* ------------------------------------------------------------------------- */

static int set_snmp_conf_field(char *field_name,char *value)
{
	FILE *fp = NULL,*tmpfp = NULL;
	int found_flag = 0;
	char line[80],tmp_buf[80];

	tmpfp = tmpfile();
	if ((fp = fopen(CONF_SNMP,"r")) == NULL) {	
		goto add_new;
	
	}
	rewind(fp);
	rewind(tmpfp);
	
	while (fgets(line,80,fp) != NULL) {
		if( Get_String_Field(line,1,' ',tmp_buf,80)==0) {
			if (strcmp(field_name,tmp_buf) == 0) {
				found_flag = 1;
				fprintf(tmpfp,"%s %s\n",field_name,value);
				continue;
			}
			fputs(line,tmpfp);
		}
	}
	fclose(fp);
	
add_new:
	if (( fp = fopen(CONF_SNMP,"w")) != NULL) {
		if(found_flag) {
			rewind(tmpfp);
			while (fgets(line,80,tmpfp)!= NULL) {
				fputs(line, fp);
			}
		}
		else {
			rewind(tmpfp);
			while (fgets(line,80,tmpfp)!= NULL) {
				fputs(line, fp);
			}
			
			fprintf(fp,"%s %s\n",field_name,value);
		}
		fclose(fp);
	}
	fclose(tmpfp);

	return SUCCESS;
}
static int get_snmp_conf_field(char *field_name,char *value,int buf_size)
{
	FILE *fp = NULL;
	int found_flag = 0;
	char line[80],tmp_buf[80];
	char *p;
	if (( fp = fopen(CONF_SNMP,"r")) == NULL)
		return -1;
	
	while (fgets(line,80,fp) != NULL) {
		if(Get_String_Field(line,1,' ',tmp_buf,80)==0) {
			if (strcmp(field_name,tmp_buf) == 0) {
				int i=0;
				
				found_flag = 1;
				p = line;
				while (*p == ' ' || *p == '\t') p++;
				if((p = strchr(p,' ')) != NULL) {
					p++;
					if(strlen(p)+1>buf_size) {
						strncpy(value,p,buf_size-1);
						*(value+buf_size-1) = '\0';
					}
					else
						strcpy(value,p);
				}
				else 
					strcpy(value,"");

				// strip line feed for solving issue on Mac
				for(i=0; i<strlen(value); i++) {
					if(value[i] == 0x0a) { 
						value[i] = '\0';
					} 
				}
				
				break;
			}
		}
	}
	
	fclose(fp);
	if(found_flag == 1) return SUCCESS;
	else return -1;
}

int restart_snmpd()
{
	char cmd_line[128];
	sprintf(cmd_line,"%s restart >/dev/null",CMD_SNMPD);
	if(system(cmd_line)!=0) 
		return -1;
	else 
		return 0;
}

static int stop_snmpd()
{
	char cmd_line[128];
	sprintf(cmd_line,"%s stop >/dev/null",CMD_SNMPD);
	if(system(cmd_line)!=0) 
		return -1;
	else 
		return 0;
}

/* ------------------------------------------------------------------------- */
/*         		Export Function Implementation                       */
/* ------------------------------------------------------------------------- */

//SNMP server
BOOL Is_SNMP_Enable()
{
	int ret;
	char ans[10];
	if((ret = GetProfileString("SNMP","Server Enable","FALSE",ans,10))<0) return FALSE;
	if(strcasecmp(ans,"TRUE") == 0) return TRUE;
	else return FALSE;	
	
}

int Enable_SNMP()
{
	int ret;
	if((ret = WriteProfileString("SNMP","Server Enable","TRUE"))<0) return -1;
	//john 2002-04-19 modified
	//return restart_snmpd();
	//end
	return 0;
	
}

int Disable_SNMP()
{
	int ret;
	if((ret = WriteProfileString("SNMP","Server Enable","FALSE"))<0) return -1;
	return stop_snmpd();
	
}

int Set_SNMP_Conf(char *community,char *contact,char *location)
{
	if(set_snmp_conf_field("syscontact",contact)<0) return -1;
	if(set_snmp_conf_field("syslocation",location)<0) return -1;
	if(set_snmp_conf_field("rwcommunity",community)<0) return -1;
	if(set_snmp_conf_field("rocommunity",community)<0) return -1;
	
	return SUCCESS;
}

int Get_SNMP_Conf(char *community,char *contact,char *location)
{
	if(get_snmp_conf_field("rwcommunity",community,128)<0) return -1;
	if(get_snmp_conf_field("syslocation",location,128)<0) return -1;
	if(get_snmp_conf_field("syscontact",contact,128)<0) return -1;
	
	return SUCCESS;
	
}


//SNMP Trap

BOOL Is_SNMPTrap_Enable()
{
	int ret;
	char ans[10];
	if((ret = GetProfileString("SNMP","Trap Enable","FALSE",ans,10))<0) return FALSE;
	if(strcasecmp(ans,"TRUE") == 0) return TRUE;
	else return FALSE;
	
	
}

int Enable_SNMPTrap()
{
	return WriteProfileString("SNMP","Trap Enable","TRUE");
	
}

int Disable_SNMPTrap()
{
	return WriteProfileString("SNMP","Trap Enable","FALSE");
	
}

int Set_SNMPTrap_Conf(char *community,char *ip)
{
	int ret = ERROR_WRITE_FILE;
	//John modified 2001-10-25:
	//ret = WriteProfileString("SNMP","Trap Community",community);
	//if( ret <0) return ret;
	
	//ret = WriteProfileString("SNMP","Trap Host Ip",ip);
	//if( ret <0) return ret;
	if(WriteProfileString("SNMP", "Trap Community", community) && WriteProfileString("SNMP", "Trap Host Ip", ip))
		ret = SUCCESS;

	return ret;
}

int Get_SNMPTrap_Conf(char *community,char *ip)
{
	int ret;
	ret = GetProfileString("SNMP","Trap Community","",community,128);
	if( ret <0) return ret;
	
	ret = GetProfileString("SNMP","Trap Host Ip","",ip,128);
	if( ret <0) return ret;
	
	return SUCCESS;
	
}

int SNMPTrap_Send_Alert(char *msg,int trap_type)
{
	char cmd_line[256];
	if(Is_SNMPTrap_Enable()) {
		char community[128],ip[128];
		Get_SNMPTrap_Conf(community,ip);
		sprintf(cmd_line,"%s -v 1 \"%s\" \"%s\" \"\" \"\" 6 %d [ 1.1.1  s \"%s\"] >/dev/null",CMD_SNMPTRAP,ip,community,trap_type,msg);
		if(system(cmd_line) !=0) return -1;
	}
	else
		return -1;
		
	return SUCCESS;
}
