//**************************************************************************
//
//	FILE:
//		cfg_qphoto.c
//
//	Abstract: 
//		Qphoto configuration Access Functions.
//
//	FUNCTIONS:	.
//
//	COMMENTS: 	N/A
//
//	HISTORY:
//		10/03/2005	Paul Chen created
//
//**************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <storage.h>
#include "config.h"
#include "Util.h"
#include "cfg_qweb.h"


/*
 * Check photo station enabled
 * Return:
 *	true	Enabled			
 *	false	Disabled
 */
int Is_Qweb_Enabled()
{
//	char buf[BUF_SIZE];
//	GetProfileString(SZ_QWEB_SECTION, SZ_ENABLE_FIELD, "FALSE", buf, sizeof(buf));
//	return NOT_FALSE(buf);
	return Get_Profile_Integer(SZ_QWEB_SECTION, SZ_ENABLE_FIELD, 0);
}

/*
 * Enable photo station system
 * Return:
 *	0	pass			
 *	ERROR_WRITE_FILE	can not write to config file
 */
int Enable_Qweb(int bEnable)
{
	int val, ret = SUCCESS;

	if (bEnable) {
		//if (Get_Disk_Status(1) != 0) return -1;
		//Modified by KenChen20060324
		if (Get_Volume_Status(1) != 0) return -1; 
	}

//	val = WriteProfileString(SZ_QWEB_SECTION, SZ_ENABLE_FIELD, BOOL2STR(bEnable));
	val = Set_Profile_Integer(SZ_QWEB_SECTION, SZ_ENABLE_FIELD, bEnable);
	if(!val) return ERROR_WRITE_FILE;

	system("/etc/init.d/Qthttpd.sh reload >/dev/null 2>&1");
	return ret;
}

// -----add by KenChen 20060327
int Restart_Qweb(int bEnable, int port)
{
	int val, ret = SUCCESS;

	if (bEnable) {
		if (Get_Volume_Status(1) != 0) return -1; 
	}

	val = Set_Profile_Integer(SZ_QWEB_SECTION, SZ_ENABLE_FIELD, bEnable);
	if(!val) return ERROR_WRITE_FILE;

	val = Set_Profile_Integer(SZ_QWEB_SECTION, SZ_QWEB_PORT_FIELD, port);
	if(!val) return ERROR_WRITE_FILE;

	system("/etc/init.d/Qthttpd.sh restart >/dev/null 2>&1");
	return ret;
}
// -----end here