#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <fcntl.h>
#include <assert.h>
#include "backup.h"
#include "Util.h"
#include "cfg_dvd.h"
#include "uLinux.h"
#include "codepage.h"
#include <cfg_system.h>
#include "naslvm.h"
#include "cgi.h"
#include "v2_menu.h"
#include "eventlog.h"
#define BLK_SIZE 8*512
#ifndef __defined__bool_t
#define __defined__bool_t
typedef int     bool_t;
#endif

#ifndef BLK_SIZE
#define BLK_SIZE        (8 * 512)
#endif
double size=0;
double total_size=0;
long int count=0;
long int total=0;
float last=0;

static BOOL does_file_exist(const char *filename)
{
	        struct stat     status;

		        assert(filename);

			        return ( 0 == lstat(filename, &status) );
}

static int copy_file(const char *src, const char *dest, bool_t option)
{
        struct stat     src_status, dest_status;
//      struct utimbuf  old_utimbuf;
        int             src_fd, dest_fd;
        int             count;
        char            buf[BLK_SIZE];
        assert(src);
        assert(dest);
        assert( does_file_exist(src) );

        stat(src, &src_status);

        if ( does_file_exist(dest) ) {
                if (option) {
                        int src_mode, dest_mode;
                        if (lstat(dest, &dest_status)){
                                src_mode  = src_status.st_mode  & S_IFMT;
                                dest_mode = dest_status.st_mode & S_IFMT;
                                return SUCCESS;
                        }
                        else
                                return SUCCESS;
                }
        }

        /** copy src to dest */
        remove(dest);
        src_fd  = open(src, O_RDONLY);
        if (0 > src_fd)
                return E_SRC;
	umask(000);
        dest_fd = open(dest, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH );

        if (0 > dest_fd) {
                close(src_fd);
                return E_COPY;
        }
        while ( 0 < ( count = read(src_fd, buf, BLK_SIZE) ) ) {
                if ( count != write(dest_fd, buf, count) ) {
                        close(src_fd);
                        close(dest_fd);
                        return E_COPY;
                }
        }
        if (0 != count) {
                close(src_fd);
                close(dest_fd);
                return E_SRC;
        }
        if ( 0 > close(src_fd) ) {
                close(dest_fd);
                return E_SRC;
        }
        if ( 0 > close(dest_fd) ){
                return E_COPY;
        }
        return SUCCESS;
}

int DVD_Is_Device_Exist(int usbdev)
{
	char cmd[CMD_LENGTH];
	int ret;

	sprintf(cmd, "%s %s 2>/dev/null | /bin/grep INQUIRY > %s", CMD_DVD_INFO, DVD_USB_DEV[usbdev],MED_LOG_FILE);
	
	ret=system(cmd);
	
	if(ret==0)	// success...
		return SUCCESS;
	else
	{
		WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_EMPTY,DVD_CONFIG);
		return E_DVD_DEVICE;
	}
}

int DVD_Is_Media_Exist(int usbdev,int isCD)
{
	int ret;
	char cmd[CMD_LENGTH],cmd1[CMD_LENGTH];
	char buf[BUF_SIZE],status[BUF_SIZE];
	FILE *fp;
	int dev,cd_dev=0;

	//printf("%s",buf);
	
	sprintf(cmd, "%s %s 2>/dev/null | /bin/grep \"Mounted Media\" > %s ", CMD_DVD_INFO, DVD_USB_DEV[usbdev],MED_LOG_FILE);	
	ret=system(cmd);
	
	if(ret==0)
	{	//success
		GetPrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,"",buf,sizeof(buf),DVD_CONFIG);
		if(strcmp(buf,STATUS_BURNING))
			WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_READY,DVD_CONFIG);
		return SUCCESS;
	}
	else
	{	
		if(isCD){
			dev=usbdev;
			DVD_Get_Status(status);
			for(;cd_dev<10;cd_dev++){
				sprintf(cmd1,"%s %d > %s",CMD_CD_DETECT,cd_dev,MED_LOG_FILE);
				ret = system(cmd1);
				if(ret==0)
					break;
			}
			WritePrivateProfileString(DVD_SECTION,DVD_CD_DEV_NO_FIELD,itoa(cd_dev),DVD_CONFIG);
			fp=fopen(MED_LOG_FILE,"r");
			fgets(buf,sizeof(buf),fp);
			if(strstr(buf,"unknown-media")){
				WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_EMPTY,DVD_CONFIG);
        			return E_DVD_MEDIA;
			}
			else{
				if(strcmp(buf,STATUS_BURNING))
                        		WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_READY,DVD_CONFIG);
				return SUCCESS;
			}
		}
		WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_EMPTY,DVD_CONFIG);
	       	return E_DVD_MEDIA;
	}
}
int DVD_Get_Device_Info(DEVICE_TYPE *dev,int usbdev)
{
	int ret,idx,idx_dev;
	char buf[BUF_SIZE];
	if((ret=DVD_Is_Device_Exist(usbdev))==SUCCESS)
	{
		//printf("ret=%d",ret);

		fgets(buf,sizeof(buf),fopen(MED_LOG_FILE,"r"));

		for(idx=0;buf[idx]!='[';idx++)
			;
		for(idx_dev=0;buf[idx]!=10&&buf[idx]!='\0';idx++,idx_dev++)
		{
			dev->dev_type[idx_dev]=buf[idx];	//Write information in obj named dev
		}

		dev->dev_type[idx_dev]='\0';
			
		//printf("%s\n",dev->dev_type);
	}
	return ret;
}

int DVD_Get_Media_Info(MEDIA_TYPE *media, int usbdev, int isCD)
{
	int ret,idx,idx_med,flag;
	char *p;
	char buf[BUF_SIZE],cmd[CMD_LENGTH],speed_buf[BUF_SIZE];
	FILE *fp;
	if((ret=DVD_Is_Media_Exist(usbdev,isCD))==SUCCESS)
	{
		fp=fopen(MED_LOG_FILE,"r");
		fgets(buf,sizeof(buf),fp);
		if(strstr(buf,"CD-RW")){
			media->type=CD_RW;
			fgets(buf,sizeof(buf),fp);
			media->speed=atoi(buf+6);
		}
		else 
		if(strstr(buf,"CD-R")){
			media->type=CD_R;
			fgets(buf,sizeof(buf),fp);
			media->speed=atof(buf+6);
		}
		else{

			for(idx=24,idx_med=0;buf[idx]!='\0'&&buf[idx]!=10;idx++,idx_med++){
				media->type_msg[idx_med]=buf[idx];
			}
			media->type_msg[idx_med]='\0';
	
			p=strstr(media->type_msg,"DVD+R");
			if(p!=NULL){
				p=strstr(media->type_msg,"DVD+RW");
				if(p!=NULL)
					media->type=DVD_PLUS_RW;
				else{
					p=strstr(media->type_msg,"Double Layer");
					if(p!=NULL)
						 media->type=DVD_R_DL;
					else
						media->type=DVD_PLUS_R;
			
				}
			}

			p=strstr(media->type_msg,"DVD-R");
			if(p!=NULL)
			{
				p=strstr(media->type_msg,"DVD-RW");
				if(p!=NULL)
					media->type=DVD_RW;
				else
					media->type=DVD_R;
			}
		
		
	
			sprintf(cmd, "%s %s 2>/dev/null | /bin/grep \"Write Speed\" > %s ", CMD_DVD_INFO,DVD_USB_DEV[usbdev],MED_LOG_FILE);
			ret=system(cmd);
			flag=0;
			fgets(buf,sizeof(buf),fopen(MED_LOG_FILE,"r"));
			for(idx=24,idx_med=0;buf[idx]!='\0'&&buf[idx]!=10;idx++,idx_med++)
			{
				media->w_speed_descript[SPEED_DESCRIPT_1][idx_med]=buf[idx];
				if(!flag)
					speed_buf[idx_med]=buf[idx];
				if(buf[idx]=='x')
				{
					media->speed=atof(speed_buf);
					flag=1;
				}
				//	printf("%d %c\n",idx,buf[idx]);
			}
		//printf("%s\n",media->type);
		//printf("%s  %2.1f\n",media->w_speed_descript[SPEED_DESCRIPT_1],media->speed);
		}
	}
	return ret;
}


int DVD_Burn_DVD(char *vollabel, int speed,int usbdev,char *filepath)
{
	int ret;
	char cmd[CMD_LENGTH]; 
	int codepage;

	codepage = Get_System_Codepage();
	if(codepage==999)
		sprintf(cmd, "%s -Z %s -use-the-force-luke=[tty] -udf -jcharset utf8 -D -R -V \"%s\" -graft-points \"%s\" -speed=%d",CMD_DVD_BURN,DVD_USB_DEV[usbdev],vollabel,filepath,speed);
	else
		sprintf(cmd, "%s -Z %s -use-the-force-luke=[tty] -udf -jcharset cp%d -D -R -V \"%s\" -graft-points \"%s\" -speed=%d",CMD_DVD_BURN,DVD_USB_DEV[usbdev],codepage,vollabel,filepath,speed);

	ret = DVD_Is_Media_Exist(usbdev,NO_CD);
	 if(ret==SUCCESS){
		WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_BURNING,DVD_CONFIG);
		system("/bin/kill -USR2 `/sbin/pidof /sbin/burn_cd`");
		ret=system(cmd);
	 	//DVD_Eject_Rom(usbdev);
	 }
	 return ret;
}

int DVD_Burn_DVD_From_File(char *charset, int speed, char *LOG_FILE,int usbdev,char *src_file)
{
	int ret;
	char cmd[CMD_LENGTH];
	sprintf(cmd, "%s -Z %s -use-the-force-luke=[tty] -jcharset %s -R -J -log-file %s -graft-points -path-list %s -speed=%d &",CMD_DVD_BURN,DVD_USB_DEV[usbdev],charset,LOG_FILE,src_file,speed);
	//printf("%s",cmd);
	ret = DVD_Is_Media_Exist(0,NO_CD);
	if(ret==SUCCESS){
		WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_BURNING,DVD_CONFIG);
		ret=system(cmd);
		WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_READY,DVD_CONFIG);
		//printf("ret=%d\n",ret);
	}
	return ret;
}

int DVD_Erase_Rom(int usbdev){
	int ret=0;
	char cmd[CMD_LENGTH];
	ret = system("mkdir ./empty");
	ret = sprintf(cmd, "%s -Z %s -use-the-force-luke=[tty] ./empty -speed=16 1>/dev/null 2>/dev/null",CMD_DVD_BURN,DVD_USB_DEV[usbdev]);
	WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_ERASING,DVD_CONFIG);
	ret = system(cmd);
	WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_EMPTY,DVD_CONFIG);
	if(ret==0)
		return SUCCESS;
	return ret;
}

int DVD_Eject_Rom(int usbdev)
{
	int ret;
	char cmd[CMD_LENGTH];
/*	DIR *dp=opendir("/mnt/cdrom");
	if(dp==NULL)
	{
		ret = system("mkdir /mnt/cdtom");
	}
        ret = system("mount -t iso9660 /dev/scd0 /mnt/cdrom 2>/dev/null 1>/dev/null");
*/
	sprintf(cmd, "/usr/bin/eject %s ",DVD_USB_DEV[usbdev]);
	WritePrivateProfileString(SZ_DVD_SECTION,SZ_STATUS_FIELD,STATUS_EMPTY,DVD_CONFIG);
	ret = system(cmd);
	//printf("ret=%d",ret);
	if(ret==0)
		return SUCCESS;
	else 
		return E_DVD_DEVICE;
	return ret;
}

int DVD_Cancel()
{
	int ret=0;

	ret = system("kill -9 `pidof /usr/bin/growisofs`");
	//printf("%d\n",atoi(strtok(buf,delim)));
	return ret;
}


void Cal_Size(char *dir,char *parent)
{
        DIR *dp;
        struct dirent *entry;
        struct stat statbuf;
        char parent_t[60];
	FILE *fp;
        if((dp=opendir(dir))==NULL){
//                fprintf(stderr,"cannot open directory : %s\n", dir);
                return;
        }


	fp=fopen("/home/httpd/cgi-bin/misc/load_process_log","w+");
	fprintf(fp,"Initialize");
	fclose(fp);
        chdir(dir);

        while((entry=readdir(dp))!=NULL){
                lstat(entry->d_name,&statbuf);
                if(S_ISDIR(statbuf.st_mode)){
                        if(strcmp(".",entry->d_name)==0 || strcmp("..",entry->d_name)==0)
                                continue;
                        sprintf(parent_t,"%s%s/",parent,entry->d_name);
//                      printf("%s\n",parent_t);
                        Cal_Size(entry->d_name,parent_t);
                }
                else{
//                      printf("%s%s            %d\n",parent,entry->d_name,statbuf.st_size);
                        size+=statbuf.st_size;
                        count++;
                }
        }
        chdir("..");
        closedir(dp);
}

void Cp_Files(char *dir,char *parent,char *dest)
{
        DIR *dp,*dest_dp;
        struct dirent *entry;
        struct stat statbuf;
        char parent_t[1024],path[1024]/*,cmd[1024]*/;
        float percent;
        if((dest_dp=opendir(dest))==NULL)
        {
		umask(000);
		mkdir(dest,S_IRUSR | S_IWUSR | S_IXUSR |S_IRGRP | S_IWGRP | S_IXGRP |S_IROTH | S_IWOTH | S_IXOTH);
//                sprintf(cmd,"/bin/mkdir %s",dest);
//                system(cmd);
        }
        closedir(dest_dp);
        if((dp=opendir(dir))==NULL){
//                fprintf(stderr,"cannot open directory : %s\n", parent);
                return;
        }

        chdir(dir);

        while((entry=readdir(dp))!=NULL){
                lstat(entry->d_name,&statbuf);
                if(S_ISDIR(statbuf.st_mode)){
                        if(strcmp(".",entry->d_name)==0 || strcmp("..",entry->d_name)==0)
                                continue;
                        sprintf(parent_t,"%s/%s",parent,entry->d_name);
//                      printf("%s\n",parent_t);
//                      sprintf(path,"/test%s",parent_t);
//                      if((dp=opendir(path))==NULL){
//                              sprintf(cmd,"mkdir %s",path);
//                              system(cmd);
//                      }
                        sprintf(path,"%s/%s",dest,entry->d_name);
//                        sprintf(cmd,"/bin/mkdir %s >/dev/null 2>/dev/null",path);
//                        system(cmd);
			umask(000);
			mkdir(path,S_IRUSR | S_IWUSR | S_IXUSR |S_IRGRP | S_IWGRP | S_IXGRP |S_IROTH | S_IWOTH | S_IXOTH);
                //      fprintf(stderr,"It's dir : %s\n",path);
//                      fprintf(stderr,"Remain size : %f", size);
                        Cp_Files(entry->d_name,parent_t,path);
                }
                else{
			char path1[2048],src[2048];
//			translate(entry->d_name,trans);
                        sprintf(src,"%s/%s",parent,entry->d_name);
			sprintf(path1,"%s/%s",dest,entry->d_name);
//			printf("%s\n",trans);
//                        sprintf(cmd,"/bin/cp %s/%s %s/", parent,trans, dest);
//			printf("%s\n",cmd);
//                      printf("cmd=%s\n",cmd);
//			system(cmd);
			copy_file(src,path1,OVERWRITE_MODE);
                        size-=statbuf.st_size;
                        percent = 100. * (total_size-size)/total_size;
                        if((percent-last)>1){
                                FILE *fp;
                                last=percent;
                                fp=fopen("/home/httpd/cgi-bin/misc/load_process_log","w+");
                                fprintf(fp,"\r%2.1f%%\n",percent);
                                fclose(fp);
//                              fprintf(stderr,"%2.1f%%\n", percent);
//                              fprintf(stderr,"Have transfered %ld file\n",count);
                        }
                        count++;
                }
        }
        chdir("..");
        closedir(dp);
//	count=0;
//	size=0;
//	total_size=0;
	
}

void Cp_Files_Skip(char *dir,char *parent,char *dest)
{
        DIR *dp,*dest_dp;
        struct dirent *entry;
        struct stat statbuf;
        char parent_t[1024],path[1024]/*,cmd[1024]*/;
        float percent;
        if((dest_dp=opendir(dest))==NULL)
        {
		umask(000);
		mkdir(dest,S_IRUSR | S_IWUSR | S_IXUSR |S_IRGRP | S_IWGRP | S_IXGRP |S_IROTH | S_IWOTH | S_IXOTH);
        }
        closedir(dest_dp);
        if((dp=opendir(dir))==NULL){
//                fprintf(stderr,"cannot open directory : %s\n", parent);
                return;
        }

        chdir(dir);

        while((entry=readdir(dp))!=NULL){
                lstat(entry->d_name,&statbuf);
                if(S_ISDIR(statbuf.st_mode)){
                        if(strcmp(".",entry->d_name)==0 || strcmp("..",entry->d_name)==0)
                                continue;
                        sprintf(parent_t,"%s/%s",parent,entry->d_name);
//                      printf("%s\n",parent_t);
//                      sprintf(path,"/test%s",parent_t);
//                      if((dp=opendir(path))==NULL){
//                              sprintf(cmd,"mkdir %s",path);
//                              system(cmd);
//                      }
                        sprintf(path,"%s/%s",dest,entry->d_name);
			umask(000);
			mkdir(path,S_IRUSR | S_IWUSR | S_IXUSR |S_IRGRP | S_IWGRP | S_IXGRP |S_IROTH | S_IWOTH | S_IXOTH);
//                        sprintf(cmd,"/bin/mkdir %s >/dev/null 2>/dev/null",path);
//                        system(cmd);
                        Cp_Files_Skip(entry->d_name,parent_t,path);
                }
                else{
			char path1[2048],src[2048];
			
//                      sprintf(source,"%s/%s",parent,entry->d_name);
//                        sprintf(cmd,"no | /bin/cp -i \"%s/%s\" \"%s/\"", parent,entry->d_name, dest);
			sprintf(src,"%s/%s",parent,entry->d_name);
			sprintf(path1,"%s/%s",dest,entry->d_name);
			umask(000);
			copy_file(src,path1,SKIP_MODE);
			
//			printf("cmd=%s\n",cmd);
//                        system(cmd);
                        size-=statbuf.st_size;
                        percent = 100. * (total_size-size)/total_size;
                        if((percent-last)>1){
                                FILE *fp;
                                last=percent;
                                fp=fopen("/home/httpd/cgi-bin/misc/load_process_log","w+");
                                fprintf(fp,"\r%2.1f%%\n",percent);
                                fclose(fp);
//                              fprintf(stderr,"%2.1f%%\n", percent);
//                              fprintf(stderr,"Have transfered %ld file\n",count);
                        }
                        count++;
                }
        }
        chdir("..");
        closedir(dp);
//      count=0;
//      size=0;
//      total_size=0;

}
int DVD_Load_Data(char *src_path, char *dest, int option)
{
        int ret=0,share_no=0,vol_cnt;
//        char cmd[CMD_LENGTH];
	FILE *fp;
	char path[BUF_SIZE];
	
        LVM_VOLUME_INFO *vol_info_list;
        vol_cnt=Get_All_LVM_Volumes_Info(&vol_info_list);

//	umask(000);
	strcpy(path,dest);
        if(strstr(path,"HDA"))
                share_no=0;
        else
        if(strstr(path,"HDB"))
                share_no=1;
//	else
//		goto next;

/*	fp=fopen("/temp_file","w+");
      	fprintf(fp,"share no = %d",share_no);
        fclose(fp);
*/
        Cal_Size(src_path,src_path);
	total_size=size;

	if (vol_info_list[share_no].free_size>0){
                if((total_size/1024)>vol_info_list[share_no].free_size){
/*			fp=fopen("/temp_file","w");
			fprintf(fp,"free : %f\n",(double)vol_info_list[share_no].free_size);
			fprintf(fp,"total : %ld\n",total_size);
*/                     
			fp=fopen(ERROR_FILE,"w+");
			fprintf(fp,"%d",E_OUT_DISK_SIZE);
			fclose(fp);
			return E_OUT_DISK_SIZE;
		}
                else{
/*			fp=fopen("/temp_file","w");
                        fprintf(fp,"Size is enough!!");
			fclose(fp);
*/		}
	}

//        printf("done.\n");
//        printf("Total size= %ld\n",size);
//        printf("The count of files= %ld\n",count);
	count=0;

//	next:
        switch(option)
        {
                case SKIP_MODE:
                        Cp_Files_Skip(src_path,src_path,dest);
                        //sprintf(cmd, "cp -rf %s %s", src_path,dest);
                        //ret=system(cmd);
                        break;
                case OVERWRITE_MODE:
			Cp_Files(src_path,src_path,dest);
                        //sprintf(cmd, "no | cp -r %s %s", src_path, dest);
                        //ret=system(cmd);
			
                        break;
                default:
                        break;
        }
	
	fp=fopen("/home/httpd/cgi-bin/misc/load_process_log","w+");
	fprintf(fp,"100.00%%");
	fclose(fp);

	count=0;
        size=0;
        total_size=0;
        if(ret==0)
                return SUCCESS;
        else
                return E_LOAD;
        return ret;
}

int DVD_Get_Burning_Process(char *logfile, char *percent_buf)
{
	int ret=0;
	FILE *fptr;
	fptr = fopen(logfile,"r");
	
	
	while (fgets(percent_buf, BUF_SIZE, fptr) != NULL)
		;
	//printf("%s",percent_buf);
	fclose(fptr);
	if(percent_buf!=NULL)
		ret = SUCCESS;
	else
		ret = E_GET_PROCESS;
	return ret;
	
}

int DVD_Get_Status(char *status_buf){
	int ret=0;
	ret=GetPrivateProfileString(DVD_SECTION,DVD_STATUS_FIELD,STATUS_EMPTY,status_buf,BUF_SIZE,DVD_CONFIG);
	return ret;
}

int DVD_Set_Status(char *status_buf){
	int ret=0;
	ret = WritePrivateProfileString(DVD_SECTION,DVD_STATUS_FIELD,status_buf,DVD_CONFIG);
	return ret;
}

int DVD_BurnCD(char *path, int usbdev,int CD_TYPE){
	int ret=0;
	char cmd[BUF_SIZE];
	int codepage;
//	MEDIA_TYPE media;	
	
        codepage = Get_System_Codepage();
	
	if(CD_TYPE==CD_RW){
	//	sprintf(cmd,"%s dev=%d,0,0 -v blank=fast", );
	}
	sprintf(cmd, "%s -r -J -jcharset cp%d -o %s -udf -graft-points %s", CMD_DVD_MKISO, codepage, IMAGE, path);
	ret = system(cmd);
	return ret;
}

int DVD_Clear_Conf(){
	int ret=0;
	WritePrivateProfileString(DVD_SECTION,DVD_SOURCE_PATH_FIELD,"",DVD_CONFIG);
	WritePrivateProfileString(DVD_SECTION,DVD_LABEL_FIELD,"",DVD_CONFIG);
	WritePrivateProfileString(DVD_SECTION,DVD_BPATH,"",DVD_CONFIG);
	WritePrivateProfileString(DVD_SECTION,DVD_LOAD_PATH_FIELD,"",DVD_CONFIG);
	WritePrivateProfileString(DVD_SECTION,DVD_VOL_FIELD,"",DVD_CONFIG);
	WritePrivateProfileString(DVD_SECTION,DVD_LOADTYPE_FIELD,"",DVD_CONFIG);
	return ret;
}

int DVD_Get_Copy_Status(char *status_buf){
	int ret=0;
	FILE *fp;
	char buf[BUF_SIZE];
	fp=fopen(LOAD_PROCESS_LOG,"r");
	fgets(buf,BUF_SIZE,fp);
	strcpy(status_buf,buf);
	fclose(fp);
	return ret;
}

int Get_Cd_Device_No(int *dev_no){
	int ret=0;
	char buf[BUF_SIZE];
	ret=GetPrivateProfileString(DVD_SECTION,DVD_CD_DEV_NO_FIELD,"0",buf,sizeof(buf),DVD_CONFIG);
	*dev_no = atoi(buf);
	return ret;
}

char *itoa(int num){
	char ret[1024*10];
	sprintf(ret,"%d",num);
	return strdup(ret);
}

int Get_Image_Size(int *size){
	int ret=0,i,j=0;
        FILE *fp;
        char buf[1024],buf1[1024];
        system("ls -l /share/HDA_DATA/cd_image > /temp_file");
        fp=fopen("/temp_file","r");
        fgets(buf,1024,fp);
        printf("%s\n",buf+34);
        fclose(fp);

        for(i=34;buf[i]!=' ';i++,j++){
                buf1[j]=buf[i];
        }
        buf1[j]='\0';

//        printf("%.2f MB\n",atof(buf1)/1024/1024);
        unlink("/temp_file");
	*size=atof(buf1)/1024/1024;
	if(*size>698)
		ret=E_OUTSPACE;
	else 
		ret=SUCCESS;
        return ret;
}

int check_size(char *path,int *mb_size){
	int ret=0;
	size=0;
	Cal_Size(path,path);
	*mb_size=size/1024/1024;
//	printf("size = %ld\n",size);

	 if(*mb_size>698)
                ret=E_OUTSPACE;
        else
                ret=SUCCESS;
	size=0;
        return ret;
		
}

int get_media_label(char *buf, int usbdev)
{
        int ret=0;
        char cmd[CMD_LENGTH];
        FILE *fp;
        sprintf(cmd,"dd if=%s of=/temp_file bs=1 skip=32808 count=32 >/dev/null 2>/dev/null",DVD_USB_DEV[usbdev]);
        ret=system(cmd);

        if(ret==0){
                ret=SUCCESS;
                fp=fopen("/temp_file","r");
                fgets(buf,CMD_LENGTH,fp);
                fclose(fp);
        }
        else if(ret==256){
                ret=MEDIA_UNUSED;
        }
        unlink("/temp_file");

        return ret;
}


int check_disk_size(char *share_name,int checked_size){
	int ret=0,vol_cnt;
        int share_no = 0;
        NAS_SHARE_INFO share_info;
        LVM_VOLUME_INFO *vol_info_list;

        vol_cnt=Get_All_LVM_Volumes_Info(&vol_info_list);
	strcpy(share_info.share_name,share_name);
	Get_NAS_Share_Info_Ex(&share_info);
	if(strstr(share_info.path,"HDA"))
		share_no=0;
	else
	if(strstr(share_info.path,"HDB"))
		share_no=1;


	
	if (vol_info_list[share_no].free_size>0){
		if(checked_size>vol_info_list[share_no].free_size)
			ret=E_OUT_DISK_SIZE;
		else
			ret=SUCCESS;
	}
//		printf("%.2f MB\n", (double)vol_info_list[share_no].free_size/1024);
	return ret;
}


int check_path(char *path){
	
	int ret=0;
	DIR *dp;
	if((dp=opendir(path))==NULL)
		return E_DIR_NOT_EXIST;
	else
		ret=SUCCESS;
	return ret;
}

int translate(char *src, char *src1){
	int idx=0,idx1=0;
	while(src[idx]!='\0'){
		src1[idx1]='\\';
		idx1++;
		src1[idx1]=src[idx];
		idx++;
		idx1++;
	}
	src1[idx1]='\0';
	return SUCCESS;
}
	
BOOL Is_DVD_Support(){
	int ret;
	char buf[BUF_SIZE];
        ret=GetProfileString("System", "Usb Dvd Support", "FALSE", buf, sizeof(buf));
	return NOT_FALSE(buf);
}
