//**************************************************************************
//
//	Copyright (c) 2001  ICP Electronics Inc.  All Rights Reserved.
//
//	FILE:
//		cfg_ddns.c
//
//	Abstract: 
//		System configuration Access Functions for DDNS.
//
//	FUNCTIONS:	Setting and getting ddns configuration from uLinux.
//		public function:
//			BOOL Is_DDNS_Enable (void);
//			BOOL Enable_DDNS (int Enable);
//			BOOL Is_DDNS_Registered (void);
//			BOOL Registered_DDNS (int Register);
//			int Get_Extend_Domain_Name (char * Ex_Domain_Name, int SizeofBuf);
//			int Get_DDNS_Domain_Name (char * Domain_Name, int SizeofBuf);
//			BOOL Set_DDNS_Domain_Name (char * Domain_Name);
//			int Get_DDNS_Server_IP (char * Server_IP, int SizeofBuf);
//			BOOL Set_DDNS_Server_IP (char * Server_IP);
//
//	COMMENTS: 	It must working with util.c
//
//	HISTORY:
//		V1.0 2001/09/04		Tiger Fu created
//
//**************************************************************************

#include	<stdio.h>
#include	<ctype.h>
#include	<stdlib.h>
#include	<string.h>

#include	<Util.h>
#include	<cfg_nic.h>

#include	"cfg_ddns.h"


#define		DEVICE_NULL		"/dev/null"
#define		DDNS_SHELL_SCRIPT	"/etc/init.d/ddns_update_for_cgi.sh"

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
BOOL Is_DDNS_Support (void)
{
	return Get_Profile_Boolean (DDNS_SECTION, DDNS_SUPPORT, TRUE);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
BOOL Is_DDNS_Enable (void)
{
	return Get_Profile_Boolean (DDNS_SECTION, DDNS_ENABLE, FALSE);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Enable_DDNS (BOOL Enable)
{
	int ret = 0;
	BOOL current_enable;
	FILE * fp = NULL;
	char command[256], buf[16];
	memset (command, '\0', sizeof (command));

	switch (Enable)
	{
	case TRUE:
		current_enable = Is_DDNS_Enable ();
		Set_Profile_String (DDNS_SECTION, DDNS_ENABLE, "TRUE");
		sprintf (command, "%s 2> %s", DDNS_SHELL_SCRIPT, DEVICE_NULL);
		system (command);
		fp = fopen ("/tmp/ddns.result", "r");
		if (fp)
		{
			fgets (buf, sizeof (buf), fp);
			ret = atoi (buf);
			fclose (fp);
		}

		if (ret != 0)
		{
			if (current_enable)
				Set_Profile_String (DDNS_SECTION, DDNS_ENABLE, "TRUE");
			else
				Set_Profile_String (DDNS_SECTION, DDNS_ENABLE, "FALSE");
		}
		break;
	case FALSE:
		Set_Profile_String (DDNS_SECTION, DDNS_ENABLE, "FALSE");
		break;
	}

	return ret;
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
BOOL Get_DDNS_Info (struct DDNS_Information * ddns_info)
{
	ddns_info->Support = Is_DDNS_Support ();				//  support
	ddns_info->Enable = Is_DDNS_Enable ();					//  enable
	if (Get_DDNS_User_Name (ddns_info->UserName, DDNS_MAX_BUF_SIZE) < 0)	//  user
		return FALSE;

	if (Get_DDNS_User_Password (ddns_info->Password, DDNS_MAX_BUF_SIZE) < 0)//  password
		return FALSE;

	if (Get_DDNS_Host (ddns_info->HostName, DDNS_MAX_BUF_SIZE) < 0)		//  host
		return FALSE;
		
	ddns_info->Wildcard = Is_Wildcard_Support ();				//  wildcard

	if (Get_DDNS_MX (ddns_info->MailExchanger, DDNS_MAX_BUF_SIZE) < 0)	//  mx
		return FALSE;
		
	ddns_info->BackupMX = Is_DDNS_BackupMX ();				//  backmx

	if (Get_DDNS_Device (ddns_info->Device, DDNS_DEV_BUF_SIZE) < 0)		//  device
		return FALSE;

	ddns_info->DDNS_Type = Get_DDNS_Type ();				//  ddns_type

	ddns_info->DDNS_Server = Get_DDNS_Server ();				//  ddns_server
	
	if (Get_DDNS_IP_Address (ddns_info->IP_Address, DDNS_IPADDR_BUF_SIZE) < 0)//  ip address
		return FALSE;

	if (Get_DDNS_Config_File (ddns_info->ConfigFile, DDNS_MAX_BUF_SIZE) < 0)//  config
		return FALSE;
	return TRUE;
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Set_DDNS_Info (struct DDNS_Information * ddns_info)
{
	int changed = 0;
	int ret = 0;
	struct DDNS_Information tmp_info;
	NIC_INFO nic_info;

	if (ddns_info->Enable == ENABLE_DDNS)
	{
		if ((ret = Check_DDNS_Info (ddns_info)) != 0)
			return ret;

		if (!Get_DDNS_Info (&tmp_info))
			return DDNS_ERROR_GET_INFO;

		if (ddns_info->Enable != tmp_info.Enable)
			changed = 1;

		if (strcmp (ddns_info->UserName, tmp_info.UserName))	//  if change then set value to conf
		{
			if (!Set_DDNS_User_Name (ddns_info->UserName))	//  user
				return DDNS_ERROR_SET_USER_NAME;
			changed = 1;
		}

		if (strcmp (ddns_info->Password, tmp_info.Password))
		{
			if (!Set_DDNS_User_Password (ddns_info->Password))//  password
				return DDNS_ERROR_SET_PASSWORD;
			changed = 1;
		}

		if (strcmp (ddns_info->HostName, tmp_info.HostName))
		{
			if (!Set_DDNS_Host (ddns_info->HostName))	//  host
				return DDNS_ERROR_SET_HOST_NAME;
			changed = 1;
		}

		if (ddns_info->Wildcard != tmp_info.Wildcard)
		{
			if (!Wildcard_Support (ddns_info->Wildcard))	//  wildcard
				return DDNS_ERROR_SET_WILDCARD;
			changed = 1;
		}

		if (strcmp (ddns_info->MailExchanger, tmp_info.MailExchanger))
		{
			if (!Set_DDNS_MX (ddns_info->MailExchanger))	//  mx
				return DDNS_ERROR_SET_MX;
			changed = 1;
		}

		if (ddns_info->BackupMX != tmp_info.BackupMX)
		{
			if (!DDNS_BackupMX (ddns_info->BackupMX))	//  backmx
				return DDNS_ERROR_SET_BACKMX;
			changed = 1;
		}

		if (strcmp (ddns_info->Device, tmp_info.Device))
		{
			if (!Set_DDNS_Device (ddns_info->Device))	//  device
				return DDNS_ERROR_SET_DEIVCE;
			changed = 1;
		}
        
		if (ddns_info->DDNS_Type != tmp_info.DDNS_Type)
		{
			if (!Set_DDNS_Type  (ddns_info->DDNS_Type))	//  ddns_type
				return DDNS_ERROR_SET_DDNS_TYPE;
			changed = 1;
		}
        
		if (ddns_info->DDNS_Server != tmp_info.DDNS_Server)
		{
			if (!Set_DDNS_Server (ddns_info->DDNS_Server))	//  ddns_server
				return DDNS_ERROR_SET_DDNS_SERVER;
			changed = 1;
		}
		
		//  get wan ip address
		NIC_Get_Info (&nic_info, NIC_WAN);
		strcpy (ddns_info->IP_Address, nic_info.ipaddr);

		if (strcmp (ddns_info->IP_Address, tmp_info.IP_Address))
		{
			if (!Set_DDNS_IP_Address (ddns_info->IP_Address))// IP address
				return DDNS_ERROR_SET_IP_ADDR;
			changed = 1;
		}

		if (changed == 1)
		{
			ret = Enable_DDNS (ENABLE_DDNS);		//  enable
			if (ret != 0)
				Restore_DDNS_Info (&tmp_info);
				
		}
	}
	else
	{
		ret = Enable_DDNS (DISABLE_DDNS);
	}
	return ret;
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Check_DDNS_Info (struct DDNS_Information * ddns_info)
{
	if (!strcmp (ddns_info->UserName, ""))
		return DDNS_ERROR_USER_NAME;

	if (!strcmp (ddns_info->Password, ""))
		return DDNS_ERROR_PASSWORD;

	if (!strcmp (ddns_info->HostName, ""))
		return DDNS_ERROR_HOST_NAME;
	
	return 0;
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Get_DDNS_User_Name (char * user_name, int size)
{
	return GetProfileString (DDNS_SECTION, DDNS_USER, "", user_name, size);
}

BOOL Set_DDNS_User_Name (char * user_name)
{
	return Set_Profile_String (DDNS_SECTION, DDNS_USER, user_name);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Get_DDNS_User_Password (char * password, int size)
{
	return GetProfileString (DDNS_SECTION, DDNS_PASSWORD, "", password, size);
}

BOOL Set_DDNS_User_Password (char * password)
{
	return Set_Profile_String (DDNS_SECTION, DDNS_PASSWORD, password);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Get_DDNS_Host (char * host, int size)
{
	return GetProfileString (DDNS_SECTION, DDNS_HOST_NAME, "", host, size);
}

BOOL Set_DDNS_Host (char * host)
{
	return Set_Profile_String (DDNS_SECTION, DDNS_HOST_NAME, host);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
BOOL Is_Wildcard_Support (void)
{
	return Get_Profile_Boolean (DDNS_SECTION, DDNS_WILDCARD, FALSE);
}

BOOL Wildcard_Support (int action)
{
	BOOL ret = FALSE;
	if (action == TRUE)
		ret = Set_Profile_String (DDNS_SECTION, DDNS_WILDCARD, "TRUE");
	else
		ret = Set_Profile_String (DDNS_SECTION, DDNS_WILDCARD, "FALSE");
	return ret;
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Get_DDNS_MX (char * mx, int size)
{
	return GetProfileString (DDNS_SECTION, DDNS_MX, "", mx, size);
}

BOOL Set_DDNS_MX (char * mx)
{
	return Set_Profile_String (DDNS_SECTION, DDNS_MX, mx);
}
//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
BOOL Is_DDNS_BackupMX (void)
{
	return Get_Profile_Boolean (DDNS_SECTION, DDNS_BACKUPMX, FALSE);
}

BOOL DDNS_BackupMX (int action)
{
	BOOL ret = FALSE;

	if (action == TRUE)
		ret = Set_Profile_String (DDNS_SECTION, DDNS_BACKUPMX, "TRUE");
	else
		ret = Set_Profile_String (DDNS_SECTION, DDNS_BACKUPMX, "FALSE");
	return ret;
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Get_DDNS_Device (char * device, int size)
{
	return GetProfileString (DDNS_SECTION, DDNS_DEVICE, "eth0", device, size);
}

BOOL Set_DDNS_Device (char * device)
{
	return Set_Profile_String (DDNS_SECTION, DDNS_DEVICE, device);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Get_DDNS_Type (void)
{
	return Get_Profile_Integer (DDNS_SECTION, DDNS_TYPE, 0);
}

BOOL Set_DDNS_Type (int type)
{
	char buf[32];
	sprintf (buf, "%d", type);
	return Set_Profile_String (DDNS_SECTION, DDNS_TYPE, buf);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Get_DDNS_Server (void)
{
	return Get_Profile_Integer (DDNS_SECTION, DDNS_SERVER_TYPE, 0);
}

BOOL Set_DDNS_Server (int type)
{
	char buf[32];
	sprintf (buf, "%d", type);
	return Set_Profile_String (DDNS_SECTION, DDNS_SERVER_TYPE, buf);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int Get_DDNS_Config_File (char * config_file, int size)
{
	return GetProfileString (DDNS_SECTION, DDNS_CONFIG_FILE, "/etc/ddns_update.conf", config_file, size);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int  Get_DDNS_IP_Address (char * ip_addr, int size)
{
	return GetProfileString (DDNS_SECTION, DDNS_IP_ADDRESS, "", ip_addr, size);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
BOOL Set_DDNS_IP_Address (char * ip_addr)
{
	return Set_Profile_String (DDNS_SECTION, DDNS_IP_ADDRESS, ip_addr);
}

//**************************************************************************
//	Function: 	
//	Description:	
//			
//	Parameter:	
//	Return value:	
//
int  Restore_DDNS_Info (struct DDNS_Information * ddns_info)
{
	if (!Set_DDNS_User_Name (ddns_info->UserName))	//  user
		return DDNS_ERROR_SET_USER_NAME;
	if (!Set_DDNS_User_Password (ddns_info->Password))//password
		return DDNS_ERROR_SET_PASSWORD;
	if (!Set_DDNS_Host (ddns_info->HostName))	//  host
		return DDNS_ERROR_SET_HOST_NAME;
	if (!Wildcard_Support (ddns_info->Wildcard))	//  wildcard
		return DDNS_ERROR_SET_WILDCARD;
	if (!Set_DDNS_MX (ddns_info->MailExchanger))	//  mx
		return DDNS_ERROR_SET_MX;
	if (!DDNS_BackupMX (ddns_info->BackupMX))	//  backmx
		return DDNS_ERROR_SET_BACKMX;
	if (!Set_DDNS_Device (ddns_info->Device))	//  device
		return DDNS_ERROR_SET_DEIVCE;
	if (!Set_DDNS_Type  (ddns_info->DDNS_Type))	//  ddns_type
		return DDNS_ERROR_SET_DDNS_TYPE;
	if (!Set_DDNS_Server (ddns_info->DDNS_Server))	//  ddns_server
		return DDNS_ERROR_SET_DDNS_SERVER;
	if (!Set_DDNS_IP_Address (ddns_info->IP_Address))// ip address
		return DDNS_ERROR_SET_IP_ADDR;
	return 0;
}
