#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/mount.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* include NAS */
#include <eventlog.h>
#include <NAS.h>
#include "cfg_system.h"
#include "cfg_backup.h"
#include "backup.h"
#include "cfg_nic.h"

#ifdef	__SNAPSHOT__	// Catherine
#include "naslvm.h"

extern int get_new_snapshot_info_from_source(char* src, SNAPSHOT_VOLUME_CONF *sconf);
extern void print_sys_log(char *str, int flag);
#endif
//#define _DEBUG		1

char	DEVNULL[]={"2>/dev/null 1>/dev/null"};
char	ftpget[]={"/sbin/ftpcopy"};
char	ftpput[]={"/sbin/ncftpput"};
char	ftpauth[]={"/sbin/ftpls"};
char	backupcopy[]={"/sbin/backupcopy"};
char	cifsmount[]={"/usr/bin/smbmount"};
char	cifsumount[]={"/bin/umount"};
char	nfsmount[]={"/bin/mount"};
char	nfsumount[]={"/bin/umount"};

int write_log(char *str, int type)
{
        int fd;
        char *ptr[10];

        fd = Open_Event_Log(1);
        if (fd <= 0)
        {
                return -1;
        }
        ptr[0]=str;
        Report_Event(fd, type, 1, ptr);
        Close_Event_Log(fd);
        return 0;
}

void DEBUG_Schedule(BACKUP_SCHEDULE *schedule)
{
	while (schedule!=NULL)
	{
		printf("schedule->name=[%s]<br>\n", schedule->name);
		printf("schedule->policy=[%d]<br>\n", schedule->policy);
		printf("schedule->usage=[%d]<br>\n", schedule->usage);
		printf("schedule->remote.volume=[%s]<br>\n", schedule->remote.volume);
		printf("schedule->remote.path=[%s]<br>\n", schedule->remote.path);
		printf("schedule->local.volume=[%s]<br>\n", schedule->local.volume);
		printf("schedule->local.path=[%s]<br>\n", schedule->local.path);
		printf("schedule->ftp.server.location=[%s]<br>\n", schedule->ftp.server.location);
		printf("schedule->ftp.user.name=[%s]<br>\n", schedule->ftp.user.name);
		printf("schedule->ftp.user.passwd=[%s]<br>\n", schedule->ftp.user.passwd);
		printf("schedule->ftp.port=[%d]<br>\n", schedule->ftp.port);
		printf("schedule->cifs.server.location=[%s]<br>\n", schedule->cifs.server.location);
		printf("schedule->cifs.user.name=[%s]<br>\n", schedule->cifs.user.name);
		printf("schedule->cifs.user.passwd=[%s]<br>\n", schedule->cifs.user.passwd);
		printf("schedule->nfs.server.location=[%s]<br>\n", schedule->nfs.server.location);
		printf("schedule->t_type=[%d]<br>\n", schedule->t_type);
		printf("schedule->week=[%d]<br>\n", schedule->week);
		printf("schedule->month=[%d]<br>\n", schedule->month);
		printf("schedule->t_hour=[%d]<br>\n", schedule->t_hour);
		printf("schedule->t_min=[%d]<br>\n", schedule->t_min);
		printf("schedule->bk_pid=[%d]<br>\n", schedule->bk_pid);
		printf("schedule->status=[%d]<br>\n", schedule->status);
		printf("schedule->latest_time=[%ld]<br>\n", schedule->latest_time);
		printf("schedule->bcompress=[%d]<br>\n\n", schedule->bcompress);
		schedule=(BACKUP_SCHEDULE *)schedule->next;
	}
}

int BACKUP_Get_Volume_Path(char *buf, int len, char *volume)
{
        SMB_SHARE_INFO  *smb_share_info, *psmb;
        int             find=0;

#ifdef	_DEBUG
	printf("BACKUP_Get_Volume_Path(%s) starts!<br>\n",
		volume);
#endif
        smb_share_info=SMB_Get_Share_Info();
#ifdef	_DEBUG
	printf("\tsmb_share_info == NULL ? %s<br>\n",
		(smb_share_info == NULL) ? "TRUE" : "FALSE");
#endif

        psmb=smb_share_info;
        while (psmb!=NULL)
        {
#ifdef	_DEBUG
		printf("\tsharename = %s<br>\n", psmb->sharename);
#endif
                if (!strcmp(psmb->sharename, volume))
                {
                        strcpy(buf, psmb->path);
                        find=1;
                        break;
                }
                psmb=(SMB_SHARE_INFO *)psmb->next;
        }
        SMB_Free_Share_Info(smb_share_info);
#ifdef	_DEBUG
	printf("found? %s; output buffer = %s<br>\n", (find) ? "TRUE" : "FALSE", buf);
#endif

	if (strncmp(buf, "/share/", 7))	// not under /share folder, return fail
		return 0;
        return find;
}

/************************************************************************/
/* if the dir name is not exist, then create it	and chmod to 0x777 	*/
/* if already existed, chmod to 0x777					*/
/* return:								*/
/*		0: success						*/
/*		otherwise: fail						*/
/************************************************************************/
int create_dir(char *dirname)
{
	DIR	*dir;
	int	ret=0;

	if ((dir=opendir(dirname))==NULL)
	{
		ret=mkdir(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
		if (ret==0)
			ret=chmod(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
	}
	else
	{
		closedir(dir);
		ret=chmod(dirname, S_IRWXU | S_IRWXG | S_IRWXO);
	}
	return ret;
}

// 2005.11.30, Johnson Cheng
// Never need it on TS-101 because of no nasrpc file
/*int Backup_Get_Server(char *ipaddr, int len, char *source)
{
        char            nasrpc[]={"/usr/local/samba/sbin/nasrpc"};
        char            output[]={"/tmp/smbserver"};
        char            cmd[256], *ptr1, *ptr2;
        FILE            *fptr;
        struct in_addr  inp;

        if (inet_aton(source, &inp)!=0)
        {
                strcpy(ipaddr, source);
                return 1;
        }
        ipaddr[0]=0x0;
        sprintf(cmd, "%s -7 -s %s > %s", nasrpc, source, output);
        system(cmd);
        if ((fptr=fopen(output, "rb"))==NULL)
                return 0;
        fgets(ipaddr, len, fptr);
        if (strstr(ipaddr, "@@error@@")!=NULL)
        {
                ipaddr[0]=0x0;
                fclose(fptr);
                return 0;
        }
        fclose(fptr);
	ipaddr[strlen(ipaddr)-3]=0x0;
	ptr1=ipaddr+2;
	ptr2=ipaddr;
	while (*ptr1!=0x0)
		*ptr2++=*ptr1++;
	*ptr2=0x0;
        return 1;
}*/

#ifdef	__SNAPSHOT__

int create_a_snapshot_for_path(char* sharedir, SNAPSHOT_VOLUME_CONF* snconf)
{
	int ret;

	if (sharedir == NULL || snconf == NULL)
		return ERROR_INVALID_PARAM;

	ret = get_new_snapshot_info_from_source(sharedir, snconf);
	if (ret<0) {
#ifdef _DEBUG
		printf("create_a_snapshot_for_path (%s) : "
			"get_new_snapshot_info_from_source fails!\n",
			sharedir);
#endif
		return ret;
	}

	ret = Add_Snapshot_Volume_Record(snconf);
	if (ret<=0) {
#ifdef	_DEBUG
		printf("create_a_snapshot_for_path (%s) : "
			"fails to add a new snapshot record, "
			"err=%d\n", sharedir, ret);
#endif
			return ret;
	}

	ret = Create_Snapshot_Volume(snconf);
	if (ret<0) {
#ifdef	_DEBUG
		printf("create_a_snapshot_for_path (%s) : "
			"fails to add a new snapshot volume,"
			"err=%d\n", sharedir, ret);
#endif
		return ret;
	}
	return SUCCESS;
}

int verify_src_vol_with_snapshot(char* srcvol)
{
	char			tmpbuf[MAX_PATH];
	SNAPSHOT_VOLUME_CONF	tmpsnap;

#ifdef	_DEBUG
	printf("verify_src_vol_with_snapshot(%s) starts!<br>\n",
		srcvol);
#endif
	if (BACKUP_Get_Volume_Path(tmpbuf, sizeof(tmpbuf), srcvol)==0)
		return BK_SRC_DIR_FAIL;

#ifdef	_DEBUG
	printf("verify_src_vol_with_snapshot(%s) step 1 (source = %s)!<br>\n",
		srcvol, tmpbuf);
#endif

	// the source is a snapshot volume
	if (!strncmp(srcvol, SNAPSHOT_NAME_PREFIX,
		strlen(SNAPSHOT_NAME_PREFIX)))
	{
		return BK_SNAP_OPTION_INVALID;
	}
#ifdef	_DEBUG
	printf("verify_src_vol_with_snapshot(%s) step 2 (source not a snap)!<br>\n",
		srcvol);
#endif

	// the source volume is either not snapsht-enabled
	// or the snapshot max count is reached
	if (get_new_snapshot_info_from_source(tmpbuf, &tmpsnap))
	{
		return BK_SNAP_CREATE_FAIL;
	}
#ifdef	_DEBUG
	printf("verify_src_vol_with_snapshot(%s) step 3 over!<br>\n",
		srcvol);
#endif
	return BACKUP_SUCCESS;
}
#endif

int backup_copy(BACKUP_SCHEDULE *schedule, char *mp, char *server)
{
	char	cmd[2048], volume_path[1024],src[2048],dest[2048];
	int	ret=BACKUP_SUCCESS;

#ifdef	__SNAPSHOT__
	int	tmp_snapshot_no = 0;
	SNAPSHOT_VOLUME_CONF snapvol;
#ifdef	_DEBUG
printf("backup_copy starts! <br>\n"
	"\tlocal.volume = %s <br>\n"
	"\tlocal.path = %s <br>\n"
	"\tremote.volume = %s <br>\n"
	"\tremote.path = %s <br>\n",
	schedule->local.volume, schedule->local.path,
	schedule->remote.volume, schedule->remote.path);
#endif
	if (schedule->rr_from_snapshot &&
		strncmp(schedule->local.volume, SNAPSHOT_NAME_PREFIX,
			strlen(SNAPSHOT_NAME_PREFIX)) == 0)
	{
#ifdef	_DEBUG
		printf("backup_copy : cannot create a snapshot on a snapshot!\n");
#endif
		return BK_SNAP_OPTION_INVALID;
	}
#endif

	if (BACKUP_Get_Volume_Path(volume_path, sizeof(volume_path), schedule->local.volume)==0)
		return BK_SRC_DIR_FAIL;

#ifdef	__SNAPSHOT__
	// if backup from snapshot
	if (schedule->rr_from_snapshot) {
		char	snapmp[MAX_PATH] = {""}, sharedir[MAX_PATH] = {""};
		char	*pp;
		int	i;

		// create a snapshot
		ret = create_a_snapshot_for_path(volume_path, &snapvol);
		if (ret<0)
			return BK_SNAP_CREATE_FAIL;
		
		tmp_snapshot_no = snapvol.i_Snapshot_No;
		Set_Snapshot_Status(tmp_snapshot_no, S_VOLUME_BUSY);
		Get_Mount_Point(snapvol.c_Snapshot_Path, snapmp);

		// change volume_path to the corresponding path of the snapshot
		pp = volume_path;
		for (i=0; i<2 && pp && *pp; i++) pp = strchr(pp+1, '/');

 		if (pp && *(pp+1)) {
 			strcpy(sharedir, (char*)(pp+1));
 			sprintf(volume_path, "%s/%s", snapmp, sharedir);
 		}
 		else
			sprintf(volume_path, "%s", snapmp);
#ifdef	_DEBUG
		printf("backup_copy :<br>\n"
			"snapshot no = %d<br>\n"
			"snapshot path = %s<br>\n"
			"new source path = %s<br>\n",
			tmp_snapshot_no,
			snapvol.c_Snapshot_Path,
			volume_path);
#endif
	}
#endif
	switch (schedule->usage)
	{
		case BK_VIA_FTP:
			if (schedule->policy==BACKUP_PUT)
			{
				if (schedule->bcompress)
				{
					sprintf(cmd, "%s -u %s -p %s -P %d %s /%s%s %s%s/%d.tar.gz",
							ftpput,
							schedule->ftp.user.name,
							schedule->ftp.user.passwd,
							schedule->ftp.port,
							server,
							schedule->remote.volume,
							schedule->remote.path,
							volume_path,
							schedule->local.path,
							schedule->bk_pid);
#ifdef _DEBUG
					printf("ftpput cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
					ret=system(cmd);
#endif
				}
				else
				{
					sprintf(cmd, "%s -u %s -p %s -R -P %d %s /%s%s %s%s/* %s",
							ftpput,
							schedule->ftp.user.name,
							schedule->ftp.user.passwd,
							schedule->ftp.port,
							server,
							schedule->remote.volume,
							schedule->remote.path,
							volume_path,
							schedule->local.path,
							DEVNULL);
#ifdef _DEBUG
					printf("ftpput cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
					ret=system(cmd);
#endif
				}
			}
			else
			if (schedule->policy==BACKUP_GET)
			{
				if (schedule->bcompress)
				{
					sprintf(cmd, "%s --user=%s --pass=%s %s:%d /%s%s/%d.tar.gz %s%s %s",
							ftpget,
							schedule->ftp.user.name,
							schedule->ftp.user.passwd,
							server,
							schedule->ftp.port,
							schedule->remote.volume,
							schedule->remote.path,
							schedule->bk_pid,
							volume_path,
							schedule->local.path,
							DEVNULL);
#ifdef _DEBUG
					printf("copy command=%s\n", cmd);
#endif
#ifndef _DEBUG
					ret=system(cmd);
#endif
					if (ret!=0)
						break;
					sprintf(cmd, "/bin/tar zxvf %s%s/%d.tar.gz -C %s%s %s",
							volume_path,
							schedule->local.path,
							schedule->bk_pid,
							volume_path,
							schedule->local.path,
							DEVNULL);
#ifdef _DEBUG
					printf("tar command=%s\n", cmd);
#endif
#ifndef _DEBUG
					ret=system(cmd);
#endif
					sprintf(cmd, "/bin/rm %s%s/%d.tar.gz -f %s",
							volume_path,
							schedule->local.path,
							schedule->bk_pid,
							DEVNULL);
					ret=system(cmd);
				}
				else
				{
					sprintf(cmd, "%s --user=%s --pass=%s %s:%d /%s%s %s%s %s",
							ftpget,
							schedule->ftp.user.name,
							schedule->ftp.user.passwd,
							server,
							schedule->ftp.port,
							schedule->remote.volume,
							schedule->remote.path,
							volume_path,
							schedule->local.path,
							DEVNULL);
#ifdef _DEBUG
					printf("copy command=%s\n", cmd);
#endif
#ifndef _DEBUG
					ret=system(cmd);
#endif
				}
			}
			break;
		case BK_VIA_CIFS:
		case BK_VIA_NFS:
			if (schedule->policy==BACKUP_PUT)
			{
				FILE	*fptr;
				char	tmp[256], cmd[1024];

				sprintf(src, "%s%s", volume_path, schedule->local.path);
				sprintf(dest,"%s%s", mp, schedule->remote.path);
				if (schedule->option & BACKUP_COPY_STOP_SERVICE)
					Stop_Services();
				//use new API Backup_Copy
// 2003/01/13 Kent modify
// to avoid multi-thread bug
				sprintf(tmp, "/tmp/%d.rr", schedule->bk_pid);
				fptr=fopen(tmp, "wb");
				fprintf(fptr, "%s\n%s\n%s\n", src, dest, schedule->name);
//				fputs(src, fptr);
//				fputs(dest, fptr);
				fclose(fptr);
				sprintf(cmd, "/sbin/backup_copy %s %d %d", tmp, schedule->option, schedule->bk_pid);
				ret=system(cmd);
				ret=(char)(ret>>8);
//				if (E_COMPRESS == (ret = Backup_Copy(src, dest, schedule->option, schedule->bk_pid, schedule->name))){
				if (E_COMPRESS==ret)
				{
// end
					schedule->bcompress=0;	
					schedule->option -= 2;//BACKUP_COPY_COMPRESS:0x02
					sprintf(cmd, "/sbin/backup_copy %s %d %d", tmp, schedule->option, schedule->bk_pid);
					ret=system(cmd);
					ret=(char)(ret>>8);
//					ret = Backup_Copy(src, dest, schedule->option, schedule->bk_pid);
					schedule->bcompress=1;	
					schedule->option |= BACKUP_COPY_COMPRESS;								
					/*sprintf(cmd, "%s -dpRuf %s%s/ %s%s %s",
							backupcopy,
							volume_path,
							schedule->local.path,
							mp,
							schedule->remote.path,
							DEVNULL);
#ifdef _DEBUG

                                      			  printf("copy cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
                                       			   ret=system(cmd);
#endif
					*/
				}
				unlink(tmp);
				if (schedule->option & BACKUP_COPY_STOP_SERVICE)
					Start_Services();
			}		
					
			/*	sprintf(cmd, "%s%s", mp,schedule->remote.path);
				if (!Is_Existing_Directory(cmd)) return BK_COPY_FAIL;
				
				if (schedule->bcompress)
				{
					sprintf(cmd, "%s -f %s%s/%d.tar.gz %s%s %s",
							backupcopy,
							volume_path,
							schedule->local.path,
							schedule->bk_pid,
							mp,
							schedule->remote.path,
							DEVNULL);
#ifdef _DEBUG

					printf("copy cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
					ret=system(cmd);
#endif
				}
				else
				{*/
					//sprintf(cmd, "%s -dpRuf %s%s/* %s%s %s",
							/*backupcopy,
							volume_path,
							schedule->local.path,
							mp,
							schedule->remote.path,
							DEVNULL);
#ifdef _DEBUG

                                        printf("copy cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
                                        ret=system(cmd);
#endif
				}*/
			
			else
			if (schedule->policy==BACKUP_GET)
			{
				if (schedule->bcompress)
				{
					sprintf(cmd, "%s %s/%s/%d.tar.gz %s%s %s",
							backupcopy,
							mp,
							schedule->remote.path,
							schedule->bk_pid,
							volume_path,
							schedule->local.path,
							DEVNULL);
#ifdef _DEBUG

					printf("copy cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
					ret=system(cmd);
#endif
        	                        if (ret!=0)
                	                        break;
                        	        sprintf(cmd, "/bin/tar zxvf %s%s/%d.tar.gz -C %s%s %s",
							volume_path,
                                        	        schedule->local.path,
                                                	schedule->bk_pid,
							volume_path,
        	                                        schedule->local.path,
                	                                DEVNULL);
#ifdef _DEBUG

                        	        printf("tar command=%s\n", cmd);
#endif
#ifndef _DEBUG
                                	ret=system(cmd);
#endif
	                                sprintf(cmd, "/bin/rm %s%s/%d.tar.gz -f %s",
							volume_path,
                	                                schedule->local.path,
                        	                        schedule->bk_pid,
                                	                DEVNULL);
	                                ret=system(cmd);
				}
				else
				{
					sprintf(cmd, "%s -dpRuf %s/%s/* %s%s %s",
							backupcopy,
							mp,
							schedule->remote.path,
							volume_path,
							schedule->local.path,
							DEVNULL);
#ifdef _DEBUG

					printf("copy cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
					ret=system(cmd);
#endif
				}
			}
			break;
	}
#ifdef	__SNAPSHOT__

	if (schedule->rr_from_snapshot) {
		Set_Snapshot_Status(tmp_snapshot_no, S_READY);
		if (Get_Snapshot_Volume_Use_Rate(snapvol.c_Snapshot_Path) >= 100) {
			char tmpbuf[BUF_SIZE];

			sprintf(tmpbuf, "Remote replication job \"%s\" "
				"might have failed due to snapshot overflow.",
				schedule->name);
			print_sys_log(tmpbuf,
				EVENTLOG_ERROR_TYPE);
		}
		Delete_Snapshot_Volume(tmp_snapshot_no);
	}
#endif
	if ( 0 == ret)
		return BACKUP_SUCCESS;
	else if ( E_SRC == ret )
		return BK_SRC_DIR_FAIL;
	else if ( E_DEST == ret )
		return BK_DEST_DIR_FAIL;
	else				
		return BK_COPY_FAIL;
}

int Backup_Update_Status(BACKUP_SCHEDULE *schedule, int status)
{
	BACKUP_SCHEDULE new;
	int		ret;

	memcpy(&new, schedule, sizeof(BACKUP_SCHEDULE));
	new.status=status;
	new.latest_time = time(NULL);//Shone added
	ret=Backup_Ren_Schedule(&new, schedule);
	return 1;
}

int backup_via_ftp(BACKUP_SCHEDULE *schedule)
{
	char	cmd[2048], server[256];
	int	ret=BACKUP_SUCCESS;

	// 2005.11.30, Johnson Cheng
	//if (Backup_Get_Server(server, 256, schedule->ftp.server.location)==0)
	//	return BK_SERVER_NOT_FOUND;

	/* check auth	*/
	sprintf(cmd, "%s --user=%s --pass=%s %s:%d / %s",
			ftpauth,
			schedule->ftp.user.name,
			schedule->ftp.user.passwd,
			server,
			schedule->ftp.port,
			DEVNULL);
#ifdef _DEBUG
	printf("ftp auth command=%s\n", cmd);
#endif
#ifndef _DEBUG
	ret=system(cmd);
#endif
	if (ret!=0)
	{
		return BK_AUTH_FAIL;
	}
	ret=backup_copy(schedule, NULL, server);
	return ret;
}

int backup_via_cifs(BACKUP_SCHEDULE *schedule)
{
	char	cmd[2048], server[256];
	int	ret=BACKUP_SUCCESS;
	char	mp[64];
#ifdef SYNC_BY_NFS
	int	ret_nfs = 0;
	char	mp_nfs[128];
#endif
//	NIC_INFO	nic_info;
	int		nic_num;

	// 2005.11.30, Johnson Cheng
        //if (Backup_Get_Server(server, 256, schedule->cifs.server.location)==0)
        //        return BK_SERVER_NOT_FOUND;

	// check src and dest are the same ?
	nic_num=NIC_Count_Interface();
/*	if (	nic_num==1 || (nic_num==2 && NIC_Is_Bonding_Support()))
	{
		// check ip the same?
		NIC_Get_Info(&nic_info, NIC_WAN_DEFAULT);
		if (!strcmp(server, nic_info.ipaddr))
			return BK_NAS_SAME;
	}
	else
	if (nic_num==2 && NIC_Is_Support_Router())
	{
		NIC_Get_Info(&nic_info, NIC_WAN);
		if (!strcmp(server, nic_info.ipaddr))
			return BK_NAS_SAME;
		NIC_Get_Info(&nic_info, NIC_LAN01);
		if (!strcmp(server, nic_info.ipaddr))
			return BK_NAS_SAME;
	}
	else
	if (nic_num==3 && NIC_Is_Switch_Support())
	{
		NIC_Get_Info(&nic_info, NIC_WAN);
		if (!strcmp(server, nic_info.ipaddr))
			return BK_NAS_SAME;
		NIC_Get_Info(&nic_info, NIC_LAN03);
		if (!strcmp(server, nic_info.ipaddr))
			return BK_NAS_SAME;
	}*/

	sprintf(mp, "/mnt/%d", getpid());
#ifdef SYNC_BY_NFS
	// Andy Wu
	sprintf(mp_nfs, "%s.nfs", mp);
#endif
	if (create_dir(mp)!=0)
		return BK_DIR_FAIL;
#ifdef SYNC_BY_NFS
	if (create_dir(mp_nfs)!=0)
		; //so what?

	sprintf(cmd, "%s \"%s:/%s\" %s %s",
			nfsmount,
			server,
			schedule->remote.volume,
			mp_nfs,
			DEVNULL);
#ifdef _DEBUG
	printf("cifs mount cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
	ret_nfs=system(cmd);
#endif
	// Andy Wu
#endif
	sprintf(cmd, "%s \"//%s/%s\" %s -o sync,lfs,fmask=664,dmask=755,username=\"%s\",password=%s %s",
			cifsmount,
			server,
			schedule->remote.volume,
			mp,
			schedule->cifs.user.name,
			schedule->cifs.user.passwd,
			DEVNULL);
#ifdef _DEBUG
	printf("cifs mount cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
	ret=system(cmd);
#endif
	if (ret!=0)
	{
		rmdir(mp);
#ifdef SYNC_BY_NFS
		if ( !ret_nfs ) {
			sprintf(cmd, "%s -f %s %s", nfsumount, mp_nfs, DEVNULL);
			system(cmd);
		}
		rmdir(mp_nfs);
#endif
		return BK_AUTH_FAIL;
	}

	ret=backup_copy(schedule, mp, server);
#ifdef SYNC_BY_NFS
	if ( !ret_nfs ) {
		sprintf(cmd, "%s -f %s %s", nfsumount, mp_nfs, DEVNULL);
		if (system(cmd)==0)
			rmdir(mp_nfs);
	}
#endif
	sprintf(cmd, "%s -f \"%s\" %s", cifsumount, mp, DEVNULL);
	if (system(cmd)==0)
		rmdir(mp);
	return ret;
}

int backup_via_nfs(BACKUP_SCHEDULE *schedule)
{
	char	cmd[2048], server[256];
	int	ret=BACKUP_SUCCESS;
	char	mp[64];

	// 2005.11.30, Johnson Cheng
        //if (Backup_Get_Server(server, 256, schedule->nfs.server.location)==0)
        //        return BK_SERVER_NOT_FOUND;

	sprintf(mp, "/mnt/%d", getpid());
	if (create_dir(mp)!=0)
		return BK_DIR_FAIL;
	sprintf(cmd, "%s \"%s:/%s\" %s %s",
			nfsmount,
			server,
			schedule->remote.volume,
			mp,
			DEVNULL);
#ifdef _DEBUG
	printf("nfs mount cmd=%s\n", cmd);
#endif
#ifndef _DEBUG
	ret=system(cmd);
#endif
	if (ret!=0)
	{
		rmdir(mp);
		return BK_AUTH_FAIL;
	}
	ret=backup_copy(schedule, mp, server);
	sprintf(cmd, "%s -f %s %s", nfsumount, mp, DEVNULL);
	if (system(cmd)==0)
		rmdir(mp);
	return ret;
}

int Backup_Upgrade_Schedule()
{
	FILE			*fptr;
	BACKUP_SCHEDULE_V1	tmp_schedule_v1;
	BACKUP_SCHEDULE		*schedule=NULL, *start=NULL;
	BACKUP_HEADER		header;
	int			size_sn, size_v1, count=0, ret;

	if ((fptr=fopen(BACKUP_SCHEDULE_CONF, "r"))==NULL)
		return BACKUP_SUCCESS;
	fread(&header, 1, sizeof(BACKUP_HEADER), fptr);
	if (header.version==BACKUP_VERSION)
	{	// v1 need to upgrade to snapshot version
		size_sn=sizeof(BACKUP_SCHEDULE);
		size_v1=sizeof(BACKUP_SCHEDULE_V1);
		while (!feof(fptr))
		{
			ret=fread(&tmp_schedule_v1, 1, size_v1, fptr);
			if (ret==size_v1)
			{
				if (count==0)
				{
					schedule=calloc(1, size_sn);
					start=schedule;
					count++;
				}
				else
				{
					schedule->next=calloc(1, size_sn);
					schedule=(BACKUP_SCHEDULE *)schedule->next;
				}
				memcpy(schedule, &tmp_schedule_v1, size_v1);
				schedule->rr_from_snapshot=0;	//default snapshot is disable
			}
		}
	}
	else
	{
		fclose(fptr);
		return BACKUP_SUCCESS;
	}
	fclose(fptr);
	backup_write_schedule(start);
        Backup_Free_Schedule(start);
	return BACKUP_SUCCESS;
}

BACKUP_SCHEDULE *Backup_Get_Schedule()
{
        FILE			*fptr;
        BACKUP_SCHEDULE		*start=NULL, *schedule=NULL, tmp_schedule;
        int                     ssize, ret, count=0;
        BACKUP_HEADER		header;

	if ((fptr=fopen(BACKUP_SCHEDULE_CONF, "r"))==NULL)
		return NULL;
	fread(&header, 1, sizeof(BACKUP_HEADER), fptr);
	ssize=sizeof(BACKUP_SCHEDULE);
	while (!feof(fptr))
	{
		ret=fread(&tmp_schedule, 1, ssize, fptr);
		if (ret==ssize)
		{
			if (count==0)
			{
				schedule=calloc(1, ssize);
				start=schedule;
				count++;
			}
			else
			{
				schedule->next=calloc(1, ssize);
                                schedule=(BACKUP_SCHEDULE *)schedule->next;
                        }
			memcpy(schedule, &tmp_schedule, ssize);
		}
	}
	fclose(fptr);
	return start;
}

int backup_write_header(FILE *fptr, int bodysize, int total)
{
	BACKUP_HEADER	header;

        header.version=BACKUP_SN_VERSION;
        header.bodysize=bodysize;
        header.total=total;
        header.reserved=0;
        if (fwrite(&header, 1, sizeof(BACKUP_HEADER), fptr)!=sizeof(BACKUP_HEADER))
                return BACKUP_FAIL;
        return BACKUP_SUCCESS;
}

void backup_write_schedule(BACKUP_SCHEDULE *schedule)
{
	BACKUP_SCHEDULE		*tmp;
	int			ssize;
	FILE			*fptr;
	int			total=0;

        tmp=schedule;
        while (tmp!=NULL)
        {
		tmp=(BACKUP_SCHEDULE *)tmp->next;
		total++;
	}
        if ((fptr=fopen(BACKUP_SCHEDULE_CONF, "w"))==NULL)
		return;
	ssize=sizeof(BACKUP_SCHEDULE);
	backup_write_header(fptr, ssize, total);
        tmp=schedule;
        while (tmp!=NULL)
	{
                fwrite(tmp, 1, ssize, fptr);
		tmp=(BACKUP_SCHEDULE *)tmp->next;
	}
	fclose(fptr);
}

int backup_comp_schedule(BACKUP_SCHEDULE *schedule1, BACKUP_SCHEDULE *schedule2)
{
	if (!strcmp(schedule1->name, schedule2->name))
		return 0;
	else
		return 1;
}

int backup_fcomp_schedule(BACKUP_SCHEDULE *schedule1, BACKUP_SCHEDULE *schedule2)
{
	if (	!strcmp(schedule1->name, schedule2->name) && schedule1->bk_pid==schedule2->bk_pid)
		return 0;
	else
		return 1;
}

void Backup_Free_Schedule(BACKUP_SCHEDULE *schedule)
{
	BACKUP_SCHEDULE	*tmp;

        tmp=schedule;
        while (schedule!=NULL)
        {
                tmp=(BACKUP_SCHEDULE *)schedule->next;
                free(schedule);
                schedule=tmp;
        }
        return;
}

int Backup_Add_Schedule(BACKUP_SCHEDULE *new)
{
	BACKUP_SCHEDULE	*schedule=NULL, *tmp=NULL;
	int		ssize;
#ifdef	__SNAPSHOT__
	int			ret;
#endif
#if	_DEBUG
printf("Backup_Add_Schedule(%s) starts<br>\n",
new->name);
#endif
        schedule=Backup_Get_Schedule();
        
/*Before using new->latest time, it will be initialized beside t_type is BK_IMMEDIATELY 
  that get time of current systeme .Because doing it in the cgi, 
  so don't initialized latest time. */              
	//new->latest_time=0;
	
        ssize=sizeof(BACKUP_SCHEDULE);
        if (schedule==NULL)
        {
                schedule=calloc(1, ssize);
                memcpy(schedule, new, ssize);
                schedule->next=NULL;
        }
        else
        {
                tmp=schedule;
                while (tmp!=NULL)
                {
                        if (!backup_comp_schedule(tmp, new))
                        {
                                Backup_Free_Schedule(schedule);
                                return ERROR_SCHEDULE_DUPLICATE;
                        }
                        if (tmp->next==NULL)
                                break;
                        else
                                tmp=(BACKUP_SCHEDULE *)tmp->next;
                }
#ifdef	__SNAPSHOT__
#ifdef	_DEBUG
		printf("Backup_Add_Schedule(%s) before verify_src_vol_with_snapshot(%s)<br>\n",
			new->name, new->local.volume);
#endif
		if (new->rr_from_snapshot &&
			(ret = verify_src_vol_with_snapshot(new->local.volume))!=BACKUP_SUCCESS)
		{
#ifdef	_DEBUG
			printf("Backup_Add_Schedule(%s) "
				"verify_src_vol_with_snapshot(%s) returns %d<br>\n",
				new->name, new->local.volume, ret);
#endif

			Backup_Free_Schedule(schedule);
			// To let you know which action (add or edit) causes the error
			if(ret == BK_SNAP_OPTION_INVALID) {
				ret = ADD_BK_SNAP_OPTION_INVALID;
			}
			else if(ret == BK_SNAP_CREATE_FAIL) {
				ret = ADD_BK_SNAP_CREATE_FAIL;
			}
			return ret;
		}
#ifdef	_DEBUG
		printf("Backup_Add_Schedule(%s) "
			"passes verify_src_vol_with_snapshot(%s)<br>\n",
			new->name, new->local.volume);
#endif
#endif
                tmp->next=calloc(1, ssize);
                tmp=(BACKUP_SCHEDULE *)tmp->next;
                memcpy(tmp, new, ssize);
                tmp->next=NULL;
        }
        backup_write_schedule(schedule);
        Backup_Free_Schedule(schedule);
	return BACKUP_SUCCESS;
}

int Backup_Ren_Schedule(BACKUP_SCHEDULE *new, BACKUP_SCHEDULE *old)
{
        BACKUP_SCHEDULE		*schedule, *tmp, *check;
        int                     ssize;
#ifdef	__SNAPSHOT__
	int			ret;
#endif

        if (!backup_fcomp_schedule(new, old))
	{
		if (new->status==old->status)
	                return BACKUP_SUCCESS;
	}
        schedule=Backup_Get_Schedule();
        ssize=sizeof(BACKUP_SCHEDULE);
        if (schedule==NULL)
                return ERROR_SCHEDULE_NOT_FOUND;
        else
        {
                tmp=schedule;
                while (tmp!=NULL)
                {
                        if (!backup_comp_schedule(tmp, old))
                        {
                                /* check if duplicate */
                                check=schedule;
                                while (check!=NULL)
                                {
                                        if (tmp!=check)
                                        {
                                                if (!backup_comp_schedule(check, new))
                                                {
                                                        Backup_Free_Schedule(schedule);
                                                        return ERROR_SCHEDULE_DUPLICATE;
                                                }
                                        }
                                        check=(BACKUP_SCHEDULE *)check->next;
                                }
#ifdef	__SNAPSHOT__
				if (new->rr_from_snapshot &&
					(ret = verify_src_vol_with_snapshot(new->local.volume)) != BACKUP_SUCCESS)
				{
					Backup_Free_Schedule(schedule);
					// To let you know which action (add or edit) causes the error
					if(ret == BK_SNAP_OPTION_INVALID) {
						ret = EDIT_BK_SNAP_OPTION_INVALID;
					}
					else if(ret == BK_SNAP_CREATE_FAIL) {
						ret = EDIT_BK_SNAP_CREATE_FAIL;
					}
					return ret;
				}
#endif
                                /* copy new to tmp */
                                new->next=tmp->next;
                                memcpy(tmp, new, sizeof(BACKUP_SCHEDULE));

                                backup_write_schedule(schedule);
                                Backup_Free_Schedule(schedule);
                                return BACKUP_SUCCESS;

                        }
                        tmp=(BACKUP_SCHEDULE *)tmp->next;
                }
        }
	return BACKUP_SUCCESS;
}

int Backup_Del_Schedule(BACKUP_SCHEDULE *del)
{
	BACKUP_SCHEDULE		*schedule, *tmp, *parent;
        int			ssize;

        schedule=Backup_Get_Schedule();
        ssize=sizeof(BACKUP_SCHEDULE);
        if (schedule==NULL)
                return ERROR_SCHEDULE_NOT_FOUND;
        else
        {
                tmp=schedule;
                parent=schedule;
                while (tmp!=NULL)
                {
                        if (!backup_comp_schedule(tmp, del))
                        {
                                if (tmp==schedule)
                                {
                                        schedule=(BACKUP_SCHEDULE *)schedule->next;
                                        free(tmp);
                                }
                                else
                                {
                                        parent->next=tmp->next;
                                        free(tmp);
                                }
                                backup_write_schedule(schedule);
                                Backup_Free_Schedule(schedule);
                                return BACKUP_SUCCESS;

                        }
                        parent=tmp;
                        tmp=(BACKUP_SCHEDULE *)tmp->next;
                }
        }
        Backup_Free_Schedule(schedule);
        return ERROR_SCHEDULE_NOT_FOUND;
}

int Backup_Now(BACKUP_SCHEDULE *schedule)
{
	int	ret=BACKUP_SUCCESS;
	char	buf[256];

	/* write log	*/
	sprintf(buf, "Remote backup schedule %s starting", schedule->name);
	write_log(buf, EVENTLOG_INFORMATION_TYPE);

	/* if none schedule, then return		*/
	if (schedule==NULL)
		return BACKUP_SUCCESS;

	/* use ftp, cifs, or nfs to copy files ?	*/
	if (schedule->usage==BK_VIA_FTP)
		ret=backup_via_ftp(schedule);
	else
	if (schedule->usage==BK_VIA_CIFS)
		ret=backup_via_cifs(schedule);
	else
	if (schedule->usage==BK_VIA_NFS)
		ret=backup_via_nfs(schedule);

	schedule->latest_time = time(NULL);

	/* backup finish	*/
	if (ret==BACKUP_SUCCESS)
	{
		Backup_Update_Status(schedule, BK_NONE_ACTION);
		schedule->status=BK_NONE_ACTION;

		/* write log	*/
		sprintf(buf, "Remote backup schedule %s finish successfully", schedule->name);
		write_log(buf, EVENTLOG_INFORMATION_TYPE);
	}
	else
	{
		Backup_Update_Status(schedule, ret);

		/* write log	*/
		switch (ret)
		{
			case BK_SERVER_NOT_FOUND:
				sprintf(buf, "Remote backup schedule %s fail, because remote server was not found.", schedule->name);
				break;
			case BK_SERVER_ERROR:
				sprintf(buf, "Remote backup schedule %s fail, because remote server error.", schedule->name);
				break;
			case BK_AUTH_FAIL:
				sprintf(buf, "Remote backup schedule %s fail, because authentication fail.", schedule->name);
				break;
			case BK_DIR_FAIL:
				sprintf(buf, "Remote backup schedule %s fail, because remote directory was not existed.", schedule->name);
				break;
			case BK_COPY_FAIL:
				sprintf(buf, "Remote backup schedule %s fail, because copy file fail.", schedule->name);
				break;
			case BK_COMPRESS_FAIL:
				sprintf(buf, "Remote backup schedule %s fail, because compress file fail.", schedule->name);
				break;
			case BK_SRC_DIR_FAIL:
				sprintf(buf, "Remote backup schedule %s fail, because local directory %s was not existed.", schedule->name, schedule->local.path);
				break;
			case BK_DEST_DIR_FAIL:
				sprintf(buf, "Remote backup schedule %s fail, because remote directory %s was not existed.", schedule->name, schedule->remote.path);
				break;
#ifdef	__SNAPSHOT__
			case BK_SNAP_OPTION_INVALID:
				sprintf(buf, "Remote backup schedule %s fail, "
					"because local network share %s is a snapshot image "
					"and cannot create a snapshot for another one.",
					schedule->name, schedule->local.volume);
				break;
			case BK_SNAP_CREATE_FAIL:
				sprintf(buf, "Remote backup schedule %s fail, "
					"because some error occurs when creating a snapshot for the "
					"local network share %s.",
					schedule->name, schedule->local.volume);
				break;
#endif
			case BK_NAS_SAME:
				sprintf(buf, "Remote backup schedule %s fail, because remote NAS IP setting is incorrect.", schedule->name);
				ret=BK_COPY_FAIL;	// to avoid to add new string
				Backup_Update_Status(schedule, ret);
				break;
			default:
				sprintf(buf, "Remote backup schedule %s fail, and error number is %d.", schedule->name, ret);
				break;
		}
		write_log(buf, EVENTLOG_ERROR_TYPE);
	}

	return ret;
}

