#!/bin/sh
# chkconfig: - 91 35
# description: This package enables Linux to talk to Macintosh computers via the \
#              AppleTalk networking protocol. It includes a daemon to allow Linux \
#              to act as a file server over EtherTalk or IP for Mac's.
# processname: atalkd
# pidfile: /var/run/atalkd.pid
# config: /usr/local/etc/metatalk/*
# Created by JohnsonCheng on 2005/09/23

ATALK_PATH=/usr/local/etc/netatalk

# Source function library.
#. /etc/init.d/functions

# Source networking configuration.
#. /etc/sysconfig/network

# Source Appletalk configuration
. ${ATALK_PATH}/netatalk.conf

# Check that networking is up.
#[ ${NETWORKING} = "no" ] && exit 0

start() {
	if [ `/sbin/getcfg Appletalk Enable -u -d TRUE` = FALSE ]
	then
	    echo "Starting AppleTalk Services: disabled."
	    exit 0
	fi

	echo -n "Starting AppleTalk services: "
	if [ ${ATALK_BGROUND} = yes ] ; then
	    echo -n "(backgrounded)"
	    {
		/sbin/daemon_mgr atalkd start "/usr/sbin/atalkd -f ${ATALK_PATH}/atalkd.conf &"
#		nbprgstr -p 4 "${ATALK_NAME}:Workstation"
#		nbprgstr -p 4 "${ATALK_NAME}:netatalk"
		if [ ${PAPD_RUN} = yes ] ; then
		    /sbin/daemon_mgr papd start "/usr/sbin/papd -f ${ATALK_PATH}/papd.conf"
		fi
		if [ ${AFPD_RUN} = yes ] ; then
		    /sbin/daemon_mgr afpd start "/usr/sbin/afpd -c ${AFPD_MAX_CLIENTS} -n \"${ATALK_NAME}\" -f ${ATALK_PATH}/AppleVolumes.default -s ${ATALK_PATH}/AppleVolumes.system"
		fi
	    } >/dev/null &
	else
	    /sbin/daemon_mgr atalkd start "/usr/sbin/atalkd -f ${ATALK_PATH}/atalkd.conf &"
#	    nbprgstr -p 4 "${ATALK_NAME}:Workstation"
#	    nbprgstr -p 4 "${ATALK_NAME}:netatalk"
	    if [ ${PAPD_RUN} = yes ] ; then
		/sbin/daemon_mgr papd start "/usr/sbin/papd -f ${ATALK_PATH}/papd.conf"
	    fi
	    if [ ${AFPD_RUN} = yes ] ; then
		/sbin/daemon_mgr afpd start "/usr/sbin/afpd -c ${AFPD_MAX_CLIENTS} -n \"${ATALK_NAME}\" -f ${ATALK_PATH}/AppleVolumes.default -s ${ATALK_PATH}/AppleVolumes.system"
	    fi
	fi
	echo
	touch /var/lock/subsys/atalk
}
  
stop() {
	echo -n "Shutting down AppleTalk services: "
	/sbin/daemon_mgr afpd stop /usr/sbin/afpd
	/sbin/daemon_mgr papd stop /usr/sbin/papd
#	nbpunrgstr "${ATALK_NAME}:Workstation@*"
#	nbpunrgstr "${ATALK_NAME}:netatalk@*"
	/sbin/daemon_mgr atalkd stop /usr/sbin/atalkd
	# Attempt to zap the module, so that we can restart the
	# Appletalk daemons cleanly
	if [ -e /proc/modules ] && [ -x /sbin/modprobe ] ; then
	    modprobe -r appletalk
	fi
	rm -f /var/lock/subsys/atalk
	echo ""
}


restart() {
	stop
	start
}

case "$1" in
    start)
	start	
	;;
    stop)
	stop
	;;
    restart|reload)
	restart
	;;
    condrestart)
    [ -f /var/lock/subsys/atalk ] && restart || : 
     ;;
    status)
	status atalkd
	;;
    *)
	echo $"Usage: $0 {start|stop|restart|status|condrestart}"
	exit 1
esac

exit 0
