#!/bin/sh
# Script file For ImRd
# Created by Paul Chen

test -f /sbin/ImRd || exit 0

case "$1" in
	start)
		echo -n "Starting ImRd service:" 
		/sbin/daemon_mgr ImRd start "/sbin/ImRd -d"
		touch /var/lock/ImRd
		echo "."
		;;
	stop)
		echo -n "Shutting down ImRd service:"
		/bin/kill -TERM `pidof ImRd`
		/sbin/daemon_mgr ImRd stop /sbin/ImRd
		rm -f /var/lock/ImRd
		echo -n " ImRd"
		echo "."
		;;
	restart)
		$0 stop
		$0 start
		;;
	notify)
	# notify daemon that a new job is the queue
		/bin/kill -USR1 `pidof ImRd`
		;;
	*)
		echo "Usage: /etc/init.d/$0 {start|stop|restart}"
		exit 1
esac

exit 0
