#!/bin/sh
# $1 = Schedule0...ScheduleN
#
#

stop_network()
{
	/etc/init.d/smb.sh stop
	/etc/init.d/atalk.sh stop
	/etc/init.d/ftp.sh stop
}

start_network()
{
#	do nothing, due to we have start service in Config Library
	kenttest=0
#	/etc/init.d/smb start
#	/etc/init.d/atalk.init start
#	/etc/init.d/nfs start
#	/etc/init.d/mars-nwe start
#	/etc/init.d/ftp.sh start
}

write_err_log() {
	case "x$1" in
	"x5")
		msg="Remote backup schedule $2 fail. (Error starting client-server protocol, maybe the destination path is nonexistent.)"
		;;
	"x10")
		msg="Remote backup schedule $2 fail. (Error in socket IO, maybe the network connection is disconnect.)"
		;;
	"x11")
		msg="Remote backup schedule $2 fail. (Error in file IO)"
		;;
	"x12")
		msg="Remote backup schedule $2 fail. (Error in rsync protocol data stream, maybe the capacity of destination is full.)"
		;;
	"x23")
		msg="Remote backup schedule $2 fail. (Some files could not be transfered, maybe the source path is incorrect.)"
		;;
	*)
		msg="Remote backup schedule $2 fail. (Other error with error code $1)"
	esac

	/sbin/write_log "$msg" 1
}


report_error()
{
	if [ "${LOG_FILE_NAME}+log" = "log" ]; then
		echo "Please provide log file name"
	else # no log file name specified
		qnap_rsync_log="${LOG_FILE_NAME}"

		while read LINE
		do
			if [ "`/bin/echo $LINE | /usr/bin/cut -c1-1`" = "[" ]; then
				/sbin/write_log "Fails to copy $LINE" 1	
				[ "$DEBUG" = "yes" ] && echo "Error : $LINE"
			else # the final result
				RESULT_STRING=$LINE
			fi
		done < $qnap_rsync_log
	fi

	case "x${RR_result}" in
	"x0")
		echo "RR [${RR_name}] succeed..." 
		RR_Num=`/sbin/getcfg "global" "Schedule Number" -f "${RR_CONF}" -d "0"`
		i=0
		while [ ${i} -lt ${RR_Num} ]
		do
			RR_name2=`/sbin/getcfg "Schedule${i}" Name -f "${RR_CONF}" -d ""`
			if [ "x${RR_name}" = "x${RR_name2}" ]; then
				/sbin/setcfg "Schedule${i}" Status 2 -f "${RR_CONF}"
				RR_finished_time_s=`/bin/date +%s`
				/sbin/setcfg "Schedule${i}" "Finished Time" ${RR_finished_time_s} -f "${RR_CONF}"
				break
			fi
			i=`/usr/bin/expr ${i} + 1`
		done
		/sbin/write_log "Remote backup schedule ${RR_name} finished successfully." 4
		;;
# Remove file level backup Paul chen
#	"x10"|"x13")
#		echo "rsync failed, trying ${RR_name} with old RR method..."
#		/sbin/write_log "Remote NAS doesn't support block level replication, trying file level replication." 4
#		#/sbin/backup2nas -j "${RR_name}" & Ricky remarked 2005/3/16 this script has run at backupground!
#		/sbin/backup2nas -j "${RR_name}"
#		RR_Num=`/sbin/getcfg "global" "Schedule Number" -f "${RR_CONF}" -d "0"`
#               i=0
#                while [ ${i} -lt ${RR_Num} ]
#                do
#                        RR_name2=`/sbin/getcfg "Schedule${i}" Name -f "${RR_CONF}" -d ""`
#                        if [ "x${RR_name}" = "x${RR_name2}" ]; then
#                                /sbin/setcfg "Schedule${i}" Status 2 -f "${RR_CONF}"
#                                RR_finished_time_s=`/bin/date +%s`
#                                /sbin/setcfg "Schedule${i}" "Finished Time" ${RR_finished_time_s} -f "${RR_CONF}"
#                                break
#                        fi
#                        i=`/usr/bin/expr ${i} + 1`
#                done
#		;;
# Paul Chen ends
	*)
		echo "RR [${RR_name}] failed... Error Code=${RR_result}"
		RR_Num=`/sbin/getcfg "global" "Schedule Number" -f "${RR_CONF}" -d "0"`
		i=0
		while [ ${i} -lt ${RR_Num} ]
		do
			RR_name2=`/sbin/getcfg "Schedule${i}" Name -f "${RR_CONF}" -d ""`
			if [ "x${RR_name}" = "x${RR_name2}" ]; then
				/sbin/setcfg "Schedule${i}" Status 7 -f "${RR_CONF}"
				RR_finished_time_s=`/bin/date +%s`
				/sbin/setcfg "Schedule${i}" "Finished Time" ${RR_finished_time_s} -f "${RR_CONF}"
				break
			fi
			i=`/usr/bin/expr ${i} + 1`
		done
		write_err_log $RR_result "$RR_name"
	esac
}
		
DEBUG=no
RR_sche=${1}
RR_CONF="/etc/config/rsync_schedule.conf"
SMB_CONF="/etc/smb.conf"
[ "x${RR_sche}" = "x" ] && exit -1
RR_name=`/sbin/getcfg "${RR_sche}" Name -f "${RR_CONF}" -d ""`
[ "x${RR_name}" = "x" ] && exit -1
Remote_IP=`/sbin/getcfg "${RR_sche}" "Remote IP" -f ${RR_CONF} -d "0.0.0.0"`
[ "x${Remote_IP}" = "x0.0.0.0" ] && exit -1

Local_vol=`/sbin/getcfg "${RR_sche}" "Local Volume" -f ${RR_CONF} -d ""`
Local_path=`/sbin/getcfg "${RR_sche}" "Local Path" -f ${RR_CONF} -d ""`
SMB_path=`/sbin/getcfg "${Local_vol}" "path" -f ${SMB_CONF} -d ""`
if [ "x${Local_path}" = "x/" ]
then
	RR_local_path="${SMB_path}"
else
	RR_local_path="${SMB_path}/${Local_path}"
fi

Remote_vol=`/sbin/getcfg "${RR_sche}" "Remote Volume" -f ${RR_CONF} -d ""`
Remote_path=`/sbin/getcfg "${RR_sche}" "Remote Path" -f ${RR_CONF} -d ""`
if [ "x${Remote_path}" = "x/" ]
then
	RR_remote_path="${Remote_vol}"
else
	RR_remote_path="${Remote_vol}${Remote_path}"
fi

RR_opt_compress=`/sbin/getcfg "${RR_sche}" "Compressed" -f ${RR_CONF} -d "FALSE" -u`
[ "x${RR_opt_compress}" = "xTRUE" ] && RR_options=${RR_options}"--compress "
RR_opt_sync=`/sbin/getcfg "${RR_sche}" "Delete Extra" -f "${RR_CONF}" -d "FALSE" -u`
[ "x${RR_opt_sync}" = "xTRUE" ] && RR_options=${RR_options}"--delete "
RR_opt_inc=`/sbin/getcfg ${RR_sche} "Incremental" -f ${RR_CONF} -d "FALSE" -u`
[ "x${RR_opt_inc}" = "xFALSE" ] && RR_options=${RR_options}"--whole-file "
RR_opt_stopnet=`/sbin/getcfg ${RR_sche} "Stop Net" -f ${RR_CONF} -d "FALSE" -u`

[ "x${RR_opt_stopnet}" = "xTRUE" ] && stop_network

# set status to "Replicating"
/sbin/write_log "Remote backup schedule ${RR_name} starting." 4
/sbin/setcfg "${RR_sche}" Status 9 -f ${RR_CONF}

LOG_FILE_NAME="/tmp/${RR_name}_`/bin/date +'%Y%m%d%H%M'`.log"
touch "${LOG_FILE_NAME}"
if [ "$DEBUG" = "yes" ]; then
	echo "Debuging mode"
#	/usr/bin/rsync -a ${RR_options} --timeout=0 --port=873 --qnap_log_file="${LOG_FILE_NAME}" "${RR_local_path}/" ${Remote_IP}::"${RR_remote_path}" -v -v -v
	/usr/bin/rsync -a ${RR_options} --timeout=0 --port=873 "${RR_local_path}/" ${Remote_IP}::"${RR_remote_path}" -v -v -v
else
	echo "Normal mode"
#	/usr/bin/rsync -a ${RR_options} --timeout=0 --port=873 --qnap_log_file="${LOG_FILE_NAME}" "${RR_local_path}/" ${Remote_IP}::"${RR_remote_path}"
	/usr/bin/rsync -a ${RR_options} --timeout=0 --port=873 "${RR_local_path}/" ${Remote_IP}::"${RR_remote_path}"
fi

# report errors to log
RR_result=$?
[ "x${RR_opt_stopnet}" = "xTRUE" ] && start_network
[ "$DEBUG" = "yes" ] && echo "log file = ${LOG_FILE_NAME}"
report_error
[ -f "${LOG_FILE_NAME}" -a "$DEBUG" = "no" ] && /bin/rm "${LOG_FILE_NAME}"

