#!/bin/sh

Set_Standby(){
        standby_enable=`/sbin/getcfg Misc "Disk StandBy Timeout Enable" -d FALSE`
        if [ "x${standby_enable}" = "xTRUE" ]
        then
                timer=`/sbin/getcfg Misc "Disk StandBy Timeout"`
                /sbin/hdsuspend -n 1 -t ${timer}
        fi
}

Set_CheckHD(){
        check_enable=`/sbin/getcfg Misc "Disk Free Size Alert Enable"`
        if [ "x${check_enable}" = "xTRUE" ]
        then
                maximum_size=`/sbin/getcfg Misc "Disk Free Size Alert"`
                /sbin/daemon_mgr check_hds_size start "/sbin/check_hds_size -s 3600 -m /share/HDA_DATA -x ${maximum_size} -d"
	else
		/sbin/daemon_mgr check_hds_size start "/sbin/check_hds_size -s 3600 -m /share/HDA_DATA -d"
        fi
}

case "$1" in
  start)
	echo "Starting Disk initialized:"
	/bin/rm /etc/config/usb_share_mapping
	/bin/touch /etc/config/usb_share_mapping
	# Clear QRAID1 status to avoid system shutdown abnormal.
	/sbin/setcfg QRAID1 "device name" ""
	/sbin/storage_boot_init 2
	/sbin/daemon_mgr hotswap start "/sbin/hotswap -d"
	/bin/touch /tmp/ledvalue
	/sbin/daemon_mgr hd_util start "/sbin/hd_util -d"
	;;
  stop)
	/sbin/daemon_mgr hotswap stop "/sbin/hotswap -d"
	/sbin/daemon_mgr hd_util stop "/sbin/hd_util -d"
	/bin/umount /dev/sda1
	/bin/umount /dev/sda3
	/bin/umount /dev/md9
	/sbin/mdadm --stop /dev/md9
	/bin/umount /dev/md0
	/sbin/mdadm --stop /dev/md0
	;;
  restart)
        echo "Restarting Disk services:"
        $0 stop
        $0 start
        echo "done."
        ;;
  *)
        echo "Usage: init_disk {start|stop|restart}"
        exit 1
esac
