#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#define STRIP_HTML	0x01
#define STRIP_SHELL	0x02
#define STRIP_JS	0x04
#define STRIP_C		0x08

#define TMP_FILE	"/tmp/mystrip"

void show_help()
{
	printf("[usage]: mystrip [folder]\n");
	printf("clear all space on the front of ecah line with text file\n\n");
}

void mystrip(char* fullpath, int type)
{
	char	line[4096], *start, *end;
	FILE	*fptr1, *fptr2;
	char	pattern1[]={"DEBUG"}, pattern2[]={"dbgtext"};
	char	pattern[][20]={ {"DEBUG"}, {"dbgtext"}, {"log_debug"}, {"snmp_log"}, {""} };
	int	delete=0;
	int	count;

	printf("strip %s", fullpath);
	if ((fptr1=fopen(fullpath, "rb"))==NULL)
		return;
	fptr2=fopen(TMP_FILE, "wb");
	while (!feof(fptr1))
	{
get_next_line:
		if (fgets(line, 4096, fptr1)!=NULL)
		{
			if (type | STRIP_HTML)
			{
				if (strstr(line, "Microsoft FrontPage"))
					continue;
				if (strstr(line, "FrontPage.Editor.Document"))
					continue;
			}
			start=line;
			while (*start==0x20 || *start=='\t')
				start++;
			end=line+strlen(line);
			end--;
			while (*end==0x20 || *end=='\t' || *end==0x0d || *end==0x0a)
				end--;
			*(end+1)=0x0a;
			*(end+2)=0x0;

			if (type & STRIP_C)
			{
				if (delete==1)
				{
					if (strchr(start, ';')!=NULL)
						delete=0;
					continue;
				}
				count=0;
				while (pattern[count][0]!=0x0)
				{
					if (strlen(start)>strlen(pattern[count]))
					{
						if (!strncmp(start, pattern[count], strlen(pattern[count])))
						{
							if (strchr(start, ';')!=NULL)
								delete=0;
							else
								delete=1;
							if (start[strlen(start)-2]=='\\')
								fputs("((void)0);\\\n", fptr2);
							else
								fputs("((void)0);\n", fptr2);
							goto get_next_line;
						}
					}
					count++;
				}
			}
			if (type & STRIP_HTML)
			{	/* to solve web filemanager bug, add one space in header of each line   */
				if (*start=='$' || *start=='#')
					fputc(' ', fptr2);
			}
			else
			if (type & STRIP_JS)
			{
				if (strlen(start)>2)
				{
					if (*start=='/' && *(start+1)=='/')
						continue;
				}
			}
			else
			if (type & STRIP_SHELL)
			{
				if (strlen(start)>1)
				{
					if (*start==';' || *start=='#')
						continue;
				}
			}
			if (type & STRIP_C)
				fputs(line, fptr2);
			else
				fputs(start, fptr2);
		}
	}
	fclose(fptr1);
	fclose(fptr2);
	sprintf(line, "/bin/mv -f %s %s 2>/dev/null 1>/dev/null", TMP_FILE, fullpath);
	system(line);
	printf("	[ok]\n");
}

int strip_main(char *path)
{
        struct dirent   *dir;
        DIR             *html;
        char            fullpath[2048];
        struct stat     statbuf;
	char		*ext;

        if ((html=opendir(path))==NULL)
        {
                printf("the folder %s is not exist !!\n");
                return 0;
        }
        while (dir=readdir(html))
        {
                sprintf(fullpath, "%s/%s", path, dir->d_name);
                if (lstat(fullpath, &statbuf)<0)
                {
                        printf("%s state error !!\n", fullpath);
                        return 0;
                }
                if (S_ISDIR(statbuf.st_mode)==0)
                {       /* not dir      */
			ext=strchr(dir->d_name, '.');
			if (ext!=NULL)
			{
				ext=ext+1;
				if (!strcasecmp(ext, "html") || !strcasecmp(ext, "htm"))
		                        mystrip(fullpath, STRIP_HTML);
				else
				if (!strcasecmp(ext, "js"))
					mystrip(fullpath, STRIP_JS);
				else
				if (!strcasecmp(ext, "sh"))
					mystrip(fullpath, STRIP_SHELL);
				else
				if (!strcasecmp(ext, "c"))
					mystrip(fullpath, STRIP_C);
			}
                }
                else
                {       /* is dir       */
			if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, ".."))
				continue;
			strip_main(fullpath);
                }
        }
}

int main(int argc, char *argv[])
{
	if (argc<2)
	{
		show_help();
		return 0;
	}
	strip_main(argv[1]);
	return 0;
}
