#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#define BOOL			unsigned char
#define FALSE			0
#define TRUE			!FALSE

#define MAX_LANG_NUMBER		20
#define LANG_ID_LENGTH		4
#define LANG_NAME_LENGTH	32
#define	FIELD_NAME_MAX_LENGTH	256
#define FILE_NAME_LENGTH	256
#define BUF_SIZE		512

#define SUCCESS			0
#define ERROR_FAIL		-1
#define ERROR_OPEN_FILE		-2
#define ERROR_WRITE_FILE	-3
#define ERROR_REPLACE_FAIL	-4
#define ERROR_NOT_FOUND		-5
#define ERROR_BUFFER_TOO_SMALL	-6

#define LANG_CONF_FILE	"lang.conf"

char Version[FIELD_NAME_MAX_LENGTH];
char BuildNo[FIELD_NAME_MAX_LENGTH];


char Lang_ID[MAX_LANG_NUMBER][LANG_ID_LENGTH] = {"ENG", "TCH", "SCH", "JPN", "KOR", "FRE", "GER", "SPA", "ITA", "POR",
						 "DUT", "NOR", "FIN", "SWE", "DAN", "RUS", "0" };
//Shone added JS_Lang_Name 2005,11,18 for TS-101 first page new UI loading method
char JS_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {   "IEI_NAS_FIRSTPAGE_LANG01",
							   "IEI_NAS_FIRSTPAGE_LANG02",	
							   "IEI_NAS_FIRSTPAGE_LANG03",	
							   "IEI_NAS_FIRSTPAGE_LANG04",	
							   "IEI_NAS_FIRSTPAGE_LANG05",	
							   "IEI_NAS_FIRSTPAGE_LANG06",	
							   "IEI_NAS_FIRSTPAGE_LANG07",	
							   "IEI_NAS_FIRSTPAGE_LANG08",	
							   "IEI_NAS_FIRSTPAGE_LANG09",	
							   "IEI_NAS_FIRSTPAGE_LANG10",	
							   "IEI_NAS_FIRSTPAGE_LANG11",
							   "IEI_NAS_FIRSTPAGE_LANG12", 
							   "IEI_NAS_FIRSTPAGE_LANG13", 
							   "IEI_NAS_FIRSTPAGE_LANG14", 
							   "IEI_NAS_FIRSTPAGE_LANG15", 
							   "IEI_NAS_FIRSTPAGE_LANG16",  			
							};

char Eng_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "English",
							   "Traditional Chinese",
							   "Simplified Chinese",
							   "Japanese",
							   "Korean",
							   "French",
							   "German",
							   "Spanish",
							   "Italian",
							   "Portuguese",
							   "Dutch",
							   "Norwegian",
							   "Finnish",
							   "Swedish",
							   "Danish",
							   "Russian"			};

char Tch_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "^",
							   "c餤",
							   "²餤",
							   "",
							   "",
							   "k",
							   "w",
							   "Z",
							   "qjQ",
							   "",
							   "",
							   "¤",
							   "",
							   "",
							   "",
							   "X"   			};
							   
char Sch_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Ӣ",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "Ų",
							   "",
							   "",
							   "",
							   ""   			};
							   
char Jpn_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "p",
							   "-ɑ̎",
							   "-ȑ̎",
							   "{",
							   "؍",
							   "tX",
							   "hCc",
							   "XyC",
							   "C^A",
							   "|gK",
							   "I_",		//
							   "mEF[",
							   "tBh",
							   "XEF[f",
							   "f}[N",
							   "VA"			};

char Kor_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "",
							   "ü߱",
							   "ü߱",
							   "Ϻ",
							   "ѱ",
							   "Ҿ",
							   "Ͼ",
							   "ξ",
							   "Żƾ",
							   "",
							   "״",
							   "븣̾",
							   "ɶ",
							   "",
							   "ũ",
							   "þƾ"			};
char Fre_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Anglais",
							   "Chinois traditionnel",
							   "Chinois simplifi",
							   "Japonais",
							   "Coren",
							   "Franais",
							   "Allemand",
							   "Espagnol",
							   "Italien",
							   "Portugais",
							   "Hollandais",
							   "Norvgien",
							   "Finnois",
							   "Sudois",
							   "Danois",
							   "Russe"			};

char Ger_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Englisch",
							   "Chinesisch (Langzeichen)",
							   "Chinesisch (Kurzzeichen)",
							   "Japanisch",
							   "Koreanisch",
							   "Franzsisch",
							   "Deutsch",
							   "Spanisch",
							   "Italienisch",
							   "Portugiesisch",
							   "Hollndisch",
							   "Norwegisch",
							   "Finnisch",
							   "Schwedisch",
							   "Dnisch",
							   "Russisch"			};
							   
							
char Ita_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Inglese",
							   "Cinese tradizionale",
							   "Cinese semplificato",
							   "Giapponese",
							   "Coreano",
							   "Francese",
							   "Tedesco",
							   "Spagnolo",
							   "Italiano",
							   "Portoghese",						
							   "Olandese",
							   "Norvegese",
							   "Finlandese",
							   "Svedese",
							   "Danese",
							   "Russo"			};

char Spa_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Ingls",
							   "Chino tradicional",
							   "Chino simplificado",
							   "Japons",
							   "Coreano",
							   "Francs",
							   "Alemn",
							   "Espaol",
							   "Italiano",
							   "Portugus",
							   "Holands",
							   "Noruego",
							   "Fins",
							   "Sueco",
							   "Dans",
							   "Ruso"			};
							   						

char Por_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Ingls",
							   "Chins tradicional",
							   "Chins simplificado",
							   "Japons",
							   "Coreano",
							   "Francs",
							   "Alemo",
							   "Espanhol",
							   "Italiano",
							   "Portugus",
							   "Holands",
							   "Noruegus",
							   "Finlands",
							   "Sueco",
							   "Dinamarqus",
							   "Russo"			};
													

char Dut_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Engels",
							   "Traditioneel Chinees",
							   "Vereenvoudigd Chinees",
							   "Japans",
							   "Koreaans",
							   "Frans",
							   "Duits",
							   "Spaans",
							   "Italiaans",
							   "Portugees",
							   "Nederlands",
							   "Noors",
							   "Fins",
							   "Zweeds",
							   "Deens",
							   "Russisch"			};

char Nor_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Engelsk",
							   "Kinesisk (tradisjonell)",
							   "Kinesisk (forenklet)",
							   "Japansk",
							   "Koreansk",
							   "Fransk",
							   "Tysk",
							   "Spansk",
							   "Italiensk",
							   "Portugisisk",
							   "Nederlandsk",
							   "Norsk",
							   "Finsk",
							   "Svensk",
							   "Dansk",
							   "Russisk"			};

char Fin_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Englanti",
							   "Perinteinen kiina",
							   "Yksinkertaistettu kiina",
							   "Japani",
							   "Korea",
							   "Ranska",
							   "Saksa",
							   "Espanja",
							   "Italia",
							   "Portugali",
							   "Hollanti",
							   "Norja",
							   "Suomi",
							   "Ruotsi",
							   "Tanska",
							   "Venj"			};
							   						
char Swe_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Englanti",
							   "Perinteinen kiina",
							   "Yksinkertaistettu kiina",
							   "Japani",
							   "Korea",
							   "Ranska",
							   "Saksa",
							   "Espanja",
							   "Italia",
							   "Portugali",
							   "Hollndska",
							   "Norska",
							   "Finska",
							   "Svenska",
							   "Danska",
							   "Ryska"			};

char Dan_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "Engelsk",
							   "Traditionel kinesisk",
							   "Simpelt kinesisk",
							   "Japansk",
							   "Koreansk",
							   "Fransk",
							   "Tysk",
							   "Spansk",
							   "Italiensk",
							   "Portugesisk",
							   "Hollandsk",		
							   "Norsk",
							   "Finsk",
							   "Svensk",
							   "Dansk",
							   "Russisk"			};

char Rus_Lang_Name[MAX_LANG_NUMBER][LANG_NAME_LENGTH] = {  "",
							   " ",
							   " ",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   ""			};

int to_upper_string(char *str)
{
	int i;
	
	for(i=0; i<sizeof(str); i++) 
		str[i] = toupper(str[i]);
	
	return SUCCESS;
}

int to_lower_string(char *str)
{
	int i;
	
	for(i=0; i<sizeof(str); i++) 
		str[i] = tolower(str[i]);
	
	return SUCCESS;
}


// Check if a string is ended with new line...
// Return:	1 - true
//		0 - false
int string_ended_with_EOL(char *str)
{
	if (str[strlen(str) - 1] == '\n') return 1;
	return 0;
}

// Kill the new line character on the end of the string...
// Return:	1 - new line killed
//		0 - no new line on the tail
int strip_EOL(char *str)
{
	if (str[strlen(str) - 1] == '\n') {
		str[strlen(str) - 1] = '\0';
		if (str[strlen(str) - 1] == '\r')
			str[strlen(str) - 1] = '\0';
		return 1;
	}
	return 0;
}

// Read from a file stream and skip until a new line character was found...
// Return: 	None
void skip_to_EOL(FILE *fp)
{
	char buf[BUF_SIZE];

	while (fgets(buf, sizeof(buf), fp) != NULL) {
		if (string_ended_with_EOL(buf))
			return;
	}
}

// Skip the white space (SPACE & TAB) characters from the start of a string
// Return the string started from the first non-white-space character
char *skip_white_space(char *str)
{
	char *p = str;
	while (*p == ' ' || *p == '\t') p++;
	return p;
}

// Strip off the white space characters appened on the end of a string.
// Return the original string ended with non-white-space characters
char *stripe_white_space_tail(char *str)
{
	if (strlen(str) > 0) {
		char *p = str + strlen(str) - 1;
		while (*p == ' ' || *p == '\t') p--;
		*(p+1) = '\0';
	}
	return str;
}

// Concat two string and produce a new string...
// Return:
//		pointer to the newly allocated concatened string
// 		NULL - if memory allocation fail
char* combine_string(char *str1, char *str2)
{
	int size = strlen(str1) + strlen(str2) + 1;
	char *p = (char *) malloc(size);
	if (NULL != p) {
		strcpy(p, str1);
		strcat(p, str2);
	}
	return p;
}

// Search a string for the offset of a specified character...
// Return:	non-negative - offset in the string that contains the specified character
//		-1 - the specified charater was not found in the string
int find_char_in_string(char *q, char delimiter)
{
	int i = 0;
	while (q[i] != '\0') {
		if ( (delimiter == ' ') || (delimiter == '\t') ) {
			if ((q[i] == ' ') || (q[i] == '\t')) {
				if ((q[i+1]== ' ') || (q[i+1] == '\t') ) {
					while ( (q[i+1]== ' ') || (q[i+1] == '\t')) 
						i++;
				}
				return i;
			}
			else
				i++;
		}
		else {
			if (q[i] == delimiter) return i;
			i++;
		 }
	}
	return -1;	// not found...
}

//
char *get_string_until_ch(char *str, char ch, char *buf, int buf_size)
{
	int i;

	str = skip_white_space(str);
	if(ch == ']') i = (int)(strrchr(str,']') - str) ;
	else i = find_char_in_string(str, ch);
	if (i < 0) // no CH was found in this line
		return NULL;

	if (i >= buf_size) i = buf_size - 1;
	strncpy(buf, str, i);
	buf[i] = '\0';

	stripe_white_space_tail(buf);

	return buf;
}

// Check if a string is started with comment characters...
// Return:	1 - true
//		0 - false
int is_commented_string(char *str)
{
	char *q = skip_white_space(str);
	if (*q == '#' || *q == ';') return 1;
	return 0;
}

char *get_one_line_of_string(FILE *fp)
{
	static char *extra_buf = NULL;
	static char buf[BUF_SIZE];

	if (extra_buf != NULL) {	// free previously allocated buffer first...
		free(extra_buf);
		extra_buf = NULL;
	}

	if (fgets(buf, sizeof(buf), fp) == NULL) return NULL;		// EOF
	if (strip_EOL(buf)) 		// got the whole line
		return buf;

	// original buffer not large enough, try to allocate more...
	if ((extra_buf = strdup(buf)) == NULL) {	// memory allocation error...
		skip_to_EOL(fp);		// skip the remains of this line.
		return buf;			// should we skip to EOL??
	}

	while (fgets(buf, sizeof(buf), fp) != NULL) {
		char *p = combine_string(extra_buf, buf);
		if (NULL == p) {		// memory allocation error...
			skip_to_EOL(fp);		// skip the remains of this line.
			return extra_buf;		// should we skip to EOL??
		}
		free(extra_buf);
		extra_buf = p;

		if (strip_EOL(extra_buf)) 	// found EOL...
			break;
	}

	return extra_buf;
}

int get_field(char *conf_file, char *field, char *result, int buf_size)
{
	FILE *fp = NULL;
	char *p, *q;
	int i = 0;

	if((fp = fopen(conf_file, "r")) == NULL)
		return	ERROR_OPEN_FILE;
	
	while ((p = get_one_line_of_string(fp)) != NULL) {
		q = skip_white_space(p);
		if (is_commented_string(q)) {
			continue;
		}
		else {	// get field data...
			char buf[FIELD_NAME_MAX_LENGTH];
			
			memset(buf, 0, sizeof(buf));
			if (get_string_until_ch(q, '=', buf, sizeof(buf)) == NULL)
				continue;
			
			if (strcasecmp(field, buf) == 0) {
				int j;
				q = q + find_char_in_string(q, '=') + 1;	// skip to the next character after '='
				q = skip_white_space(q);
				if (NULL != result) {
					result[0]='\0'; //empty string
					j = strlen(q);
					if (j+1 > buf_size) {
						j = buf_size - 1;
						strncpy(result, q, j);
						result[j] = '\0';
						stripe_white_space_tail(result);
						fclose(fp);
						return ERROR_BUFFER_TOO_SMALL;
					}
					else {
						strncpy(result, q, j);
						result[j] = '\0';
						stripe_white_space_tail(result);
						fclose(fp);
						return SUCCESS;
					}
				}
				else { 
					fclose(fp);
					return (strlen(q)+1); //return required buffer length
				}
			}
		}
	}
	fclose(fp);
	return ERROR_NOT_FOUND;
}

BOOL is_in_supported_lang_list(char *result, char (*supported_lang_list)[LANG_ID_LENGTH], int list_cnt)
{
	int i;
	
	for(i=0; i<list_cnt; i++) { // check whether the language is existed
		if(!strcasecmp(result, supported_lang_list[i])) 
			return TRUE;
	}
	return FALSE;
}
int get_lang_conf(char *config_filename, char (*supported_lang_list)[LANG_ID_LENGTH], char *output_path,
						char *ulinux_filename, int *list_cnt)
{
	int i, j, k, ret;
	char lang_field_name[7];
	char number[3];
	char result[FIELD_NAME_MAX_LENGTH];

	// get default field data
	if((ret = get_field(config_filename, "default", result, FIELD_NAME_MAX_LENGTH)) != SUCCESS)
		return ret;
		
	to_upper_string(result);
	strcpy(supported_lang_list[0], result);

	*list_cnt = 1;
	for(i=1; i<MAX_LANG_NUMBER; i++) {
		strcpy(lang_field_name, "lang");
		sprintf(number, "%d", i);	// number = itoa(i);
		strcat(lang_field_name, number);
		if((get_field(config_filename, lang_field_name, result, FIELD_NAME_MAX_LENGTH)) != SUCCESS) {
			continue;
		}
		else {
			to_upper_string(result);
//printf("Get lang%d = %s\n", i, result);
			for(j=0; j<MAX_LANG_NUMBER; j++) { // check whether the language is supported and not existed
/*
				if((!strcasecmp(result, Lang_ID[j])) && 
				   (!is_in_supported_lang_list(result, supported_lang_list, (*list_cnt)))) {
*/
				if((!strcasecmp(result, Lang_ID[j])) && 
				   (!is_in_supported_lang_list(result, supported_lang_list, (*list_cnt)) ||
				   (!strcasecmp(result, supported_lang_list[0])) )) {
					strncpy(supported_lang_list[(*list_cnt)++], result, LANG_ID_LENGTH);
//printf("ADD %s to SLL[%d]\n", result, (*list_cnt-1));
					break;
				}
			}
		}
	}
#if 0
	// get output path field data
	if((ret = get_field(config_filename, "path", result, FIELD_NAME_MAX_LENGTH)) != SUCCESS)
		return ret;
	if(strlen(result) == 0) // empty path field
		getcwd(output_path, FIELD_NAME_MAX_LENGTH);
	else
		realpath(result, output_path);
	// get the path of uLinux.conf	
	if((ret = get_field(config_filename, "uLinux", result, FIELD_NAME_MAX_LENGTH)) != SUCCESS)
		return ret;
	if(strlen(result) == 0) // empty path field
		getcwd(ulinux_path, FIELD_NAME_MAX_LENGTH);
	else
		realpath(result, ulinux_path);
#endif	
	return SUCCESS;
	
}

int replace_index_html(char (*supported_lang_list)[LANG_ID_LENGTH],
				 int list_cnt, FILE *fpin, FILE *fpout)
{
	int i;
	char *p = NULL, buf[BUF_SIZE];
	char supported_file_name_list[MAX_LANG_NUMBER][LANG_NAME_LENGTH];

	
	if((fpin == NULL) || (fpout == NULL)) 
		return ERROR_FAIL;

	for(i=0; i<list_cnt; i++) {
		strcpy(supported_file_name_list[i], "index");
		strcpy(buf, supported_lang_list[i]);
		to_lower_string(buf);
		strcat(supported_file_name_list[i], buf);
		strcat(supported_file_name_list[i], ".html");
	}

	while ((p = fgets(buf, sizeof(buf), fpin)) != NULL) {
		if (is_commented_string(p)) {
			fprintf(fpout, "%s", p); 
			continue;
		}
		else {	// get field data...
			if(strstr(p, "$DEFINE_DEFAULT_LANGUAGE$") != 0) {
				fprintf(fpout, "var default_lang = \'%s\';\n", supported_lang_list[0]);
			}
			else if(strstr(p, "$SELECT_DEFAULT_LANGUAGE$") != 0) {
				fprintf(fpout, "if (result == \'%s\')\n", supported_lang_list[1]);
				fprintf(fpout, "\t window.location = \'/%s\';\n", supported_file_name_list[1]);
				for(i=2; i<list_cnt; i++) {
					fprintf(fpout, "else if (result == \'%s\')\n", supported_lang_list[i]);
					fprintf(fpout, "\t window.location = \'/%s\';\n", supported_file_name_list[i]);
				}
				fprintf(fpout, "else\n");//Shone added default language seeting 2005,10,06
				fprintf(fpout, "\t window.location = \'/%s\';\n", "indexeng.html");
			}
			else {
				fprintf(fpout, "%s", p);
			}
		}
	}

	
}

int output_index_html(char (*supported_lang_list)[LANG_ID_LENGTH], char *input_path, char *output_path, int list_cnt)
{
	int i;
	FILE *fpin = NULL, *fpout = NULL;
	char input_filename[FILE_NAME_LENGTH] = "template_index.html";
	char output_filename[FILE_NAME_LENGTH];
	char real_input_filename[BUF_SIZE];

	realpath(input_path, real_input_filename);
	strcat(real_input_filename, "/");
	strcat(real_input_filename, input_filename);

	strcpy(output_filename, output_path);
	strcat(output_filename, "/");
	strcat(output_filename, "index.html");

	if((fpin = fopen(real_input_filename, "r")) == NULL) {
		printf("Fail to open file: %s\n", real_input_filename);
		return	ERROR_OPEN_FILE;
	}
	if((fpout = fopen(output_filename, "w")) == NULL) {
		printf("Fail to write file: %s\n", output_filename);
		return	ERROR_WRITE_FILE;
	}
			
	if(SUCCESS != replace_index_html(supported_lang_list, list_cnt, fpin, fpout))
	{
		fclose(fpout);
		fclose(fpin); 
		printf("Fail to replace file: %s\n", input_filename);
		return ERROR_REPLACE_FAIL;
	}
	fclose(fpout);
	fclose(fpin); 
	return SUCCESS;
}

int replace_localized_index_html(int index, char (*supported_lang_list)[LANG_ID_LENGTH], int list_cnt, FILE *fpin, FILE *fpout)
{
	int i, j, count;
	char *p = NULL, buf[BUF_SIZE];
	char localized_lang[LANG_ID_LENGTH];
	char localized_lang_name[LANG_NAME_LENGTH];
	char supported_lang_name[MAX_LANG_NUMBER][LANG_NAME_LENGTH];

	if((fpin == NULL) || (fpout == NULL)) 
		return ERROR_FAIL;

	if(!strcasecmp(supported_lang_list[index], "TCH")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Tch_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "SCH")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Sch_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "JPN")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Jpn_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "KOR")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Kor_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "FRE")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Fre_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "GER")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Ger_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "ITA")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Ita_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "SPA")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Spa_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "POR")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Por_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "DUT")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Dut_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "NOR")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Nor_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "FIN")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Fin_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "SWE")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Swe_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "DAN")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Dan_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else if(!strcasecmp(supported_lang_list[index], "RUS")) {
		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Rus_Lang_Name[j]);
					break;
				}
			}
		}
	}
	else {//for indexeng.html
		for(i=0; i<list_cnt; i++)//Shone modified for TS-101 first page new loading method.
		{
			for(j=0; j<MAX_LANG_NUMBER; j++) 
			{
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) 
				{
					strcpy(supported_lang_name[i], JS_Lang_Name[j]);
					break;
				}
			}
		}
/*		for(i=0; i<list_cnt; i++) {
			for(j=0; j<MAX_LANG_NUMBER; j++) {
				if(!strcasecmp(supported_lang_list[i], Lang_ID[j])) {
					strcpy(supported_lang_name[i], Eng_Lang_Name[j]);
					break;
				}
			}
		}*/
	}
	
	while ((p = fgets(buf, sizeof(buf), fpin)) != NULL) {
		if (is_commented_string(p)) {
			fprintf(fpout, "%s", p); 
			continue;
		}
		else {	// get field data...
			if(strstr(p, "$LANGUAGE_LIST$") != 0) {
				for(i=1; i<list_cnt; i++) {
				//	fprintf(fpout, "<option value=\"%s\" $selected_%s$ ><SCRIPT Language=\"JavaScript\">document.write(%s)</SCRIPT></option>\n", supported_lang_list[i], supported_lang_list[i], supported_lang_name[i]);					
//Shone modified for Apple Safari Browser, if document.write inside, it'll be abnormal 2005,11,22
					fprintf(fpout, "<SCRIPT Language=\"JavaScript\">document.write('<option value=\"%s\" $selected_%s$ >' + %s + '</option>')</SCRIPT>\n", supported_lang_list[i], supported_lang_list[i], supported_lang_name[i]);					
/* Shone modified 2005,11,16 for firstpage loading
					if(i == index)
						fprintf(fpout, "<option value=\"%s\" selected>%s</option>\n", supported_lang_list[i], supported_lang_name[i]);
//					else if(!strcmp(supported_lang_list[i+1], supported_lang_list[0])) continue;
					else
						fprintf(fpout, "<option value=\"%s\">%s</option>\n", supported_lang_list[i], supported_lang_name[i]);
*/
				}
			}
			else if(strstr(p, "$VERSION$") != 0) 
				fprintf(fpout, "<td valign=\"top\" align=\"center\"><font color=\"#000066\">Version %s build %s</font></td>\n", Version, BuildNo);
			else if(strstr(p, "$VERSION_NEW$") != 0) 
				fprintf(fpout, "Version %s build %s", Version, BuildNo);
			else {
				fprintf(fpout, "%s", p);
			}
		}
	}


	 
}		

int output_localized_index_html(char (*supported_lang_list)[LANG_ID_LENGTH], char *input_path, char *output_path,
				char *ulinux_filename, int list_cnt)
{
	int i, ret;
	FILE *fpin = NULL, *fpout = NULL;
	char tmp[5];
	char *input_filename_prefix = "template_index";
	char *output_filename_prefix = "index";
	char *filename_extension = ".html";
	char output_filename[FILE_NAME_LENGTH];
	char real_input_filename[BUF_SIZE];
	char real_ulinux_filename[BUF_SIZE];

	realpath(ulinux_filename, real_ulinux_filename);
	if((ret = get_field(real_ulinux_filename, "Version", Version, FIELD_NAME_MAX_LENGTH)) != SUCCESS) {
		if(ret == ERROR_OPEN_FILE) 
		  printf("Failed to open %s\n", real_ulinux_filename);
		else if (ret == ERROR_NOT_FOUND)
		  printf("Cannot find \"Version\" in uLinux.conf\n");
		return ERROR_NOT_FOUND;
	}
	if((ret = get_field(real_ulinux_filename, "Build Number", BuildNo, FIELD_NAME_MAX_LENGTH)) != SUCCESS) {
		if(ret == ERROR_OPEN_FILE) 
		  printf("Failed to open %s\n", real_ulinux_filename);
		else if (ret == ERROR_NOT_FOUND)
			printf("Cannot find \"Build Number\" in uLinux.conf\n");
		return ERROR_NOT_FOUND;
	}
	
	//for(i=0; i<list_cnt; i++) {
	for(i=0; i<1; i++) {//Shone modified 2005,12,22 to fit current front page (Using only template_indexeng.html)
		realpath(input_path, real_input_filename);
		strcat(real_input_filename, "/");
		strcat(real_input_filename, input_filename_prefix);
		strcpy(tmp, supported_lang_list[i]);
		to_lower_string(tmp);
		strcat(real_input_filename, tmp);
		strcat(real_input_filename, filename_extension);

		strcpy(output_filename, output_path);
		strcat(output_filename, "/");
		strcat(output_filename, output_filename_prefix);
		strcat(output_filename, tmp);
		strcat(output_filename, filename_extension);
		to_lower_string(output_filename);
		
		if((fpin = fopen(real_input_filename, "r")) == NULL) {
			printf("Fail to open file: %s\n", real_input_filename);
			return	ERROR_OPEN_FILE;
		}
		if((fpout = fopen(output_filename, "w")) == NULL) {
			printf("Fail to write file: %s\n", output_filename);
			return	ERROR_WRITE_FILE;
		}
			
		if(SUCCESS != replace_localized_index_html(i, supported_lang_list, list_cnt, fpin, fpout))
		{
			fclose(fpout);
			fclose(fpin); 
			printf("Fail to replace file: %s\n", real_input_filename);
			return ERROR_REPLACE_FAIL;
		}

		fclose(fpout);
		fclose(fpin); 
	}
	return SUCCESS;
}

int remove_redundant_files(char (*supported_lang_list)[LANG_ID_LENGTH], char *output_path, int list_cnt)
{
	int i;
	char tmp[5], buf[BUF_SIZE];
	char redundant_file_path[FIELD_NAME_MAX_LENGTH+16];  // append "/v2_menu/images"
	
	for(i=0; i<MAX_LANG_NUMBER; i++) {
		if (!strcmp(Lang_ID[i], "0")) break;
		if(!is_in_supported_lang_list(Lang_ID[i], supported_lang_list, list_cnt)) {
			strcpy(redundant_file_path, output_path);
			strcat(redundant_file_path, "/v2_menu/images");
			strcpy(tmp, Lang_ID[i]);
			to_lower_string(tmp);
			// Because the prefix of the files are named as cht or chs
			if(!strcmp(tmp, "tch"))
				strcpy(tmp, "cht");
			else if(!strcmp(tmp, "sch"))
				strcpy(tmp, "chs");
			
			sprintf(buf, "rm -f %s/%s_*", redundant_file_path, tmp);
printf("%s ...\n", buf);
			system(buf);
		}
	}
	return SUCCESS;
}
	
int remove_redundant_dirs(char (*supported_lang_list)[LANG_ID_LENGTH], char *output_path, int list_cnt)
{
	int i;
	char tmp[5], buf[BUF_SIZE];
	char redundant_dir_path[FIELD_NAME_MAX_LENGTH+6];  // append "/help"
	
	for(i=0; i<MAX_LANG_NUMBER; i++) {
		if (!strcmp(Lang_ID[i], "0")) break;
		if(!is_in_supported_lang_list(Lang_ID[i], supported_lang_list, list_cnt)) {
			strcpy(redundant_dir_path, output_path);
			strcat(redundant_dir_path, "/help");
			strcpy(tmp, Lang_ID[i]);
			to_lower_string(tmp);
			// Because the the directories are named as cht or chs
			if(!strcmp(tmp, "tch"))
				strcpy(tmp, "cht");
			else if(!strcmp(tmp, "sch"))
				strcpy(tmp, "chs");
			sprintf(buf, "rm -rf %s/%s", redundant_dir_path, tmp);
printf("%s ...\n", buf);
			system(buf);
		}
	}
	return SUCCESS;
}

int main(int argc, char *argv[])
{
	int i, ret, list_cnt = 0;
	char supported_lang_list[MAX_LANG_NUMBER][LANG_ID_LENGTH];
	char output_path[FIELD_NAME_MAX_LENGTH];
	char ulinux_filename[FIELD_NAME_MAX_LENGTH];
	char input_path[FIELD_NAME_MAX_LENGTH]; //current directory
	char config_filename[BUF_SIZE];
	
	if(argc == 5) {
		strcpy(ulinux_filename, argv[1]);
		strcpy(config_filename, argv[2]);
		strcpy(input_path, argv[3]);
		strcpy(output_path, argv[4]);
	}
	else {
		printf("Usage:\n\t %s uLinux_conf_file lang_conf_file template_index_file_path output_path\n", argv[0]);
		return ERROR_FAIL;
	}
		
	if((ret = get_lang_conf(config_filename, supported_lang_list, output_path, ulinux_filename, &list_cnt)) != SUCCESS) {
		if(ret == ERROR_OPEN_FILE)
			printf("Fail to open config file !\n");
		else if(ret == ERROR_BUFFER_TOO_SMALL)
			printf("Out of buffer size !\n");
		else if(ret == ERROR_NOT_FOUND)
			printf("Fail to get field data !\n");
			
		return ERROR_FAIL;
	}

	if((ret = output_localized_index_html(supported_lang_list, input_path, output_path, ulinux_filename, list_cnt)) != SUCCESS) {
		return ERROR_FAIL;
	}

	if((ret = output_index_html(supported_lang_list, input_path, output_path, list_cnt)) != SUCCESS) {
		return ERROR_FAIL;
	}
	
	if((ret = remove_redundant_files(supported_lang_list, output_path, list_cnt)) != SUCCESS) {
		return ERROR_FAIL;
	}
			
	if((ret = remove_redundant_dirs(supported_lang_list, output_path, list_cnt)) != SUCCESS) {
		return ERROR_FAIL;
	}

	return SUCCESS;	
}
