#!/usr/bin/perl
#
# A Perl script to compare two files (mostly .js files), 
# and lists the different parts.
#
# by Andy Wu 01-23-2003
#

@fh0_var=();
@fh0_value=();
$fh0_count=0;

@fh1_var=();
@fh1_value=();
$fh1_count=0;

if ( $#ARGV != 1 ) {
	print "A Perl script to compare two files (mostly .js files), \nand lists the different parts.\n";
	print "\nusage: $0 filename1 filename2\n\n";
	exit(1);
}

open (FH0, $ARGV[0]) || die "cannot open $ARGV[0]\n";
foreach (<FH0>){
        if (/\s*var\s*(.*)\s*=\s*\'(.*)\'\;?.*/) {
        	$fh0_count++;
        }
	($fh0_var[$fh0_count], $fh0_value[$fh0_count]) = ($1, $2);
	#print '$fh0_var['.$fh0_count.'] = '.$fh0_var[$fh0_count]."\n";
	#print '$fh0_value['.$fh0_count.'] = '.$fh0_value[$fh0_count]."\n";

}
close(FH0);

open (FH1, $ARGV[1]) || die "cannot open $ARGV[1]\n";
foreach (<FH1>){
        if (/\s*var\s*(.*)\s*=\s*\'(.*)\'\;?.*/) {
        	$fh1_count++;
        }
	($fh1_var[$fh1_count], $fh1_value[$fh1_count]) = ($1, $2);
	#print '$fh1_var['.$fh1_count.'] = '.$fh1_var[$fh1_count]."\n";
	#print '$fh1_value['.$fh1_count.'] = '.$fh1_value[$fh1_count]."\n";
}
close(FH1);


sub chk_var_val {
	my ($array1_var_ref, $array1_val_ref, $array2_var_ref, $array2_val_ref) = @_;
	my (@base_var, @base_value, @cmp_var, @cmp_value);
	my (@unmatch_idx, @unmatch_var, @unmatch_value);
	my $unmatch_count = 1;

	my (@untrans_idx, @untrans_var, @untrans_value);
	my $untrans_count = 1;

	@base_var	= @{ $array1_var_ref };
	@base_value	= @{ $array1_val_ref };
	@cmp_var	= @{ $array2_var_ref };
	@cmp_value	= @{ $array2_val_ref };

	my ($base_count, $cmp_count) = ($#base_var, $#cmp_var);

	$last_match=0;
	for($i = 1; $i <= $base_count; $i ++) {
		my $matched=0;
		my $untrans=0;
		for($j = $last_match; $j <= $cmp_count; $j ++) {
			if ($base_var[$i] eq $cmp_var[$j]) {
				if ($base_value[$i] ne $cmp_value[$i]) {
					$last_match=$j;
					$matched=1;
					$untrans=0;
					last;
				} else {
					$matched=1;
					$untrans=1;
				}
			}
		}
		if ($matched != 1){
			for($j = 1; $j <= $last_match - 1; $j ++) {
				if ($base_var[$i] eq $cmp_var[$j]) {
					if ($base_value[$i] ne $cmp_value[$i]) {
						$matched=1;
						$untrans=0;
						last;
					} else {
						$matched=1;
						$untrans=1;
					}
				}
			}
		}
		
		if ($matched != 1) {
			$unmatch_idx[$unmatch_count]	= $i;
			$unmatch_var[$unmatch_count]	= $base_var[$i];
			$unmatch_value[$unmatch_count]	= $base_value[$i];
			$unmatch_count++;
		} elsif ($untrans == 1) {
			$untrans_idx[$untrans_count]	= $i;
			$untrans_var[$untrans_count]	= $base_var[$i];
			$untrans_value[$untrans_count]	= $base_value[$i];
			$untrans_count++;
			
		}
	}

	print "Total mismatched strings : ".($unmatch_count-1)."\n\n";
	print "-"x80;
	print "\n";

	for($k = 1; $k < $unmatch_count; $k ++) {
		print "$k. line $unmatch_idx[$k] :\n";
		print "    $unmatch_var[$k] = $unmatch_value[$k]\n";
		#print "-"x80;
		#print "\n";
	}

	print "\n\nTotal untranslated strings : ".($untrans_count-1)."\n\n";
	print "-"x80;
	print "\n";

	for($k = 1; $k < $untrans_count; $k ++) {
		print "$k. line $untrans_idx[$k] :\n";
		print "    $untrans_var[$k] = $untrans_value[$k]\n";
		#print "-"x80;
		#print "\n";
	}
}

print "\n\n\nThe strings exist in <$ARGV[0]> but not in <$ARGV[1]>, or \nthe untranslated strings are : \n";
print "="x80;
print "\n";
chk_var_val(\@fh0_var, \@fh0_value, \@fh1_var, \@fh1_value);

print "\n\n\nThe strings exist in <$ARGV[1]> but not in <$ARGV[0]>, or \nthe untranslated strings are : \n";
print "="x80;
print "\n";
chk_var_val(\@fh1_var, \@fh1_value, \@fh0_var, \@fh0_value);
