/*
 * $Id: hqx.c,v 1.12.4.1.4.1 2005/02/06 10:16:00 didg Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <sys/types.h>
#include <sys/uio.h>
#include <sys/time.h>
#include <sys/param.h>

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <unistd.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif /* HAVE_FCNTL_H */

#include <netinet/in.h>

#include <atalk/adouble.h>
#include <netatalk/endian.h>

#include "megatron.h"
#include "nad.h"
#include "hqx.h"

#define HEXOUTPUT	0

/*	String used to indicate standard input instead of a disk
	file.  Should be a string not normally used for a file
 */
#ifndef	STDIN
#	define	STDIN	"-"
#endif /* ! STDIN */

/*	Yes and no
 */
#define NOWAY		0
#define SURETHANG	1

/*	Looking for the first or any other line of a binhex file
 */
#define	FIRST		0
#define OTHER		1

/*	This is the binhex run length encoding character
 */
#define RUNCHAR		0x90

/*	These are field sizes in bytes of various pieces of the
	binhex header
 */
#define	BHH_VERSION		1
#define	BHH_TCSIZ		8
#define	BHH_FLAGSIZ		2
#define	BHH_DATASIZ		4
#define	BHH_RESSIZ		4
#define BHH_CRCSIZ		2
#define BHH_HEADSIZ		21

u_short		updcrc();

/*	Forward declarations.
 */
int skip_junk(int line);
int hqx_close(int keepflag);
int hqx_header_read(struct FHeader *fh);
int hqx_header_write(struct FHeader *fh);
int hqx_7tobin(char *outbuf, int datalen);
int hqx7_fill(u_char *hqx7_ptr);

#if HEXOUTPUT
FILE		*rawhex, *expandhex;
#endif /* HEXOUTPUT */

struct hqx_file_data {
    u_int32_t		forklen[ NUMFORKS ];
    u_short		forkcrc[ NUMFORKS ];
    char		path[ MAXPATHLEN + 1];
    u_short		headercrc;
    int			filed;
} 		hqx;

extern char	*forkname[];
u_char		hqx7_buf[8192];
u_char		*hqx7_first;
u_char		*hqx7_last;
int		first_flag;

/* 
hqx_open must be called first.  pass it a filename that is supposed
to contain a binhqx file.  an hqx struct will be allocated and
somewhat initialized; hqx_fd is set.  skip_junk is called from
here; skip_junk leaves hqx7_first and hqx7_last set.
 */

int hqx_open( hqxfile, flags, fh, options )
    char		*hqxfile;
    int			flags, options;
    struct FHeader	*fh;
{
    int			maxlen;

#if DEBUG
    fprintf( stderr, "megatron: entering hqx_open\n" );
#endif /* DEBUG */
    select_charset( options);
    if ( flags == O_RDONLY ) {

#if HEXOUTPUT
	rawhex = fopen( "rawhex.unhex", "w" );
	expandhex = fopen( "expandhex.unhex", "w" );
#endif /* HEXOUTPUT */

	first_flag = 0;

	if ( strcmp( hqxfile, STDIN ) == 0 ) {
	    hqx.filed = fileno( stdin );
	} else if (( hqx.filed = open( hqxfile, O_RDONLY )) < 0 ) {
	    perror( hqxfile );
	    return( -1 );
	}

	if ( skip_junk( FIRST ) == 0 ) {
	    if ( hqx_header_read( fh ) == 0 ) {
#if DEBUG
		off_t	pos;

		pos = lseek( hqx.filed, 0, SEEK_CUR );
		fprintf( stderr, "megatron: current position is %ld\n", pos );
#endif /* DEBUG */
		return( 0 );
	    }
	}
	hqx_close( KEEP );
	fprintf( stderr, "%s\n", hqxfile );
	return( -1 );
    } else {
	maxlen = sizeof( hqx.path ) -1;
	strncpy( hqx.path, fh->name, maxlen );
	strncpy( hqx.path, mtoupath( hqx.path ), maxlen );
	strncat( hqx.path, ".hqx", maxlen - strlen( hqx.path ));
	if (( hqx.filed = open( hqx.path, flags, 0666 )) < 0 ) {
	    perror( hqx.path );
	    return( -1 );
	}
	if ( hqx_header_write( fh ) != 0 ) {
	    hqx_close( TRASH );
	    fprintf( stderr, "%s\n", hqx.path );
	    return( -1 );
	}
	return( 0 );
    }
}

/* 
 * hqx_close must be called before a second file can be opened using
 * hqx_open.  Upon successful completion, a value of 0 is returned.  
 * Otherwise, a value of -1 is returned.
 */

int hqx_close( keepflag )
    int			keepflag;
{
    if ( keepflag == KEEP ) {
	return( close( hqx.filed ));
    } else if ( keepflag == TRASH ) {
	if (( strcmp( hqx.path, STDIN ) != 0 ) && ( unlink( hqx.path ) < 0 )) {
	    perror( hqx.path );
	}
	return( 0 );
    } else return( -1 );
}

/*
 * hqx_read is called until it returns zero for each fork.  when it is
 * and finds that there is zero left to give, it reads in and compares
 * the crc with the calculated one, and returns zero if all is well.
 * it returns negative is the crc was bad or if has been called too many
 * times for the same fork.  hqx_read must be called enough times to
 * return zero and no more than that.
 */

int hqx_read( fork, buffer, length )
    int			fork;
    char		*buffer;
    int			length;
{
    u_short		storedcrc;
    int			readlen;
    int			cc;

#if DEBUG >= 3
    {
	off_t	pos;
	pos = lseek( hqx.filed, 0, SEEK_CUR );
	fprintf( stderr, "hqx_read: current position is %ld\n", pos );
    }
    fprintf( stderr, "hqx_read: fork is %s\n", forkname[ fork ] );
    fprintf( stderr, "hqx_read: remaining length is %d\n", hqx.forklen[fork] );
#endif /* DEBUG >= 3 */

    if (hqx.forklen[fork] > length) {
	fprintf(stderr, "This should never happen, dude! length %d, fork length == %u\n", length, hqx.forklen[fork]);
	return hqx.forklen[fork];
    }

    if ( hqx.forklen[ fork ] == 0 ) {
	cc = hqx_7tobin( (char *)&storedcrc, sizeof( storedcrc ));
	if ( cc == sizeof( storedcrc )) {
	    storedcrc = ntohs ( storedcrc );
#if DEBUG >= 4
    fprintf( stderr, "hqx_read: storedcrc\t\t%x\n", storedcrc );
    fprintf( stderr, "hqx_read: observed crc\t\t%x\n\n", hqx.forkcrc[fork] );
#endif /* DEBUG >= 4 */
	    if ( storedcrc == hqx.forkcrc[ fork ] ) {
		return( 0 );
	    }
	    fprintf( stderr, "hqx_read: Bad %s fork crc, dude\n", 
		    forkname[ fork ] );
	}
	return( -1 );
    }

    if ( hqx.forklen[ fork ] < length ) {
	readlen = hqx.forklen[ fork ];
    } else {
	readlen = length;
    }
#if DEBUG >= 3
    fprintf( stderr, "hqx_read: readlen is %d\n", readlen );
#endif /* DEBUG >= 3 */

    cc = hqx_7tobin( buffer, readlen );
    if ( cc > 0 ) {
	hqx.forkcrc[ fork ] = 
		updcrc( hqx.forkcrc[ fork ], (u_char *)buffer, cc );
	hqx.forklen[ fork ] -= cc;
    }
#if DEBUG >= 3
    fprintf( stderr, "hqx_read: chars read is %d\n", cc );
#endif /* DEBUG >= 3 */
    return( cc );
}

/* 
 * hqx_header_read is called by hqx_open, and before any information can
 * read from the hqx_header substruct.  it must be called before any
 * of the bytes of the other two forks can be read, as well.
 * returns a negative number if it was unable to pull enough information
 * to fill the hqx_header fields.
 */

int hqx_header_read( fh )
    struct FHeader	*fh;
{
    char		*headerbuf, *headerptr;
    u_int32_t		time_seconds;
    u_short		mask;
    u_short		header_crc;
    char		namelen;

#if HEXOUTPUT
    int		headerfork;
    headerfork = open( "headerfork", O_WRONLY|O_CREAT, 0622 );
#endif /* HEXOUTPUT */

    mask = htons( 0xfcee );
    hqx.headercrc = 0;

    if ( hqx_7tobin( &namelen, sizeof( namelen )) == 0 ) {
	fprintf( stderr, "Premature end of file :" );
	return( -2 );
    }
    hqx.headercrc = updcrc( hqx.headercrc, (u_char *)&namelen, 
	    sizeof( namelen ));

#if HEXOUTPUT
    write( headerfork, &namelen, sizeof( namelen ));
#endif /* HEXOUTPUT */

    if (( headerbuf = 
	    (char *)malloc( (unsigned int)( namelen + BHH_HEADSIZ ))) == 0 ) {
	return( -1 );
    }
    if ( hqx_7tobin( headerbuf, ( namelen + BHH_HEADSIZ )) == 0 ) {
	free( headerbuf );
	fprintf( stderr, "Premature end of file :" );
	return( -2 );
    }
    headerptr = headerbuf;
    hqx.headercrc = updcrc( hqx.headercrc, 
	    (u_char *)headerbuf, ( namelen + BHH_HEADSIZ - BHH_CRCSIZ ));

#if HEXOUTPUT
    write( headerfork, headerbuf, ( namelen + BHH_HEADSIZ ));
#endif /* HEXOUTPUT */

/*
 * stuff from the hqx file header
 */

    memcpy( fh->name, headerptr, (int)namelen );
    headerptr += namelen;
    headerptr += BHH_VERSION;
    memcpy(&fh->finder_info,  headerptr, BHH_TCSIZ );
    headerptr += BHH_TCSIZ;
    memcpy(&fh->finder_info.fdFlags,  headerptr, BHH_FLAGSIZ );
    fh->finder_info.fdFlags = fh->finder_info.fdFlags & mask;
    headerptr += BHH_FLAGSIZ;
    memcpy(&fh->forklen[ DATA ],  headerptr, BHH_DATASIZ );
    hqx.forklen[ DATA ] = ntohl( fh->forklen[ DATA ] );
    headerptr += BHH_DATASIZ;
    memcpy( &fh->forklen[ RESOURCE ], headerptr, BHH_RESSIZ );
    hqx.forklen[ RESOURCE ] = ntohl( fh->forklen[ RESOURCE ] );
    headerptr += BHH_RESSIZ;
    memcpy(&header_crc,  headerptr, BHH_CRCSIZ );
    headerptr += BHH_CRCSIZ;
    header_crc = ntohs( header_crc );

/*
 * stuff that should be zero'ed out
 */

    fh->comment[0] = '\0';
    fh->finder_info.fdLocation = 0;
    fh->finder_info.fdFldr = 0;

#if DEBUG >= 5
    {
	short		flags;

	fprintf( stderr, "Values read by hqx_header_read\n" );
	fprintf( stderr, "name length\t\t%d\n", namelen );
	fprintf( stderr, "file name\t\t%s\n", fh->name );
	fprintf( stderr, "get info comment\t%s\n", fh->comment );
	fprintf( stderr, "type\t\t\t%.*s\n", sizeof( fh->finder_info.fdType ),
		&fh->finder_info.fdType );
	fprintf( stderr, "creator\t\t\t%.*s\n", 
		sizeof( fh->finder_info.fdCreator ), 
		&fh->finder_info.fdCreator );
	memcpy( &flags, &fh->finder_info.fdFlags, sizeof( flags ));
	flags = ntohs( flags );
	fprintf( stderr, "flags\t\t\t%x\n", flags );
	fprintf( stderr, "data fork length\t%ld\n", hqx.forklen[DATA] );
	fprintf( stderr, "resource fork length\t%ld\n", hqx.forklen[RESOURCE] );
	fprintf( st